/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.concurrent.Callable;
import java.util.function.Consumer;
import javax.cache.CacheException;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.Ignition;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SqlIllegalSchemaSelfTest
extends GridCommonAbstractTest {
    protected void afterTest() throws Exception {
        this.stopAllGrids();
    }

    @Test
    public void testBadCacheName() throws Exception {
        final IgniteConfiguration cfg = this.getConfiguration();
        cfg.setCacheConfiguration(new CacheConfiguration[]{new CacheConfiguration().setName("IGNITE")});
        GridTestUtils.assertThrows((IgniteLogger)this.log, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Ignition.start((IgniteConfiguration)cfg);
                return null;
            }
        }, IgniteException.class, (String)"SQL schema name derived from cache name is reserved (please set explicit SQL schema name through CacheConfiguration.setSqlSchema() or choose another cache name) [cacheName=IGNITE, schemaName=null]");
    }

    @Test
    public void testBadCacheNameDynamic() throws Exception {
        this.doubleConsumerAccept(node -> {
            try {
                node.getOrCreateCache(new CacheConfiguration().setName("IGNITE"));
            }
            catch (CacheException e) {
                SqlIllegalSchemaSelfTest.assertTrue((boolean)this.hasCause(e, IgniteCheckedException.class, "SQL schema name derived from cache name is reserved (please set explicit SQL schema name through CacheConfiguration.setSqlSchema() or choose another cache name) [cacheName=IGNITE, schemaName=null]"));
                return;
            }
            catch (Throwable e) {
                SqlIllegalSchemaSelfTest.fail((String)("Exception class is not as expected [expected=" + CacheException.class + ", actual=" + e.getClass() + ']'));
            }
            SqlIllegalSchemaSelfTest.fail((String)"Exception has not been thrown.");
        });
    }

    @Test
    public void testBadSchemaLower() throws Exception {
        final IgniteConfiguration cfg = this.getConfiguration();
        cfg.setCacheConfiguration(new CacheConfiguration[]{new CacheConfiguration().setName("CACHE").setSqlSchema("IGNITE".toLowerCase())});
        GridTestUtils.assertThrows((IgniteLogger)this.log, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Ignition.start((IgniteConfiguration)cfg);
                return null;
            }
        }, IgniteException.class, (String)"SQL schema name is reserved (please choose another one) [cacheName=CACHE, schemaName=ignite]");
    }

    @Test
    public void testBadSchemaLowerDynamic() throws Exception {
        this.doubleConsumerAccept(node -> {
            try {
                node.getOrCreateCache(new CacheConfiguration().setName("CACHE").setSqlSchema("IGNITE".toLowerCase()));
            }
            catch (CacheException e) {
                SqlIllegalSchemaSelfTest.assertTrue((boolean)this.hasCause(e, IgniteCheckedException.class, "SQL schema name is reserved (please choose another one) [cacheName=CACHE, schemaName=ignite]"));
                return;
            }
            catch (Throwable e) {
                SqlIllegalSchemaSelfTest.fail((String)("Exception class is not as expected [expected=" + CacheException.class + ", actual=" + e.getClass() + ']'));
            }
            SqlIllegalSchemaSelfTest.fail((String)"Exception has not been thrown.");
        });
    }

    @Test
    public void testBadSchemaUpper() throws Exception {
        final IgniteConfiguration cfg = this.getConfiguration();
        cfg.setCacheConfiguration(new CacheConfiguration[]{new CacheConfiguration().setName("CACHE").setSqlSchema("IGNITE".toUpperCase())});
        GridTestUtils.assertThrows((IgniteLogger)this.log, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Ignition.start((IgniteConfiguration)cfg);
                return null;
            }
        }, IgniteException.class, (String)"SQL schema name is reserved (please choose another one) [cacheName=CACHE, schemaName=IGNITE]");
    }

    @Test
    public void testBadSchemaUpperDynamic() throws Exception {
        this.doubleConsumerAccept(node -> {
            try {
                node.getOrCreateCache(new CacheConfiguration().setName("CACHE").setSqlSchema("IGNITE".toUpperCase()));
            }
            catch (CacheException e) {
                SqlIllegalSchemaSelfTest.assertTrue((boolean)this.hasCause(e, IgniteCheckedException.class, "SQL schema name is reserved (please choose another one) [cacheName=CACHE, schemaName=IGNITE]"));
                return;
            }
            catch (Throwable e) {
                SqlIllegalSchemaSelfTest.fail((String)("Exception class is not as expected [expected=" + CacheException.class + ", actual=" + e.getClass() + ']'));
            }
            SqlIllegalSchemaSelfTest.fail((String)"Exception has not been thrown.");
        });
    }

    @Test
    public void testBadSchemaQuoted() throws Exception {
        final IgniteConfiguration cfg = this.getConfiguration();
        cfg.setCacheConfiguration(new CacheConfiguration[]{new CacheConfiguration().setName("CACHE").setSqlSchema("\"" + "IGNITE".toUpperCase() + "\"")});
        GridTestUtils.assertThrows((IgniteLogger)this.log, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Ignition.start((IgniteConfiguration)cfg);
                return null;
            }
        }, IgniteException.class, (String)"SQL schema name is reserved (please choose another one) [cacheName=CACHE, schemaName=\"IGNITE\"]");
    }

    @Test
    public void testBadSchemaQuotedDynamic() throws Exception {
        this.doubleConsumerAccept(node -> {
            try {
                node.getOrCreateCache(new CacheConfiguration().setName("CACHE").setSqlSchema("\"" + "IGNITE".toUpperCase() + "\""));
            }
            catch (CacheException e) {
                SqlIllegalSchemaSelfTest.assertTrue((boolean)this.hasCause(e, IgniteCheckedException.class, "SQL schema name is reserved (please choose another one) [cacheName=CACHE, schemaName=\"IGNITE\"]"));
                return;
            }
            catch (Throwable e) {
                SqlIllegalSchemaSelfTest.fail((String)("Exception class is not as expected [expected=" + CacheException.class + ", actual=" + e.getClass() + ']'));
            }
            SqlIllegalSchemaSelfTest.fail((String)"Exception has not been thrown.");
        });
    }

    private void doubleConsumerAccept(Consumer<Ignite> cons) throws Exception {
        Ignite node = this.startGrid();
        cons.accept(node);
        cons.accept(node);
    }

    private boolean hasCause(@Nullable Throwable t, Class<?> cls, String msg) {
        if (t == null) {
            return false;
        }
        assert (cls != null);
        for (Throwable th = t; th != null; th = th.getCause()) {
            if (cls.isAssignableFrom(th.getClass()) && F.eq((Object)th.getMessage(), (Object)msg)) {
                return true;
            }
            for (Throwable n : th.getSuppressed()) {
                if (!this.hasCause(n, cls, msg)) continue;
                return true;
            }
            if (th.getCause() == th) break;
        }
        return false;
    }
}

