/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CyclicBarrier;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.query.GridRunningQueryInfo;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class RunningQueriesTest
extends GridCommonAbstractTest {
    @Test
    public void testQueriesOriginalText() throws Exception {
        IgniteEx ignite = this.startGrid(0);
        IgniteCache cache = ignite.getOrCreateCache(new CacheConfiguration().setName("cache").setQueryEntities(Collections.singletonList(new QueryEntity(Integer.class, Integer.class))).setSqlFunctionClasses(new Class[]{TestSQLFunctions.class}));
        cache.put((Object)0, (Object)0);
        GridTestUtils.runAsync(() -> cache.query(new SqlFieldsQuery("SELECT * FROM /* comment */ Integer WHERE awaitBarrier() = 0")).getAll());
        GridTestUtils.runAsync(() -> cache.query((Query)new SqlQuery(Integer.class, "FROM /* comment */ Integer WHERE awaitBarrier() = 0")).getAll());
        TestSQLFunctions.barrier.await();
        Collection runningQueries = ignite.context().query().runningQueries(-1L);
        TestSQLFunctions.barrier.await();
        RunningQueriesTest.assertEquals((int)2, (int)runningQueries.size());
        for (GridRunningQueryInfo info : runningQueries) {
            RunningQueriesTest.assertTrue((String)("Failed to find comment in query: " + info.query()), (boolean)info.query().contains("/* comment */"));
        }
    }

    public static class TestSQLFunctions {
        static CyclicBarrier barrier = new CyclicBarrier(3);

        @QuerySqlFunction
        public static long awaitBarrier() {
            try {
                barrier.await();
                barrier.await();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return 0L;
        }
    }
}

