/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.Ignition;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.twostep.MapQueryLazyWorker;
import org.apache.ignite.internal.util.lang.GridAbsPredicate;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class LazyQuerySelfTest
extends GridCommonAbstractTest {
    private static final int KEY_CNT = 200;
    private static final int BASE_QRY_ARG = 50;
    private static final int PAGE_SIZE_SMALL = 12;
    private static final String CACHE_NAME = "cache";

    protected void afterTest() throws Exception {
        this.stopAllGrids();
    }

    @Test
    public void testSingleNode() throws Exception {
        this.checkSingleNode(1);
    }

    @Test
    public void testSingleNodeWithParallelism() throws Exception {
        this.checkSingleNode(4);
    }

    @Test
    public void testMultipleNodes() throws Exception {
        this.checkMultipleNodes(1);
    }

    @Test
    public void testMultipleNodesWithParallelism() throws Exception {
        this.checkMultipleNodes(4);
    }

    public void checkSingleNode(int parallelism) throws Exception {
        Ignite srv = this.startGrid();
        srv.createCache(LazyQuerySelfTest.cacheConfiguration(parallelism));
        LazyQuerySelfTest.populateBaseQueryData(srv);
        this.checkBaseOperations(srv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkMultipleNodes(int parallelism) throws Exception {
        int i;
        IgniteEx cli;
        IgniteEx srv1 = this.startGrid(1);
        IgniteEx srv2 = this.startGrid(2);
        try {
            Ignition.setClientMode((boolean)true);
            cli = this.startGrid(3);
        }
        finally {
            Ignition.setClientMode((boolean)false);
        }
        cli.createCache(LazyQuerySelfTest.cacheConfiguration(parallelism));
        LazyQuerySelfTest.populateBaseQueryData((Ignite)cli);
        this.checkBaseOperations((Ignite)srv1);
        this.checkBaseOperations((Ignite)srv2);
        this.checkBaseOperations((Ignite)cli);
        FieldsQueryCursor<List<?>> cursor = LazyQuerySelfTest.execute((Ignite)cli, LazyQuerySelfTest.baseQuery().setPageSize(12));
        Iterator iter = cursor.iterator();
        for (i = 0; i < 30; ++i) {
            iter.next();
        }
        this.stopGrid(3);
        LazyQuerySelfTest.assertNoWorkers();
        cursor = LazyQuerySelfTest.execute((Ignite)srv1, LazyQuerySelfTest.baseQuery().setPageSize(12));
        try {
            iter = cursor.iterator();
            for (i = 0; i < 30; ++i) {
                iter.next();
            }
            this.stopGrid(2);
        }
        finally {
            cursor.close();
        }
        LazyQuerySelfTest.assertNoWorkers();
    }

    private void checkBaseOperations(Ignite node) throws Exception {
        int i;
        Iterator iter2;
        Object row2;
        ArrayList rows = LazyQuerySelfTest.execute(node, LazyQuerySelfTest.baseQuery()).getAll();
        LazyQuerySelfTest.assertBaseQueryResults(rows);
        LazyQuerySelfTest.assertNoWorkers();
        rows = LazyQuerySelfTest.execute(node, LazyQuerySelfTest.baseQuery().setPageSize(12)).getAll();
        LazyQuerySelfTest.assertBaseQueryResults(rows);
        LazyQuerySelfTest.assertNoWorkers();
        rows = new ArrayList();
        FieldsQueryCursor<List<?>> cursor = LazyQuerySelfTest.execute(node, LazyQuerySelfTest.baseQuery().setPageSize(12));
        for (Object row2 : cursor) {
            rows.add((List<?>)row2);
        }
        LazyQuerySelfTest.assertBaseQueryResults(rows);
        LazyQuerySelfTest.assertNoWorkers();
        FieldsQueryCursor<List<?>> partialCursor = LazyQuerySelfTest.execute(node, LazyQuerySelfTest.baseQuery().setPageSize(12));
        row2 = null;
        try {
            iter2 = partialCursor.iterator();
            for (i = 0; i < 30; ++i) {
                iter2.next();
            }
        }
        catch (Throwable iter2) {
            row2 = iter2;
            throw iter2;
        }
        finally {
            if (partialCursor != null) {
                if (row2 != null) {
                    try {
                        partialCursor.close();
                    }
                    catch (Throwable iter2) {
                        ((Throwable)row2).addSuppressed(iter2);
                    }
                } else {
                    partialCursor.close();
                }
            }
        }
        LazyQuerySelfTest.assertNoWorkers();
        ArrayList<Iterator> iters = new ArrayList<Iterator>();
        for (int i2 = 0; i2 < 200; ++i2) {
            iters.add(LazyQuerySelfTest.execute(node, LazyQuerySelfTest.randomizedQuery().setPageSize(12)).iterator());
        }
        while (!iters.isEmpty()) {
            Iterator iterIter = iters.iterator();
            while (iterIter.hasNext()) {
                iter2 = (Iterator)iterIter.next();
                for (i = 0; iter2.hasNext() && i < 20; ++i) {
                    iter2.next();
                }
                if (iter2.hasNext()) continue;
                iterIter.remove();
            }
        }
        LazyQuerySelfTest.assertNoWorkers();
    }

    private static void populateBaseQueryData(Ignite node) {
        IgniteCache<Long, Person> cache = LazyQuerySelfTest.cache(node);
        for (long i = 0L; i < 200L; ++i) {
            cache.put((Object)i, (Object)new Person(i));
        }
    }

    private static SqlFieldsQuery randomizedQuery() {
        return LazyQuerySelfTest.query(ThreadLocalRandom.current().nextInt(100));
    }

    private static SqlFieldsQuery baseQuery() {
        return LazyQuerySelfTest.query(50L);
    }

    private static CacheConfiguration<Long, Person> cacheConfiguration(int parallelism) {
        return new CacheConfiguration().setName(CACHE_NAME).setIndexedTypes(new Class[]{Long.class, Person.class}).setQueryParallelism(parallelism);
    }

    private static SqlFieldsQuery query(long arg) {
        return new SqlFieldsQuery("SELECT id, name FROM Person WHERE id >= ?").setArgs(new Object[]{arg});
    }

    private static void assertBaseQueryResults(List<List<?>> rows) {
        LazyQuerySelfTest.assertEquals((int)150, (int)rows.size());
        for (List<?> row : rows) {
            Long id = (Long)row.get(0);
            String name = (String)row.get(1);
            LazyQuerySelfTest.assertTrue((id >= 50L ? 1 : 0) != 0);
            LazyQuerySelfTest.assertEquals((String)LazyQuerySelfTest.nameForId(id), (String)name);
        }
    }

    private static IgniteCache<Long, Person> cache(Ignite node) {
        return node.cache(CACHE_NAME);
    }

    private static FieldsQueryCursor<List<?>> execute(Ignite node, SqlFieldsQuery qry) {
        return LazyQuerySelfTest.cache(node).query(qry.setLazy(true));
    }

    private static void assertNoWorkers() throws Exception {
        assert (GridTestUtils.waitForCondition((GridAbsPredicate)new GridAbsPredicate(){

            public boolean apply() {
                for (Ignite node : Ignition.allGrids()) {
                    IgniteH2Indexing idx = (IgniteH2Indexing)((IgniteKernal)node).context().query().getIndexing();
                    if (idx.mapQueryExecutor().registeredLazyWorkers() == 0) continue;
                    return false;
                }
                return MapQueryLazyWorker.activeCount() == 0;
            }
        }, (long)1000L));
    }

    private static String nameForId(long id) {
        return "name-" + id;
    }

    private static class Person {
        @QuerySqlField(index=true)
        private long id;
        @QuerySqlField
        private String name;

        public Person(long id) {
            this.id = id;
            this.name = LazyQuerySelfTest.nameForId(id);
        }

        public long id() {
            return this.id;
        }

        public String name() {
            return this.name;
        }
    }
}

