/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.cache.Cache;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.query.SqlFieldsQueryEx;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class IgniteSqlSkipReducerOnUpdateDmlFlagSelfTest
extends GridCommonAbstractTest {
    private static int NODE_COUNT = 4;
    private static String NODE_CLIENT = "client";
    private static String CACHE_ACCOUNT = "acc";
    private static String CACHE_REPORT = "rep";
    private static String CACHE_STOCK = "stock";
    private static String CACHE_TRADE = "trade";
    private static String CACHE_LIST = "list";
    private static IgniteEx client;

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration c = super.getConfiguration(gridName);
        ArrayList<CacheConfiguration> ccfgs = new ArrayList<CacheConfiguration>();
        ccfgs.add(this.buildCacheConfiguration(CACHE_ACCOUNT));
        ccfgs.add(this.buildCacheConfiguration(CACHE_STOCK));
        ccfgs.add(this.buildCacheConfiguration(CACHE_TRADE));
        ccfgs.add(this.buildCacheConfiguration(CACHE_REPORT));
        ccfgs.add(this.buildCacheConfiguration(CACHE_LIST));
        c.setCacheConfiguration(ccfgs.toArray(new CacheConfiguration[ccfgs.size()]));
        if (gridName.equals(NODE_CLIENT)) {
            c.setClientMode(true);
        }
        return c;
    }

    private CacheConfiguration buildCacheConfiguration(String name) {
        if (name.equals(CACHE_ACCOUNT)) {
            CacheConfiguration ccfg = new CacheConfiguration(CACHE_ACCOUNT);
            ccfg.setCacheMode(CacheMode.PARTITIONED);
            QueryEntity entity = new QueryEntity(Integer.class, Account.class);
            ccfg.setQueryEntities(Collections.singletonList(entity));
            return ccfg;
        }
        if (name.equals(CACHE_STOCK)) {
            CacheConfiguration ccfg = new CacheConfiguration(CACHE_STOCK);
            ccfg.setCacheMode(CacheMode.REPLICATED);
            QueryEntity entity = new QueryEntity(Integer.class, Stock.class);
            ccfg.setQueryEntities(Collections.singletonList(entity));
            return ccfg;
        }
        if (name.equals(CACHE_TRADE)) {
            CacheConfiguration ccfg = new CacheConfiguration(CACHE_TRADE);
            ccfg.setCacheMode(CacheMode.PARTITIONED);
            QueryEntity entity = new QueryEntity(Integer.class, Trade.class);
            ccfg.setQueryEntities(Collections.singletonList(entity));
            return ccfg;
        }
        if (name.equals(CACHE_REPORT)) {
            CacheConfiguration ccfg = new CacheConfiguration(CACHE_REPORT);
            ccfg.setCacheMode(CacheMode.PARTITIONED);
            QueryEntity entity = new QueryEntity(Integer.class, Report.class);
            ccfg.setQueryEntities(Collections.singletonList(entity));
            return ccfg;
        }
        if (name.equals(CACHE_LIST)) {
            CacheConfiguration ccfg = new CacheConfiguration(CACHE_LIST);
            ccfg.setCacheMode(CacheMode.PARTITIONED);
            QueryEntity entity = new QueryEntity(Integer.class, String.class);
            ccfg.setQueryEntities(Collections.singletonList(entity));
            return ccfg;
        }
        assert (false);
        return null;
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGrids(NODE_COUNT);
        client = this.startGrid(NODE_CLIENT);
        this.awaitPartitionMapExchange();
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        this.awaitPartitionMapExchange();
        client.cache(CACHE_ACCOUNT).clear();
        client.cache(CACHE_STOCK).clear();
        client.cache(CACHE_TRADE).clear();
        client.cache(CACHE_REPORT).clear();
        client.cache(CACHE_LIST).clear();
    }

    @Test
    public void testUpdate() throws Exception {
        Map<Integer, Account> accounts = this.getAccounts(100, 1, 100);
        String text = "UPDATE \"acc\".Account SET depo = depo - ? WHERE depo > 0";
        this.checkUpdate(client.cache(CACHE_ACCOUNT), accounts, new SqlFieldsQueryEx(text, Boolean.valueOf(false)).setArgs(new Object[]{10}));
    }

    @Test
    public void testUpdateFastKey() throws Exception {
        Map<Integer, Account> accounts = this.getAccounts(100, 1, 100);
        String text = "UPDATE \"acc\".Account SET depo = depo - ? WHERE _key = ?";
        this.checkUpdate(client.cache(CACHE_ACCOUNT), accounts, new SqlFieldsQueryEx(text, Boolean.valueOf(false)).setArgs(new Object[]{10, 1}));
    }

    @Test
    public void testUpdateLimit() throws Exception {
        Map<Integer, Account> accounts = this.getAccounts(100, 1, 100);
        String text = "UPDATE \"acc\".Account SET depo = depo - ? WHERE sn >= ? AND sn < ? LIMIT ?";
        this.checkUpdate(client.cache(CACHE_ACCOUNT), accounts, new SqlFieldsQueryEx(text, Boolean.valueOf(false)).setArgs(new Object[]{10, 0, 10, 10}));
    }

    @Test
    public void testUpdateWhereSubquery() throws Exception {
        Map<Integer, Account> accounts = this.getAccounts(100, 1, -100);
        Map<Integer, Trade> trades = this.getTrades(100, 2);
        client.cache(CACHE_ACCOUNT).putAll(accounts);
        String text = "UPDATE \"trade\".Trade t SET qty = ? WHERE accountId IN (SELECT p._key FROM \"acc\".Account p WHERE depo < ?)";
        this.checkUpdate(client.cache(CACHE_TRADE), trades, new SqlFieldsQueryEx(text, Boolean.valueOf(false)).setArgs(new Object[]{0, 0}));
    }

    @Test
    public void testUpdateSetSubquery() throws Exception {
        Map<Integer, Account> accounts = this.getAccounts(100, 1, 1000);
        Map<Integer, Trade> trades = this.getTrades(100, 2);
        client.cache(CACHE_ACCOUNT).putAll(accounts);
        String text = "UPDATE \"trade\".Trade t SET qty = (SELECT a.depo/t.price FROM \"acc\".Account a WHERE t.accountId = a._key)";
        this.checkUpdate(client.cache(CACHE_TRADE), trades, new SqlFieldsQueryEx(text, Boolean.valueOf(false)));
    }

    @Test
    public void testUpdateSetTableSubquery() throws Exception {
        Map<Integer, Account> accounts = this.getAccounts(100, 1, 1000);
        Map<Integer, Trade> trades = this.getTrades(100, 2);
        client.cache(CACHE_ACCOUNT).putAll(accounts);
        String text = "UPDATE \"trade\".Trade t SET (qty) = (SELECT a.depo/t.price FROM \"acc\".Account a WHERE t.accountId = a._key)";
        this.checkUpdate(client.cache(CACHE_TRADE), trades, new SqlFieldsQueryEx(text, Boolean.valueOf(false)));
    }

    @Test
    public void testInsertValues() throws Exception {
        String text = "INSERT INTO \"acc\".Account (_key, name, sn, depo) VALUES (?, ?, ?, ?), (?, ?, ?, ?)";
        this.checkUpdate(client.cache(CACHE_ACCOUNT), null, new SqlFieldsQueryEx(text, Boolean.valueOf(false)).setArgs(new Object[]{1, "John Marry", 11111, 100, 2, "Marry John", 11112, 200}));
    }

    @Test
    public void testInsertFromSelect() throws Exception {
        Map<Integer, Account> accounts = this.getAccounts(100, 1, 1000);
        client.cache(CACHE_ACCOUNT).putAll(accounts);
        String text = "INSERT INTO \"trade\".Trade (_key, accountId, stockId, qty, price) SELECT a._key, a._key, ?, a.depo/?, ? FROM \"acc\".Account a";
        this.checkUpdate(client.cache(CACHE_TRADE), null, new SqlFieldsQueryEx(text, Boolean.valueOf(false)).setArgs(new Object[]{1, 10, 10}));
    }

    @Test
    public void testInsertFromSelectOrderBy() throws Exception {
        Map<Integer, Account> accounts = this.getAccounts(100, 1, 1000);
        client.cache(CACHE_ACCOUNT).putAll(accounts);
        String text = "INSERT INTO \"trade\".Trade (_key, accountId, stockId, qty, price) SELECT a._key, a._key, ?, a.depo/?, ? FROM \"acc\".Account a ORDER BY a.sn DESC";
        this.checkUpdate(client.cache(CACHE_TRADE), null, new SqlFieldsQueryEx(text, Boolean.valueOf(false)).setArgs(new Object[]{1, 10, 10}));
    }

    @Test
    public void testInsertFromSelectUnion() throws Exception {
        Map<Integer, Account> accounts = this.getAccounts(20, 1, 1000);
        client.cache(CACHE_ACCOUNT).putAll(accounts);
        String text = "INSERT INTO \"trade\".Trade (_key, accountId, stockId, qty, price) SELECT a._key, a._key, 0, a.depo, 1 FROM \"acc\".Account a UNION SELECT 101 + a2._key, a2._key, 1, a2.depo, 1 FROM \"acc\".Account a2";
        this.checkUpdate(client.cache(CACHE_TRADE), null, new SqlFieldsQueryEx(text, Boolean.valueOf(false)));
    }

    @Test
    public void testInsertFromSelectGroupBy() throws Exception {
        Map<Integer, Account> accounts = this.getAccounts(100, 1, 1000);
        Map<Integer, Trade> trades = this.getTrades(100, 2);
        client.cache(CACHE_ACCOUNT).putAll(accounts);
        client.cache(CACHE_TRADE).putAll(trades);
        String text = "INSERT INTO \"rep\".Report (_key, accountId, spends, count) SELECT accountId, accountId, SUM(qty * price), COUNT(*) FROM \"trade\".Trade GROUP BY accountId";
        this.checkUpdate(client.cache(CACHE_REPORT), null, new SqlFieldsQueryEx(text, Boolean.valueOf(false)));
    }

    @Test
    public void testInsertFromSelectDistinct() throws Exception {
        Map<Integer, Account> accounts = this.getAccounts(100, 2, 100);
        client.cache(CACHE_ACCOUNT).putAll(accounts);
        String text = "INSERT INTO \"list\".String (_key, _val) SELECT DISTINCT sn, name FROM \"acc\".Account ";
        this.checkUpdate(client.cache(CACHE_LIST), null, new SqlFieldsQueryEx(text, Boolean.valueOf(false)));
    }

    @Test
    public void testInsertFromSelectJoin() throws Exception {
        Map<Integer, Account> accounts = this.getAccounts(100, 1, 100);
        Map<Integer, Stock> stocks = this.getStocks(5);
        client.cache(CACHE_ACCOUNT).putAll(accounts);
        client.cache(CACHE_STOCK).putAll(stocks);
        String text = "INSERT INTO \"trade\".Trade(_key, accountId, stockId, qty, price) SELECT 5*a._key + s._key, a._key, s._key, ?, a.depo/? FROM \"acc\".Account a JOIN \"stock\".Stock s ON 1=1";
        this.checkUpdate(client.cache(CACHE_TRADE), null, new SqlFieldsQueryEx(text, Boolean.valueOf(false)).setArgs(new Object[]{10, 10}));
    }

    @Test
    public void testDelete() throws Exception {
        Map<Integer, Account> accounts = this.getAccounts(100, 1, 100);
        client.cache(CACHE_ACCOUNT).putAll(accounts);
        String text = "DELETE FROM \"acc\".Account WHERE sn > ?";
        this.checkUpdate(client.cache(CACHE_ACCOUNT), accounts, new SqlFieldsQueryEx(text, Boolean.valueOf(false)).setArgs(new Object[]{10}));
    }

    @Test
    public void testDeleteTop() throws Exception {
        Map<Integer, Account> accounts = this.getAccounts(100, 1, 100);
        client.cache(CACHE_ACCOUNT).putAll(accounts);
        String text = "DELETE TOP ? FROM \"acc\".Account WHERE sn < ?";
        this.checkUpdate(client.cache(CACHE_ACCOUNT), accounts, new SqlFieldsQueryEx(text, Boolean.valueOf(false)).setArgs(new Object[]{10, 10}));
    }

    @Test
    public void testDeleteWhereSubquery() throws Exception {
        Map<Integer, Account> accounts = this.getAccounts(20, 1, 100);
        Map<Integer, Trade> trades = this.getTrades(10, 2);
        client.cache(CACHE_ACCOUNT).putAll(accounts);
        client.cache(CACHE_TRADE).putAll(trades);
        String text = "DELETE FROM \"acc\".Account WHERE _key IN (SELECT t.accountId FROM \"trade\".Trade t)";
        this.checkUpdate(client.cache(CACHE_ACCOUNT), accounts, new SqlFieldsQueryEx(text, Boolean.valueOf(false)));
    }

    @Test
    public void testMergeValues() throws Exception {
        Map<Integer, Account> accounts = this.getAccounts(1, 1, 100);
        String text = "MERGE INTO \"acc\".Account (_key, name, sn, depo) VALUES (?, ?, ?, ?), (?, ?, ?, ?)";
        this.checkUpdate(client.cache(CACHE_ACCOUNT), accounts, new SqlFieldsQueryEx(text, Boolean.valueOf(false)).setArgs(new Object[]{0, "John Marry", 11111, 100, 1, "Marry John", 11112, 200}));
    }

    @Test
    public void testMergeFromSelectJoin() throws Exception {
        Map<Integer, Account> accounts = this.getAccounts(100, 1, 100);
        Map<Integer, Stock> stocks = this.getStocks(5);
        client.cache(CACHE_ACCOUNT).putAll(accounts);
        client.cache(CACHE_STOCK).putAll(stocks);
        HashMap<Integer, Trade> trades = new HashMap<Integer, Trade>();
        trades.put(5, new Trade(1, 1, 1, 1));
        String text = "MERGE INTO \"trade\".Trade(_key, accountId, stockId, qty, price) SELECT 5*a._key + s._key, a._key, s._key, ?, a.depo/? FROM \"acc\".Account a JOIN \"stock\".Stock s ON 1=1";
        this.checkUpdate(client.cache(CACHE_TRADE), trades, new SqlFieldsQueryEx(text, Boolean.valueOf(false)).setArgs(new Object[]{10, 10}));
    }

    @Test
    public void testMergeFromSelectOrderBy() throws Exception {
        Map<Integer, Account> accounts = this.getAccounts(100, 1, 1000);
        client.cache(CACHE_ACCOUNT).putAll(accounts);
        HashMap<Integer, Trade> trades = new HashMap<Integer, Trade>();
        trades.put(5, new Trade(1, 1, 1, 1));
        String text = "MERGE INTO \"trade\".Trade (_key, accountId, stockId, qty, price) SELECT a._key, a._key, ?, a.depo/?, ? FROM \"acc\".Account a ORDER BY a.sn DESC";
        this.checkUpdate(client.cache(CACHE_TRADE), trades, new SqlFieldsQueryEx(text, Boolean.valueOf(false)).setArgs(new Object[]{1, 10, 10}));
    }

    @Test
    public void testMergeFromSelectGroupBy() throws Exception {
        Map<Integer, Account> accounts = this.getAccounts(100, 1, 1000);
        Map<Integer, Trade> trades = this.getTrades(100, 2);
        client.cache(CACHE_ACCOUNT).putAll(accounts);
        client.cache(CACHE_TRADE).putAll(trades);
        HashMap<Integer, Report> reports = new HashMap<Integer, Report>();
        reports.put(5, new Report(5, 1, 1));
        String text = "MERGE INTO \"rep\".Report (_key, accountId, spends, count) SELECT accountId, accountId, SUM(qty * price), COUNT(*) FROM \"trade\".Trade GROUP BY accountId";
        this.checkUpdate(client.cache(CACHE_REPORT), reports, new SqlFieldsQueryEx(text, Boolean.valueOf(false)));
    }

    private Map<Integer, Account> getAccounts(int num, int numCopy, int depo) {
        HashMap<Integer, Account> res = new HashMap<Integer, Account>();
        int count = 0;
        for (int i = 0; i < num; ++i) {
            String name = "John doe #" + i;
            for (int j = 0; j < numCopy; ++j) {
                res.put(count++, new Account(name, i, depo));
            }
        }
        return res;
    }

    private Map<Integer, Stock> getStocks(int num) {
        HashMap<Integer, Stock> res = new HashMap<Integer, Stock>();
        for (int i = 0; i < num; ++i) {
            res.put(i, new Stock("T" + i, "Stock #" + i));
        }
        return res;
    }

    private Map<Integer, Trade> getTrades(int numAccounts, int numStocks) {
        HashMap<Integer, Trade> res = new HashMap<Integer, Trade>();
        int count = 0;
        for (int i = 0; i < numAccounts; ++i) {
            for (int j = 0; j < numStocks; ++j) {
                res.put(count++, new Trade(i, j, 100, 100));
            }
        }
        return res;
    }

    private <K, V> void checkUpdate(IgniteCache<K, V> cache, Map<K, V> initial, SqlFieldsQueryEx qry) {
        cache.clear();
        if (!F.isEmpty(initial)) {
            cache.putAll(initial);
        }
        List updRes = cache.query(qry.setSkipReducerOnUpdate(true)).getAll();
        HashMap<Object, Object> result = new HashMap<Object, Object>(cache.size(new CachePeekMode[0]));
        for (Cache.Entry e : cache) {
            result.put(e.getKey(), e.getValue());
        }
        cache.clear();
        if (!F.isEmpty(initial)) {
            cache.putAll(initial);
        }
        List updRes2 = cache.query(qry.setSkipReducerOnUpdate(false)).getAll();
        IgniteSqlSkipReducerOnUpdateDmlFlagSelfTest.assertTrue((((Number)((List)updRes.get(0)).get(0)).intValue() > 0 ? 1 : 0) != 0);
        IgniteSqlSkipReducerOnUpdateDmlFlagSelfTest.assertEquals((int)((Number)((List)updRes.get(0)).get(0)).intValue(), (int)((Number)((List)updRes2.get(0)).get(0)).intValue());
        IgniteSqlSkipReducerOnUpdateDmlFlagSelfTest.assertEquals((int)result.size(), (int)cache.size(new CachePeekMode[0]));
        for (Cache.Entry e : cache) {
            IgniteSqlSkipReducerOnUpdateDmlFlagSelfTest.assertEquals((Object)e.getValue(), result.get(e.getKey()));
        }
    }

    public class Report {
        @QuerySqlField
        int accountId;
        @QuerySqlField
        int spends;
        @QuerySqlField
        int count;

        Report(int accountId, int spends, int count) {
            this.accountId = accountId;
            this.spends = spends;
            this.count = count;
        }

        public int hashCode() {
            return this.accountId ^ this.spends ^ this.count;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!obj.getClass().equals(Report.class)) {
                return false;
            }
            Report other = (Report)obj;
            return this.accountId == other.accountId && this.spends == other.spends && this.count == other.count;
        }
    }

    public class Trade {
        @QuerySqlField
        int accountId;
        @QuerySqlField
        int stockId;
        @QuerySqlField
        int qty;
        @QuerySqlField
        int price;

        Trade(int accountId, int stockId, int qty, int price) {
            this.accountId = accountId;
            this.stockId = stockId;
            this.qty = qty;
            this.price = price;
        }

        public int hashCode() {
            return this.accountId ^ this.stockId ^ this.qty ^ this.price;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!obj.getClass().equals(Trade.class)) {
                return false;
            }
            Trade other = (Trade)obj;
            return this.accountId == other.accountId && this.stockId == other.stockId && this.qty == other.qty && this.price == other.price;
        }
    }

    public class Stock {
        @QuerySqlField
        String ticker;
        @QuerySqlField
        String name;

        Stock(String ticker, String name) {
            this.ticker = ticker;
            this.name = name;
        }
    }

    public class Account {
        @QuerySqlField
        String name;
        @QuerySqlField
        int sn;
        @QuerySqlField
        int depo;

        Account(String name, int sn, int depo) {
            this.name = name;
            this.sn = sn;
            this.depo = depo;
        }

        public int hashCode() {
            return (this.name == null ? 0 : this.name.hashCode()) ^ this.sn ^ this.depo;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!obj.getClass().equals(Account.class)) {
                return false;
            }
            Account other = (Account)obj;
            return F.eq((Object)this.name, (Object)other.name) && this.sn == other.sn && this.depo == other.depo;
        }
    }
}

