/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import javax.cache.Cache;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheKeyConfiguration;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.eviction.EvictionPolicy;
import org.apache.ignite.cache.eviction.fifo.FifoEvictionPolicy;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class IgniteSqlSegmentedIndexSelfTest
extends GridCommonAbstractTest {
    private static final String ORG_CACHE_NAME = "org";
    private static final String PERSON_CAHE_NAME = "pers";
    private static final int ORG_CACHE_SIZE = 500;
    private static final int PERSON_CACHE_SIZE = 1000;
    private static final int ORPHAN_ROWS = 10;
    private static int QRY_PARALLELISM_LVL = 97;

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        CacheKeyConfiguration keyCfg = new CacheKeyConfiguration("MyCache", "affKey");
        cfg.setCacheKeyConfiguration(new CacheKeyConfiguration[]{keyCfg});
        cfg.setPeerClassLoadingEnabled(false);
        return cfg;
    }

    protected int nodesCount() {
        return 1;
    }

    protected void beforeTestsStarted() throws Exception {
        this.startGrids(this.nodesCount());
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        this.grid(0).destroyCaches(Arrays.asList(PERSON_CAHE_NAME, ORG_CACHE_NAME));
    }

    protected <K, V> CacheConfiguration<K, V> cacheConfig(String name, boolean partitioned, Class<?> ... idxTypes) {
        return new CacheConfiguration().setName(name).setCacheMode(partitioned ? CacheMode.PARTITIONED : CacheMode.REPLICATED).setQueryParallelism(partitioned ? QRY_PARALLELISM_LVL : 1).setAtomicityMode(CacheAtomicityMode.ATOMIC).setIndexedTypes((Class[])idxTypes);
    }

    @Test
    public void testSegmentedIndex() throws Exception {
        this.ignite(0).createCache(this.cacheConfig(PERSON_CAHE_NAME, true, Integer.class, Person.class));
        this.ignite(0).createCache(this.cacheConfig(ORG_CACHE_NAME, true, Integer.class, Organization.class));
        this.fillCache();
        this.checkDistributedQueryWithSegmentedIndex();
        this.checkLocalQueryWithSegmentedIndex();
        this.checkLocalSizeQueryWithSegmentedIndex();
    }

    @Test
    public void testSegmentedIndexReproducableResults() throws Exception {
        this.ignite(0).createCache(this.cacheConfig(ORG_CACHE_NAME, true, Integer.class, Organization.class));
        IgniteCache cache = this.ignite(0).cache(ORG_CACHE_NAME);
        int expSize = this.nodesCount() * QRY_PARALLELISM_LVL * 3 / 2;
        for (int i = 0; i < expSize; ++i) {
            cache.put((Object)i, (Object)new Organization("org-" + i));
        }
        String select0 = "select * from \"org\".Organization o";
        for (int i = 0; i < 10; ++i) {
            List res = cache.query(new SqlFieldsQuery(select0)).getAll();
            IgniteSqlSegmentedIndexSelfTest.assertEquals((int)expSize, (int)res.size());
        }
    }

    @Test
    public void testSegmentedIndexSizeReproducableResults() throws Exception {
        this.ignite(0).createCache(this.cacheConfig(ORG_CACHE_NAME, true, Integer.class, Organization.class));
        IgniteCache cache = this.ignite(0).cache(ORG_CACHE_NAME);
        long expSize = this.nodesCount() * QRY_PARALLELISM_LVL * 3 / 2;
        int i = 0;
        while ((long)i < expSize) {
            cache.put((Object)i, (Object)new Organization("org-" + i));
            ++i;
        }
        String select0 = "select count(*) from \"org\".Organization o";
        for (int i2 = 0; i2 < 10; ++i2) {
            List res = cache.query(new SqlFieldsQuery(select0)).getAll();
            IgniteSqlSegmentedIndexSelfTest.assertEquals((Object)expSize, ((List)res.get(0)).get(0));
        }
    }

    @Test
    public void testSegmentedIndexWithEvictionPolicy() throws Exception {
        IgniteCache cache = this.ignite(0).createCache(this.cacheConfig(ORG_CACHE_NAME, true, Integer.class, Organization.class).setEvictionPolicy((EvictionPolicy)new FifoEvictionPolicy(10)).setOnheapCacheEnabled(true));
        long SIZE = 20L;
        int i = 0;
        while ((long)i < 20L) {
            cache.put((Object)i, (Object)new Organization("org-" + i));
            ++i;
        }
        String select0 = "select name from \"org\".Organization";
        List res = cache.query(new SqlFieldsQuery(select0)).getAll();
        IgniteSqlSegmentedIndexSelfTest.assertEquals((long)20L, (long)res.size());
    }

    @Test
    public void testSizeOnSegmentedIndexWithEvictionPolicy() throws Exception {
        IgniteCache cache = this.ignite(0).createCache(this.cacheConfig(ORG_CACHE_NAME, true, Integer.class, Organization.class).setEvictionPolicy((EvictionPolicy)new FifoEvictionPolicy(10)).setOnheapCacheEnabled(true));
        long SIZE = 20L;
        int i = 0;
        while ((long)i < 20L) {
            cache.put((Object)i, (Object)new Organization("org-" + i));
            ++i;
        }
        String select0 = "select count(*) from \"org\".Organization";
        List res = cache.query(new SqlFieldsQuery(select0)).getAll();
        IgniteSqlSegmentedIndexSelfTest.assertEquals((Object)20L, ((List)res.get(0)).get(0));
    }

    @Test
    public void testSegmentedPartitionedWithReplicated() throws Exception {
        this.ignite(0).createCache(this.cacheConfig(PERSON_CAHE_NAME, true, Integer.class, Person.class));
        this.ignite(0).createCache(this.cacheConfig(ORG_CACHE_NAME, false, Integer.class, Organization.class));
        this.fillCache();
        this.checkDistributedQueryWithSegmentedIndex();
        this.checkLocalQueryWithSegmentedIndex();
        this.checkLocalSizeQueryWithSegmentedIndex();
    }

    public void checkDistributedQueryWithSegmentedIndex() throws Exception {
        for (int i = 0; i < this.nodesCount(); ++i) {
            IgniteCache c1 = this.ignite(i).cache(PERSON_CAHE_NAME);
            long expPersons = 0L;
            for (Cache.Entry e : c1) {
                Integer orgId = ((Person)e.getValue()).orgId;
                if (10 > orgId || orgId >= 500) continue;
                ++expPersons;
            }
            String select0 = "select o.name n1, p.name n2 from \"pers\".Person p, \"org\".Organization o where p.orgId = o._key";
            List res = c1.query(new SqlFieldsQuery(select0).setDistributedJoins(true)).getAll();
            IgniteSqlSegmentedIndexSelfTest.assertEquals((long)expPersons, (long)res.size());
        }
    }

    public void checkLocalQueryWithSegmentedIndex() throws Exception {
        for (int i = 0; i < this.nodesCount(); ++i) {
            Ignite node = this.ignite(i);
            IgniteCache c1 = node.cache(PERSON_CAHE_NAME);
            IgniteCache c2 = node.cache(ORG_CACHE_NAME);
            HashSet<Object> locOrgIds = new HashSet<Object>();
            for (Cache.Entry e : c2.localEntries(new CachePeekMode[0])) {
                locOrgIds.add(e.getKey());
            }
            long expPersons = 0L;
            for (Cache.Entry e : c1.localEntries(new CachePeekMode[0])) {
                Integer orgId = ((Person)e.getValue()).orgId;
                if (!locOrgIds.contains(orgId)) continue;
                ++expPersons;
            }
            String select0 = "select o.name n1, p.name n2 from \"pers\".Person p, \"org\".Organization o where p.orgId = o._key";
            List res = c1.query(new SqlFieldsQuery(select0).setLocal(true)).getAll();
            IgniteSqlSegmentedIndexSelfTest.assertEquals((long)expPersons, (long)res.size());
        }
    }

    public void checkLocalSizeQueryWithSegmentedIndex() throws Exception {
        for (int i = 0; i < this.nodesCount(); ++i) {
            Object e2;
            Ignite node = this.ignite(i);
            IgniteCache c1 = node.cache(PERSON_CAHE_NAME);
            IgniteCache c2 = node.cache(ORG_CACHE_NAME);
            HashSet<Object> locOrgIds = new HashSet<Object>();
            for (Object e2 : c2.localEntries(new CachePeekMode[0])) {
                locOrgIds.add(e2.getKey());
            }
            int expPersons = 0;
            e2 = c1.localEntries(new CachePeekMode[0]).iterator();
            while (e2.hasNext()) {
                Cache.Entry e3 = (Cache.Entry)e2.next();
                Integer orgId = ((Person)e3.getValue()).orgId;
                if (!locOrgIds.contains(orgId)) continue;
                ++expPersons;
            }
            String select0 = "select count(*) from \"pers\".Person p, \"org\".Organization o where p.orgId = o._key";
            List res = c1.query(new SqlFieldsQuery(select0).setLocal(true)).getAll();
            IgniteSqlSegmentedIndexSelfTest.assertEquals((Object)expPersons, ((List)res.get(0)).get(0));
        }
    }

    private void fillCache() {
        IgniteCache c1 = this.ignite(0).cache(PERSON_CAHE_NAME);
        IgniteCache c2 = this.ignite(0).cache(ORG_CACHE_NAME);
        for (int i = 0; i < 500; ++i) {
            c2.put((Object)i, (Object)new Organization("org-" + i));
        }
        Random random = new Random();
        for (int i = 0; i < 1000; ++i) {
            int orgID = 10 + random.nextInt(510);
            c1.put((Object)i, (Object)new Person(orgID, "pers-" + i));
        }
    }

    private static class Organization
    implements Serializable {
        @QuerySqlField
        String name;

        public Organization() {
        }

        public Organization(String name) {
            this.name = name;
        }
    }

    private static class Person
    implements Serializable {
        @QuerySqlField(index=true)
        Integer orgId;
        @QuerySqlField
        String name;

        public Person() {
        }

        public Person(int orgId, String name) {
            this.orgId = orgId;
            this.name = name;
        }
    }
}

