/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.Assert;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheKeyConfiguration;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.affinity.AffinityKeyMapped;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.events.CacheQueryExecutedEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class IgniteSqlRoutingTest
extends GridCommonAbstractTest {
    private static String NODE_CLIENT = "client";
    private static String CACHE_PERSON = "Person";
    private static String CACHE_CALL = "Call";
    private static int NODE_COUNT = 4;
    private static String FINAL_QRY = "select count(1) from {0} where name=?";
    private static String FINAL_QRY_PARAM = "Abracadabra";

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration c = super.getConfiguration(gridName);
        c.setMarshaller((Marshaller)new BinaryMarshaller());
        ArrayList<CacheConfiguration> ccfgs = new ArrayList<CacheConfiguration>();
        CacheConfiguration ccfg = this.buildCacheConfiguration(gridName);
        if (ccfg != null) {
            ccfgs.add(ccfg);
        }
        ccfgs.add(this.buildCacheConfiguration(CACHE_PERSON));
        ccfgs.add(this.buildCacheConfiguration(CACHE_CALL));
        c.setCacheConfiguration(ccfgs.toArray(new CacheConfiguration[ccfgs.size()]));
        if (gridName.equals(NODE_CLIENT)) {
            c.setClientMode(true);
        }
        c.setCacheKeyConfiguration(new CacheKeyConfiguration[]{new CacheKeyConfiguration(CallKey.class)});
        return c;
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGrids(NODE_COUNT);
        this.startGrid(NODE_CLIENT);
        this.awaitPartitionMapExchange();
        this.fillCaches();
    }

    private CacheConfiguration buildCacheConfiguration(String name) {
        if (name.equals(CACHE_PERSON)) {
            CacheConfiguration ccfg = new CacheConfiguration(CACHE_PERSON);
            ccfg.setCacheMode(CacheMode.PARTITIONED);
            QueryEntity entity = new QueryEntity();
            entity.setKeyType(Integer.class.getName());
            entity.setValueType(Person.class.getName());
            LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
            fields.put("name", String.class.getName());
            fields.put("age", Integer.class.getName());
            entity.setFields(fields);
            ccfg.setQueryEntities(Arrays.asList(entity));
            return ccfg;
        }
        if (name.equals(CACHE_CALL)) {
            CacheConfiguration ccfg = new CacheConfiguration(CACHE_CALL);
            ccfg.setCacheMode(CacheMode.PARTITIONED);
            QueryEntity entity = new QueryEntity(CallKey.class.getName(), Call.class.getName());
            HashSet<String> keyFields = new HashSet<String>();
            keyFields.add("personId");
            keyFields.add("id");
            entity.setKeyFields(keyFields);
            LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
            fields.put("personId", Integer.class.getName());
            fields.put("id", Integer.class.getName());
            fields.put("name", String.class.getName());
            fields.put("duration", Integer.class.getName());
            entity.setFields(fields);
            ccfg.setQueryEntities(Arrays.asList(entity));
            return ccfg;
        }
        return null;
    }

    @Test
    public void testUnicastQuerySelectAffinityKeyEqualsConstant() throws Exception {
        IgniteCache cache = this.grid(NODE_CLIENT).cache(CACHE_CALL);
        List<List<?>> result = this.runQueryEnsureUnicast(cache, new SqlFieldsQuery("select id, name, duration from Call where personId=100 order by id"), 1);
        IgniteSqlRoutingTest.assertEquals((int)2, (int)result.size());
        this.checkResultsRow(result, 0, 1, "caller1", 100);
        this.checkResultsRow(result, 1, 2, "caller2", 200);
    }

    @Test
    public void testUnicastQuerySelectAffinityKeyEqualsParameter() throws Exception {
        IgniteCache cache = this.grid(NODE_CLIENT).cache(CACHE_CALL);
        List<List<?>> result = this.runQueryEnsureUnicast(cache, new SqlFieldsQuery("select id, name, duration from Call where personId=? order by id").setArgs(new Object[]{100}), 1);
        IgniteSqlRoutingTest.assertEquals((int)2, (int)result.size());
        this.checkResultsRow(result, 0, 1, "caller1", 100);
        this.checkResultsRow(result, 1, 2, "caller2", 200);
    }

    @Test
    public void testUnicastQuerySelectKeyEqualsParameterReused() throws Exception {
        IgniteCache cache = this.grid(NODE_CLIENT).cache(CACHE_PERSON);
        for (int key : new int[]{0, 250, 500, 750, 1000}) {
            List<List<?>> result = this.runQueryEnsureUnicast(cache, new SqlFieldsQuery("select name, age from Person where _key=?").setArgs(new Object[]{key}), 1);
            IgniteSqlRoutingTest.assertEquals((int)1, (int)result.size());
            Person person = (Person)cache.get((Object)key);
            this.checkResultsRow(result, 0, person.name, person.age);
        }
    }

    @Test
    public void testUnicastQuerySelectKeyEqualsParameter() throws Exception {
        IgniteCache cache = this.grid(NODE_CLIENT).cache(CACHE_CALL);
        CallKey callKey = new CallKey(5, 1);
        List<List<?>> result = this.runQueryEnsureUnicast(cache, new SqlFieldsQuery("select name, duration from Call where _key=?").setArgs(new Object[]{callKey}), 1);
        IgniteSqlRoutingTest.assertEquals((int)1, (int)result.size());
        Call call = (Call)cache.get((Object)callKey);
        this.checkResultsRow(result, 0, call.name, call.duration);
    }

    @Test
    public void testUnicastQueryGroups() throws Exception {
        IgniteCache cache = this.grid(NODE_CLIENT).cache(CACHE_CALL);
        String qry = "select name, count(1) from Call where personId = ? group by name having count(1) = 1 order by name";
        int personId = 10;
        List<List<?>> result = this.runQueryEnsureUnicast(cache, new SqlFieldsQuery(qry).setArgs(new Object[]{10}), 1);
        IgniteSqlRoutingTest.assertEquals((int)2, (int)result.size());
        this.checkResultsRow(result, 0, "caller1", 1L);
        this.checkResultsRow(result, 1, "caller2", 1L);
    }

    @Test
    public void testUnicastQuerySelectKeyEqualAndFieldParameter() throws Exception {
        IgniteCache cache = this.grid(NODE_CLIENT).cache(CACHE_CALL);
        CallKey callKey = new CallKey(5, 1);
        List<List<?>> result = this.runQueryEnsureUnicast(cache, new SqlFieldsQuery("select name, duration from Call where _key=? and duration=?").setArgs(new Object[]{callKey, 100}), 1);
        IgniteSqlRoutingTest.assertEquals((int)1, (int)result.size());
        Call call = (Call)cache.get((Object)callKey);
        this.checkResultsRow(result, 0, call.name, call.duration);
    }

    @Test
    public void testUnicastQuerySelect2KeyEqualsAndFieldParameter() throws Exception {
        IgniteCache cache = this.grid(NODE_CLIENT).cache(CACHE_CALL);
        CallKey callKey1 = new CallKey(5, 1);
        CallKey callKey2 = new CallKey(1000, 1);
        List<List<?>> result = this.runQueryEnsureUnicast(cache, new SqlFieldsQuery("select name, duration from Call where (_key=? and duration=?) or (_key=?)").setArgs(new Object[]{callKey1, 100, callKey2}), 2);
        IgniteSqlRoutingTest.assertEquals((int)2, (int)result.size());
        Call call = (Call)cache.get((Object)callKey1);
        this.checkResultsRow(result, 0, call.name, call.duration);
        call = (Call)cache.get((Object)callKey2);
        this.checkResultsRow(result, 1, call.name, call.duration);
    }

    @Test
    public void testUnicastQueryKeyTypeConversionParameter() throws Exception {
        IgniteCache cache = this.grid(NODE_CLIENT).cache(CACHE_PERSON);
        List<List<?>> result = this.runQueryEnsureUnicast(cache, new SqlFieldsQuery("select name, age from Person where _key = ?").setArgs(new Object[]{"5"}), 1);
        Person person = (Person)cache.get((Object)5);
        IgniteSqlRoutingTest.assertEquals((int)1, (int)result.size());
        IgniteSqlRoutingTest.assertEquals((Object)person.name, result.get(0).get(0));
        IgniteSqlRoutingTest.assertEquals((Object)person.age, result.get(0).get(1));
    }

    @Test
    public void testUnicastQueryKeyTypeConversionConstant() throws Exception {
        IgniteCache cache = this.grid(NODE_CLIENT).cache(CACHE_PERSON);
        List<List<?>> result = this.runQueryEnsureUnicast(cache, new SqlFieldsQuery("select name, age from Person where _key = '5'"), 1);
        Person person = (Person)cache.get((Object)5);
        IgniteSqlRoutingTest.assertEquals((int)1, (int)result.size());
        IgniteSqlRoutingTest.assertEquals((Object)person.name, result.get(0).get(0));
        IgniteSqlRoutingTest.assertEquals((Object)person.age, result.get(0).get(1));
    }

    @Test
    public void testUnicastQueryAffinityKeyTypeConversionParameter() throws Exception {
        IgniteCache cache = this.grid(NODE_CLIENT).cache(CACHE_CALL);
        List<List<?>> result = this.runQueryEnsureUnicast(cache, new SqlFieldsQuery("select id, name, duration from Call where personId=? order by id").setArgs(new Object[]{"100"}), 1);
        IgniteSqlRoutingTest.assertEquals((int)2, (int)result.size());
        this.checkResultsRow(result, 0, 1, "caller1", 100);
        this.checkResultsRow(result, 1, 2, "caller2", 200);
    }

    @Test
    public void testUnicastQueryAffinityKeyTypeConversionConstant() throws Exception {
        IgniteCache cache = this.grid(NODE_CLIENT).cache(CACHE_CALL);
        List<List<?>> result = this.runQueryEnsureUnicast(cache, new SqlFieldsQuery("select id, name, duration from Call where personId='100' order by id"), 1);
        IgniteSqlRoutingTest.assertEquals((int)2, (int)result.size());
        this.checkResultsRow(result, 0, 1, "caller1", 100);
        this.checkResultsRow(result, 1, 2, "caller2", 200);
    }

    @Test
    public void testBroadcastQuerySelectKeyEqualsOrFieldParameter() throws Exception {
        IgniteCache cache = this.grid(NODE_CLIENT).cache(CACHE_CALL);
        CallKey callKey = new CallKey(5, 1);
        List<List<?>> result = this.runQueryEnsureBroadcast(cache, new SqlFieldsQuery("select name, duration from Call where _key=? or duration=?").setArgs(new Object[]{callKey, 100}));
        IgniteSqlRoutingTest.assertEquals((int)(cache.size(new CachePeekMode[0]) / 2), (int)result.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUuidKeyAsByteArrayParameter() throws Exception {
        String cacheName = "uuidCache";
        CacheConfiguration ccfg = new CacheConfiguration(cacheName);
        ccfg.setCacheMode(CacheMode.PARTITIONED);
        ccfg.setIndexedTypes(new Class[]{UUID.class, UUID.class});
        IgniteCache cache = this.grid(NODE_CLIENT).createCache(ccfg);
        try {
            int count = 10;
            UUID[] values = new UUID[count];
            for (int i = 0; i < count; ++i) {
                UUID val = UUID.randomUUID();
                cache.put((Object)val, (Object)val);
                values[i] = val;
            }
            for (UUID val : values) {
                byte[] arr = this.convertUuidToByteArray(val);
                List result = cache.query(new SqlFieldsQuery("select _val from UUID where _key = ?").setArgs(new Object[]{arr})).getAll();
                IgniteSqlRoutingTest.assertEquals((int)1, (int)result.size());
                IgniteSqlRoutingTest.assertEquals((Object)val, ((List)result.get(0)).get(0));
            }
        }
        finally {
            cache.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDateKeyAsTimestampParameter() throws Exception {
        String cacheName = "dateCache";
        CacheConfiguration ccfg = new CacheConfiguration(cacheName);
        ccfg.setCacheMode(CacheMode.PARTITIONED);
        ccfg.setIndexedTypes(new Class[]{Date.class, Date.class});
        IgniteCache cache = this.grid(NODE_CLIENT).createCache(ccfg);
        try {
            int count = 30;
            Date[] values = new Date[count];
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
            for (int i = 0; i < count; ++i) {
                Date val = dateFormat.parse(String.format("%02d/06/2017", i + 1));
                cache.put((Object)val, (Object)val);
                values[i] = val;
            }
            for (Date val : values) {
                Timestamp ts = new Timestamp(val.getTime());
                List result = cache.query(new SqlFieldsQuery("select _val from Date where _key = ?").setArgs(new Object[]{ts})).getAll();
                IgniteSqlRoutingTest.assertEquals((int)1, (int)result.size());
                IgniteSqlRoutingTest.assertEquals((Object)val, ((List)result.get(0)).get(0));
            }
        }
        finally {
            cache.destroy();
        }
    }

    private byte[] convertUuidToByteArray(UUID val) {
        assert (val != null);
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        bb.putLong(val.getMostSignificantBits());
        bb.putLong(val.getLeastSignificantBits());
        return bb.array();
    }

    private void fillCaches() {
        IgniteCache callCache = this.grid(NODE_CLIENT).cache(CACHE_CALL);
        IgniteCache personCache = this.grid(NODE_CLIENT).cache(CACHE_PERSON);
        int count = IgniteSqlRoutingTest.affinity((IgniteCache)personCache).partitions();
        String[] names = new String[]{"John", "Bob", "James", "David", "Chuck"};
        for (int i = 0; i < count; ++i) {
            Person person = new Person(names[i % names.length], 20 + i % names.length);
            personCache.put((Object)i, (Object)person);
            callCache.put((Object)new CallKey(i, 1), (Object)new Call("caller1", 100));
            callCache.put((Object)new CallKey(i, 2), (Object)new Call("caller2", 200));
        }
    }

    private void checkResultsRow(List<List<?>> results, int rowId, Object ... expected) throws Exception {
        IgniteSqlRoutingTest.assertTrue((rowId < results.size() ? 1 : 0) != 0);
        List<?> row = results.get(rowId);
        IgniteSqlRoutingTest.assertEquals((int)expected.length, (int)row.size());
        for (int col = 0; col < expected.length; ++col) {
            IgniteSqlRoutingTest.assertEquals((Object)expected[col], row.get(col));
        }
    }

    private List<List<?>> runQueryEnsureUnicast(IgniteCache<?, ?> cache, SqlFieldsQuery qry, int nodeCnt) throws Exception {
        try (EventCounter evtCounter = new EventCounter(nodeCnt);){
            List result = cache.query(qry).getAll();
            cache.query(new SqlFieldsQuery(MessageFormat.format(FINAL_QRY, cache.getName())).setArgs(new Object[]{FINAL_QRY_PARAM})).getAll();
            evtCounter.await();
            List list = result;
            return list;
        }
    }

    private List<List<?>> runQueryEnsureBroadcast(IgniteCache<?, ?> cache, SqlFieldsQuery qry) throws Exception {
        final CountDownLatch execLatch = new CountDownLatch(NODE_COUNT);
        IgnitePredicate<Event> pred = new IgnitePredicate<Event>(){

            public boolean apply(Event evt) {
                assert (evt instanceof CacheQueryExecutedEvent);
                CacheQueryExecutedEvent qe = (CacheQueryExecutedEvent)evt;
                Assert.assertNotNull((Object)qe.clause());
                execLatch.countDown();
                return true;
            }
        };
        for (int i = 0; i < NODE_COUNT; ++i) {
            this.grid(i).events().localListen((IgnitePredicate)pred, new int[]{96});
        }
        List result = cache.query(qry).getAll();
        IgniteSqlRoutingTest.assertTrue((boolean)execLatch.await(5000L, TimeUnit.MILLISECONDS));
        for (int i = 0; i < NODE_COUNT; ++i) {
            this.grid(i).events().stopLocalListen((IgnitePredicate)pred, new int[0]);
        }
        return result;
    }

    private static class Call {
        private String name;
        private int duration;

        public Call(String name, int duration) {
            this.name = name;
            this.duration = duration;
        }

        public int hashCode() {
            return this.name.hashCode() ^ this.duration;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Call)) {
                return false;
            }
            Call other = (Call)o;
            return this.name.equals(other.name) && this.duration == other.duration;
        }
    }

    private static class CallKey {
        @AffinityKeyMapped
        private int personId;
        private int id;

        private CallKey(int personId, int id) {
            this.personId = personId;
            this.id = id;
        }

        public int hashCode() {
            return this.personId ^ this.id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CallKey)) {
                return false;
            }
            CallKey other = (CallKey)o;
            return this.personId == other.personId && this.id == other.id;
        }
    }

    private static class Person {
        private String name;
        private int age;

        public Person(String name, int age) {
            this.name = name;
            this.age = age;
        }

        public int hashCode() {
            return this.name.hashCode() ^ this.age;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Person)) {
                return false;
            }
            Person other = (Person)o;
            return this.name.equals(other.name) && this.age == other.age;
        }
    }

    private class EventCounter
    implements AutoCloseable {
        final AtomicInteger cnt;
        final CountDownLatch execLatch;
        final IgnitePredicate<Event> pred = new IgnitePredicate<Event>(){

            public boolean apply(Event evt) {
                assert (evt instanceof CacheQueryExecutedEvent);
                CacheQueryExecutedEvent qe = (CacheQueryExecutedEvent)evt;
                String cacheName = qe.cacheName();
                assert (cacheName != null);
                if (!cacheName.equals(CACHE_PERSON) && !cacheName.equals(CACHE_CALL)) {
                    return true;
                }
                Assert.assertNotNull((Object)qe.clause());
                Object[] args = qe.arguments();
                if (args != null && args.length > 0 && args[0] instanceof String) {
                    String strParam = (String)args[0];
                    if (FINAL_QRY_PARAM.equals(strParam)) {
                        EventCounter.this.execLatch.countDown();
                        return true;
                    }
                }
                EventCounter.this.cnt.decrementAndGet();
                return true;
            }
        };

        private EventCounter(int cnt) {
            this.cnt = new AtomicInteger(cnt);
            this.execLatch = new CountDownLatch(NODE_COUNT);
            for (int i = 0; i < NODE_COUNT; ++i) {
                IgniteSqlRoutingTest.this.grid(i).events().localListen(this.pred, new int[]{96});
            }
        }

        public void await() throws Exception {
            Assert.assertTrue((boolean)this.execLatch.await(5000L, TimeUnit.MILLISECONDS));
            Assert.assertEquals((int)0, (int)this.cnt.get());
        }

        @Override
        public void close() throws Exception {
            for (int i = 0; i < NODE_COUNT; ++i) {
                IgniteSqlRoutingTest.this.grid(i).events().stopLocalListen(this.pred, new int[0]);
            }
        }
    }
}

