/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class IgniteSqlParameterizedQueryTest
extends GridCommonAbstractTest {
    private static final String CACHE_BOOKMARK = "Bookmark";
    private static final String NODE_CLIENT = "client";

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration c = super.getConfiguration(gridName);
        c.setCacheConfiguration(new CacheConfiguration[]{this.buildCacheConfiguration(CACHE_BOOKMARK)});
        if (gridName.equals(NODE_CLIENT)) {
            c.setClientMode(true);
        }
        return c;
    }

    private CacheConfiguration buildCacheConfiguration(String name) {
        CacheConfiguration ccfg = new CacheConfiguration(name);
        ccfg.setIndexedTypes(new Class[]{String.class, Bookmark.class});
        return ccfg;
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.startGrid(0);
        this.startGrid(NODE_CLIENT);
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        this.stopAllGrids();
    }

    private Object columnValue(String field, Object val) {
        IgniteCache cache = this.grid(NODE_CLIENT).cache(CACHE_BOOKMARK);
        SqlFieldsQuery qry = new SqlFieldsQuery("SELECT " + field + " from  Bookmark where " + field + " = ?");
        qry.setArgs(new Object[]{val});
        FieldsQueryCursor cursor = cache.query(qry);
        List results = cursor.getAll();
        IgniteSqlParameterizedQueryTest.assertEquals((String)("Search by field '" + field + "' returns incorrect row count!"), (int)1, (int)results.size());
        List row0 = (List)results.get(0);
        return row0.get(0);
    }

    @Test
    public void testSupportedTypes() throws Exception {
        IgniteCache cache = this.grid(NODE_CLIENT).cache(CACHE_BOOKMARK);
        Bookmark bookmark = new Bookmark();
        bookmark.setId(UUID.randomUUID().toString());
        bookmark.setStockCount(Integer.MAX_VALUE);
        bookmark.setUrlPort((short)Short.MAX_VALUE);
        bookmark.setUserId(Long.MAX_VALUE);
        bookmark.setVisitRatio(Float.valueOf(Float.MAX_VALUE));
        bookmark.setTaxPercentage((Double)Double.MAX_VALUE);
        bookmark.setFavourite(true);
        bookmark.setDisplayMask((byte)127);
        bookmark.setSerialNumber(UUID.randomUUID());
        bookmark.setVisitCount(new BigInteger("1000000000000000"));
        bookmark.setSiteWeight(new BigDecimal("1000000000000000.001"));
        bookmark.setCreated(new Date());
        cache.put((Object)bookmark.id, (Object)bookmark);
        IgniteSqlParameterizedQueryTest.assertEquals((Object)bookmark.getId(), (Object)this.columnValue("id", bookmark.getId()));
        IgniteSqlParameterizedQueryTest.assertEquals((Object)bookmark.getStockCount(), (Object)this.columnValue("stockcount", bookmark.getStockCount()));
        IgniteSqlParameterizedQueryTest.assertEquals((Object)bookmark.getUrlPort(), (Object)this.columnValue("urlport", bookmark.getUrlPort()));
        IgniteSqlParameterizedQueryTest.assertEquals((Object)bookmark.getUserId(), (Object)this.columnValue("userid", bookmark.getUserId()));
        IgniteSqlParameterizedQueryTest.assertEquals((Object)bookmark.getVisitRatio(), (Object)this.columnValue("visitratio", bookmark.getVisitRatio()));
        IgniteSqlParameterizedQueryTest.assertEquals((Object)bookmark.getTaxPercentage(), (Object)this.columnValue("taxpercentage", bookmark.getTaxPercentage()));
        IgniteSqlParameterizedQueryTest.assertEquals((Object)bookmark.getFavourite(), (Object)this.columnValue("favourite", bookmark.getFavourite()));
        IgniteSqlParameterizedQueryTest.assertEquals((Object)bookmark.getDisplayMask(), (Object)this.columnValue("displaymask", bookmark.getDisplayMask()));
        IgniteSqlParameterizedQueryTest.assertEquals((Object)bookmark.getSerialNumber(), (Object)this.columnValue("serialnumber", bookmark.getSerialNumber()));
        IgniteSqlParameterizedQueryTest.assertEquals((Object)bookmark.getVisitCount(), (Object)this.columnValue("visitcount", bookmark.getVisitCount()));
        IgniteSqlParameterizedQueryTest.assertEquals((Object)bookmark.getSiteWeight(), (Object)this.columnValue("siteweight", bookmark.getSiteWeight()));
        IgniteSqlParameterizedQueryTest.assertEquals((Object)bookmark.getCreated(), (Object)this.columnValue("created", bookmark.getCreated()));
    }

    private static class Bookmark
    implements Serializable {
        @QuerySqlField
        private String id;
        @QuerySqlField
        private Integer stockCount;
        @QuerySqlField
        private Short urlPort;
        @QuerySqlField
        private Long userId;
        @QuerySqlField
        private Float visitRatio;
        @QuerySqlField
        private Double taxPercentage;
        @QuerySqlField
        private Boolean favourite;
        @QuerySqlField
        private Byte displayMask;
        @QuerySqlField
        private UUID serialNumber;
        @QuerySqlField
        private BigDecimal siteWeight;
        @QuerySqlField
        private BigInteger visitCount;
        @QuerySqlField
        private Date created;

        private Bookmark() {
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public Integer getStockCount() {
            return this.stockCount;
        }

        public void setStockCount(Integer stockCount) {
            this.stockCount = stockCount;
        }

        public Short getUrlPort() {
            return this.urlPort;
        }

        public void setUrlPort(Short urlPort) {
            this.urlPort = urlPort;
        }

        public Long getUserId() {
            return this.userId;
        }

        public void setUserId(Long userId) {
            this.userId = userId;
        }

        public Float getVisitRatio() {
            return this.visitRatio;
        }

        public void setVisitRatio(Float visitRatio) {
            this.visitRatio = visitRatio;
        }

        public Double getTaxPercentage() {
            return this.taxPercentage;
        }

        public void setTaxPercentage(Double taxPercentage) {
            this.taxPercentage = taxPercentage;
        }

        public Boolean getFavourite() {
            return this.favourite;
        }

        public void setFavourite(Boolean favourite) {
            this.favourite = favourite;
        }

        public Byte getDisplayMask() {
            return this.displayMask;
        }

        public void setDisplayMask(Byte displayMask) {
            this.displayMask = displayMask;
        }

        public UUID getSerialNumber() {
            return this.serialNumber;
        }

        public void setSerialNumber(UUID serialNumber) {
            this.serialNumber = serialNumber;
        }

        public BigDecimal getSiteWeight() {
            return this.siteWeight;
        }

        public void setSiteWeight(BigDecimal siteWeight) {
            this.siteWeight = siteWeight;
        }

        public BigInteger getVisitCount() {
            return this.visitCount;
        }

        public void setVisitCount(BigInteger visitCount) {
            this.visitCount = visitCount;
        }

        public Date getCreated() {
            return this.created;
        }

        public void setCreated(Date created) {
            this.created = created;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Bookmark bookmark = (Bookmark)o;
            return Objects.equals(this.id, bookmark.id);
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }
    }
}

