/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class IgniteSqlKeyValueFieldsTest
extends GridCommonAbstractTest {
    private static String NODE_BAD_CONF_MISS_KEY_FIELD = "badConf1";
    private static String NODE_BAD_CONF_MISS_VAL_FIELD = "badConf2";
    private static String NODE_CLIENT = "client";
    private static String CACHE_PERSON_NO_KV = "PersonNoKV";
    private static String CACHE_INT_NO_KV_TYPE = "IntNoKVType";
    private static String CACHE_PERSON = "Person";
    private static String CACHE_JOB = "Job";

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration c = super.getConfiguration(gridName);
        c.setMarshaller((Marshaller)new BinaryMarshaller());
        ArrayList<CacheConfiguration> ccfgs = new ArrayList<CacheConfiguration>();
        CacheConfiguration ccfg = this.buildCacheConfiguration(gridName);
        if (ccfg != null) {
            ccfgs.add(ccfg);
        }
        ccfgs.add(this.buildCacheConfiguration(CACHE_PERSON_NO_KV));
        ccfgs.add(this.buildCacheConfiguration(CACHE_INT_NO_KV_TYPE));
        ccfgs.add(this.buildCacheConfiguration(CACHE_PERSON));
        ccfgs.add(this.buildCacheConfiguration(CACHE_JOB));
        c.setCacheConfiguration(ccfgs.toArray(new CacheConfiguration[ccfgs.size()]));
        if (gridName.equals(NODE_CLIENT)) {
            c.setClientMode(true);
        }
        return c;
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.startGrid(0);
        this.startGrid(NODE_CLIENT);
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        this.stopAllGrids();
    }

    private CacheConfiguration buildCacheConfiguration(String name) {
        if (name.equals(NODE_BAD_CONF_MISS_KEY_FIELD)) {
            CacheConfiguration ccfg = new CacheConfiguration(NODE_BAD_CONF_MISS_KEY_FIELD);
            QueryEntity qe = new QueryEntity(Object.class.getName(), Object.class.getName());
            qe.setKeyFieldName("k");
            qe.addQueryField("a", Integer.class.getName(), null);
            ccfg.setQueryEntities((Collection)F.asList((Object)qe));
            return ccfg;
        }
        if (name.equals(NODE_BAD_CONF_MISS_VAL_FIELD)) {
            CacheConfiguration ccfg = new CacheConfiguration(NODE_BAD_CONF_MISS_VAL_FIELD);
            QueryEntity qe = new QueryEntity(Object.class.getName(), Object.class.getName());
            qe.setValueFieldName("v");
            qe.addQueryField("a", Integer.class.getName(), null);
            ccfg.setQueryEntities((Collection)F.asList((Object)qe));
            return ccfg;
        }
        if (name.equals(CACHE_PERSON_NO_KV)) {
            CacheConfiguration ccfg = new CacheConfiguration(CACHE_PERSON_NO_KV);
            QueryEntity entity = new QueryEntity();
            entity.setKeyType(Integer.class.getName());
            entity.setValueType(Person.class.getName());
            LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
            fields.put("name", String.class.getName());
            fields.put("age", Integer.class.getName());
            entity.setFields(fields);
            ccfg.setQueryEntities(Arrays.asList(entity));
            return ccfg;
        }
        if (name.equals(CACHE_INT_NO_KV_TYPE)) {
            CacheConfiguration ccfg = new CacheConfiguration(CACHE_INT_NO_KV_TYPE);
            QueryEntity entity = new QueryEntity();
            entity.setKeyType(null);
            entity.setValueType(null);
            entity.setKeyFieldName("id");
            entity.setValueFieldName("v");
            LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
            fields.put("id", Integer.class.getName());
            fields.put("v", Integer.class.getName());
            entity.setFields(fields);
            ccfg.setQueryEntities(Arrays.asList(entity));
            return ccfg;
        }
        if (name.equals(CACHE_PERSON)) {
            CacheConfiguration ccfg = new CacheConfiguration(CACHE_PERSON);
            QueryEntity entity = new QueryEntity();
            entity.setKeyType(Integer.class.getName());
            entity.setValueType(Person.class.getName());
            entity.setKeyFieldName("id");
            entity.setValueFieldName("v");
            LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
            fields.put("name", String.class.getName());
            fields.put("age", Integer.class.getName());
            fields.put(entity.getKeyFieldName(), entity.getKeyType());
            fields.put(entity.getValueFieldName(), entity.getValueType());
            entity.setFields(fields);
            ccfg.setQueryEntities(Arrays.asList(entity));
            return ccfg;
        }
        if (name.equals(CACHE_JOB)) {
            CacheConfiguration ccfg = new CacheConfiguration(CACHE_JOB);
            ccfg.setIndexedTypes(new Class[]{Integer.class, Integer.class});
            return ccfg;
        }
        return null;
    }

    @Test
    public void testSetIndexTypesPrimitive() throws Exception {
        IgniteCache cache = this.grid(NODE_CLIENT).cache(CACHE_JOB);
        this.checkInsert(cache, "insert into Integer (_key, _val) values (?,?)", 1, 100);
        this.checkSelect(cache, "select * from Integer", 1, 100);
        this.checkSelect(cache, "select _key, _val from Integer", 1, 100);
    }

    @Test
    public void testErrorKeyFieldMissingFromFields() throws Exception {
        this.checkCacheStartupError(NODE_BAD_CONF_MISS_KEY_FIELD);
    }

    @Test
    public void testErrorValueFieldMissingFromFields() throws Exception {
        this.checkCacheStartupError(NODE_BAD_CONF_MISS_VAL_FIELD);
    }

    private void checkCacheStartupError(final String name) {
        GridTestUtils.assertThrows((IgniteLogger)this.log, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                IgniteSqlKeyValueFieldsTest.this.startGrid(name);
                return null;
            }
        }, IgniteCheckedException.class, null);
    }

    @Test
    public void testQueryEntityAutoKeyValTypes() throws Exception {
        IgniteCache cache = this.grid(NODE_CLIENT).cache(CACHE_INT_NO_KV_TYPE);
        this.checkInsert(cache, "insert into Integer (_key, _val) values (?,?)", 1, 100);
        this.checkSelect(cache, "select * from Integer where id = 1", 1, 100);
        this.checkSelect(cache, "select * from Integer", 1, 100);
        this.checkSelect(cache, "select _key, _val from Integer", 1, 100);
        this.checkSelect(cache, "select id, v from Integer", 1, 100);
    }

    @Test
    public void testNoKeyValueAliases() throws Exception {
        IgniteCache cache = this.grid(NODE_CLIENT).cache(CACHE_PERSON_NO_KV);
        Person alice = new Person("Alice", 1);
        this.checkInsert(cache, "insert into Person (_key, _val) values (?,?)", 1, alice);
        this.checkSelect(cache, "select * from Person", alice.name, alice.age);
        this.checkSelect(cache, "select _key, _val from Person", 1, alice);
    }

    @Test
    public void testKeyValueAlias() throws Exception {
        Person alice = new Person("Alice", 1);
        Person bob = new Person("Bob", 2);
        IgniteCache cache = this.grid(NODE_CLIENT).cache(CACHE_PERSON);
        this.checkInsert(cache, "insert into Person (_key, _val) values (?,?)", 1, alice);
        this.checkInsert(cache, "insert into Person (id, v) values (?,?)", 2, bob);
        this.checkSelect(cache, "select * from Person where _key=1", alice.name, alice.age, 1, alice);
        this.checkSelect(cache, "select _key, _val from Person where id=1", 1, alice);
        this.checkSelect(cache, "select * from Person where _key=2", bob.name, bob.age, 2, bob);
        this.checkSelect(cache, "select _key, _val from Person where id=2", 2, bob);
        this.checkInsert(cache, "update Person set age = ? where id = ?", 3, 1);
        this.checkSelect(cache, "select _key, age from Person where id=1", 1, 3);
        this.checkInsert(cache, "update Person set v = ? where id = ?", alice, 1);
        this.checkSelect(cache, "select _key, _val from Person where id=1", 1, alice);
    }

    @Test
    public void testVersionField() throws Exception {
        Person alice = new Person("Alice", 1);
        Person bob = new Person("Bob", 2);
        IgniteCache cache = this.grid(NODE_CLIENT).cache(CACHE_PERSON);
        this.checkInsert(cache, "insert into Person (id, v) values (?,?)", 1, alice);
        IgniteSqlKeyValueFieldsTest.assertNotNull((Object)this.getVersion(cache, 1));
        this.checkInsert(cache, "insert into Person (id, v) values (?,?)", 2, bob);
        IgniteSqlKeyValueFieldsTest.assertNotNull((Object)this.getVersion(cache, 2));
        GridCacheVersion v1 = this.getVersion(cache, 1);
        this.checkInsert(cache, "update Person set age = ? where id = ?", 3, 1);
        GridCacheVersion v2 = this.getVersion(cache, 1);
        IgniteSqlKeyValueFieldsTest.assertFalse((boolean)v1.equals((Object)v2));
    }

    @Test
    public void testJoinKeyValFields() throws Exception {
        IgniteEx client = this.grid(NODE_CLIENT);
        IgniteCache cache = client.cache(CACHE_PERSON);
        IgniteCache cache2 = client.cache(CACHE_JOB);
        this.checkInsert(cache, "insert into Person (id, v) values (?, ?)", 1, new Person("Bob", 30));
        this.checkInsert(cache, "insert into Person (id, v) values (?, ?)", 2, new Person("David", 35));
        this.checkInsert(cache2, "insert into Integer (_key, _val) values (?, ?)", 100, 1);
        this.checkInsert(cache2, "insert into Integer (_key, _val) values (?, ?)", 200, 2);
        FieldsQueryCursor cursor = cache.query(new SqlFieldsQuery("select p.id, j._key from Person p, \"" + CACHE_JOB + "\".Integer j where p.id = j._val"));
        List results = cursor.getAll();
        IgniteSqlKeyValueFieldsTest.assertEquals((int)2, (int)results.size());
        IgniteSqlKeyValueFieldsTest.assertEquals((Object)1, ((List)results.get(0)).get(0));
        IgniteSqlKeyValueFieldsTest.assertEquals((Object)100, ((List)results.get(0)).get(1));
        IgniteSqlKeyValueFieldsTest.assertEquals((Object)2, ((List)results.get(1)).get(0));
        IgniteSqlKeyValueFieldsTest.assertEquals((Object)200, ((List)results.get(1)).get(1));
    }

    @Test
    public void testAutoKeyFieldIndex() throws Exception {
        IgniteEx client = this.grid(NODE_CLIENT);
        IgniteCache cache = client.cache(CACHE_PERSON);
        FieldsQueryCursor cursor = cache.query(new SqlFieldsQuery("explain select * from Person where id = 1"));
        List results = cursor.getAll();
        IgniteSqlKeyValueFieldsTest.assertEquals((int)2, (int)results.size());
        IgniteSqlKeyValueFieldsTest.assertTrue((boolean)((String)((List)results.get(0)).get(0)).contains("\"_key_PK_proxy\""));
        cursor = cache.query(new SqlFieldsQuery("explain select * from Person where _key = 1"));
        results = cursor.getAll();
        IgniteSqlKeyValueFieldsTest.assertEquals((int)2, (int)results.size());
        IgniteSqlKeyValueFieldsTest.assertTrue((boolean)((String)((List)results.get(0)).get(0)).contains("\"_key_PK\""));
    }

    private GridCacheVersion getVersion(IgniteCache<?, ?> cache, int key) {
        FieldsQueryCursor cursor = cache.query(new SqlFieldsQuery("select _ver from Person where id = ?").setArgs(new Object[]{key}));
        List results = cursor.getAll();
        IgniteSqlKeyValueFieldsTest.assertEquals((int)1, (int)results.size());
        return (GridCacheVersion)((List)results.get(0)).get(0);
    }

    private void checkInsert(IgniteCache<?, ?> cache, String qry, Object ... args) throws Exception {
        FieldsQueryCursor cursor = cache.query(new SqlFieldsQuery(qry).setArgs(args));
        IgniteSqlKeyValueFieldsTest.assertEquals((int)1, (int)((Number)((List)cursor.getAll().get(0)).get(0)).intValue());
    }

    private void checkSelect(IgniteCache<?, ?> cache, String selectQry, Object ... expected) {
        FieldsQueryCursor cursor = cache.query(new SqlFieldsQuery(selectQry));
        List results = cursor.getAll();
        IgniteSqlKeyValueFieldsTest.assertEquals((int)1, (int)results.size());
        List row0 = (List)results.get(0);
        for (int col = 0; col < expected.length; ++col) {
            IgniteSqlKeyValueFieldsTest.assertEquals((Object)expected[col], row0.get(col));
        }
    }

    private static class Person {
        private String name;
        private int age;

        public Person(String name, int age) {
            this.name = name;
            this.age = age;
        }

        public int hashCode() {
            return this.name.hashCode() ^ this.age;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Person)) {
                return false;
            }
            Person other = (Person)o;
            return this.name.equals(other.name) && this.age == other.age;
        }
    }
}

