/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.Ignition;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class IgniteSqlGroupConcatNotCollocatedTest
extends GridCommonAbstractTest {
    private static final int CLIENT = 7;
    private static final String CACHE_NAME = "cache";

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setCacheConfiguration(new CacheConfiguration[]{new CacheConfiguration(CACHE_NAME).setAffinity((AffinityFunction)new RendezvousAffinityFunction().setPartitions(8)).setQueryEntities(Collections.singletonList(new QueryEntity(Key.class, Value.class)))});
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        this.startGridsMultiThreaded(3, false);
        Ignition.setClientMode((boolean)true);
        try {
            this.startGrid(7);
        }
        finally {
            Ignition.setClientMode((boolean)false);
        }
        IgniteCache c = this.grid(7).cache(CACHE_NAME);
        int k = 0;
        for (int grp = 1; grp < 7; ++grp) {
            for (int i = 0; i < grp; ++i) {
                c.put((Object)new Key(k, grp), (Object)new Value(k, Character.toString((char)(65 + k))));
                ++k;
            }
        }
    }

    protected void afterTestsStopped() throws Exception {
        this.stopAllGrids();
    }

    @Test
    public void testGroupConcatSimple() {
        IgniteCache c = this.ignite(7).cache(CACHE_NAME);
        List res = c.query(new SqlFieldsQuery("select grp, GROUP_CONCAT(str0) from Value group by grp")).getAll();
        for (List row : res) {
            int grp = (Integer)row.get(0);
            String str = (String)row.get(1);
            for (int i = 0; i < grp; ++i) {
                String s = "" + (char)(65 + i + (grp - 1) * grp / 2);
                IgniteSqlGroupConcatNotCollocatedTest.assertTrue((String)("Invalid group_concat result: string doesn't contain value: [str=" + str + ", val=" + s), (boolean)str.contains(s));
            }
        }
    }

    @Test
    public void testGroupConcatCountDistinct() {
        IgniteCache c = this.ignite(7).cache(CACHE_NAME);
        List res = c.query(new SqlFieldsQuery("select count(distinct str0), group_concat(str0) from Value group by grp")).getAll();
        for (List row : res) {
            long cnt = (Long)row.get(0);
            String str = (String)row.get(1);
            int i = 0;
            while ((long)i < cnt) {
                String s = "" + (char)((long)(65 + i) + (cnt - 1L) * cnt / 2L);
                IgniteSqlGroupConcatNotCollocatedTest.assertTrue((String)("Invalid group_concat result: string doesn't contain value: [str=" + str + ", val=" + s), (boolean)str.contains(s));
                ++i;
            }
        }
    }

    @Test
    public void testGroupConcatDistributedException() {
        final IgniteCache c = this.ignite(7).cache(CACHE_NAME);
        GridTestUtils.assertThrowsAnyCause((IgniteLogger)this.log, (Callable)new Callable<Object>(){

            @Override
            public Object call() {
                c.query(new SqlFieldsQuery("select grp, GROUP_CONCAT(str0 ORDER BY str0) from Value group by grp")).getAll();
                return null;
            }
        }, IgniteSQLException.class, (String)"Clauses DISTINCT and ORDER BY are unsupported for GROUP_CONCAT for not collocated data");
    }

    public static class Value {
        @QuerySqlField
        private String str0;
        @QuerySqlField
        private String str1;
        @QuerySqlField
        private String strId;

        public Value(int id, String str) {
            this.str0 = str;
            this.str1 = str + "_1";
            this.strId = "id#" + id;
        }
    }

    public static class Key {
        @QuerySqlField
        private int id;
        @QuerySqlField
        private int grp;

        public Key(int id, int grp) {
            this.id = id;
            this.grp = grp;
        }
    }
}

