/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.Ignition;
import org.apache.ignite.cache.CacheKeyConfiguration;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.AffinityKeyMapped;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class IgniteSqlGroupConcatCollocatedTest
extends GridCommonAbstractTest {
    private static final int CLIENT = 7;
    private static final int KEY_BASE_FOR_DUPLICATES = 100;
    private static final String CACHE_NAME = "cache";

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setCacheConfiguration(new CacheConfiguration[]{new CacheConfiguration(CACHE_NAME).setAffinity((AffinityFunction)new RendezvousAffinityFunction().setPartitions(8)).setQueryEntities(Collections.singletonList(new QueryEntity(Key.class, Value.class)))}).setCacheKeyConfiguration(new CacheKeyConfiguration[]{new CacheKeyConfiguration(Key.class)});
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        int i;
        int grp;
        this.startGridsMultiThreaded(3, false);
        Ignition.setClientMode((boolean)true);
        try {
            this.startGrid(7);
        }
        finally {
            Ignition.setClientMode((boolean)false);
        }
        IgniteCache c = this.grid(7).cache(CACHE_NAME);
        int k = 0;
        for (grp = 1; grp < 7; ++grp) {
            for (i = 0; i < grp; ++i) {
                c.put((Object)new Key(k, grp), (Object)new Value(k, Character.toString((char)(65 + k))));
                ++k;
            }
        }
        k = 0;
        for (grp = 1; grp < 7; ++grp) {
            for (i = 0; i < grp; ++i) {
                c.put((Object)new Key(k + 100, grp), (Object)new Value(k + 100, Character.toString((char)(65 + k))));
                ++k;
            }
        }
    }

    protected void afterTestsStopped() throws Exception {
        this.stopAllGrids();
    }

    @Test
    public void testGroupConcatSimple() {
        IgniteCache c = this.ignite(7).cache(CACHE_NAME);
        List res = c.query(new SqlFieldsQuery("select grp, GROUP_CONCAT(str0) from Value WHERE id < ? group by grp ").setCollocated(true).setArgs(new Object[]{100})).getAll();
        for (List row : res) {
            int grp = (Integer)row.get(0);
            String str = (String)row.get(1);
            for (int i = 0; i < grp; ++i) {
                String s = "" + (char)(65 + i + (grp - 1) * grp / 2);
                IgniteSqlGroupConcatCollocatedTest.assertTrue((String)("Invalid group_concat result: string doesn't contain value: [str=" + str + ", val=" + s), (boolean)str.contains(s));
            }
        }
    }

    @Test
    public void testGroupConcatOrderBy() {
        IgniteCache c = this.ignite(7).cache(CACHE_NAME);
        HashMap<Integer, String> exp = new HashMap<Integer, String>();
        exp.put(1, "id#0=A");
        exp.put(2, "id#1=B; id#2=C");
        exp.put(3, "id#3=D; id#4=E; id#5=F");
        exp.put(4, "id#6=G; id#7=H; id#8=I; id#9=J");
        exp.put(5, "id#10=K; id#11=L; id#12=M; id#13=N; id#14=O");
        exp.put(6, "id#15=P; id#16=Q; id#17=R; id#18=S; id#19=T; id#20=U");
        List res = c.query(new SqlFieldsQuery("select grp, GROUP_CONCAT(strId || '=' || str0 ORDER BY id SEPARATOR '; ') from Value WHERE id < ? group by grp").setCollocated(true).setArgs(new Object[]{100})).getAll();
        HashMap<Integer, String> resMap = this.resultMap(res);
        IgniteSqlGroupConcatCollocatedTest.assertEquals(exp, resMap);
    }

    @Test
    public void testGroupConcatWithDistinct() {
        IgniteCache c = this.ignite(7).cache(CACHE_NAME);
        HashMap<Integer, String> exp = new HashMap<Integer, String>();
        exp.put(1, "A");
        exp.put(2, "B,C");
        exp.put(3, "D,E,F");
        exp.put(4, "G,H,I,J");
        exp.put(5, "K,L,M,N,O");
        exp.put(6, "P,Q,R,S,T,U");
        List res = c.query(new SqlFieldsQuery("select grp, GROUP_CONCAT(DISTINCT str0 ORDER BY str0) from Value group by grp").setCollocated(true)).getAll();
        HashMap<Integer, String> resMap = this.resultMap(res);
        IgniteSqlGroupConcatCollocatedTest.assertEquals(exp, resMap);
    }

    private HashMap<Integer, String> resultMap(List<List<Object>> res) {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        for (List<Object> row : res) {
            map.put((Integer)row.get(0), (String)row.get(1));
        }
        return map;
    }

    public static class Value {
        @QuerySqlField
        private String str0;
        @QuerySqlField
        private String str1;
        @QuerySqlField
        private String strId;

        public Value(int id, String str) {
            this.str0 = str;
            this.str1 = str + "_1";
            this.strId = "id#" + id;
        }
    }

    public static class Key {
        @QuerySqlField
        private int id;
        @QuerySqlField
        @AffinityKeyMapped
        private int grp;

        public Key(int id, int grp) {
            this.id = id;
            this.grp = grp;
        }
    }
}

