/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.List;
import org.apache.ignite.Ignite;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class IgniteSqlEntryCacheModeAgnosticTest
extends GridCommonAbstractTest {
    public static final String HOST = "127.0.0.1";
    private static final String PARTITIONED_CACHE_NAME = "PART_CACHE";
    private static final String REPLICATED_CACHE_NAME = "REPL_CACHE";
    private static final String LOCAL_CACHE_NAME = "LOCAL_CACHE";

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration c = super.getConfiguration(gridName);
        c.setLocalHost(HOST);
        c.setCacheConfiguration(new CacheConfiguration[]{this.cacheConfiguration(LOCAL_CACHE_NAME), this.cacheConfiguration(REPLICATED_CACHE_NAME), this.cacheConfiguration(PARTITIONED_CACHE_NAME)});
        return c;
    }

    private CacheConfiguration cacheConfiguration(String cacheName) throws Exception {
        CacheConfiguration cfg = IgniteSqlEntryCacheModeAgnosticTest.defaultCacheConfiguration();
        cfg.setAffinity((AffinityFunction)new RendezvousAffinityFunction());
        cfg.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        switch (cacheName) {
            case "LOCAL_CACHE": {
                cfg.setCacheMode(CacheMode.LOCAL);
                break;
            }
            case "REPL_CACHE": {
                cfg.setCacheMode(CacheMode.REPLICATED);
                break;
            }
            case "PART_CACHE": {
                cfg.setCacheMode(CacheMode.PARTITIONED);
                cfg.setBackups(0);
                break;
            }
            default: {
                throw new Exception("Invalid cache name " + cacheName);
            }
        }
        cfg.setName(cacheName);
        cfg.setIndexedTypes(new Class[]{Integer.class, String.class});
        return cfg;
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
    }

    @Test
    public void testCrossCacheModeQuery() throws Exception {
        Ignite ignite = this.startGrid();
        ignite.cache(LOCAL_CACHE_NAME).put((Object)1, (Object)LOCAL_CACHE_NAME);
        ignite.cache(REPLICATED_CACHE_NAME).put((Object)1, (Object)REPLICATED_CACHE_NAME);
        ignite.cache(PARTITIONED_CACHE_NAME).put((Object)1, (Object)PARTITIONED_CACHE_NAME);
        List cacheNamesList = F.asList((Object[])new String[]{LOCAL_CACHE_NAME, REPLICATED_CACHE_NAME, PARTITIONED_CACHE_NAME});
        for (String entryCacheName : cacheNamesList) {
            for (String qryCacheName : cacheNamesList) {
                if (entryCacheName.equals(qryCacheName)) continue;
                FieldsQueryCursor cursor = ignite.cache(entryCacheName).query(new SqlFieldsQuery("SELECT _VAL FROM \"" + qryCacheName + "\".String"));
                IgniteSqlEntryCacheModeAgnosticTest.assertEquals((String)qryCacheName, (String)((String)((List)cursor.getAll().get(0)).get(0)));
            }
        }
    }
}

