/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.database.baseline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.cluster.BaselineNode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.cache.distributed.near.IgniteCacheQueryNodeRestartSelfTest;

public class IgniteChangingBaselineCacheQueryNodeRestartSelfTest
extends IgniteCacheQueryNodeRestartSelfTest {
    @Override
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setMaxSize(0xC800000L).setPersistenceEnabled(true)));
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        this.cleanPersistenceDir();
        this.startGrids(this.gridCount());
        this.initStoreStrategy();
        this.grid(0).cluster().active(true);
        this.awaitPartitionMapExchange();
    }

    protected void afterTestsStopped() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    @Override
    protected IgniteInternalFuture createRestartAction(final AtomicBoolean done, final AtomicInteger restartCnt) throws Exception {
        return this.multithreadedAsync(new Callable<Object>(){
            private final long baselineTopChangeInterval = 10000L;
            private final int logFreq = 50;
            private boolean lastOpChangeUp;

            @Override
            public Object call() throws Exception {
                while (!done.get()) {
                    if (this.lastOpChangeUp) {
                        IgniteChangingBaselineCacheQueryNodeRestartSelfTest.this.stopGrid(IgniteChangingBaselineCacheQueryNodeRestartSelfTest.this.gridCount());
                        this.lastOpChangeUp = false;
                    } else {
                        IgniteChangingBaselineCacheQueryNodeRestartSelfTest.this.startGrid(IgniteChangingBaselineCacheQueryNodeRestartSelfTest.this.gridCount());
                        this.lastOpChangeUp = true;
                    }
                    IgniteChangingBaselineCacheQueryNodeRestartSelfTest.this.grid(0).cluster().setBaselineTopology(IgniteChangingBaselineCacheQueryNodeRestartSelfTest.this.baselineNodes(IgniteChangingBaselineCacheQueryNodeRestartSelfTest.this.grid(0).cluster().forServers().nodes()));
                    Thread.sleep(10000L);
                    int c = restartCnt.incrementAndGet();
                    if (c % 50 != 0) continue;
                    IgniteChangingBaselineCacheQueryNodeRestartSelfTest.this.info("BaselineTopology changes: " + c);
                }
                return true;
            }
        }, 1, "restart-thread");
    }

    private Collection<BaselineNode> baselineNodes(Collection<ClusterNode> clNodes) {
        ArrayList<BaselineNode> res = new ArrayList<BaselineNode>(clNodes.size());
        for (ClusterNode clN : clNodes) {
            res.add((BaselineNode)clN);
        }
        return res;
    }
}

