/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.database.baseline;

import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.processors.cache.IgniteCacheLockPartitionOnAffinityRunAtomicCacheOpTest;

public class IgniteBaselineLockPartitionOnAffinityRunAtomicCacheTest
extends IgniteCacheLockPartitionOnAffinityRunAtomicCacheOpTest {
    @Override
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setInitialSize(0xC800000L).setMaxSize(0xC800000L).setPersistenceEnabled(true)));
        return cfg;
    }

    @Override
    protected CacheConfiguration cacheConfiguration(String igniteInstanceName) throws Exception {
        CacheConfiguration ccfg = super.cacheConfiguration(igniteInstanceName);
        ccfg.setBackups(2);
        return ccfg;
    }

    @Override
    protected void beforeTestsStarted() throws Exception {
        this.cleanPersistenceDir();
    }

    @Override
    protected void beforeTest() throws Exception {
        this.cleanPersistenceDir();
        int gridCnt = this.gridCount();
        this.startGrids(gridCnt + 1);
        this.grid(0).active(true);
        this.stopGrid(gridCnt);
        this.startGrid(gridCnt + 1);
        this.fillCaches();
        this.createCaches();
        this.awaitPartitionMapExchange();
    }

    @Override
    protected void afterTest() throws Exception {
        this.destroyCaches();
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    @Override
    protected void afterTestsStopped() throws Exception {
        this.cleanPersistenceDir();
    }
}

