/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.database;

import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheRebalanceMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.persistence.DbCheckpointListener;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.query.QuerySchema;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class IgnitePersistentStoreSchemaLoadTest
extends GridCommonAbstractTest {
    private static final String TMPL_NAME = "test_cache*";
    private static final String TBL_NAME = Person.class.getSimpleName();
    private static final String SQL_CACHE_NAME = QueryUtils.createTableCacheName((String)"PUBLIC", (String)TBL_NAME);
    private static final String STATIC_CACHE_NAME = TBL_NAME;

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        cfg.setCacheConfiguration(new CacheConfiguration[]{this.cacheCfg(TMPL_NAME)});
        DataStorageConfiguration pCfg = new DataStorageConfiguration();
        pCfg.setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true).setMaxSize(0x6400000L));
        pCfg.setCheckpointFrequency(1000L);
        cfg.setDataStorageConfiguration(pCfg);
        return cfg;
    }

    private IgniteConfiguration getConfigurationWithStaticCache(String gridName) throws Exception {
        IgniteConfiguration cfg = this.getConfiguration(gridName);
        CacheConfiguration ccfg = this.cacheCfg(STATIC_CACHE_NAME);
        ccfg.setIndexedTypes(new Class[]{Integer.class, Person.class});
        ccfg.setSqlEscapeAll(true);
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfg});
        return this.optimize(cfg);
    }

    private CacheConfiguration cacheCfg(String name) {
        CacheConfiguration cfg = new CacheConfiguration();
        cfg.setName(name);
        cfg.setRebalanceMode(CacheRebalanceMode.NONE);
        cfg.setAtomicityMode(CacheAtomicityMode.ATOMIC);
        return cfg;
    }

    protected void beforeTest() throws Exception {
        System.setProperty("IGNITE_SKIP_CONFIGURATION_CONSISTENCY_CHECK", "true");
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
        System.clearProperty("IGNITE_SKIP_CONFIGURATION_CONSISTENCY_CHECK");
    }

    @Test
    public void testDynamicSchemaChangesPersistence() throws Exception {
        this.checkSchemaStateAfterNodeRestart(false);
    }

    @Test
    public void testDynamicSchemaChangesPersistenceWithAliveCluster() throws Exception {
        this.checkSchemaStateAfterNodeRestart(true);
    }

    @Test
    public void testDynamicSchemaChangesPersistenceWithStaticCache() throws Exception {
        IgniteEx node = this.startGrid(this.getConfigurationWithStaticCache(this.getTestIgniteInstanceName(0)));
        node.active(true);
        IgniteCache cache = node.cache(STATIC_CACHE_NAME);
        IgnitePersistentStoreSchemaLoadTest.assertNotNull((Object)cache);
        CountDownLatch cnt = this.checkpointLatch(node);
        IgnitePersistentStoreSchemaLoadTest.assertEquals((int)0, (int)this.indexCnt(node, STATIC_CACHE_NAME));
        this.makeDynamicSchemaChanges(node, STATIC_CACHE_NAME);
        this.checkDynamicSchemaChanges(node, STATIC_CACHE_NAME);
        cnt.await();
        this.stopGrid(0);
        node = this.startGrid(0);
        node.active(true);
        this.checkDynamicSchemaChanges(node, STATIC_CACHE_NAME);
    }

    private void checkSchemaStateAfterNodeRestart(boolean aliveCluster) throws Exception {
        IgniteEx node = this.startGrid(0);
        node.active(true);
        if (aliveCluster) {
            this.startGrid(1);
        }
        CountDownLatch cnt = this.checkpointLatch(node);
        node.context().query().querySqlFields(new SqlFieldsQuery("create table \"Person\" (\"id\" int primary key, \"name\" varchar)"), false);
        IgnitePersistentStoreSchemaLoadTest.assertEquals((int)0, (int)this.indexCnt(node, SQL_CACHE_NAME));
        this.makeDynamicSchemaChanges(node, "PUBLIC");
        this.checkDynamicSchemaChanges(node, SQL_CACHE_NAME);
        cnt.await();
        this.stopGrid(0);
        node = this.startGrid(0);
        node.active(true);
        this.checkDynamicSchemaChanges(node, SQL_CACHE_NAME);
        node.context().query().querySqlFields(new SqlFieldsQuery("drop table \"Person\""), false).getAll();
    }

    private int indexCnt(IgniteEx node, String cacheName) {
        QuerySchema schema;
        DynamicCacheDescriptor desc = node.context().cache().cacheDescriptor(cacheName);
        int cnt = 0;
        if (desc != null && (schema = desc.schema()) != null) {
            for (QueryEntity entity : schema.entities()) {
                cnt += entity.getIndexes().size();
            }
        }
        return cnt;
    }

    private int colsCnt(IgniteEx node, String cacheName) {
        QuerySchema schema;
        DynamicCacheDescriptor desc = node.context().cache().cacheDescriptor(cacheName);
        int cnt = 0;
        if (desc != null && (schema = desc.schema()) != null) {
            for (QueryEntity entity : schema.entities()) {
                cnt += entity.getFields().size();
            }
        }
        return cnt;
    }

    private CountDownLatch checkpointLatch(IgniteEx node) {
        final CountDownLatch cnt = new CountDownLatch(1);
        GridCacheDatabaseSharedManager db = (GridCacheDatabaseSharedManager)node.context().cache().context().database();
        db.addCheckpointListener(new DbCheckpointListener(){

            public void onCheckpointBegin(DbCheckpointListener.Context ctx) {
                cnt.countDown();
            }
        });
        return cnt;
    }

    private void makeDynamicSchemaChanges(IgniteEx node, String schema) {
        node.context().query().querySqlFields(new SqlFieldsQuery("create index \"my_idx\" on \"Person\" (\"id\", \"name\")").setSchema(schema), false).getAll();
        node.context().query().querySqlFields(new SqlFieldsQuery("alter table \"Person\" add column (\"age\" int, \"city\" char)").setSchema(schema), false).getAll();
        node.context().query().querySqlFields(new SqlFieldsQuery("alter table \"Person\" drop column \"city\"").setSchema(schema), false).getAll();
    }

    private void checkDynamicSchemaChanges(IgniteEx node, String cacheName) {
        IgnitePersistentStoreSchemaLoadTest.assertEquals((int)1, (int)this.indexCnt(node, cacheName));
        IgnitePersistentStoreSchemaLoadTest.assertEquals((int)3, (int)this.colsCnt(node, cacheName));
    }

    protected static class Person
    implements Serializable {
        private static final long serialVersionUID = 0L;
        @QuerySqlField
        protected int id;
        @QuerySqlField
        protected String name;

        private Person() {
        }

        public Person(int id) {
            this.id = id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Person person = (Person)o;
            return this.id == person.id && (this.name != null ? this.name.equals(person.name) : person.name == null);
        }

        public int hashCode() {
            int res = this.id;
            res = 31 * res + (this.name != null ? this.name.hashCode() : 0);
            return res;
        }
    }
}

