/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.database;

import java.io.Serializable;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheRebalanceMode;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class IgnitePersistentStoreQueryWithMultipleClassesPerCacheTest
extends GridCommonAbstractTest {
    private static final String CACHE_NAME = "test_cache";

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        cfg.setCacheConfiguration(new CacheConfiguration[]{this.cacheCfg(CACHE_NAME)});
        DataStorageConfiguration pCfg = new DataStorageConfiguration();
        pCfg.setCheckpointFrequency(1000L);
        cfg.setDataStorageConfiguration(pCfg);
        return cfg;
    }

    private CacheConfiguration cacheCfg(String name) {
        CacheConfiguration cfg = new CacheConfiguration();
        cfg.setName(name);
        cfg.setRebalanceMode(CacheRebalanceMode.NONE);
        cfg.setAtomicityMode(CacheAtomicityMode.ATOMIC);
        cfg.setIndexedTypes(new Class[]{Integer.class, Country.class, Integer.class, Person.class});
        return cfg;
    }

    protected void beforeTest() throws Exception {
        System.setProperty("IGNITE_SKIP_CONFIGURATION_CONSISTENCY_CHECK", "true");
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
        System.clearProperty("IGNITE_SKIP_CONFIGURATION_CONSISTENCY_CHECK");
    }

    @Test
    public void testSimple() throws Exception {
        IgniteEx ig0 = this.startGrid(0);
        ig0.active(true);
        ig0.cache(CACHE_NAME).put((Object)0, (Object)new Person(0));
        ig0.cache(CACHE_NAME).put((Object)1, (Object)new Country());
        List all = ig0.cache(CACHE_NAME).query(new SqlFieldsQuery("select depId FROM \"test_cache\".Person")).getAll();
        assert (all.size() == 1);
    }

    public static class Country {
        @QuerySqlField(index=true)
        private int id;
        @QuerySqlField
        private String name;
        @QuerySqlField
        private UUID uuid = UUID.randomUUID();
    }

    public static class Person
    implements Serializable {
        private static final long serialVersionUID = 0L;
        @QuerySqlField
        protected int depId;
        @QuerySqlField
        protected String name;
        @QuerySqlField
        protected UUID id = UUID.randomUUID();

        private Person() {
        }

        private Person(int depId) {
            this.depId = depId;
            this.name = "Name-" + this.id + " " + depId;
        }
    }
}

