/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.db.wal;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteCompute;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheRebalanceMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.BinaryConfiguration;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.WALMode;
import org.apache.ignite.internal.DiscoverySpiTestListener;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.managers.discovery.IgniteDiscoverySpi;
import org.apache.ignite.internal.managers.discovery.IgniteDiscoverySpiInternalListener;
import org.apache.ignite.internal.pagemem.FullPageId;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.pagemem.wal.WALIterator;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.pagemem.wal.record.DataEntry;
import org.apache.ignite.internal.pagemem.wal.record.DataRecord;
import org.apache.ignite.internal.pagemem.wal.record.MemoryRecoveryRecord;
import org.apache.ignite.internal.pagemem.wal.record.PageSnapshot;
import org.apache.ignite.internal.pagemem.wal.record.TxRecord;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.PageDeltaRecord;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointEntry;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointEntryType;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStoreManager;
import org.apache.ignite.internal.processors.cache.persistence.filename.PdsConsistentIdProcessor;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetaStorage;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMemoryEx;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.TrackingPageIO;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.GridAbsPredicate;
import org.apache.ignite.internal.util.lang.IgniteInClosureX;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.PA;
import org.apache.ignite.internal.util.typedef.PAX;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteRunnable;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.apache.ignite.testframework.junits.multijvm.IgniteProcessProxy;
import org.apache.ignite.transactions.Transaction;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class IgniteWalRecoveryTest
extends GridCommonAbstractTest {
    private static final String HAS_CACHE = "HAS_CACHE";
    private static final int LARGE_ARR_SIZE = 1025;
    private boolean fork;
    private static final String CACHE_NAME = "partitioned";
    private static final String RENAMED_CACHE_NAME = "partitioned0";
    private static final String CACHE_TO_DESTROY_NAME = "destroyCache";
    private static final String LOC_CACHE_NAME = "local";
    private boolean renamed;
    private int walSegmentSize;
    private int walSegments = 10;
    private boolean logOnly;
    private long customFailureDetectionTimeout = -1L;

    protected boolean isMultiJvm() {
        return this.fork;
    }

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        CacheConfiguration ccfg = this.renamed ? new CacheConfiguration(RENAMED_CACHE_NAME) : new CacheConfiguration(CACHE_NAME);
        ccfg.setAtomicityMode(CacheAtomicityMode.ATOMIC);
        ccfg.setRebalanceMode(CacheRebalanceMode.SYNC);
        ccfg.setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32));
        ccfg.setNodeFilter((IgnitePredicate)new RemoteNodeFilter());
        ccfg.setIndexedTypes(new Class[]{Integer.class, IndexedObject.class});
        CacheConfiguration locCcfg = new CacheConfiguration(LOC_CACHE_NAME);
        locCcfg.setCacheMode(CacheMode.LOCAL);
        locCcfg.setIndexedTypes(new Class[]{Integer.class, IndexedObject.class});
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfg, locCcfg});
        DataStorageConfiguration dbCfg = new DataStorageConfiguration();
        dbCfg.setPageSize(4096);
        DataRegionConfiguration memPlcCfg = new DataRegionConfiguration();
        memPlcCfg.setName("dfltDataRegion");
        memPlcCfg.setInitialSize(0x40000000L);
        memPlcCfg.setMaxSize(0x40000000L);
        memPlcCfg.setPersistenceEnabled(true);
        dbCfg.setDefaultDataRegionConfiguration(memPlcCfg);
        dbCfg.setWalRecordIteratorBufferSize(0x100000);
        dbCfg.setWalHistorySize(2);
        if (this.logOnly) {
            dbCfg.setWalMode(WALMode.LOG_ONLY);
        }
        if (this.walSegmentSize != 0) {
            dbCfg.setWalSegmentSize(this.walSegmentSize);
        }
        dbCfg.setWalSegments(this.walSegments);
        cfg.setDataStorageConfiguration(dbCfg);
        BinaryConfiguration binCfg = new BinaryConfiguration();
        binCfg.setCompactFooter(false);
        cfg.setBinaryConfiguration(binCfg);
        if (!this.getTestIgniteInstanceName(0).equals(gridName)) {
            cfg.setUserAttributes(F.asMap((Object)HAS_CACHE, (Object)true));
        }
        if (this.customFailureDetectionTimeout > 0L) {
            cfg.setFailureDetectionTimeout(this.customFailureDetectionTimeout);
        }
        return cfg;
    }

    protected void beforeTest() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
        this.renamed = false;
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.logOnly = false;
        this.cleanPersistenceDir();
    }

    @Test
    public void testWalBig() throws Exception {
        IgniteEx ignite = this.startGrid(1);
        ignite.cluster().active(true);
        IgniteCache cache = ignite.cache(CACHE_NAME);
        Random rnd = new Random();
        HashMap<Integer, IndexedObject> map = new HashMap<Integer, IndexedObject>();
        for (int i = 0; i < 10000; ++i) {
            if (i % 1000 == 0) {
                X.println((String)(" >> " + i), (Object[])new Object[0]);
            }
            int k = rnd.nextInt(300000);
            IndexedObject v = new IndexedObject(rnd.nextInt(10000));
            cache.put((Object)k, (Object)v);
            map.put(k, v);
        }
        for (Integer k : map.keySet()) {
            IgniteWalRecoveryTest.assertEquals(map.get(k), (Object)cache.get((Object)k));
        }
        this.stopGrid(1);
        ignite = this.startGrid(1);
        ignite.cluster().active(true);
        cache = ignite.cache(CACHE_NAME);
        for (Integer k : map.keySet()) {
            IgniteWalRecoveryTest.assertEquals(map.get(k), (Object)cache.get((Object)k));
        }
    }

    @Test
    public void testWalBigObjectNodeCancel() throws Exception {
        int size;
        int i;
        int MAX_SIZE_POWER = 21;
        IgniteEx ignite = this.startGrid(1);
        ignite.cluster().active(true);
        IgniteCache cache = ignite.cache(CACHE_NAME);
        for (i = 0; i < 21; ++i) {
            size = 1 << i;
            cache.put((Object)("key_" + i), (Object)this.createTestData(size));
        }
        this.stopGrid(1, true);
        ignite = this.startGrid(1);
        ignite.cluster().active(true);
        cache = ignite.cache(CACHE_NAME);
        for (i = 0; i < 21; ++i) {
            size = 1 << i;
            int[] data = this.createTestData(size);
            int[] val = (int[])cache.get((Object)("key_" + i));
            IgniteWalRecoveryTest.assertTrue((String)("Invalid data. [key=key_" + i + ']'), (boolean)Arrays.equals(data, val));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSwitchClassLoader() throws Exception {
        try {
            int i;
            IgniteEx igniteEx = this.startGrid(1);
            this.startGrid(2);
            igniteEx.cluster().active(true);
            IgniteCache cache = igniteEx.cache(CACHE_NAME);
            ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
            ClassLoader newCl = IgniteWalRecoveryTest.getExternalClassLoader();
            Thread.currentThread().setContextClassLoader(newCl);
            for (i = 0; i < 10; ++i) {
                cache.put((Object)i, (Object)(i % 2 == 0 ? EnumVal.VAL1 : EnumVal.VAL2));
            }
            for (i = 0; i < 10; ++i) {
                assert (cache.containsKey((Object)i));
            }
            cache.clear();
            Thread.currentThread().setContextClassLoader(oldCl);
            for (i = 0; i < 10; ++i) {
                cache.put((Object)i, (Object)(i % 2 == 0 ? EnumVal.VAL1 : EnumVal.VAL2));
            }
            for (i = 0; i < 10; ++i) {
                assert (cache.containsKey((Object)i));
            }
        }
        finally {
            this.stopAllGrids();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWalSimple() throws Exception {
        try {
            IndexedObject o;
            int i;
            IgniteEx ignite = this.startGrid(1);
            ignite.cluster().active(true);
            IgniteCache cache = ignite.cache(CACHE_NAME);
            this.info(" --> step1");
            for (i = 0; i < 10000; i += 2) {
                cache.put((Object)i, (Object)new IndexedObject(i));
            }
            this.info(" --> step2");
            for (i = 0; i < 10000; i += 3) {
                cache.put((Object)i, (Object)new IndexedObject(i * 2));
            }
            this.info(" --> step3");
            for (i = 0; i < 10000; i += 7) {
                cache.put((Object)i, (Object)new IndexedObject(i * 3));
            }
            this.info(" --> check1");
            for (i = 0; i < 10000; ++i) {
                o = i % 7 == 0 ? new IndexedObject(i * 3) : (i % 3 == 0 ? new IndexedObject(i * 2) : (i % 2 == 0 ? new IndexedObject(i) : null));
                IgniteWalRecoveryTest.assertEquals((Object)o, (Object)cache.get((Object)i));
            }
            this.stopGrid(1);
            ignite = this.startGrid(1);
            ignite.cluster().active(true);
            cache = ignite.cache(CACHE_NAME);
            this.info(" --> check2");
            for (i = 0; i < 10000; ++i) {
                o = i % 7 == 0 ? new IndexedObject(i * 3) : (i % 3 == 0 ? new IndexedObject(i * 2) : (i % 2 == 0 ? new IndexedObject(i) : null));
                IgniteWalRecoveryTest.assertEquals((Object)o, (Object)cache.get((Object)i));
            }
            this.info(" --> ok");
        }
        finally {
            this.stopAllGrids();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWalLargeValue() throws Exception {
        try {
            byte[] data;
            int i;
            IgniteEx ignite = this.startGrid(1);
            ignite.cluster().active(true);
            IgniteCache cache = ignite.cache(CACHE_NAME);
            for (i = 0; i < 10000; ++i) {
                data = new byte[i];
                Arrays.fill(data, (byte)i);
                cache.put((Object)i, (Object)data);
                if (i % 1000 != 0) continue;
                X.println((String)(" ---> put: " + i), (Object[])new Object[0]);
            }
            this.stopGrid(1);
            ignite = this.startGrid(1);
            ignite.cluster().active(true);
            cache = ignite.cache(CACHE_NAME);
            this.info(" --> check2");
            for (i = 0; i < 10000; ++i) {
                data = new byte[i];
                Arrays.fill(data, (byte)i);
                byte[] loaded = (byte[])cache.get((Object)i);
                Assert.assertArrayEquals((byte[])data, (byte[])loaded);
                if (i % 1000 != 0) continue;
                X.println((String)(" ---> get: " + i), (Object[])new Object[0]);
            }
        }
        finally {
            this.stopAllGrids();
        }
    }

    @Test
    public void testBinaryRecoverBeforePMEWhenMiddleCheckpoint() throws Exception {
        this.startGrids(3);
        IgniteEx ig2 = this.grid(2);
        ig2.cluster().active(true);
        IgniteCache cache = ig2.cache(CACHE_NAME);
        for (int i = 1; i <= 4000; ++i) {
            cache.put((Object)i, (Object)new BigObject(i));
        }
        BigObject objToCheck = new BigObject(1);
        ig2.getOrCreateCache(CACHE_TO_DESTROY_NAME).put((Object)1, (Object)objToCheck);
        final GridCacheDatabaseSharedManager dbMgr = (GridCacheDatabaseSharedManager)ig2.context().cache().context().database();
        GridFutureAdapter cpFinishFut = dbMgr.forceCheckpoint("force checkpoint").finishFuture();
        cpFinishFut.listen((IgniteInClosure)new IgniteInClosureX<IgniteInternalFuture>(){

            public void applyx(IgniteInternalFuture fut0) throws IgniteCheckedException {
                try {
                    CheckpointEntry cpEntry = dbMgr.checkpointHistory().lastCheckpoint();
                    String cpEndFileName = GridCacheDatabaseSharedManager.checkpointFileName((CheckpointEntry)cpEntry, (CheckpointEntryType)CheckpointEntryType.END);
                    Files.delete(Paths.get(dbMgr.checkpointDirectory().getAbsolutePath(), cpEndFileName));
                    IgniteWalRecoveryTest.this.log.info("Checkpoint marker removed [cpEndFileName=" + cpEndFileName + ']');
                }
                catch (IOException e) {
                    throw new IgniteCheckedException((Throwable)e);
                }
            }
        });
        IgniteInternalCache destoryCache = ig2.cachex(CACHE_TO_DESTROY_NAME);
        FilePageStoreManager pageStoreMgr = (FilePageStoreManager)destoryCache.context().shared().pageStore();
        File destroyCacheWorkDir = pageStoreMgr.cacheWorkDir(destoryCache.configuration());
        this.stopAllGrids();
        File[] files = destroyCacheWorkDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith("cache_data.dat");
            }
        });
        IgniteWalRecoveryTest.assertTrue((files.length > 0 ? 1 : 0) != 0);
        for (File file : files) {
            IgniteWalRecoveryTest.assertTrue((String)("Can't remove " + file.getAbsolutePath()), (boolean)file.delete());
        }
        this.startGrids(2);
        final String ig2Name = this.getTestIgniteInstanceName(2);
        IgniteConfiguration onJoinCfg = this.optimize(this.getConfiguration(ig2Name));
        ((IgniteDiscoverySpi)onJoinCfg.getDiscoverySpi()).setInternalListener((IgniteDiscoverySpiInternalListener)new DiscoverySpiTestListener(){

            public void beforeJoin(ClusterNode locNode, IgniteLogger log) {
                String nodeName = (String)locNode.attribute("org.apache.ignite.ignite.name");
                GridCacheSharedContext sharedCtx = ((IgniteEx)IgniteWalRecoveryTest.this.ignite(IgniteWalRecoveryTest.this.getTestIgniteInstanceIndex(nodeName))).context().cache().context();
                if (nodeName.equals(ig2Name)) {
                    junit.framework.Assert.assertFalse((boolean)((GridCacheDatabaseSharedManager)sharedCtx.database()).checkpointHistory().checkpoints().isEmpty());
                }
                super.beforeJoin(locNode, log);
            }
        });
        Ignite restoredIg2 = this.startGrid(ig2Name, onJoinCfg);
        this.awaitPartitionMapExchange();
        IgniteWalRecoveryTest.assertEquals((Object)restoredIg2.cache(CACHE_TO_DESTROY_NAME).get((Object)1), (Object)objToCheck);
    }

    @Test
    public void testWalRolloverMultithreadedDefault() throws Exception {
        this.logOnly = false;
        this.checkWalRolloverMultithreaded();
    }

    @Test
    public void testWalRolloverMultithreadedLogOnly() throws Exception {
        this.logOnly = true;
        this.checkWalRolloverMultithreaded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHugeCheckpointRecord() throws Exception {
        long prevFDTimeout = this.customFailureDetectionTimeout;
        try {
            this.customFailureDetectionTimeout = 40000L;
            final IgniteEx ignite = this.startGrid(1);
            ignite.cluster().active(true);
            for (int i = 0; i < 50; ++i) {
                CacheConfiguration ccfg = new CacheConfiguration("cache-" + i);
                ccfg.setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 128));
                IgniteCache cache = ignite.getOrCreateCache(ccfg);
                cache.put((Object)i, (Object)i);
            }
            final long endTime = System.currentTimeMillis() + 30000L;
            IgniteInternalFuture fut = GridTestUtils.runMultiThreadedAsync((Callable)new Callable<Void>(){

                @Override
                public Void call() {
                    ThreadLocalRandom rnd = ThreadLocalRandom.current();
                    while (U.currentTimeMillis() < endTime) {
                        IgniteCache cache = ignite.cache("cache-" + ((Random)rnd).nextInt(50));
                        cache.put((Object)((Random)rnd).nextInt(50000), (Object)((Random)rnd).nextInt());
                    }
                    return null;
                }
            }, (int)16, (String)"put-thread");
            while (System.currentTimeMillis() < endTime) {
                ignite.context().cache().context().database().wakeupForCheckpoint("test").get();
                U.sleep((long)500L);
            }
            fut.get();
        }
        finally {
            this.customFailureDetectionTimeout = prevFDTimeout;
            this.stopAllGrids();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkWalRolloverMultithreaded() throws Exception {
        this.walSegmentSize = 0x200000;
        final long endTime = System.currentTimeMillis() + 60000L;
        try {
            IgniteEx ignite = this.startGrid(1);
            ignite.cluster().active(true);
            final IgniteCache cache = ignite.cache(CACHE_NAME);
            GridTestUtils.runMultiThreaded((Callable)new Callable<Void>(){

                @Override
                public Void call() {
                    ThreadLocalRandom rnd = ThreadLocalRandom.current();
                    while (U.currentTimeMillis() < endTime) {
                        cache.put((Object)((Random)rnd).nextInt(50000), (Object)((Random)rnd).nextInt());
                    }
                    return null;
                }
            }, (int)16, (String)"put-thread");
        }
        finally {
            this.stopAllGrids();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWalRenameDirSimple() throws Exception {
        try {
            IgniteEx ignite = this.startGrid(1);
            ignite.cluster().active(true);
            IgniteCache cache = ignite.cache(CACHE_NAME);
            for (int i = 0; i < 100; ++i) {
                cache.put((Object)i, (Object)new IndexedObject(i));
            }
            Object consistentId = ignite.cluster().localNode().consistentId();
            this.stopGrid(1);
            File cacheDir = this.cacheDir(CACHE_NAME, consistentId.toString());
            this.renamed = cacheDir.renameTo(new File(cacheDir.getParent(), "cache-partitioned0"));
            assert (this.renamed);
            ignite = this.startGrid(1);
            ignite.cluster().active(true);
            cache = ignite.cache(RENAMED_CACHE_NAME);
            for (int i = 0; i < 100; ++i) {
                IgniteWalRecoveryTest.assertEquals((Object)new IndexedObject(i), (Object)cache.get((Object)i));
            }
        }
        finally {
            this.stopAllGrids();
        }
    }

    private File cacheDir(String cacheName, String consId) throws IgniteCheckedException {
        String subfolderName = PdsConsistentIdProcessor.genNewStyleSubfolderName((int)0, (UUID)UUID.fromString(consId));
        File dbDir = U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"db", (boolean)false);
        assert (dbDir.exists());
        File consIdDir = new File(dbDir.getAbsolutePath(), subfolderName);
        assert (consIdDir.exists());
        File cacheDir = new File(consIdDir.getAbsolutePath(), "cache-" + cacheName);
        assert (cacheDir.exists());
        return cacheDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRecoveryNoCheckpoint() throws Exception {
        try {
            IgniteEx ctrlGrid = this.startGrid(0);
            this.fork = true;
            IgniteEx cacheGrid = this.startGrid(1);
            ctrlGrid.cluster().active(true);
            ctrlGrid.compute(ctrlGrid.cluster().forRemotes()).run((IgniteRunnable)new LoadRunnable(false));
            this.info("Killing remote process...");
            ((IgniteProcessProxy)cacheGrid).kill();
            final IgniteEx g0 = ctrlGrid;
            GridTestUtils.waitForCondition((GridAbsPredicate)new PA(){

                public boolean apply() {
                    return g0.cluster().nodes().size() == 1;
                }
            }, (long)this.getTestTimeout());
            this.fork = false;
            cacheGrid = this.startGrid(1);
            IgniteCache cache = cacheGrid.cache(CACHE_NAME);
            for (int i = 0; i < 10000; ++i) {
                IgniteWalRecoveryTest.assertEquals((Object)new IndexedObject(i), (Object)cache.get((Object)i));
            }
            List res = cache.query(new SqlFieldsQuery("select count(iVal) from IndexedObject")).getAll();
            IgniteWalRecoveryTest.assertEquals((int)1, (int)res.size());
            IgniteWalRecoveryTest.assertEquals((Object)10000L, ((List)res.get(0)).get(0));
            IgniteCache locCache = cacheGrid.cache(LOC_CACHE_NAME);
            for (int i = 0; i < 10000; ++i) {
                IgniteWalRecoveryTest.assertEquals((Object)new IndexedObject(i), (Object)locCache.get((Object)i));
            }
        }
        finally {
            this.stopAllGrids();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRecoveryLargeNoCheckpoint() throws Exception {
        try {
            IgniteEx ctrlGrid = this.startGrid(0);
            this.fork = true;
            IgniteEx cacheGrid = this.startGrid(1);
            ctrlGrid.cluster().active(true);
            ctrlGrid.compute(ctrlGrid.cluster().forRemotes()).run((IgniteRunnable)new LargeLoadRunnable(false));
            this.info("Killing remote process...");
            ((IgniteProcessProxy)cacheGrid).kill();
            final IgniteEx g0 = ctrlGrid;
            GridTestUtils.waitForCondition((GridAbsPredicate)new PA(){

                public boolean apply() {
                    return g0.cluster().nodes().size() == 1;
                }
            }, (long)this.getTestTimeout());
            this.fork = false;
            cacheGrid = this.startGrid(1);
            IgniteCache cache = cacheGrid.cache(CACHE_NAME);
            IgniteCache locCache = cacheGrid.cache(LOC_CACHE_NAME);
            for (int i = 0; i < 1000; ++i) {
                long[] data = new long[1025];
                Arrays.fill(data, (long)i);
                Assert.assertArrayEquals((long[])data, (long[])((long[])cache.get((Object)i)));
                Assert.assertArrayEquals((long[])data, (long[])((long[])locCache.get((Object)i)));
            }
        }
        finally {
            this.stopAllGrids();
        }
    }

    protected long getTestTimeout() {
        return TimeUnit.MINUTES.toMillis(20L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRandomCrash() throws Exception {
        try {
            IgniteEx ctrlGrid = this.startGrid(0);
            this.fork = true;
            IgniteEx cacheGrid = this.startGrid(1);
            ctrlGrid.cluster().active(true);
            IgniteCompute rmt = ctrlGrid.compute(ctrlGrid.cluster().forRemotes());
            rmt.run((IgniteRunnable)new LoadRunnable(false));
            this.info(">>> Finished cache population.");
            rmt.run((IgniteRunnable)new AsyncLoadRunnable());
            Thread.sleep(20000L);
            this.info(">>> Killing remote process...");
            ((IgniteProcessProxy)cacheGrid).kill();
            this.startGrid(1);
            Boolean res = (Boolean)rmt.call((IgniteCallable)new VerifyCallable());
            IgniteWalRecoveryTest.assertTrue((boolean)res);
        }
        finally {
            this.stopAllGrids();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLargeRandomCrash() throws Exception {
        try {
            IgniteEx ctrlGrid = this.startGrid(0);
            this.fork = true;
            IgniteEx cacheGrid = this.startGrid(1);
            ctrlGrid.cluster().active(true);
            IgniteCompute rmt = ctrlGrid.compute(ctrlGrid.cluster().forRemotes());
            rmt.run((IgniteRunnable)new LargeLoadRunnable(false));
            this.info(">>> Finished cache population.");
            rmt.run((IgniteRunnable)new AsyncLargeLoadRunnable());
            Thread.sleep(20000L);
            this.info(">>> Killing remote process...");
            ((IgniteProcessProxy)cacheGrid).kill();
            this.startGrid(1);
            Boolean res = (Boolean)rmt.call((IgniteCallable)new VerifyLargeCallable());
            IgniteWalRecoveryTest.assertTrue((boolean)res);
        }
        finally {
            this.stopAllGrids();
        }
    }

    @Test
    public void testDestroyCache() throws Exception {
        try {
            IgniteEx ignite = this.startGrid(1);
            ignite.cluster().active(true);
            IgniteCache cache = ignite.getOrCreateCache("test");
            cache.put((Object)1, (Object)new IndexedObject(1));
            ignite.destroyCache("test");
            cache = ignite.getOrCreateCache("test");
            IgniteWalRecoveryTest.assertNull((Object)cache.get((Object)1));
        }
        finally {
            this.stopAllGrids();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEvictPartition() throws Exception {
        try {
            int i;
            IgniteEx ignite1 = this.startGrid("node1");
            ignite1.cluster().active(true);
            IgniteCache cache1 = ignite1.cache(CACHE_NAME);
            for (int i2 = 0; i2 < 100; ++i2) {
                cache1.put((Object)i2, (Object)new IndexedObject(i2));
            }
            IgniteEx ignite2 = this.startGrid("node2");
            IgniteCache cache2 = ignite2.cache(CACHE_NAME);
            for (i = 0; i < 100; ++i) {
                IgniteWalRecoveryTest.assertEquals((Object)new IndexedObject(i), (Object)cache1.get((Object)i));
                IgniteWalRecoveryTest.assertEquals((Object)new IndexedObject(i), (Object)cache2.get((Object)i));
            }
            ignite1.close();
            ignite2.close();
            ignite1 = this.startGrid("node1");
            ignite2 = this.startGrid("node2");
            ignite1.cluster().active(true);
            cache1 = ignite1.cache(CACHE_NAME);
            cache2 = ignite2.cache(CACHE_NAME);
            for (i = 0; i < 100; ++i) {
                IgniteWalRecoveryTest.assertEquals((Object)new IndexedObject(i), (Object)cache1.get((Object)i));
                IgniteWalRecoveryTest.assertEquals((Object)new IndexedObject(i), (Object)cache2.get((Object)i));
            }
        }
        finally {
            this.stopAllGrids();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetastorage() throws Exception {
        try {
            int i;
            int cnt = 5000;
            IgniteEx ignite0 = this.startGrid("node1");
            IgniteEx ignite1 = this.startGrid("node2");
            ignite1.cluster().active(true);
            GridCacheSharedContext sharedCtx0 = ignite0.context().cache().context();
            GridCacheSharedContext sharedCtx1 = ignite1.context().cache().context();
            MetaStorage storage0 = sharedCtx0.database().metaStorage();
            MetaStorage storage1 = sharedCtx1.database().metaStorage();
            assert (storage0 != null);
            for (i = 0; i < cnt; ++i) {
                sharedCtx0.database().checkpointReadLock();
                try {
                    storage0.putData(String.valueOf(i), new byte[]{(byte)(i % 256), 2, 3});
                }
                finally {
                    sharedCtx0.database().checkpointReadUnlock();
                }
                byte[] b1 = new byte[i + 3];
                b1[0] = 1;
                b1[1] = 2;
                b1[2] = 3;
                sharedCtx1.database().checkpointReadLock();
                try {
                    storage1.putData(String.valueOf(i), b1);
                    continue;
                }
                finally {
                    sharedCtx1.database().checkpointReadUnlock();
                }
            }
            for (i = 0; i < cnt; ++i) {
                byte[] d1 = storage0.getData(String.valueOf(i));
                IgniteWalRecoveryTest.assertEquals((int)3, (int)d1.length);
                IgniteWalRecoveryTest.assertEquals((byte)((byte)(i % 256)), (byte)d1[0]);
                IgniteWalRecoveryTest.assertEquals((int)2, (int)d1[1]);
                IgniteWalRecoveryTest.assertEquals((int)3, (int)d1[2]);
                byte[] d2 = storage1.getData(String.valueOf(i));
                IgniteWalRecoveryTest.assertEquals((int)(i + 3), (int)d2.length);
                IgniteWalRecoveryTest.assertEquals((int)1, (int)d2[0]);
                IgniteWalRecoveryTest.assertEquals((int)2, (int)d2[1]);
                IgniteWalRecoveryTest.assertEquals((int)3, (int)d2[2]);
            }
        }
        finally {
            this.stopAllGrids();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetastorageLargeArray() throws Exception {
        try {
            int k;
            int i;
            int cnt = 5000;
            int arraySize = 32768;
            IgniteEx ignite = this.startGrid("node1");
            ignite.cluster().active(true);
            GridCacheSharedContext sharedCtx = ignite.context().cache().context();
            MetaStorage storage = sharedCtx.database().metaStorage();
            for (i = 0; i < cnt; ++i) {
                byte[] b1 = new byte[arraySize];
                for (k = 0; k < arraySize; ++k) {
                    b1[k] = (byte)(k % 100);
                }
                sharedCtx.database().checkpointReadLock();
                try {
                    storage.putData(String.valueOf(i), b1);
                    continue;
                }
                finally {
                    sharedCtx.database().checkpointReadUnlock();
                }
            }
            for (i = 0; i < cnt; ++i) {
                byte[] d2 = storage.getData(String.valueOf(i));
                IgniteWalRecoveryTest.assertEquals((int)arraySize, (int)d2.length);
                for (k = 0; k < arraySize; ++k) {
                    IgniteWalRecoveryTest.assertEquals((byte)((byte)(k % 100)), (byte)d2[k]);
                }
            }
        }
        finally {
            this.stopAllGrids();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetastorageRemove() throws Exception {
        try {
            int i;
            int cnt = 400;
            IgniteEx ignite0 = this.startGrid("node1");
            ignite0.cluster().active(true);
            GridCacheSharedContext sharedCtx0 = ignite0.context().cache().context();
            MetaStorage storage = sharedCtx0.database().metaStorage();
            assert (storage != null);
            for (i = 0; i < cnt; ++i) {
                sharedCtx0.database().checkpointReadLock();
                try {
                    storage.putData(String.valueOf(i), new byte[]{1, 2, 3});
                    continue;
                }
                finally {
                    sharedCtx0.database().checkpointReadUnlock();
                }
            }
            for (i = 0; i < 10; ++i) {
                sharedCtx0.database().checkpointReadLock();
                try {
                    storage.removeData(String.valueOf(i));
                    continue;
                }
                finally {
                    sharedCtx0.database().checkpointReadUnlock();
                }
            }
            for (i = 10; i < cnt; ++i) {
                byte[] d1 = storage.getData(String.valueOf(i));
                IgniteWalRecoveryTest.assertEquals((int)3, (int)d1.length);
                IgniteWalRecoveryTest.assertEquals((int)1, (int)d1[0]);
                IgniteWalRecoveryTest.assertEquals((int)2, (int)d1[1]);
                IgniteWalRecoveryTest.assertEquals((int)3, (int)d1[2]);
            }
        }
        finally {
            this.stopAllGrids();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetastorageUpdate() throws Exception {
        try {
            int i;
            int cnt = 2000;
            IgniteEx ignite0 = this.startGrid("node1");
            ignite0.cluster().active(true);
            GridCacheSharedContext sharedCtx0 = ignite0.context().cache().context();
            MetaStorage storage = sharedCtx0.database().metaStorage();
            assert (storage != null);
            for (i = 0; i < cnt; ++i) {
                sharedCtx0.database().checkpointReadLock();
                try {
                    storage.putData(String.valueOf(i), new byte[]{1, 2, 3});
                    continue;
                }
                finally {
                    sharedCtx0.database().checkpointReadUnlock();
                }
            }
            for (i = 0; i < cnt; ++i) {
                sharedCtx0.database().checkpointReadLock();
                try {
                    storage.putData(String.valueOf(i), new byte[]{2, 2, 3, 4});
                    continue;
                }
                finally {
                    sharedCtx0.database().checkpointReadUnlock();
                }
            }
            for (i = 0; i < cnt; ++i) {
                byte[] d1 = storage.getData(String.valueOf(i));
                IgniteWalRecoveryTest.assertEquals((int)4, (int)d1.length);
                IgniteWalRecoveryTest.assertEquals((int)2, (int)d1[0]);
                IgniteWalRecoveryTest.assertEquals((int)2, (int)d1[1]);
                IgniteWalRecoveryTest.assertEquals((int)3, (int)d1[2]);
            }
        }
        finally {
            this.stopAllGrids();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetastorageWalRestore() throws Exception {
        try {
            byte[] value;
            int i;
            int cnt = 2000;
            IgniteEx ignite0 = this.startGrid(0);
            ignite0.cluster().active(true);
            GridCacheSharedContext sharedCtx0 = ignite0.context().cache().context();
            MetaStorage storage = sharedCtx0.database().metaStorage();
            assert (storage != null);
            for (i = 0; i < cnt; ++i) {
                sharedCtx0.database().checkpointReadLock();
                try {
                    storage.putData(String.valueOf(i), new byte[]{1, 2, 3});
                    continue;
                }
                finally {
                    sharedCtx0.database().checkpointReadUnlock();
                }
            }
            for (i = 0; i < cnt; ++i) {
                value = storage.getData(String.valueOf(i));
                assert (value != null);
                assert (value.length == 3);
            }
            this.stopGrid(0);
            ignite0 = this.startGrid(0);
            ignite0.cluster().active(true);
            sharedCtx0 = ignite0.context().cache().context();
            storage = sharedCtx0.database().metaStorage();
            assert (storage != null);
            for (i = 0; i < cnt; ++i) {
                value = storage.getData(String.valueOf(i));
                assert (value != null);
            }
        }
        finally {
            this.stopAllGrids();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAbsentDeadlock_Iterator_RollOver_Archivation() throws Exception {
        try {
            this.walSegments = 2;
            this.walSegmentSize = 524288;
            IgniteEx ignite0 = this.startGrid("node0");
            ignite0.active(true);
            IgniteCache cache0 = ignite0.cache(CACHE_NAME);
            for (int i = 0; i < 100; ++i) {
                cache0.put((Object)i, (Object)new IndexedObject(i));
            }
            GridCacheSharedContext sharedCtx = ignite0.context().cache().context();
            GridCacheDatabaseSharedManager db = (GridCacheDatabaseSharedManager)sharedCtx.database();
            db.waitForCheckpoint("test");
            db.enableCheckpoints(false).get();
            WALPointer ptr = sharedCtx.wal().log((WALRecord)new MemoryRecoveryRecord(U.currentTimeMillis()));
            this.info("Replay marker: " + ptr);
            for (int i = 100; i < 200; ++i) {
                cache0.put((Object)i, (Object)new IndexedObject(i));
            }
            CountDownLatch insertFinished = new CountDownLatch(1);
            GridTestUtils.runAsync(() -> {
                try (WALIterator it = sharedCtx.wal().replay(ptr);){
                    if (it.hasNext()) {
                        it.next();
                        insertFinished.await();
                    }
                }
                return null;
            });
            IgniteInternalFuture future = GridTestUtils.runAsync(() -> {
                for (int i = 0; i < 10000; ++i) {
                    cache0.put((Object)i, (Object)new IndexedObject(i));
                }
                return null;
            });
            future.get();
            insertFinished.countDown();
            ignite0.close();
        }
        finally {
            this.stopAllGrids();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testApplyDeltaRecords() throws Exception {
        try {
            int i;
            IgniteEx ignite0 = this.startGrid("node0");
            ignite0.cluster().active(true);
            IgniteCache cache0 = ignite0.cache(CACHE_NAME);
            for (int i2 = 0; i2 < 1000; ++i2) {
                cache0.put((Object)i2, (Object)new IndexedObject(i2));
            }
            GridCacheSharedContext sharedCtx = ignite0.context().cache().context();
            GridCacheDatabaseSharedManager db = (GridCacheDatabaseSharedManager)sharedCtx.database();
            db.waitForCheckpoint("test");
            db.enableCheckpoints(false).get();
            WALPointer ptr = sharedCtx.wal().log((WALRecord)new MemoryRecoveryRecord(U.currentTimeMillis()));
            this.info("Replay marker: " + ptr);
            for (i = 1000; i < 5000; ++i) {
                cache0.put((Object)i, (Object)new IndexedObject(i));
            }
            this.info("Done puts...");
            for (i = 2000; i < 3000; ++i) {
                cache0.remove((Object)i);
            }
            this.info("Done removes...");
            for (i = 5000; i < 6000; ++i) {
                cache0.put((Object)i, (Object)new IndexedObject(i));
            }
            this.info("Done puts...");
            HashMap<FullPageId, byte[]> rolledPages = new HashMap<FullPageId, byte[]>();
            int pageSize = sharedCtx.database().pageSize();
            ByteBuffer buf = ByteBuffer.allocateDirect(pageSize);
            WALIterator it = sharedCtx.wal().replay(ptr);
            Object object = null;
            try {
                while (it.hasNext()) {
                    IgniteBiTuple igniteBiTuple = (IgniteBiTuple)it.next();
                    WALRecord rec = (WALRecord)igniteBiTuple.get2();
                    if (rec instanceof PageSnapshot) {
                        PageSnapshot page = (PageSnapshot)rec;
                        rolledPages.put(page.fullPageId(), page.pageData());
                        continue;
                    }
                    if (!(rec instanceof PageDeltaRecord)) continue;
                    PageDeltaRecord delta = (PageDeltaRecord)rec;
                    FullPageId fullId = new FullPageId(delta.pageId(), delta.groupId());
                    byte[] pageData = (byte[])rolledPages.get(fullId);
                    if (pageData == null) {
                        pageData = new byte[pageSize];
                        rolledPages.put(fullId, pageData);
                    }
                    IgniteWalRecoveryTest.assertNotNull((String)("Missing page snapshot [page=" + fullId + ", delta=" + delta + ']'), (Object)pageData);
                    buf.order(ByteOrder.nativeOrder());
                    buf.position(0);
                    buf.put(pageData);
                    buf.position(0);
                    delta.applyDelta(sharedCtx.database().dataRegion(null).pageMemory(), GridUnsafe.bufferAddress((ByteBuffer)buf));
                    buf.position(0);
                    buf.get(pageData);
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (it != null) {
                    if (object != null) {
                        try {
                            it.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        it.close();
                    }
                }
            }
            this.info("Done apply...");
            PageMemoryEx pageMem = (PageMemoryEx)db.dataRegion(null).pageMemory();
            for (Map.Entry entry : rolledPages.entrySet()) {
                FullPageId fullId = (FullPageId)entry.getKey();
                ignite0.context().cache().context().database().checkpointReadLock();
                try {
                    long page = pageMem.acquirePage(fullId.groupId(), fullId.pageId(), true);
                    try {
                        long bufPtr = pageMem.writeLock(fullId.groupId(), fullId.pageId(), page, true);
                        try {
                            byte[] data = (byte[])entry.getValue();
                            for (int i3 = 0; i3 < data.length; ++i3) {
                                if (fullId.pageId() == ((TrackingPageIO)TrackingPageIO.VERSIONS.latest()).trackingPageFor(fullId.pageId(), db.pageSize())) continue;
                                IgniteWalRecoveryTest.assertEquals((String)("page=" + fullId + ", pos=" + i3), (byte)PageUtils.getByte((long)bufPtr, (int)i3), (byte)data[i3]);
                            }
                        }
                        finally {
                            pageMem.writeUnlock(fullId.groupId(), fullId.pageId(), page, null, false, true);
                        }
                    }
                    finally {
                        pageMem.releasePage(fullId.groupId(), fullId.pageId(), page);
                    }
                }
                finally {
                    ignite0.context().cache().context().database().checkpointReadUnlock();
                }
            }
            ignite0.close();
        }
        finally {
            this.stopAllGrids();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRecoveryOnTransactionalAndPartitionedCache() throws Exception {
        IgniteEx ignite = (IgniteEx)this.startGrids(3);
        ignite.cluster().active(true);
        try {
            String cacheName = "transactional";
            CacheConfiguration cacheConfiguration = new CacheConfiguration("transactional").setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32)).setCacheMode(CacheMode.PARTITIONED).setRebalanceMode(CacheRebalanceMode.SYNC).setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC).setBackups(2);
            ignite.createCache(cacheConfiguration);
            IgniteCache cache = ignite.cache("transactional");
            HashMap map = new HashMap();
            int transactions = 100;
            int operationsPerTransaction = 40;
            Random random = new Random();
            for (int t = 1; t <= 100; ++t) {
                Transaction tx = ignite.transactions().txStart(TransactionConcurrency.OPTIMISTIC, TransactionIsolation.READ_COMMITTED);
                HashMap<Integer, BigObject> changesInTransaction = new HashMap<Integer, BigObject>();
                for (int op = 0; op < 40; ++op) {
                    int key = random.nextInt(1000) + 1;
                    BigObject value = random.nextBoolean() ? this.randomString(random) + key : new BigObject(key);
                    changesInTransaction.put(key, value);
                    cache.put((Object)key, (Object)value);
                }
                if (random.nextBoolean()) {
                    tx.commit();
                    map.putAll(changesInTransaction);
                } else {
                    tx.rollback();
                }
                if (t % 50 != 0) continue;
                this.log.info("Finished transaction " + t);
            }
            this.stopAllGrids();
            ignite = (IgniteEx)this.startGrids(3);
            ignite.cluster().active(true);
            cache = ignite.cache("transactional");
            for (Object key : map.keySet()) {
                Object expectedValue = map.get(key);
                Object actualValue = cache.get(key);
                Assert.assertEquals((String)("Unexpected value for key " + key), expectedValue, (Object)actualValue);
            }
        }
        finally {
            this.stopAllGrids();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTxRecordsConsistency() throws Exception {
        System.setProperty("IGNITE_WAL_LOG_TX_RECORDS", "true");
        IgniteEx ignite = (IgniteEx)this.startGrids(3);
        ignite.cluster().active(true);
        try {
            String cacheName = "transactional";
            CacheConfiguration cacheConfiguration = new CacheConfiguration("transactional").setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32)).setCacheMode(CacheMode.PARTITIONED).setRebalanceMode(CacheRebalanceMode.SYNC).setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC).setBackups(0);
            ignite.createCache(cacheConfiguration);
            IgniteCache cache = ignite.cache("transactional");
            GridCacheSharedContext sharedCtx = ignite.context().cache().context();
            GridCacheDatabaseSharedManager db = (GridCacheDatabaseSharedManager)sharedCtx.database();
            db.waitForCheckpoint("test");
            db.enableCheckpoints(false).get();
            WALPointer startPtr = sharedCtx.wal().log((WALRecord)new MemoryRecoveryRecord(U.currentTimeMillis()));
            int transactions = 100;
            int operationsPerTransaction = 40;
            Random random = new Random();
            for (int t = 1; t <= 100; ++t) {
                Transaction tx = ignite.transactions().txStart(TransactionConcurrency.OPTIMISTIC, TransactionIsolation.READ_COMMITTED);
                for (int op = 0; op < 40; ++op) {
                    int key = random.nextInt(1000) + 1;
                    BigObject value = random.nextBoolean() ? this.randomString(random) + key : new BigObject(key);
                    cache.put((Object)key, (Object)value);
                }
                if (random.nextBoolean()) {
                    tx.commit();
                } else {
                    tx.rollback();
                }
                if (t % 50 != 0) continue;
                this.log.info("Finished transaction " + t);
            }
            HashSet<GridCacheVersion> activeTransactions = new HashSet<GridCacheVersion>();
            try (WALIterator it = sharedCtx.wal().replay(startPtr);){
                while (it.hasNext()) {
                    IgniteBiTuple tup = (IgniteBiTuple)it.next();
                    WALRecord rec = (WALRecord)tup.get2();
                    if (rec instanceof TxRecord) {
                        TxRecord txRecord = (TxRecord)rec;
                        GridCacheVersion txId = txRecord.nearXidVersion();
                        switch (txRecord.state()) {
                            case PREPARED: {
                                assert (!activeTransactions.contains(txId)) : "Transaction is already present " + txRecord;
                                activeTransactions.add(txId);
                                break;
                            }
                            case COMMITTED: {
                                assert (activeTransactions.contains(txId)) : "No PREPARE marker for transaction " + txRecord;
                                activeTransactions.remove(txId);
                                break;
                            }
                            case ROLLED_BACK: {
                                activeTransactions.remove(txId);
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Unknown Tx state of record " + txRecord);
                            }
                        }
                        continue;
                    }
                    if (!(rec instanceof DataRecord)) continue;
                    DataRecord dataRecord = (DataRecord)rec;
                    for (DataEntry entry : dataRecord.writeEntries()) {
                        GridCacheVersion txId = entry.nearXidVersion();
                        assert (activeTransactions.contains(txId)) : "No transaction for entry " + entry;
                    }
                }
            }
        }
        finally {
            System.clearProperty("IGNITE_WAL_LOG_TX_RECORDS");
            this.stopAllGrids();
        }
    }

    private String randomString(Random random) {
        int len = random.nextInt(50) + 1;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            sb.append(random.nextInt(26) + 97);
        }
        return sb.toString();
    }

    private int[] createTestData(int size) {
        int[] data = new int[size];
        for (int d = 0; d < size; ++d) {
            data[d] = d;
        }
        return data;
    }

    private static enum EnumVal {
        VAL1,
        VAL2,
        VAL3;

    }

    private static class IndexedObject {
        @QuerySqlField(index=true)
        private int iVal;

        private IndexedObject(int iVal) {
            this.iVal = iVal;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IndexedObject)) {
                return false;
            }
            IndexedObject that = (IndexedObject)o;
            return this.iVal == that.iVal;
        }

        public int hashCode() {
            return this.iVal;
        }

        public String toString() {
            return S.toString(IndexedObject.class, (Object)this);
        }
    }

    private static class VerifyLargeCallable
    implements IgniteCallable<Boolean> {
        @IgniteInstanceResource
        private Ignite ignite;

        private VerifyLargeCallable() {
        }

        public Boolean call() throws Exception {
            try {
                boolean successfulWaiting = GridTestUtils.waitForCondition((GridAbsPredicate)new PAX(){

                    public boolean applyx() {
                        return ignite.cache(IgniteWalRecoveryTest.CACHE_NAME) != null;
                    }
                }, (long)10000L);
                junit.framework.Assert.assertTrue((boolean)successfulWaiting);
            }
            catch (IgniteInterruptedCheckedException e) {
                throw new RuntimeException(e);
            }
            IgniteCache cache = this.ignite.cache(IgniteWalRecoveryTest.CACHE_NAME);
            for (int i = 0; i < 1000; ++i) {
                long[] data = new long[1025];
                Arrays.fill(data, (long)i);
                Object val = cache.get((Object)i);
                if (val == null) {
                    this.ignite.log().warning("Failed to find a value for key: " + i);
                    return false;
                }
                junit.framework.Assert.assertTrue((boolean)Arrays.equals(data, (long[])val));
            }
            return true;
        }
    }

    private static class AsyncLargeLoadRunnable
    implements IgniteRunnable {
        @IgniteInstanceResource
        private Ignite ignite;

        private AsyncLargeLoadRunnable() {
        }

        public void run() {
            try {
                boolean successfulWaiting = GridTestUtils.waitForCondition((GridAbsPredicate)new PAX(){

                    public boolean applyx() {
                        return ignite.cache(IgniteWalRecoveryTest.CACHE_NAME) != null;
                    }
                }, (long)10000L);
                junit.framework.Assert.assertTrue((boolean)successfulWaiting);
            }
            catch (IgniteInterruptedCheckedException e) {
                throw new RuntimeException(e);
            }
            this.ignite.log().info(">>>>>>> Started load.");
            for (int i = 0; i < 1; ++i) {
                this.ignite.scheduler().callLocal((Callable)new Callable<Object>(){

                    @Override
                    public Object call() {
                        IgniteCache cache = ignite.cache(IgniteWalRecoveryTest.CACHE_NAME);
                        ThreadLocalRandom rnd = ThreadLocalRandom.current();
                        int cnt = 0;
                        while (!Thread.currentThread().isInterrupted()) {
                            long[] data = new long[1025];
                            int key = rnd.nextInt(1000);
                            Arrays.fill(data, (long)key);
                            cache.put((Object)key, (Object)data);
                            if (++cnt <= 0 || cnt % 1000 != 0) continue;
                            ignite.log().info(">>>> Updated: " + cnt);
                        }
                        return null;
                    }
                });
            }
        }
    }

    private static class LargeLoadRunnable
    implements IgniteRunnable {
        @IgniteInstanceResource
        private Ignite ignite;
        private boolean disableCheckpoints;

        private LargeLoadRunnable(boolean disableCheckpoints) {
            this.disableCheckpoints = disableCheckpoints;
        }

        public void run() {
            try {
                boolean successfulWaiting = GridTestUtils.waitForCondition((GridAbsPredicate)new PAX(){

                    public boolean applyx() {
                        return ignite.cache(IgniteWalRecoveryTest.CACHE_NAME) != null;
                    }
                }, (long)10000L);
                junit.framework.Assert.assertTrue((boolean)successfulWaiting);
            }
            catch (IgniteInterruptedCheckedException e) {
                throw new RuntimeException(e);
            }
            this.ignite.log().info("Started load.");
            if (this.disableCheckpoints) {
                GridCacheDatabaseSharedManager dbMgr = (GridCacheDatabaseSharedManager)((IgniteEx)this.ignite).context().cache().context().database();
                dbMgr.enableCheckpoints(false);
            }
            IgniteCache cache = this.ignite.cache(IgniteWalRecoveryTest.CACHE_NAME);
            IgniteCache locCache = this.ignite.cache(IgniteWalRecoveryTest.LOC_CACHE_NAME);
            for (int i = 0; i < 1000; ++i) {
                long[] data = new long[1025];
                Arrays.fill(data, (long)i);
                cache.put((Object)i, (Object)data);
                locCache.put((Object)i, (Object)data);
            }
            this.ignite.log().info("Finished load.");
        }
    }

    private static class VerifyCallable
    implements IgniteCallable<Boolean> {
        @IgniteInstanceResource
        private Ignite ignite;

        private VerifyCallable() {
        }

        public Boolean call() throws Exception {
            try {
                boolean successfulWaiting = GridTestUtils.waitForCondition((GridAbsPredicate)new PAX(){

                    public boolean applyx() {
                        return ignite.cache(IgniteWalRecoveryTest.CACHE_NAME) != null;
                    }
                }, (long)10000L);
                junit.framework.Assert.assertTrue((boolean)successfulWaiting);
            }
            catch (IgniteInterruptedCheckedException e) {
                throw new RuntimeException(e);
            }
            IgniteCache cache = this.ignite.cache(IgniteWalRecoveryTest.CACHE_NAME);
            IgniteCache locCache = this.ignite.cache(IgniteWalRecoveryTest.LOC_CACHE_NAME);
            for (int i = 0; i < 10000; ++i) {
                Object val = cache.get((Object)i);
                if (val == null) {
                    this.ignite.log().warning("Failed to find a value for PARTITIONED cache key: " + i);
                    return false;
                }
                val = locCache.get((Object)i);
                if (val != null) continue;
                this.ignite.log().warning("Failed to find a value for LOCAL cache key: " + i);
                return false;
            }
            return true;
        }
    }

    private static class AsyncLoadRunnable
    implements IgniteRunnable {
        @IgniteInstanceResource
        private Ignite ignite;

        private AsyncLoadRunnable() {
        }

        public void run() {
            try {
                boolean successfulWaiting = GridTestUtils.waitForCondition((GridAbsPredicate)new PAX(){

                    public boolean applyx() {
                        return ignite.cache(IgniteWalRecoveryTest.CACHE_NAME) != null;
                    }
                }, (long)10000L);
                junit.framework.Assert.assertTrue((boolean)successfulWaiting);
            }
            catch (IgniteInterruptedCheckedException e) {
                throw new RuntimeException(e);
            }
            this.ignite.log().info(">>>>>>> Started load.");
            for (int i = 0; i < 4; ++i) {
                this.ignite.scheduler().callLocal((Callable)new Callable<Object>(){

                    @Override
                    public Object call() {
                        IgniteCache cache = ignite.cache(IgniteWalRecoveryTest.CACHE_NAME);
                        IgniteCache locCache = ignite.cache(IgniteWalRecoveryTest.LOC_CACHE_NAME);
                        ThreadLocalRandom rnd = ThreadLocalRandom.current();
                        int cnt = 0;
                        while (!Thread.currentThread().isInterrupted()) {
                            cache.put((Object)rnd.nextInt(10000), (Object)new IndexedObject(rnd.nextInt()));
                            locCache.put((Object)rnd.nextInt(10000), (Object)new IndexedObject(rnd.nextInt()));
                            if (++cnt <= 0 || cnt % 1000 != 0) continue;
                            ignite.log().info(">>>> Updated: " + cnt);
                        }
                        return null;
                    }
                });
            }
        }
    }

    private static class LoadRunnable
    implements IgniteRunnable {
        @IgniteInstanceResource
        private Ignite ignite;
        private boolean disableCheckpoints;

        private LoadRunnable(boolean disableCheckpoints) {
            this.disableCheckpoints = disableCheckpoints;
        }

        public void run() {
            this.ignite.log().info("Started load.");
            if (this.disableCheckpoints) {
                GridCacheDatabaseSharedManager dbMgr = (GridCacheDatabaseSharedManager)((IgniteEx)this.ignite).context().cache().context().database();
                try {
                    dbMgr.enableCheckpoints(false).get();
                }
                catch (IgniteCheckedException e) {
                    throw new IgniteException((Throwable)e);
                }
            }
            try {
                boolean successfulWaiting = GridTestUtils.waitForCondition((GridAbsPredicate)new PAX(){

                    public boolean applyx() {
                        return ignite.cache(IgniteWalRecoveryTest.CACHE_NAME) != null;
                    }
                }, (long)10000L);
                junit.framework.Assert.assertTrue((boolean)successfulWaiting);
            }
            catch (IgniteInterruptedCheckedException e) {
                throw new RuntimeException(e);
            }
            IgniteCache cache = this.ignite.cache(IgniteWalRecoveryTest.CACHE_NAME);
            IgniteCache locCache = this.ignite.cache(IgniteWalRecoveryTest.LOC_CACHE_NAME);
            for (int i = 0; i < 10000; ++i) {
                cache.put((Object)i, (Object)new IndexedObject(i));
                locCache.put((Object)i, (Object)new IndexedObject(i));
            }
            this.ignite.log().info("Finished load.");
        }
    }

    private static class BigObject {
        private final int index;
        private final byte[] payload = new byte[4096];

        BigObject(int index) {
            this.index = index;
            for (int i = 0; i < this.payload.length; ++i) {
                if (i % index != 0) continue;
                this.payload[i] = (byte)index;
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BigObject bigObject = (BigObject)o;
            return this.index == bigObject.index && Arrays.equals(this.payload, bigObject.payload);
        }

        public int hashCode() {
            return Objects.hash(this.index, this.payload);
        }
    }

    private static class RemoteNodeFilter
    implements IgnitePredicate<ClusterNode> {
        private RemoteNodeFilter() {
        }

        public boolean apply(ClusterNode clusterNode) {
            return clusterNode.attribute(IgniteWalRecoveryTest.HAS_CACHE) != null;
        }
    }
}

