/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.mvcc;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteTransactions;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.mvcc.CacheMvccAbstractTest;
import org.apache.ignite.internal.processors.cache.mvcc.MvccRepeatableReadBulkOpsTest;
import org.apache.ignite.transactions.Transaction;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class MvccRepeatableReadOperationsTest
extends MvccRepeatableReadBulkOpsTest {
    @Override
    protected Map<Integer, CacheMvccAbstractTest.MvccTestAccount> getEntries(CacheMvccAbstractTest.TestCache<Integer, CacheMvccAbstractTest.MvccTestAccount> cache, Set<Integer> keys, CacheMvccAbstractTest.ReadMode readMode) {
        switch (readMode) {
            case GET: {
                HashMap<Integer, CacheMvccAbstractTest.MvccTestAccount> res = new HashMap<Integer, CacheMvccAbstractTest.MvccTestAccount>();
                for (Integer key : keys) {
                    CacheMvccAbstractTest.MvccTestAccount val = (CacheMvccAbstractTest.MvccTestAccount)cache.cache.get((Object)key);
                    if (val == null) continue;
                    res.put(key, val);
                }
                return res;
            }
            case SQL: {
                return MvccRepeatableReadOperationsTest.getAllSql(cache);
            }
            case INVOKE: {
                HashMap<Integer, CacheMvccAbstractTest.MvccTestAccount> res = new HashMap<Integer, CacheMvccAbstractTest.MvccTestAccount>();
                MvccRepeatableReadBulkOpsTest.GetEntryProcessor ep = new MvccRepeatableReadBulkOpsTest.GetEntryProcessor();
                for (Integer key : keys) {
                    CacheMvccAbstractTest.MvccTestAccount val = (CacheMvccAbstractTest.MvccTestAccount)cache.cache.invoke((Object)key, ep, new Object[0]);
                    if (val == null) continue;
                    res.put(key, val);
                }
                return res;
            }
        }
        MvccRepeatableReadOperationsTest.fail();
        return null;
    }

    @Override
    protected void updateEntries(CacheMvccAbstractTest.TestCache<Integer, CacheMvccAbstractTest.MvccTestAccount> cache, Map<Integer, CacheMvccAbstractTest.MvccTestAccount> entries, CacheMvccAbstractTest.WriteMode writeMode) {
        switch (writeMode) {
            case PUT: {
                for (Map.Entry<Integer, CacheMvccAbstractTest.MvccTestAccount> e : entries.entrySet()) {
                    if (e.getValue() == null) {
                        cache.cache.remove((Object)e.getKey());
                        continue;
                    }
                    cache.cache.put((Object)e.getKey(), (Object)e.getValue());
                }
                break;
            }
            case DML: {
                for (Map.Entry<Integer, CacheMvccAbstractTest.MvccTestAccount> e : entries.entrySet()) {
                    if (e.getValue() == null) {
                        MvccRepeatableReadOperationsTest.removeSql(cache, (Integer)e.getKey());
                        continue;
                    }
                    MvccRepeatableReadOperationsTest.mergeSql(cache, (Integer)e.getKey(), (Integer)e.getValue().val, (Integer)e.getValue().updateCnt);
                }
                break;
            }
            case INVOKE: {
                MvccRepeatableReadBulkOpsTest.GetAndPutEntryProcessor ep = new MvccRepeatableReadBulkOpsTest.GetAndPutEntryProcessor();
                for (Map.Entry<Integer, CacheMvccAbstractTest.MvccTestAccount> e : entries.entrySet()) {
                    cache.cache.invoke((Object)e.getKey(), ep, new Object[]{e.getValue()});
                }
                break;
            }
            default: {
                MvccRepeatableReadOperationsTest.fail();
            }
        }
    }

    @Override
    protected void removeEntries(CacheMvccAbstractTest.TestCache<Integer, CacheMvccAbstractTest.MvccTestAccount> cache, Set<Integer> keys, CacheMvccAbstractTest.WriteMode writeMode) {
        switch (writeMode) {
            case PUT: {
                for (Integer key : keys) {
                    cache.cache.remove((Object)key);
                }
                break;
            }
            case DML: {
                for (Integer key : keys) {
                    MvccRepeatableReadOperationsTest.removeSql(cache, (Integer)key);
                }
                break;
            }
            case INVOKE: {
                MvccRepeatableReadBulkOpsTest.RemoveEntryProcessor ep = new MvccRepeatableReadBulkOpsTest.RemoveEntryProcessor();
                for (Integer key : keys) {
                    cache.cache.invoke((Object)key, ep, new Object[0]);
                }
                break;
            }
            default: {
                MvccRepeatableReadOperationsTest.fail();
            }
        }
    }

    @Override
    protected void checkContains(CacheMvccAbstractTest.TestCache<Integer, CacheMvccAbstractTest.MvccTestAccount> cache, boolean expected, Set<Integer> keys) {
        for (Integer key : keys) {
            MvccRepeatableReadOperationsTest.assertEquals((boolean)expected, (boolean)cache.cache.containsKey((Object)key));
        }
    }

    @Test
    public void testGetAndUpdateOperations() throws IgniteCheckedException {
        IgniteEx node1 = this.grid(0);
        CacheMvccAbstractTest.TestCache cache1 = new CacheMvccAbstractTest.TestCache(node1.cache("default"));
        HashSet<Integer> keysForUpdate = new HashSet<Integer>(3);
        HashSet<Integer> keysForRemove = new HashSet<Integer>(3);
        Set<Integer> allKeys = this.generateKeySet(this.grid(0).cache("default"), keysForUpdate, keysForRemove);
        Map<Integer, CacheMvccAbstractTest.MvccTestAccount> initialMap = keysForRemove.stream().collect(Collectors.toMap(k -> k, k -> new CacheMvccAbstractTest.MvccTestAccount(k.intValue(), 1)));
        Map<Integer, CacheMvccAbstractTest.MvccTestAccount> updateMap = keysForUpdate.stream().collect(Collectors.toMap(k -> k, k -> new CacheMvccAbstractTest.MvccTestAccount(k.intValue(), 3)));
        cache1.cache.putAll(initialMap);
        IgniteTransactions txs = node1.transactions();
        try (Transaction tx = txs.txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
            for (Integer key : keysForUpdate) {
                CacheMvccAbstractTest.MvccTestAccount newVal1 = new CacheMvccAbstractTest.MvccTestAccount(key.intValue(), 1);
                MvccRepeatableReadOperationsTest.assertNull((Object)cache1.cache.getAndPut((Object)key, (Object)newVal1));
                CacheMvccAbstractTest.MvccTestAccount newVal2 = new CacheMvccAbstractTest.MvccTestAccount(key.intValue(), 2);
                MvccRepeatableReadOperationsTest.assertEquals((Object)newVal1, (Object)cache1.cache.getAndPut((Object)key, (Object)newVal2));
            }
            for (Integer key : keysForRemove) {
                MvccRepeatableReadOperationsTest.assertEquals((Object)initialMap.get(key), (Object)cache1.cache.getAndRemove((Object)key));
                MvccRepeatableReadOperationsTest.assertNull((Object)cache1.cache.getAndRemove((Object)key));
            }
            for (Integer key : allKeys) {
                CacheMvccAbstractTest.MvccTestAccount oldVal = new CacheMvccAbstractTest.MvccTestAccount(key.intValue(), 2);
                CacheMvccAbstractTest.MvccTestAccount newVal = new CacheMvccAbstractTest.MvccTestAccount(key.intValue(), 3);
                if (keysForRemove.contains(key)) {
                    MvccRepeatableReadOperationsTest.assertNull((Object)cache1.cache.getAndReplace((Object)key, (Object)newVal));
                    continue;
                }
                MvccRepeatableReadOperationsTest.assertEquals((Object)oldVal, (Object)cache1.cache.getAndReplace((Object)key, (Object)newVal));
            }
            MvccRepeatableReadOperationsTest.assertEquals(updateMap, this.getEntries((CacheMvccAbstractTest.TestCache<Integer, CacheMvccAbstractTest.MvccTestAccount>)cache1, allKeys, CacheMvccAbstractTest.ReadMode.SQL));
            MvccRepeatableReadOperationsTest.assertEquals(updateMap, this.getEntries((CacheMvccAbstractTest.TestCache<Integer, CacheMvccAbstractTest.MvccTestAccount>)cache1, allKeys, CacheMvccAbstractTest.ReadMode.GET));
            tx.commit();
        }
        MvccRepeatableReadOperationsTest.assertEquals(updateMap, this.getEntries((CacheMvccAbstractTest.TestCache<Integer, CacheMvccAbstractTest.MvccTestAccount>)cache1, allKeys, CacheMvccAbstractTest.ReadMode.SQL));
        MvccRepeatableReadOperationsTest.assertEquals(updateMap, this.getEntries((CacheMvccAbstractTest.TestCache<Integer, CacheMvccAbstractTest.MvccTestAccount>)cache1, allKeys, CacheMvccAbstractTest.ReadMode.GET));
    }

    @Test
    public void testPutIfAbsentConsistency() throws IgniteCheckedException {
        IgniteEx node1 = this.grid(0);
        CacheMvccAbstractTest.TestCache cache1 = new CacheMvccAbstractTest.TestCache(node1.cache("default"));
        HashSet<Integer> keysForCreate = new HashSet<Integer>(3);
        HashSet<Integer> keysForUpdate = new HashSet<Integer>(3);
        Set<Integer> allKeys = this.generateKeySet(this.grid(0).cache("default"), keysForCreate, keysForUpdate);
        Map<Integer, CacheMvccAbstractTest.MvccTestAccount> initialMap = keysForUpdate.stream().collect(Collectors.toMap(k -> k, k -> new CacheMvccAbstractTest.MvccTestAccount(k.intValue(), 1)));
        Map<Integer, CacheMvccAbstractTest.MvccTestAccount> updatedMap = allKeys.stream().collect(Collectors.toMap(k -> k, k -> new CacheMvccAbstractTest.MvccTestAccount(k.intValue(), 1)));
        cache1.cache.putAll(initialMap);
        IgniteTransactions txs = node1.transactions();
        try (Transaction tx = txs.txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
            for (Integer key : keysForUpdate) {
                MvccRepeatableReadOperationsTest.assertFalse((boolean)cache1.cache.putIfAbsent((Object)key, (Object)new CacheMvccAbstractTest.MvccTestAccount(key.intValue(), 2)));
            }
            for (Integer key : keysForCreate) {
                MvccRepeatableReadOperationsTest.assertTrue((boolean)cache1.cache.putIfAbsent((Object)key, (Object)new CacheMvccAbstractTest.MvccTestAccount(key.intValue(), 1)));
            }
            MvccRepeatableReadOperationsTest.assertEquals(updatedMap, this.getEntries((CacheMvccAbstractTest.TestCache<Integer, CacheMvccAbstractTest.MvccTestAccount>)cache1, allKeys, CacheMvccAbstractTest.ReadMode.SQL));
            tx.commit();
        }
        MvccRepeatableReadOperationsTest.assertEquals(updatedMap, this.getEntries((CacheMvccAbstractTest.TestCache<Integer, CacheMvccAbstractTest.MvccTestAccount>)cache1, allKeys, CacheMvccAbstractTest.ReadMode.SQL));
        MvccRepeatableReadOperationsTest.assertEquals(updatedMap, this.getEntries((CacheMvccAbstractTest.TestCache<Integer, CacheMvccAbstractTest.MvccTestAccount>)cache1, allKeys, CacheMvccAbstractTest.ReadMode.GET));
    }

    @Test
    public void testReplaceConsistency() throws IgniteCheckedException {
        IgniteEx node1 = this.grid(0);
        CacheMvccAbstractTest.TestCache cache1 = new CacheMvccAbstractTest.TestCache(node1.cache("default"));
        HashSet<Integer> existedKeys = new HashSet<Integer>(3);
        HashSet<Integer> nonExistedKeys = new HashSet<Integer>(3);
        Set<Integer> allKeys = this.generateKeySet(this.grid(0).cache("default"), existedKeys, nonExistedKeys);
        Map<Integer, CacheMvccAbstractTest.MvccTestAccount> initialMap = existedKeys.stream().collect(Collectors.toMap(k -> k, k -> new CacheMvccAbstractTest.MvccTestAccount(k.intValue(), 1)));
        Map<Integer, CacheMvccAbstractTest.MvccTestAccount> updateMap = existedKeys.stream().collect(Collectors.toMap(k -> k, k -> new CacheMvccAbstractTest.MvccTestAccount(k.intValue(), 3)));
        cache1.cache.putAll(initialMap);
        IgniteTransactions txs = node1.transactions();
        try (Transaction tx = txs.txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
            for (Integer key : allKeys) {
                CacheMvccAbstractTest.MvccTestAccount newVal = new CacheMvccAbstractTest.MvccTestAccount(key.intValue(), 2);
                if (existedKeys.contains(key)) {
                    MvccRepeatableReadOperationsTest.assertTrue((boolean)cache1.cache.replace((Object)key, (Object)new CacheMvccAbstractTest.MvccTestAccount(key.intValue(), 1), (Object)newVal));
                    MvccRepeatableReadOperationsTest.assertEquals((Object)newVal, (Object)cache1.cache.getAndReplace((Object)key, (Object)new CacheMvccAbstractTest.MvccTestAccount(key.intValue(), 3)));
                    continue;
                }
                MvccRepeatableReadOperationsTest.assertFalse((boolean)cache1.cache.replace((Object)key, (Object)new CacheMvccAbstractTest.MvccTestAccount(key.intValue(), 1), (Object)newVal));
                MvccRepeatableReadOperationsTest.assertNull((Object)cache1.cache.getAndReplace((Object)key, (Object)new CacheMvccAbstractTest.MvccTestAccount(key.intValue(), 3)));
            }
            MvccRepeatableReadOperationsTest.assertEquals(updateMap, this.getEntries((CacheMvccAbstractTest.TestCache<Integer, CacheMvccAbstractTest.MvccTestAccount>)cache1, allKeys, CacheMvccAbstractTest.ReadMode.SQL));
            MvccRepeatableReadOperationsTest.assertEquals(updateMap, this.getEntries((CacheMvccAbstractTest.TestCache<Integer, CacheMvccAbstractTest.MvccTestAccount>)cache1, allKeys, CacheMvccAbstractTest.ReadMode.GET));
            tx.commit();
        }
        MvccRepeatableReadOperationsTest.assertEquals(updateMap, this.getEntries((CacheMvccAbstractTest.TestCache<Integer, CacheMvccAbstractTest.MvccTestAccount>)cache1, allKeys, CacheMvccAbstractTest.ReadMode.SQL));
        MvccRepeatableReadOperationsTest.assertEquals(updateMap, this.getEntries((CacheMvccAbstractTest.TestCache<Integer, CacheMvccAbstractTest.MvccTestAccount>)cache1, allKeys, CacheMvccAbstractTest.ReadMode.GET));
    }
}

