/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.mvcc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.EntryProcessorResult;
import javax.cache.processor.MutableEntry;
import junit.framework.Assert;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteTransactions;
import org.apache.ignite.cache.CacheEntryProcessor;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.cache.mvcc.CacheMvccAbstractTest;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.transactions.Transaction;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class MvccRepeatableReadBulkOpsTest
extends CacheMvccAbstractTest {
    protected CacheMode cacheMode() {
        return CacheMode.PARTITIONED;
    }

    private int nodesCount() {
        return 4;
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.cleanPersistenceDir();
        this.startGridsMultiThreaded(this.nodesCount() - 1);
        this.client = true;
        this.startGrid(this.nodesCount() - 1);
    }

    protected void afterTestsStopped() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
        super.afterTestsStopped();
    }

    protected void beforeTest() throws Exception {
        this.grid(0).createCache(this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 1, 32).setIndexedTypes(new Class[]{Integer.class, CacheMvccAbstractTest.MvccTestAccount.class}));
    }

    protected void afterTest() throws Exception {
        this.grid(0).destroyCache("default");
    }

    @Test
    public void testRepeatableReadIsolationGetPut() throws Exception {
        this.checkOperations(CacheMvccAbstractTest.ReadMode.GET, CacheMvccAbstractTest.ReadMode.GET, CacheMvccAbstractTest.WriteMode.PUT, true);
        this.checkOperations(CacheMvccAbstractTest.ReadMode.GET, CacheMvccAbstractTest.ReadMode.GET, CacheMvccAbstractTest.WriteMode.PUT, false);
    }

    @Test
    public void testRepeatableReadIsolationInvoke() throws Exception {
        this.checkOperations(CacheMvccAbstractTest.ReadMode.GET, CacheMvccAbstractTest.ReadMode.GET, CacheMvccAbstractTest.WriteMode.INVOKE, true);
        this.checkOperations(CacheMvccAbstractTest.ReadMode.GET, CacheMvccAbstractTest.ReadMode.GET, CacheMvccAbstractTest.WriteMode.INVOKE, false);
    }

    @Test
    public void testRepeatableReadIsolationSqlPut() throws Exception {
        this.checkOperations(CacheMvccAbstractTest.ReadMode.SQL, CacheMvccAbstractTest.ReadMode.SQL, CacheMvccAbstractTest.WriteMode.PUT, true);
        this.checkOperations(CacheMvccAbstractTest.ReadMode.SQL, CacheMvccAbstractTest.ReadMode.SQL, CacheMvccAbstractTest.WriteMode.PUT, false);
    }

    @Test
    public void testRepeatableReadIsolationSqlInvoke() throws Exception {
        this.checkOperations(CacheMvccAbstractTest.ReadMode.SQL, CacheMvccAbstractTest.ReadMode.SQL, CacheMvccAbstractTest.WriteMode.INVOKE, true);
        this.checkOperations(CacheMvccAbstractTest.ReadMode.SQL, CacheMvccAbstractTest.ReadMode.SQL, CacheMvccAbstractTest.WriteMode.INVOKE, false);
    }

    @Test
    public void testRepeatableReadIsolationSqlDml() throws Exception {
        this.checkOperations(CacheMvccAbstractTest.ReadMode.SQL, CacheMvccAbstractTest.ReadMode.SQL, CacheMvccAbstractTest.WriteMode.DML, true);
        this.checkOperations(CacheMvccAbstractTest.ReadMode.SQL, CacheMvccAbstractTest.ReadMode.SQL, CacheMvccAbstractTest.WriteMode.DML, false);
    }

    @Test
    public void testRepeatableReadIsolationGetDml() throws Exception {
        this.checkOperations(CacheMvccAbstractTest.ReadMode.GET, CacheMvccAbstractTest.ReadMode.GET, CacheMvccAbstractTest.WriteMode.DML, true);
        this.checkOperations(CacheMvccAbstractTest.ReadMode.GET, CacheMvccAbstractTest.ReadMode.GET, CacheMvccAbstractTest.WriteMode.DML, false);
    }

    @Test
    public void testRepeatableReadIsolationMixedPut() throws Exception {
        this.checkOperations(CacheMvccAbstractTest.ReadMode.SQL, CacheMvccAbstractTest.ReadMode.GET, CacheMvccAbstractTest.WriteMode.PUT, false);
        this.checkOperations(CacheMvccAbstractTest.ReadMode.SQL, CacheMvccAbstractTest.ReadMode.GET, CacheMvccAbstractTest.WriteMode.PUT, true);
        this.checkOperations(CacheMvccAbstractTest.ReadMode.SQL, CacheMvccAbstractTest.ReadMode.GET, CacheMvccAbstractTest.WriteMode.INVOKE, false);
        this.checkOperations(CacheMvccAbstractTest.ReadMode.SQL, CacheMvccAbstractTest.ReadMode.GET, CacheMvccAbstractTest.WriteMode.INVOKE, true);
    }

    @Test
    public void testRepeatableReadIsolationMixedPut2() throws Exception {
        this.checkOperations(CacheMvccAbstractTest.ReadMode.GET, CacheMvccAbstractTest.ReadMode.SQL, CacheMvccAbstractTest.WriteMode.PUT, false);
        this.checkOperations(CacheMvccAbstractTest.ReadMode.GET, CacheMvccAbstractTest.ReadMode.SQL, CacheMvccAbstractTest.WriteMode.PUT, true);
        this.checkOperations(CacheMvccAbstractTest.ReadMode.GET, CacheMvccAbstractTest.ReadMode.SQL, CacheMvccAbstractTest.WriteMode.INVOKE, false);
        this.checkOperations(CacheMvccAbstractTest.ReadMode.GET, CacheMvccAbstractTest.ReadMode.SQL, CacheMvccAbstractTest.WriteMode.INVOKE, true);
    }

    @Test
    public void testRepeatableReadIsolationMixedDml() throws Exception {
        this.checkOperations(CacheMvccAbstractTest.ReadMode.SQL, CacheMvccAbstractTest.ReadMode.GET, CacheMvccAbstractTest.WriteMode.DML, false);
        this.checkOperations(CacheMvccAbstractTest.ReadMode.SQL, CacheMvccAbstractTest.ReadMode.GET, CacheMvccAbstractTest.WriteMode.DML, true);
    }

    @Test
    public void testRepeatableReadIsolationMixedDml2() throws Exception {
        this.checkOperations(CacheMvccAbstractTest.ReadMode.GET, CacheMvccAbstractTest.ReadMode.SQL, CacheMvccAbstractTest.WriteMode.DML, false);
        this.checkOperations(CacheMvccAbstractTest.ReadMode.GET, CacheMvccAbstractTest.ReadMode.SQL, CacheMvccAbstractTest.WriteMode.DML, true);
    }

    @Test
    public void testOperationConsistency() throws Exception {
        this.checkOperationsConsistency(CacheMvccAbstractTest.WriteMode.PUT, false);
        this.checkOperationsConsistency(CacheMvccAbstractTest.WriteMode.DML, false);
        this.checkOperationsConsistency(CacheMvccAbstractTest.WriteMode.INVOKE, false);
        this.checkOperationsConsistency(CacheMvccAbstractTest.WriteMode.PUT, true);
        this.checkOperationsConsistency(CacheMvccAbstractTest.WriteMode.DML, true);
        this.checkOperationsConsistency(CacheMvccAbstractTest.WriteMode.INVOKE, true);
    }

    @Test
    public void testInvokeConsistency() throws Exception {
        IgniteEx node = this.grid(0);
        CacheMvccAbstractTest.TestCache cache = new CacheMvccAbstractTest.TestCache(node.cache("default"));
        HashSet<Integer> keys1 = new HashSet<Integer>(3);
        HashSet<Integer> keys2 = new HashSet<Integer>(3);
        Set<Integer> allKeys = this.generateKeySet(cache.cache, keys1, keys2);
        Map<Integer, CacheMvccAbstractTest.MvccTestAccount> map1 = keys1.stream().collect(Collectors.toMap(k -> k, k -> new CacheMvccAbstractTest.MvccTestAccount(k.intValue(), 1)));
        Map<Integer, CacheMvccAbstractTest.MvccTestAccount> map2 = keys2.stream().collect(Collectors.toMap(k -> k, k -> new CacheMvccAbstractTest.MvccTestAccount(k.intValue(), 1)));
        MvccRepeatableReadBulkOpsTest.assertEquals((int)0, (int)cache.cache.size(new CachePeekMode[0]));
        this.updateEntries((CacheMvccAbstractTest.TestCache<Integer, CacheMvccAbstractTest.MvccTestAccount>)cache, map1, CacheMvccAbstractTest.WriteMode.INVOKE);
        MvccRepeatableReadBulkOpsTest.assertEquals((int)3, (int)cache.cache.size(new CachePeekMode[0]));
        this.updateEntries((CacheMvccAbstractTest.TestCache<Integer, CacheMvccAbstractTest.MvccTestAccount>)cache, map1, CacheMvccAbstractTest.WriteMode.INVOKE);
        MvccRepeatableReadBulkOpsTest.assertEquals((int)3, (int)cache.cache.size(new CachePeekMode[0]));
        this.getEntries((CacheMvccAbstractTest.TestCache<Integer, CacheMvccAbstractTest.MvccTestAccount>)cache, allKeys, CacheMvccAbstractTest.ReadMode.INVOKE);
        MvccRepeatableReadBulkOpsTest.assertEquals((int)3, (int)cache.cache.size(new CachePeekMode[0]));
        this.updateEntries((CacheMvccAbstractTest.TestCache<Integer, CacheMvccAbstractTest.MvccTestAccount>)cache, map2, CacheMvccAbstractTest.WriteMode.INVOKE);
        MvccRepeatableReadBulkOpsTest.assertEquals((int)6, (int)cache.cache.size(new CachePeekMode[0]));
        this.getEntries((CacheMvccAbstractTest.TestCache<Integer, CacheMvccAbstractTest.MvccTestAccount>)cache, keys2, CacheMvccAbstractTest.ReadMode.INVOKE);
        MvccRepeatableReadBulkOpsTest.assertEquals((int)6, (int)cache.cache.size(new CachePeekMode[0]));
        this.removeEntries((CacheMvccAbstractTest.TestCache<Integer, CacheMvccAbstractTest.MvccTestAccount>)cache, keys1, CacheMvccAbstractTest.WriteMode.INVOKE);
        MvccRepeatableReadBulkOpsTest.assertEquals((int)3, (int)cache.cache.size(new CachePeekMode[0]));
        this.removeEntries((CacheMvccAbstractTest.TestCache<Integer, CacheMvccAbstractTest.MvccTestAccount>)cache, keys1, CacheMvccAbstractTest.WriteMode.INVOKE);
        MvccRepeatableReadBulkOpsTest.assertEquals((int)3, (int)cache.cache.size(new CachePeekMode[0]));
        this.getEntries((CacheMvccAbstractTest.TestCache<Integer, CacheMvccAbstractTest.MvccTestAccount>)cache, allKeys, CacheMvccAbstractTest.ReadMode.INVOKE);
        MvccRepeatableReadBulkOpsTest.assertEquals((int)3, (int)cache.cache.size(new CachePeekMode[0]));
        this.updateEntries((CacheMvccAbstractTest.TestCache<Integer, CacheMvccAbstractTest.MvccTestAccount>)cache, map1, CacheMvccAbstractTest.WriteMode.INVOKE);
        MvccRepeatableReadBulkOpsTest.assertEquals((int)6, (int)cache.cache.size(new CachePeekMode[0]));
        this.removeEntries((CacheMvccAbstractTest.TestCache<Integer, CacheMvccAbstractTest.MvccTestAccount>)cache, allKeys, CacheMvccAbstractTest.WriteMode.INVOKE);
        MvccRepeatableReadBulkOpsTest.assertEquals((int)0, (int)cache.cache.size(new CachePeekMode[0]));
        this.getEntries((CacheMvccAbstractTest.TestCache<Integer, CacheMvccAbstractTest.MvccTestAccount>)cache, allKeys, CacheMvccAbstractTest.ReadMode.INVOKE);
        MvccRepeatableReadBulkOpsTest.assertEquals((int)0, (int)cache.cache.size(new CachePeekMode[0]));
    }

    private void checkOperations(final CacheMvccAbstractTest.ReadMode readModeBefore, final CacheMvccAbstractTest.ReadMode readModeAfter, final CacheMvccAbstractTest.WriteMode writeMode, boolean readFromClient) throws Exception {
        IgniteEx node1 = this.grid(readFromClient ? this.nodesCount() - 1 : 0);
        IgniteEx node2 = this.grid(readFromClient ? 0 : this.nodesCount() - 1);
        final CacheMvccAbstractTest.TestCache cache1 = new CacheMvccAbstractTest.TestCache(node1.cache("default"));
        final CacheMvccAbstractTest.TestCache cache2 = new CacheMvccAbstractTest.TestCache(node2.cache("default"));
        HashSet<Integer> keysForUpdate = new HashSet<Integer>(3);
        final HashSet<Integer> keysForRemove = new HashSet<Integer>(3);
        final Set<Integer> allKeys = this.generateKeySet(this.grid(0).cache("default"), keysForUpdate, keysForRemove);
        final Map<Integer, CacheMvccAbstractTest.MvccTestAccount> initialMap = allKeys.stream().collect(Collectors.toMap(k -> k, k -> new CacheMvccAbstractTest.MvccTestAccount(k.intValue(), 1)));
        final Map updateMap = keysForUpdate.stream().collect(Collectors.toMap(Function.identity(), k -> new CacheMvccAbstractTest.MvccTestAccount(k.intValue(), 2)));
        cache1.cache.putAll(initialMap);
        final IgniteTransactions txs1 = node1.transactions();
        final IgniteTransactions txs2 = node2.transactions();
        final CountDownLatch updateStart = new CountDownLatch(1);
        final CountDownLatch updateFinish = new CountDownLatch(1);
        IgniteInternalFuture updater = GridTestUtils.runAsync((Callable)new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                updateStart.await();
                Assert.assertEquals((int)initialMap.size(), (int)cache2.cache.size(new CachePeekMode[0]));
                try (Transaction tx = txs2.txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                    tx.timeout(3000L);
                    MvccRepeatableReadBulkOpsTest.this.updateEntries((CacheMvccAbstractTest.TestCache<Integer, CacheMvccAbstractTest.MvccTestAccount>)cache2, updateMap, writeMode);
                    MvccRepeatableReadBulkOpsTest.this.removeEntries((CacheMvccAbstractTest.TestCache<Integer, CacheMvccAbstractTest.MvccTestAccount>)cache2, keysForRemove, writeMode);
                    Assert.assertEquals((Object)updateMap, (Object)cache2.cache.getAll(allKeys));
                    tx.commit();
                }
                finally {
                    updateFinish.countDown();
                }
                Assert.assertEquals((int)updateMap.size(), (int)cache2.cache.size(new CachePeekMode[0]));
                return null;
            }
        });
        IgniteInternalFuture reader = GridTestUtils.runAsync((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try (Transaction tx = txs1.txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                    Assert.assertEquals((Object)initialMap, MvccRepeatableReadBulkOpsTest.this.getEntries((CacheMvccAbstractTest.TestCache<Integer, CacheMvccAbstractTest.MvccTestAccount>)cache1, allKeys, readModeBefore));
                    MvccRepeatableReadBulkOpsTest.this.checkContains((CacheMvccAbstractTest.TestCache<Integer, CacheMvccAbstractTest.MvccTestAccount>)cache1, true, allKeys);
                    updateStart.countDown();
                    updateFinish.await();
                    Assert.assertEquals((Object)initialMap, MvccRepeatableReadBulkOpsTest.this.getEntries((CacheMvccAbstractTest.TestCache<Integer, CacheMvccAbstractTest.MvccTestAccount>)cache1, allKeys, readModeAfter));
                    MvccRepeatableReadBulkOpsTest.this.checkContains((CacheMvccAbstractTest.TestCache<Integer, CacheMvccAbstractTest.MvccTestAccount>)cache1, true, allKeys);
                    tx.commit();
                }
                return null;
            }
        });
        try {
            updater.get(3000L, TimeUnit.MILLISECONDS);
            reader.get(3000L, TimeUnit.MILLISECONDS);
        }
        catch (Throwable e) {
            throw new AssertionError((Object)e);
        }
        finally {
            updateStart.countDown();
            updateFinish.countDown();
        }
        MvccRepeatableReadBulkOpsTest.assertEquals(updateMap, (Object)cache1.cache.getAll(allKeys));
    }

    protected Set<Integer> generateKeySet(IgniteCache<?, ?> cache, Set<Integer> keySet1, Set<Integer> keySet2) throws IgniteCheckedException {
        LinkedHashSet<Integer> allKeys = new LinkedHashSet<Integer>();
        allKeys.addAll(this.primaryKeys(cache, 2));
        allKeys.addAll(this.backupKeys(cache, 2, 1));
        allKeys.addAll(this.nearKeys(cache, 2, 1));
        ArrayList keys0 = new ArrayList(allKeys);
        for (int i = 0; i < 6; ++i) {
            if (i % 2 == 0) {
                keySet1.add((Integer)keys0.get(i));
                continue;
            }
            keySet2.add((Integer)keys0.get(i));
        }
        assert (allKeys.size() == 6);
        return allKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkOperationsConsistency(CacheMvccAbstractTest.WriteMode writeMode, boolean requestFromClient) throws Exception {
        IgniteEx node = this.grid(requestFromClient ? this.nodesCount() - 1 : 0);
        CacheMvccAbstractTest.TestCache cache = new CacheMvccAbstractTest.TestCache(node.cache("default"));
        HashSet<Integer> keysForUpdate = new HashSet<Integer>(3);
        HashSet<Integer> keysForRemove = new HashSet<Integer>(3);
        Set<Integer> allKeys = this.generateKeySet(this.grid(0).cache("default"), keysForUpdate, keysForRemove);
        try {
            int updCnt = 1;
            Map<Integer, CacheMvccAbstractTest.MvccTestAccount> initialVals = allKeys.stream().collect(Collectors.toMap(k -> k, k -> new CacheMvccAbstractTest.MvccTestAccount(k.intValue(), 1)));
            this.updateEntries((CacheMvccAbstractTest.TestCache<Integer, CacheMvccAbstractTest.MvccTestAccount>)cache, initialVals, writeMode);
            MvccRepeatableReadBulkOpsTest.assertEquals((int)initialVals.size(), (int)cache.cache.size(new CachePeekMode[0]));
            IgniteTransactions txs = node.transactions();
            Map<Integer, CacheMvccAbstractTest.MvccTestAccount> updatedVals = null;
            try (Transaction tx = txs.txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                Map<Integer, CacheMvccAbstractTest.MvccTestAccount> vals1 = this.getEntries((CacheMvccAbstractTest.TestCache<Integer, CacheMvccAbstractTest.MvccTestAccount>)cache, allKeys, CacheMvccAbstractTest.ReadMode.GET);
                Map<Integer, CacheMvccAbstractTest.MvccTestAccount> vals2 = this.getEntries((CacheMvccAbstractTest.TestCache<Integer, CacheMvccAbstractTest.MvccTestAccount>)cache, allKeys, CacheMvccAbstractTest.ReadMode.SQL);
                Map<Integer, CacheMvccAbstractTest.MvccTestAccount> vals3 = this.getEntries((CacheMvccAbstractTest.TestCache<Integer, CacheMvccAbstractTest.MvccTestAccount>)cache, allKeys, CacheMvccAbstractTest.ReadMode.INVOKE);
                MvccRepeatableReadBulkOpsTest.assertEquals(initialVals, vals1);
                MvccRepeatableReadBulkOpsTest.assertEquals(initialVals, vals2);
                MvccRepeatableReadBulkOpsTest.assertEquals(initialVals, vals3);
                MvccRepeatableReadBulkOpsTest.assertEquals((int)initialVals.size(), (int)cache.cache.size(new CachePeekMode[0]));
                for (CacheMvccAbstractTest.ReadMode readMode : new CacheMvccAbstractTest.ReadMode[]{CacheMvccAbstractTest.ReadMode.GET, CacheMvccAbstractTest.ReadMode.SQL, CacheMvccAbstractTest.ReadMode.INVOKE}) {
                    int updCnt0 = ++updCnt;
                    updatedVals = allKeys.stream().collect(Collectors.toMap(Function.identity(), k -> new CacheMvccAbstractTest.MvccTestAccount(k.intValue(), updCnt0)));
                    this.updateEntries((CacheMvccAbstractTest.TestCache<Integer, CacheMvccAbstractTest.MvccTestAccount>)cache, updatedVals, writeMode);
                    MvccRepeatableReadBulkOpsTest.assertEquals((int)allKeys.size(), (int)cache.cache.size(new CachePeekMode[0]));
                    this.removeEntries((CacheMvccAbstractTest.TestCache<Integer, CacheMvccAbstractTest.MvccTestAccount>)cache, keysForRemove, writeMode);
                    for (Integer key : keysForRemove) {
                        updatedVals.remove(key);
                    }
                    MvccRepeatableReadBulkOpsTest.assertEquals((String)String.valueOf(readMode), updatedVals, this.getEntries((CacheMvccAbstractTest.TestCache<Integer, CacheMvccAbstractTest.MvccTestAccount>)cache, allKeys, readMode));
                }
                tx.commit();
            }
            tx = txs.txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);
            var13_13 = null;
            try {
                MvccRepeatableReadBulkOpsTest.assertEquals(updatedVals, this.getEntries((CacheMvccAbstractTest.TestCache<Integer, CacheMvccAbstractTest.MvccTestAccount>)cache, allKeys, CacheMvccAbstractTest.ReadMode.GET));
                MvccRepeatableReadBulkOpsTest.assertEquals(updatedVals, this.getEntries((CacheMvccAbstractTest.TestCache<Integer, CacheMvccAbstractTest.MvccTestAccount>)cache, allKeys, CacheMvccAbstractTest.ReadMode.SQL));
                MvccRepeatableReadBulkOpsTest.assertEquals(updatedVals, this.getEntries((CacheMvccAbstractTest.TestCache<Integer, CacheMvccAbstractTest.MvccTestAccount>)cache, allKeys, CacheMvccAbstractTest.ReadMode.INVOKE));
                tx.commit();
            }
            catch (Throwable throwable) {
                var13_13 = throwable;
                throw throwable;
            }
            finally {
                if (tx != null) {
                    if (var13_13 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var13_13.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
            MvccRepeatableReadBulkOpsTest.assertEquals((int)updatedVals.size(), (int)cache.cache.size(new CachePeekMode[0]));
        }
        finally {
            cache.cache.removeAll(keysForUpdate);
        }
        MvccRepeatableReadBulkOpsTest.assertEquals((int)0, (int)cache.cache.size(new CachePeekMode[0]));
    }

    protected Map<Integer, CacheMvccAbstractTest.MvccTestAccount> getEntries(CacheMvccAbstractTest.TestCache<Integer, CacheMvccAbstractTest.MvccTestAccount> cache, Set<Integer> keys, CacheMvccAbstractTest.ReadMode readMode) {
        switch (readMode) {
            case GET: {
                return cache.cache.getAll(keys);
            }
            case SQL: {
                return MvccRepeatableReadBulkOpsTest.getAllSql(cache);
            }
            case INVOKE: {
                HashMap<Integer, CacheMvccAbstractTest.MvccTestAccount> res = new HashMap<Integer, CacheMvccAbstractTest.MvccTestAccount>();
                GetEntryProcessor ep = new GetEntryProcessor();
                Map invokeRes = cache.cache.invokeAll(keys, ep, new Object[0]);
                for (Map.Entry e : invokeRes.entrySet()) {
                    res.put((Integer)e.getKey(), (CacheMvccAbstractTest.MvccTestAccount)((EntryProcessorResult)e.getValue()).get());
                }
                return res;
            }
        }
        MvccRepeatableReadBulkOpsTest.fail();
        return null;
    }

    protected void updateEntries(CacheMvccAbstractTest.TestCache<Integer, CacheMvccAbstractTest.MvccTestAccount> cache, final Map<Integer, CacheMvccAbstractTest.MvccTestAccount> entries, CacheMvccAbstractTest.WriteMode writeMode) {
        switch (writeMode) {
            case PUT: {
                cache.cache.putAll(entries);
                break;
            }
            case DML: {
                for (Map.Entry<Integer, CacheMvccAbstractTest.MvccTestAccount> e : entries.entrySet()) {
                    MvccRepeatableReadBulkOpsTest.mergeSql(cache, (Integer)e.getKey(), (Integer)e.getValue().val, (Integer)e.getValue().updateCnt);
                }
                break;
            }
            case INVOKE: {
                GetAndPutEntryProcessor<Integer, CacheMvccAbstractTest.MvccTestAccount> ep = new GetAndPutEntryProcessor<Integer, CacheMvccAbstractTest.MvccTestAccount>(){

                    @Override
                    CacheMvccAbstractTest.MvccTestAccount newValForKey(Integer key) {
                        return (CacheMvccAbstractTest.MvccTestAccount)entries.get(key);
                    }
                };
                cache.cache.invokeAll(entries.keySet(), (CacheEntryProcessor)ep, new Object[0]);
                break;
            }
            default: {
                MvccRepeatableReadBulkOpsTest.fail();
            }
        }
    }

    protected void removeEntries(CacheMvccAbstractTest.TestCache<Integer, CacheMvccAbstractTest.MvccTestAccount> cache, Set<Integer> keys, CacheMvccAbstractTest.WriteMode writeMode) {
        switch (writeMode) {
            case PUT: {
                cache.cache.removeAll(keys);
                break;
            }
            case DML: {
                for (Integer key : keys) {
                    MvccRepeatableReadBulkOpsTest.removeSql(cache, (Integer)key);
                }
                break;
            }
            case INVOKE: {
                RemoveEntryProcessor ep = new RemoveEntryProcessor();
                cache.cache.invokeAll(keys, ep, new Object[0]);
                break;
            }
            default: {
                MvccRepeatableReadBulkOpsTest.fail();
            }
        }
    }

    protected void checkContains(CacheMvccAbstractTest.TestCache<Integer, CacheMvccAbstractTest.MvccTestAccount> cache, boolean expected, Set<Integer> keys) {
        MvccRepeatableReadBulkOpsTest.assertEquals((boolean)expected, (boolean)cache.cache.containsKeys(keys));
    }

    static class GetAndPutEntryProcessor<K, V>
    implements CacheEntryProcessor<K, V, V> {
        GetAndPutEntryProcessor() {
        }

        public V process(MutableEntry<K, V> entry, Object ... args) throws EntryProcessorException {
            Object newVal = !F.isEmpty((Object[])args) ? args[0] : this.newValForKey(entry.getKey());
            Object oldVal = entry.getValue();
            entry.setValue(newVal);
            return (V)oldVal;
        }

        V newValForKey(K key) {
            throw new UnsupportedOperationException();
        }
    }

    static class RemoveEntryProcessor<K, V, R>
    implements CacheEntryProcessor<K, V, R> {
        RemoveEntryProcessor() {
        }

        public R process(MutableEntry<K, V> entry, Object ... arguments) throws EntryProcessorException {
            entry.remove();
            return null;
        }
    }

    static class GetEntryProcessor<K, V>
    implements CacheEntryProcessor<K, V, V> {
        GetEntryProcessor() {
        }

        public V process(MutableEntry<K, V> entry, Object ... arguments) throws EntryProcessorException {
            return (V)entry.getValue();
        }
    }
}

