/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.mvcc;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import junit.framework.Assert;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteTransactions;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.affinity.Affinity;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxy;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.mvcc.CacheMvccAbstractTest;
import org.apache.ignite.internal.util.lang.GridInClosure3;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.transactions.Transaction;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CacheMvccSqlUpdateCountersTest
extends CacheMvccAbstractTest {
    protected CacheMode cacheMode() {
        return CacheMode.PARTITIONED;
    }

    @Test
    public void testUpdateCountersInsertSimple() throws Exception {
        SqlFieldsQuery qry;
        this.ccfg = this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 2, 1024).setIndexedTypes(new Class[]{Integer.class, Integer.class});
        Ignite node = this.startGridsMultiThreaded(3);
        IgniteCache cache = node.cache("default");
        Affinity aff = CacheMvccSqlUpdateCountersTest.affinity((IgniteCache)cache);
        Integer key1 = 1;
        int part1 = aff.partition((Object)key1);
        try (Transaction tx = node.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
            qry = new SqlFieldsQuery("INSERT INTO Integer (_key, _val) values (" + key1 + ",1)");
            cache.query(qry).getAll();
            tx.commit();
        }
        this.checkUpdateCounters("default", part1, 1L);
        tx = node.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);
        var7_7 = null;
        try {
            qry = new SqlFieldsQuery("UPDATE Integer SET _val=2 WHERE _key=" + key1);
            cache.query(qry).getAll();
            tx.commit();
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var7_7 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var7_7.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        this.checkUpdateCounters("default", part1, 2L);
    }

    @Test
    public void testUpdateCountersDoubleUpdate() throws Exception {
        SqlFieldsQuery qry;
        this.ccfg = this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 2, 1024).setIndexedTypes(new Class[]{Integer.class, Integer.class});
        Ignite node = this.startGridsMultiThreaded(3);
        IgniteCache cache = node.cache("default");
        Affinity aff = CacheMvccSqlUpdateCountersTest.affinity((IgniteCache)cache);
        int key1 = 1;
        int part1 = aff.partition((Object)key1);
        try (Transaction tx = node.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
            qry = new SqlFieldsQuery("INSERT INTO Integer (_key, _val) values (" + key1 + ",1)");
            cache.query(qry).getAll();
            qry = new SqlFieldsQuery("UPDATE Integer SET _val=2 WHERE _key=" + key1);
            cache.query(qry).getAll();
            tx.commit();
        }
        this.checkUpdateCounters("default", part1, 1L);
        tx = node.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);
        var7_7 = null;
        try {
            qry = new SqlFieldsQuery("MERGE INTO Integer (_key, _val) values (" + key1 + ",1)");
            cache.query(qry).getAll();
            qry = new SqlFieldsQuery("UPDATE Integer SET _val=2 WHERE _key=" + key1);
            cache.query(qry).getAll();
            tx.commit();
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var7_7 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var7_7.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        this.checkUpdateCounters("default", part1, 2L);
    }

    @Test
    public void testUpdateCountersRollback() throws Exception {
        SqlFieldsQuery qry;
        this.ccfg = this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 2, 1024).setIndexedTypes(new Class[]{Integer.class, Integer.class});
        Ignite node = this.startGridsMultiThreaded(3);
        IgniteCache cache = node.cache("default");
        Affinity aff = CacheMvccSqlUpdateCountersTest.affinity((IgniteCache)cache);
        int key1 = 1;
        int part1 = aff.partition((Object)key1);
        try (Transaction tx = node.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
            qry = new SqlFieldsQuery("INSERT INTO Integer (_key, _val) values (" + key1 + ",1)");
            cache.query(qry).getAll();
            qry = new SqlFieldsQuery("UPDATE Integer SET _val=2 WHERE _key=" + key1);
            cache.query(qry).getAll();
            tx.rollback();
        }
        this.checkUpdateCounters("default", part1, 0L);
        tx = node.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);
        var7_7 = null;
        try {
            qry = new SqlFieldsQuery("MERGE INTO Integer (_key, _val) values (" + key1 + ",1)");
            cache.query(qry).getAll();
            qry = new SqlFieldsQuery("UPDATE Integer SET _val=2 WHERE _key=" + key1);
            cache.query(qry).getAll();
            tx.rollback();
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var7_7 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var7_7.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        this.checkUpdateCounters("default", part1, 0L);
    }

    @Test
    public void testDeleteOwnKey() throws Exception {
        SqlFieldsQuery qry;
        this.ccfg = this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 2, 1).setCacheMode(CacheMode.REPLICATED).setIndexedTypes(new Class[]{Integer.class, Integer.class});
        Ignite node = this.startGridsMultiThreaded(1);
        IgniteCache cache = node.cache("default");
        Affinity aff = CacheMvccSqlUpdateCountersTest.affinity((IgniteCache)cache);
        int key1 = 1;
        int part1 = aff.partition((Object)key1);
        try (Transaction tx = node.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
            qry = new SqlFieldsQuery("INSERT INTO Integer (_key, _val) values (" + key1 + ",1)");
            cache.query(qry).getAll();
            qry = new SqlFieldsQuery("MERGE INTO Integer (_key, _val) values (" + key1 + ",2)");
            cache.query(qry).getAll();
            qry = new SqlFieldsQuery("MERGE INTO Integer (_key, _val) values (" + key1 + ",3)");
            cache.query(qry).getAll();
            qry = new SqlFieldsQuery("DELETE FROM Integer WHERE _key=" + key1);
            cache.query(qry).getAll();
            qry = new SqlFieldsQuery("MERGE INTO Integer (_key, _val) values (" + key1 + ",4)");
            cache.query(qry).getAll();
            qry = new SqlFieldsQuery("MERGE INTO Integer (_key, _val) values (" + key1 + ",5)");
            cache.query(qry).getAll();
            qry = new SqlFieldsQuery("DELETE FROM Integer WHERE _key=" + key1);
            cache.query(qry).getAll();
            tx.commit();
        }
        this.checkUpdateCounters("default", part1, 0L);
        tx = node.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);
        var7_7 = null;
        try {
            qry = new SqlFieldsQuery("MERGE INTO Integer (_key, _val) values (" + key1 + ",1)");
            cache.query(qry).getAll();
            tx.commit();
        }
        catch (Throwable qry2) {
            var7_7 = qry2;
            throw qry2;
        }
        finally {
            if (tx != null) {
                if (var7_7 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable qry2) {
                        var7_7.addSuppressed(qry2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        this.checkUpdateCounters("default", part1, 1L);
        tx = node.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);
        var7_7 = null;
        try {
            qry = new SqlFieldsQuery("DELETE FROM Integer WHERE _key=" + key1);
            cache.query(qry).getAll();
            tx.commit();
        }
        catch (Throwable qry3) {
            var7_7 = qry3;
            throw qry3;
        }
        finally {
            if (tx != null) {
                if (var7_7 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable qry3) {
                        var7_7.addSuppressed(qry3);
                    }
                } else {
                    tx.close();
                }
            }
        }
        this.checkUpdateCounters("default", part1, 2L);
        tx = node.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);
        var7_7 = null;
        try {
            qry = new SqlFieldsQuery("DELETE FROM Integer WHERE _key=" + key1);
            cache.query(qry).getAll();
            tx.commit();
        }
        catch (Throwable qry4) {
            var7_7 = qry4;
            throw qry4;
        }
        finally {
            if (tx != null) {
                if (var7_7 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable qry4) {
                        var7_7.addSuppressed(qry4);
                    }
                } else {
                    tx.close();
                }
            }
        }
        this.checkUpdateCounters("default", part1, 2L);
        tx = node.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);
        var7_7 = null;
        try {
            qry = new SqlFieldsQuery("MERGE INTO Integer (_key, _val) values (" + key1 + ",5)");
            cache.query(qry).getAll();
            tx.commit();
        }
        catch (Throwable qry5) {
            var7_7 = qry5;
            throw qry5;
        }
        finally {
            if (tx != null) {
                if (var7_7 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable qry5) {
                        var7_7.addSuppressed(qry5);
                    }
                } else {
                    tx.close();
                }
            }
        }
        this.checkUpdateCounters("default", part1, 3L);
        tx = node.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);
        var7_7 = null;
        try {
            qry = new SqlFieldsQuery("DELETE FROM Integer WHERE _key=" + key1);
            cache.query(qry).getAll();
            qry = new SqlFieldsQuery("MERGE INTO Integer (_key, _val) values (" + key1 + ",5)");
            cache.query(qry).getAll();
            qry = new SqlFieldsQuery("DELETE FROM Integer WHERE _key=" + key1);
            cache.query(qry).getAll();
            tx.commit();
        }
        catch (Throwable qry6) {
            var7_7 = qry6;
            throw qry6;
        }
        finally {
            if (tx != null) {
                if (var7_7 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable qry6) {
                        var7_7.addSuppressed(qry6);
                    }
                } else {
                    tx.close();
                }
            }
        }
        this.checkUpdateCounters("default", part1, 4L);
        tx = node.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);
        var7_7 = null;
        try {
            qry = new SqlFieldsQuery("MERGE INTO Integer (_key, _val) values (" + key1 + ",6)");
            cache.query(qry).getAll();
            tx.commit();
        }
        catch (Throwable qry7) {
            var7_7 = qry7;
            throw qry7;
        }
        finally {
            if (tx != null) {
                if (var7_7 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable qry7) {
                        var7_7.addSuppressed(qry7);
                    }
                } else {
                    tx.close();
                }
            }
        }
        this.checkUpdateCounters("default", part1, 5L);
        tx = node.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);
        var7_7 = null;
        try {
            qry = new SqlFieldsQuery("DELETE FROM Integer WHERE _key=" + key1);
            cache.query(qry).getAll();
            qry = new SqlFieldsQuery("MERGE INTO Integer (_key, _val) values (" + key1 + ",5)");
            cache.query(qry).getAll();
            tx.commit();
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var7_7 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var7_7.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        this.checkUpdateCounters("default", part1, 6L);
    }

    @Test
    public void testUpdateCountersMultithreaded() throws Exception {
        int writers = 4;
        boolean readers = false;
        int parts = 8;
        final int keys = 20;
        final ConcurrentHashMap<Integer, AtomicLong> tracker = new ConcurrentHashMap<Integer, AtomicLong>();
        for (int i = 0; i < keys; ++i) {
            tracker.put(i, new AtomicLong(1L));
        }
        IgniteInClosure<IgniteCache<Object, Object>> init = new IgniteInClosure<IgniteCache<Object, Object>>(){

            public void apply(IgniteCache<Object, Object> cache) {
                IgniteTransactions txs = ((Ignite)cache.unwrap(Ignite.class)).transactions();
                try (Transaction tx = txs.txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                    SqlFieldsQuery qry = new SqlFieldsQuery("INSERT INTO MvccTestAccount(_key, val, updateCnt) VALUES (?, 0, 1)");
                    for (int i = 0; i < keys; ++i) {
                        try (FieldsQueryCursor cur = cache.query(qry.setArgs(new Object[]{i}));){
                            Assert.assertEquals((Object)1L, ((List)cur.iterator().next()).get(0));
                        }
                        tx.commit();
                    }
                }
            }
        };
        GridInClosure3<Integer, List<CacheMvccAbstractTest.TestCache>, AtomicBoolean> writer = new GridInClosure3<Integer, List<CacheMvccAbstractTest.TestCache>, AtomicBoolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Could not resolve type clashes
             */
            public void apply(Integer idx, List<CacheMvccAbstractTest.TestCache> caches, AtomicBoolean stop) {
                ThreadLocalRandom rnd = ThreadLocalRandom.current();
                HashMap<Integer, AtomicLong> acc = new HashMap<Integer, AtomicLong>();
                int v = 0;
                while (!stop.get()) {
                    block35: {
                        Object e5;
                        int cnt = rnd.nextInt(keys / 3);
                        if (cnt == 0) {
                            cnt = 2;
                        }
                        while (acc.size() < cnt) {
                            acc.put(rnd.nextInt(cnt), new AtomicLong());
                        }
                        CacheMvccAbstractTest.TestCache cache = CacheMvccAbstractTest.randomCache(caches, (ThreadLocalRandom)rnd);
                        boolean success = true;
                        try {
                            IgniteTransactions txs = ((Ignite)cache.cache.unwrap(Ignite.class)).transactions();
                            try (Transaction tx = txs.txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                                Map allVals = CacheMvccSqlUpdateCountersTest.this.readAllByMode(cache.cache, tracker.keySet(), CacheMvccAbstractTest.ReadMode.SQL, CacheMvccAbstractTest.ACCOUNT_CODEC);
                                boolean rmv = allVals.size() > keys * 2 / 3;
                                for (Map.Entry e2 : acc.entrySet()) {
                                    SqlFieldsQuery qry;
                                    int key = (Integer)e2.getKey();
                                    AtomicLong accCntr = (AtomicLong)e2.getValue();
                                    boolean exists = allVals.containsKey(key);
                                    int delta = 0;
                                    boolean createdInTx = false;
                                    if (rmv && rnd.nextBoolean()) {
                                        if (exists) {
                                            delta = 1;
                                        }
                                        qry = new SqlFieldsQuery("DELETE FROM MvccTestAccount WHERE _key=" + key);
                                        cache.cache.query(qry).getAll();
                                    } else {
                                        delta = 1;
                                        if (!exists) {
                                            createdInTx = true;
                                        }
                                        qry = new SqlFieldsQuery("MERGE INTO MvccTestAccount (_key, val, updateCnt) VALUES (" + key + ",  " + rnd.nextInt(100) + ", 1)");
                                        cache.cache.query(qry).getAll();
                                    }
                                    if (rnd.nextBoolean()) {
                                        if (createdInTx) {
                                            delta = 0;
                                        }
                                        qry = new SqlFieldsQuery("DELETE FROM MvccTestAccount WHERE _key=" + key);
                                        cache.cache.query(qry).getAll();
                                    } else {
                                        delta = 1;
                                        qry = new SqlFieldsQuery("MERGE INTO MvccTestAccount (_key, val, updateCnt) VALUES (" + key + ",  " + rnd.nextInt(100) + ", 1)");
                                        cache.cache.query(qry).getAll();
                                    }
                                    accCntr.addAndGet(delta);
                                }
                                tx.commit();
                            }
                            cache.readUnlock();
                            if (!success) break block35;
                            ++v;
                        }
                        catch (Exception e3) {
                            CacheMvccSqlUpdateCountersTest.this.handleTxException(e3);
                            success = false;
                            int r = 0;
                            for (Map.Entry en : acc.entrySet()) {
                                if (((IgniteCacheProxy)cache.cache).context().affinity().partition(en.getKey()) != 0) continue;
                                r += ((AtomicLong)en.getValue()).intValue();
                            }
                            continue;
                        }
                        finally {
                            cache.readUnlock();
                            if (success) {
                                ++v;
                                for (Map.Entry e4 : acc.entrySet()) {
                                    int k = (Integer)e4.getKey();
                                    long updCntr = ((AtomicLong)e4.getValue()).get();
                                    ((AtomicLong)tracker.get(k)).addAndGet(updCntr);
                                }
                                int r = 0;
                                for (Map.Entry en : acc.entrySet()) {
                                    if (((IgniteCacheProxy)cache.cache).context().affinity().partition(en.getKey()) != 0) continue;
                                    r += ((AtomicLong)en.getValue()).intValue();
                                }
                            }
                            acc.clear();
                            continue;
                        }
                        for (Object e5 : acc.entrySet()) {
                            int k = (Integer)e5.getKey();
                            long updCntr = ((AtomicLong)e5.getValue()).get();
                            ((AtomicLong)tracker.get(k)).addAndGet(updCntr);
                        }
                        int r = 0;
                        e5 = acc.entrySet().iterator();
                        while (e5.hasNext()) {
                            Map.Entry en = (Map.Entry)e5.next();
                            if (((IgniteCacheProxy)cache.cache).context().affinity().partition(en.getKey()) != 0) continue;
                            r += ((AtomicLong)en.getValue()).intValue();
                        }
                    }
                    acc.clear();
                }
                CacheMvccSqlUpdateCountersTest.this.info("Writer done, updates: " + v);
            }
        };
        GridInClosure3<Integer, List<CacheMvccAbstractTest.TestCache>, AtomicBoolean> reader = new GridInClosure3<Integer, List<CacheMvccAbstractTest.TestCache>, AtomicBoolean>(){

            public void apply(Integer idx, List<CacheMvccAbstractTest.TestCache> caches, AtomicBoolean stop) {
            }
        };
        this.readWriteTest(null, 4, 1, 2, parts, 4, 0, 30000L, (IgniteInClosure)new CacheMvccAbstractTest.InitIndexing(new Class[]{Integer.class, CacheMvccAbstractTest.MvccTestAccount.class}), (IgniteInClosure)init, (GridInClosure3)writer, (GridInClosure3)reader);
        HashMap<Integer, AtomicLong> updPerParts = new HashMap<Integer, AtomicLong>(parts);
        Affinity aff = this.grid(1).cachex("default").affinity();
        for (Map.Entry e : tracker.entrySet()) {
            int k = (Integer)e.getKey();
            long updCntr = ((AtomicLong)e.getValue()).get();
            int p = aff.partition((Object)k);
            AtomicLong cntr = (AtomicLong)updPerParts.get(p);
            if (cntr == null) {
                cntr = new AtomicLong();
                updPerParts.putIfAbsent(p, cntr);
            }
            cntr.addAndGet(updCntr);
        }
        for (Map.Entry e : updPerParts.entrySet()) {
            this.checkUpdateCounters("default", (Integer)e.getKey(), ((AtomicLong)e.getValue()).get());
        }
    }

    private void checkUpdateCounters(String cacheName, int p, long val) {
        for (Ignite node : G.allGrids()) {
            if (node.configuration().isClientMode().booleanValue()) continue;
            IgniteCacheProxy cache = (IgniteCacheProxy)node.cache(cacheName);
            GridDhtLocalPartition part = cache.context().topology().localPartition(p);
            if (!cache.context().mvccEnabled() || part == null) continue;
            CacheMvccSqlUpdateCountersTest.assertEquals((String)("part=" + p), (long)val, (long)part.updateCounter());
        }
    }
}

