/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.mvcc;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.Phaser;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.MutableEntry;
import junit.framework.Assert;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxy;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.mvcc.CacheMvccAbstractTest;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRowAdapter;
import org.apache.ignite.internal.processors.cache.query.SqlFieldsQueryEx;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.transactions.IgniteTxTimeoutCheckedException;
import org.apache.ignite.internal.util.future.GridCompoundFuture;
import org.apache.ignite.internal.util.lang.GridCursor;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.transactions.Transaction;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public abstract class CacheMvccSqlTxQueriesAbstractTest
extends CacheMvccAbstractTest {
    @Test
    public void testAccountsTxDmlSql_SingleNode_SinglePartition() throws Exception {
        this.accountsTxReadAll(1, 0, 0, 1, (IgniteInClosure)new CacheMvccAbstractTest.InitIndexing(new Class[]{Integer.class, CacheMvccAbstractTest.MvccTestAccount.class}), false, CacheMvccAbstractTest.ReadMode.SQL, CacheMvccAbstractTest.WriteMode.DML);
    }

    @Test
    public void testAccountsTxDmlSql_WithRemoves_SingleNode_SinglePartition() throws Exception {
        this.accountsTxReadAll(1, 0, 0, 1, (IgniteInClosure)new CacheMvccAbstractTest.InitIndexing(new Class[]{Integer.class, CacheMvccAbstractTest.MvccTestAccount.class}), true, CacheMvccAbstractTest.ReadMode.SQL, CacheMvccAbstractTest.WriteMode.DML);
    }

    @Test
    public void testAccountsTxDmlSql_SingleNode() throws Exception {
        this.accountsTxReadAll(1, 0, 0, 64, (IgniteInClosure)new CacheMvccAbstractTest.InitIndexing(new Class[]{Integer.class, CacheMvccAbstractTest.MvccTestAccount.class}), false, CacheMvccAbstractTest.ReadMode.SQL, CacheMvccAbstractTest.WriteMode.DML);
    }

    @Test
    public void testAccountsTxDmlSql_SingleNode_Persistence() throws Exception {
        this.persistence = true;
        this.testAccountsTxDmlSql_SingleNode();
    }

    @Test
    public void testAccountsTxDmlSumSql_SingleNode() throws Exception {
        this.accountsTxReadAll(1, 0, 0, 64, (IgniteInClosure)new CacheMvccAbstractTest.InitIndexing(new Class[]{Integer.class, CacheMvccAbstractTest.MvccTestAccount.class}), false, CacheMvccAbstractTest.ReadMode.SQL_SUM, CacheMvccAbstractTest.WriteMode.DML);
    }

    @Test
    public void testAccountsTxDmlSumSql_WithRemoves_SingleNode() throws Exception {
        this.accountsTxReadAll(1, 0, 0, 64, (IgniteInClosure)new CacheMvccAbstractTest.InitIndexing(new Class[]{Integer.class, CacheMvccAbstractTest.MvccTestAccount.class}), true, CacheMvccAbstractTest.ReadMode.SQL_SUM, CacheMvccAbstractTest.WriteMode.DML);
    }

    @Test
    public void testAccountsTxDmlSumSql_WithRemoves__ClientServer_Backups0() throws Exception {
        this.accountsTxReadAll(4, 2, 0, 64, (IgniteInClosure)new CacheMvccAbstractTest.InitIndexing(new Class[]{Integer.class, CacheMvccAbstractTest.MvccTestAccount.class}), true, CacheMvccAbstractTest.ReadMode.SQL_SUM, CacheMvccAbstractTest.WriteMode.DML);
    }

    @Test
    public void testAccountsTxDmlSumSql_ClientServer_Backups2() throws Exception {
        this.accountsTxReadAll(4, 2, 2, 64, (IgniteInClosure)new CacheMvccAbstractTest.InitIndexing(new Class[]{Integer.class, CacheMvccAbstractTest.MvccTestAccount.class}), true, CacheMvccAbstractTest.ReadMode.SQL_SUM, CacheMvccAbstractTest.WriteMode.DML);
    }

    @Test
    public void testAccountsTxDmlSql_WithRemoves_SingleNode() throws Exception {
        this.accountsTxReadAll(1, 0, 0, 64, (IgniteInClosure)new CacheMvccAbstractTest.InitIndexing(new Class[]{Integer.class, CacheMvccAbstractTest.MvccTestAccount.class}), true, CacheMvccAbstractTest.ReadMode.SQL, CacheMvccAbstractTest.WriteMode.DML);
    }

    @Test
    public void testAccountsTxDmlSql_WithRemoves_SingleNode_Persistence() throws Exception {
        this.persistence = true;
        this.testAccountsTxDmlSql_WithRemoves_SingleNode();
    }

    @Test
    public void testAccountsTxDmlSql_ClientServer_Backups0() throws Exception {
        this.accountsTxReadAll(4, 2, 0, 64, (IgniteInClosure)new CacheMvccAbstractTest.InitIndexing(new Class[]{Integer.class, CacheMvccAbstractTest.MvccTestAccount.class}), false, CacheMvccAbstractTest.ReadMode.SQL, CacheMvccAbstractTest.WriteMode.DML);
    }

    @Test
    public void testAccountsTxDmlSql_WithRemoves_ClientServer_Backups0() throws Exception {
        this.accountsTxReadAll(4, 2, 0, 64, (IgniteInClosure)new CacheMvccAbstractTest.InitIndexing(new Class[]{Integer.class, CacheMvccAbstractTest.MvccTestAccount.class}), true, CacheMvccAbstractTest.ReadMode.SQL, CacheMvccAbstractTest.WriteMode.DML);
    }

    @Test
    public void testAccountsTxDmlSql_WithRemoves_ClientServer_Backups0_Persistence() throws Exception {
        this.persistence = true;
        this.testAccountsTxDmlSql_WithRemoves_ClientServer_Backups0();
    }

    @Test
    public void testAccountsTxDmlSql_ClientServer_Backups1() throws Exception {
        this.accountsTxReadAll(3, 0, 1, 64, (IgniteInClosure)new CacheMvccAbstractTest.InitIndexing(new Class[]{Integer.class, CacheMvccAbstractTest.MvccTestAccount.class}), false, CacheMvccAbstractTest.ReadMode.SQL, CacheMvccAbstractTest.WriteMode.DML);
    }

    @Test
    public void testAccountsTxDmlSql_WithRemoves_ClientServer_Backups1() throws Exception {
        this.accountsTxReadAll(4, 2, 1, 64, (IgniteInClosure)new CacheMvccAbstractTest.InitIndexing(new Class[]{Integer.class, CacheMvccAbstractTest.MvccTestAccount.class}), true, CacheMvccAbstractTest.ReadMode.SQL, CacheMvccAbstractTest.WriteMode.DML);
    }

    @Test
    public void testAccountsTxDmlSql_WithRemoves_ClientServer_Backups1_Persistence() throws Exception {
        this.persistence = true;
        this.testAccountsTxDmlSql_WithRemoves_ClientServer_Backups1();
    }

    @Test
    public void testAccountsTxDmlSql_ClientServer_Backups2() throws Exception {
        this.accountsTxReadAll(4, 2, 2, 64, (IgniteInClosure)new CacheMvccAbstractTest.InitIndexing(new Class[]{Integer.class, CacheMvccAbstractTest.MvccTestAccount.class}), false, CacheMvccAbstractTest.ReadMode.SQL, CacheMvccAbstractTest.WriteMode.DML);
    }

    @Test
    public void testAccountsTxDmlSql_WithRemoves_ClientServer_Backups2() throws Exception {
        this.accountsTxReadAll(4, 2, 2, 64, (IgniteInClosure)new CacheMvccAbstractTest.InitIndexing(new Class[]{Integer.class, CacheMvccAbstractTest.MvccTestAccount.class}), true, CacheMvccAbstractTest.ReadMode.SQL, CacheMvccAbstractTest.WriteMode.DML);
    }

    @Test
    public void testAccountsTxDmlSql_ClientServer_Backups2_Persistence() throws Exception {
        this.persistence = true;
        this.testAccountsTxDmlSql_ClientServer_Backups2();
    }

    @Test
    public void testParsingErrorHasNoSideEffect() throws Exception {
        this.ccfg = this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 0, 4).setIndexedTypes(new Class[]{Integer.class, Integer.class});
        IgniteEx node = this.startGrid(0);
        IgniteCache cache = node.cache("default");
        try (Transaction tx = node.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
            Throwable throwable;
            FieldsQueryCursor cur;
            tx.timeout(3000L);
            SqlFieldsQuery qry = new SqlFieldsQuery("INSERT INTO Integer (_key, _val) values (1),(2,2),(3,3)");
            try {
                cur = cache.query(qry);
                throwable = null;
                try {
                    CacheMvccSqlTxQueriesAbstractTest.fail((String)"We should not get there.");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (cur != null) {
                        if (throwable != null) {
                            try {
                                cur.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            cur.close();
                        }
                    }
                }
            }
            catch (CacheException ex) {
                IgniteSQLException cause = (IgniteSQLException)X.cause((Throwable)ex, IgniteSQLException.class);
                CacheMvccSqlTxQueriesAbstractTest.assertNotNull((Object)cause);
                CacheMvccSqlTxQueriesAbstractTest.assertEquals((int)1001, (int)cause.statusCode());
                CacheMvccSqlTxQueriesAbstractTest.assertFalse((boolean)tx.isRollbackOnly());
            }
            qry = new SqlFieldsQuery("INSERT INTO Integer (_key, _val) values (4,4),(5,5),(6,6)");
            cur = cache.query(qry);
            throwable = null;
            try {
                CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)3L, ((List)cur.iterator().next()).get(0));
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (cur != null) {
                    if (throwable != null) {
                        try {
                            cur.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        cur.close();
                    }
                }
            }
            tx.commit();
        }
        CacheMvccSqlTxQueriesAbstractTest.assertNull((Object)cache.get((Object)1));
        CacheMvccSqlTxQueriesAbstractTest.assertNull((Object)cache.get((Object)2));
        CacheMvccSqlTxQueriesAbstractTest.assertNull((Object)cache.get((Object)3));
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)4, (Object)cache.get((Object)4));
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)5, (Object)cache.get((Object)5));
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)6, (Object)cache.get((Object)6));
    }

    @Test
    public void testQueryInsertStaticCache() throws Exception {
        this.ccfg = this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 2, 1024).setIndexedTypes(new Class[]{Integer.class, Integer.class});
        this.startGridsMultiThreaded(4);
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        IgniteEx checkNode = this.grid(((Random)rnd).nextInt(4));
        IgniteEx updateNode = this.grid(((Random)rnd).nextInt(4));
        IgniteCache cache = checkNode.cache("default");
        try (Transaction tx = updateNode.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
            tx.timeout(3000L);
            SqlFieldsQuery qry = new SqlFieldsQuery("INSERT INTO Integer (_key, _val) values (1,1),(2,2),(3,3)");
            IgniteCache cache0 = updateNode.cache("default");
            try (FieldsQueryCursor cur = cache0.query(qry);){
                CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)3L, ((List)cur.iterator().next()).get(0));
            }
            qry = new SqlFieldsQuery("INSERT INTO Integer (_key, _val) values (4,4),(5,5),(6,6)");
            cur = cache0.query(qry);
            var10_12 = null;
            try {
                CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)3L, ((List)cur.iterator().next()).get(0));
            }
            catch (Throwable throwable) {
                var10_12 = throwable;
                throw throwable;
            }
            finally {
                if (cur != null) {
                    if (var10_12 != null) {
                        try {
                            cur.close();
                        }
                        catch (Throwable throwable) {
                            var10_12.addSuppressed(throwable);
                        }
                    } else {
                        cur.close();
                    }
                }
            }
            tx.commit();
        }
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)1, (Object)cache.get((Object)1));
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)2, (Object)cache.get((Object)2));
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)3, (Object)cache.get((Object)3));
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)4, (Object)cache.get((Object)4));
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)5, (Object)cache.get((Object)5));
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)6, (Object)cache.get((Object)6));
    }

    @Test
    public void testQueryInsertStaticCacheImplicit() throws Exception {
        this.ccfg = this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 2, 1024).setIndexedTypes(new Class[]{Integer.class, Integer.class});
        this.startGridsMultiThreaded(4);
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        IgniteEx checkNode = this.grid(((Random)rnd).nextInt(4));
        IgniteEx updateNode = this.grid(((Random)rnd).nextInt(4));
        IgniteCache cache = checkNode.cache("default");
        SqlFieldsQuery qry = new SqlFieldsQuery("INSERT INTO Integer (_key, _val) values (1,1),(2,2),(3,3)").setTimeout(3000, TimeUnit.MILLISECONDS);
        IgniteCache cache0 = updateNode.cache("default");
        try (FieldsQueryCursor cur = cache0.query(qry);){
            CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)3L, ((List)cur.iterator().next()).get(0));
        }
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)1, (Object)cache.get((Object)1));
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)2, (Object)cache.get((Object)2));
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)3, (Object)cache.get((Object)3));
    }

    @Test
    public void testQueryDeleteStaticCache() throws Exception {
        this.ccfg = this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 2, 1024).setIndexedTypes(new Class[]{Integer.class, Integer.class});
        this.startGridsMultiThreaded(4);
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        IgniteEx checkNode = this.grid(((Random)rnd).nextInt(4));
        IgniteEx updateNode = this.grid(((Random)rnd).nextInt(4));
        IgniteCache cache = checkNode.cache("default");
        SqlFieldsQuery qry = new SqlFieldsQuery("INSERT INTO Integer (_key, _val) values (1,1),(2,2),(3,3)").setTimeout(3000, TimeUnit.MILLISECONDS);
        IgniteCache cache0 = updateNode.cache("default");
        try (FieldsQueryCursor cur = cache0.query(qry);){
            CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)3L, ((List)cur.iterator().next()).get(0));
        }
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)1, (Object)cache.get((Object)1));
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)2, (Object)cache.get((Object)2));
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)3, (Object)cache.get((Object)3));
        var8_8 = null;
        try (Transaction tx = updateNode.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
            tx.timeout(3000L);
            qry = new SqlFieldsQuery("DELETE FROM Integer WHERE 1 = 1");
            try (FieldsQueryCursor cur = cache0.query(qry);){
                CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)3L, ((List)cur.iterator().next()).get(0));
            }
            tx.commit();
        }
        catch (Throwable throwable) {
            var8_8 = throwable;
            throw throwable;
        }
        CacheMvccSqlTxQueriesAbstractTest.assertNull((Object)cache.get((Object)1));
        CacheMvccSqlTxQueriesAbstractTest.assertNull((Object)cache.get((Object)2));
        CacheMvccSqlTxQueriesAbstractTest.assertNull((Object)cache.get((Object)3));
    }

    @Test
    public void testQueryFastDeleteStaticCache() throws Exception {
        this.ccfg = this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 2, 1024).setIndexedTypes(new Class[]{Integer.class, Integer.class});
        this.startGridsMultiThreaded(4);
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        IgniteEx checkNode = this.grid(((Random)rnd).nextInt(4));
        IgniteEx updateNode = this.grid(((Random)rnd).nextInt(4));
        IgniteCache cache = checkNode.cache("default");
        SqlFieldsQuery qry = new SqlFieldsQuery("INSERT INTO Integer (_key, _val) values (1,1),(2,2),(3,3)").setTimeout(3000, TimeUnit.MILLISECONDS);
        IgniteCache cache0 = updateNode.cache("default");
        try (FieldsQueryCursor cur = cache0.query(qry);){
            CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)3L, ((List)cur.iterator().next()).get(0));
        }
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)1, (Object)cache.get((Object)1));
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)2, (Object)cache.get((Object)2));
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)3, (Object)cache.get((Object)3));
        var8_8 = null;
        try (Transaction tx = updateNode.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
            tx.timeout(3000L);
            qry = new SqlFieldsQuery("DELETE FROM Integer WHERE _key = 1");
            try (FieldsQueryCursor cur = cache0.query(qry);){
                CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)1L, ((List)cur.iterator().next()).get(0));
            }
            tx.commit();
        }
        catch (Throwable throwable) {
            var8_8 = throwable;
            throw throwable;
        }
        CacheMvccSqlTxQueriesAbstractTest.assertNull((Object)cache.get((Object)1));
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)2, (Object)cache.get((Object)2));
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)3, (Object)cache.get((Object)3));
    }

    @Test
    public void testQueryFastUpdateStaticCache() throws Exception {
        this.ccfg = this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 2, 1024).setIndexedTypes(new Class[]{Integer.class, Integer.class});
        this.startGridsMultiThreaded(4);
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        IgniteEx checkNode = this.grid(((Random)rnd).nextInt(4));
        IgniteEx updateNode = this.grid(((Random)rnd).nextInt(4));
        IgniteCache cache = checkNode.cache("default");
        SqlFieldsQuery qry = new SqlFieldsQuery("INSERT INTO Integer (_key, _val) values (1,1),(2,2),(3,3)").setTimeout(3000, TimeUnit.MILLISECONDS);
        IgniteCache cache0 = updateNode.cache("default");
        try (FieldsQueryCursor cur = cache0.query(qry);){
            CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)3L, ((List)cur.iterator().next()).get(0));
        }
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)1, (Object)cache.get((Object)1));
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)2, (Object)cache.get((Object)2));
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)3, (Object)cache.get((Object)3));
        var8_8 = null;
        try (Transaction tx = updateNode.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
            tx.timeout(3000L);
            qry = new SqlFieldsQuery("UPDATE Integer SET _val = 8 WHERE _key = 1");
            try (FieldsQueryCursor cur = cache0.query(qry);){
                CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)1L, ((List)cur.iterator().next()).get(0));
            }
            tx.commit();
        }
        catch (Throwable throwable) {
            var8_8 = throwable;
            throw throwable;
        }
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)8, (Object)cache.get((Object)1));
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)2, (Object)cache.get((Object)2));
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)3, (Object)cache.get((Object)3));
    }

    @Test
    public void testQueryFastDeleteObjectStaticCache() throws Exception {
        this.ccfg = this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 2, 1024).setIndexedTypes(new Class[]{Integer.class, MvccTestSqlIndexValue.class});
        this.startGridsMultiThreaded(4);
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        IgniteEx checkNode = this.grid(((Random)rnd).nextInt(4));
        IgniteEx updateNode = this.grid(((Random)rnd).nextInt(4));
        IgniteCache cache = checkNode.cache("default");
        cache.putAll(F.asMap((Object)1, (Object)new MvccTestSqlIndexValue(1), (Object)2, (Object)new MvccTestSqlIndexValue(2), (Object)3, (Object)new MvccTestSqlIndexValue(3)));
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)new MvccTestSqlIndexValue(1), (Object)cache.get((Object)1));
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)new MvccTestSqlIndexValue(2), (Object)cache.get((Object)2));
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)new MvccTestSqlIndexValue(3), (Object)cache.get((Object)3));
        try (Transaction tx = updateNode.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
            tx.timeout(3000L);
            SqlFieldsQuery qry = new SqlFieldsQuery("DELETE FROM MvccTestSqlIndexValue WHERE _key = 1");
            IgniteCache cache0 = updateNode.cache("default");
            try (FieldsQueryCursor cur = cache0.query(qry);){
                CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)1L, ((List)cur.iterator().next()).get(0));
            }
            tx.commit();
        }
        CacheMvccSqlTxQueriesAbstractTest.assertNull((Object)cache.get((Object)1));
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)new MvccTestSqlIndexValue(2), (Object)cache.get((Object)2));
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)new MvccTestSqlIndexValue(3), (Object)cache.get((Object)3));
    }

    @Test
    public void testQueryFastUpdateObjectStaticCache() throws Exception {
        this.ccfg = this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 2, 1024).setIndexedTypes(new Class[]{Integer.class, MvccTestSqlIndexValue.class});
        this.startGridsMultiThreaded(4);
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        IgniteEx checkNode = this.grid(((Random)rnd).nextInt(4));
        IgniteEx updateNode = this.grid(((Random)rnd).nextInt(4));
        IgniteCache cache = checkNode.cache("default");
        cache.putAll(F.asMap((Object)1, (Object)new MvccTestSqlIndexValue(1), (Object)2, (Object)new MvccTestSqlIndexValue(2), (Object)3, (Object)new MvccTestSqlIndexValue(3)));
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)new MvccTestSqlIndexValue(1), (Object)cache.get((Object)1));
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)new MvccTestSqlIndexValue(2), (Object)cache.get((Object)2));
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)new MvccTestSqlIndexValue(3), (Object)cache.get((Object)3));
        try (Transaction tx = updateNode.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
            tx.timeout(3000L);
            SqlFieldsQuery qry = new SqlFieldsQuery("UPDATE MvccTestSqlIndexValue SET idxVal1 = 8 WHERE _key = 1");
            IgniteCache cache0 = updateNode.cache("default");
            try (FieldsQueryCursor cur = cache0.query(qry);){
                CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)1L, ((List)cur.iterator().next()).get(0));
            }
            tx.commit();
        }
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)new MvccTestSqlIndexValue(8), (Object)cache.get((Object)1));
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)new MvccTestSqlIndexValue(2), (Object)cache.get((Object)2));
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)new MvccTestSqlIndexValue(3), (Object)cache.get((Object)3));
    }

    @Test
    public void testQueryDeleteStaticCacheImplicit() throws Exception {
        this.ccfg = this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 2, 1024).setIndexedTypes(new Class[]{Integer.class, Integer.class});
        this.startGridsMultiThreaded(4);
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        IgniteEx checkNode = this.grid(((Random)rnd).nextInt(4));
        IgniteEx updateNode = this.grid(((Random)rnd).nextInt(4));
        IgniteCache cache = checkNode.cache("default");
        cache.putAll(F.asMap((Object)1, (Object)1, (Object)2, (Object)2, (Object)3, (Object)3));
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)1, (Object)cache.get((Object)1));
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)2, (Object)cache.get((Object)2));
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)3, (Object)cache.get((Object)3));
        SqlFieldsQuery qry = new SqlFieldsQuery("DELETE FROM Integer WHERE 1 = 1").setTimeout(3000, TimeUnit.MILLISECONDS);
        IgniteCache cache0 = updateNode.cache("default");
        try (FieldsQueryCursor cur = cache0.query(qry);){
            CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)3L, ((List)cur.iterator().next()).get(0));
        }
        CacheMvccSqlTxQueriesAbstractTest.assertNull((Object)cache.get((Object)1));
        CacheMvccSqlTxQueriesAbstractTest.assertNull((Object)cache.get((Object)2));
        CacheMvccSqlTxQueriesAbstractTest.assertNull((Object)cache.get((Object)3));
    }

    @Test
    public void testQueryUpdateStaticCache() throws Exception {
        this.ccfg = this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 2, 1024).setIndexedTypes(new Class[]{Integer.class, Integer.class});
        this.startGridsMultiThreaded(4);
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        IgniteEx checkNode = this.grid(((Random)rnd).nextInt(4));
        IgniteEx updateNode = this.grid(((Random)rnd).nextInt(4));
        IgniteCache cache = checkNode.cache("default");
        cache.putAll(F.asMap((Object)1, (Object)1, (Object)2, (Object)2, (Object)3, (Object)3));
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)1, (Object)cache.get((Object)1));
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)2, (Object)cache.get((Object)2));
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)3, (Object)cache.get((Object)3));
        try (Transaction tx = updateNode.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
            tx.timeout(3000L);
            SqlFieldsQuery qry = new SqlFieldsQuery("UPDATE Integer SET _val = (_key * 10)");
            IgniteCache cache0 = updateNode.cache("default");
            try (FieldsQueryCursor cur = cache0.query(qry);){
                CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)3L, ((List)cur.iterator().next()).get(0));
            }
            tx.commit();
        }
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)10, (Object)cache.get((Object)1));
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)20, (Object)cache.get((Object)2));
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)30, (Object)cache.get((Object)3));
    }

    @Test
    public void testQueryUpdateStaticCacheImplicit() throws Exception {
        this.ccfg = this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 2, 1024).setIndexedTypes(new Class[]{Integer.class, Integer.class});
        this.startGridsMultiThreaded(4);
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        IgniteEx checkNode = this.grid(((Random)rnd).nextInt(4));
        IgniteEx updateNode = this.grid(((Random)rnd).nextInt(4));
        IgniteCache cache = checkNode.cache("default");
        cache.putAll(F.asMap((Object)1, (Object)1, (Object)2, (Object)2, (Object)3, (Object)3));
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)1, (Object)cache.get((Object)1));
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)2, (Object)cache.get((Object)2));
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)3, (Object)cache.get((Object)3));
        SqlFieldsQuery qry = new SqlFieldsQuery("UPDATE Integer SET _val = (_key * 10)").setTimeout(3000, TimeUnit.MILLISECONDS);
        IgniteCache cache0 = updateNode.cache("default");
        try (FieldsQueryCursor cur = cache0.query(qry);){
            CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)3L, ((List)cur.iterator().next()).get(0));
        }
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)10, (Object)cache.get((Object)1));
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)20, (Object)cache.get((Object)2));
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)30, (Object)cache.get((Object)3));
    }

    @Test
    public void testQueryDeadlockWithTxTimeout() throws Exception {
        this.checkQueryDeadlock(TimeoutMode.TX);
    }

    @Test
    public void testQueryDeadlockWithStmtTimeout() throws Exception {
        this.checkQueryDeadlock(TimeoutMode.STMT);
    }

    private void checkQueryDeadlock(final TimeoutMode timeoutMode) throws Exception {
        this.ccfg = this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 2, 1024).setIndexedTypes(new Class[]{Integer.class, Integer.class});
        this.startGridsMultiThreaded(2);
        this.client = true;
        this.startGridsMultiThreaded(2, 2);
        final CyclicBarrier barrier = new CyclicBarrier(2);
        final AtomicInteger idx = new AtomicInteger();
        final AtomicReference ex = new AtomicReference();
        this.multithreaded(new Runnable(){

            @Override
            public void run() {
                int id = idx.getAndIncrement();
                IgniteEx node = CacheMvccSqlTxQueriesAbstractTest.this.grid(id);
                try (Transaction tx = node.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                    if (timeoutMode == TimeoutMode.TX) {
                        tx.timeout(3000L);
                    }
                    IgniteCache cache0 = node.cache("default");
                    String qry1 = "INSERT INTO Integer (_key, _val) values (1,1),(2,2),(3,3)";
                    String qry2 = "INSERT INTO Integer (_key, _val) values (4,4),(5,5),(6,6)";
                    SqlFieldsQuery qry = new SqlFieldsQuery(id % 2 == 0 ? qry1 : qry2);
                    if (timeoutMode == TimeoutMode.STMT) {
                        qry.setTimeout(3000, TimeUnit.MILLISECONDS);
                    }
                    try (FieldsQueryCursor cur = cache0.query(qry);){
                        cur.getAll();
                    }
                    barrier.await();
                    qry = new SqlFieldsQuery(id % 2 == 0 ? qry2 : qry1);
                    if (timeoutMode == TimeoutMode.STMT) {
                        qry.setTimeout(3000, TimeUnit.MILLISECONDS);
                    }
                    cur = cache0.query(qry);
                    var10_13 = null;
                    try {
                        cur.getAll();
                    }
                    catch (Throwable throwable) {
                        var10_13 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (cur != null) {
                            if (var10_13 != null) {
                                try {
                                    cur.close();
                                }
                                catch (Throwable throwable) {
                                    var10_13.addSuppressed(throwable);
                                }
                            } else {
                                cur.close();
                            }
                        }
                    }
                    tx.commit();
                }
                catch (Exception e) {
                    CacheMvccSqlTxQueriesAbstractTest.this.onException(ex, e);
                }
            }
        }, 2);
        Exception ex0 = (Exception)ex.get();
        CacheMvccSqlTxQueriesAbstractTest.assertNotNull((Object)ex0);
        if (!X.hasCause((Throwable)ex0, (Class[])new Class[]{IgniteTxTimeoutCheckedException.class})) {
            throw ex0;
        }
    }

    @Test
    public void testQueryDeadlockImplicit() throws Exception {
        this.ccfg = this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 0, 1024).setIndexedTypes(new Class[]{Integer.class, Integer.class});
        this.startGridsMultiThreaded(2);
        final Phaser phaser = new Phaser(2);
        final AtomicReference ex = new AtomicReference();
        GridTestUtils.runAsync((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                IgniteEx node = CacheMvccSqlTxQueriesAbstractTest.this.grid(0);
                try (Transaction tx = node.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                    IgniteCache cache0 = node.cache("default");
                    SqlFieldsQuery qry = new SqlFieldsQuery("INSERT INTO Integer (_key, _val) values (1,1),(2,2),(3,3)");
                    try (FieldsQueryCursor cur = cache0.query(qry);){
                        cur.getAll();
                    }
                    CacheMvccSqlTxQueriesAbstractTest.this.awaitPhase(phaser, 2);
                    tx.commit();
                }
                catch (Exception e) {
                    CacheMvccSqlTxQueriesAbstractTest.this.onException(ex, e);
                }
                finally {
                    phaser.arrive();
                }
            }
        });
        phaser.arriveAndAwaitAdvance();
        IgniteEx node = this.grid(1);
        IgniteCache cache0 = node.cache("default");
        SqlFieldsQuery qry = new SqlFieldsQuery("INSERT INTO Integer (_key, _val) values (1,1),(2,2),(3,3)").setTimeout(3000, TimeUnit.MILLISECONDS);
        try (FieldsQueryCursor cur = cache0.query(qry);){
            cur.getAll();
        }
        catch (Exception e) {
            phaser.arrive();
            this.onException(ex, e);
        }
        phaser.arriveAndAwaitAdvance();
        Exception ex0 = (Exception)ex.get();
        CacheMvccSqlTxQueriesAbstractTest.assertNotNull((Object)ex0);
        if (!X.hasCause((Throwable)ex0, (Class[])new Class[]{IgniteTxTimeoutCheckedException.class})) {
            throw ex0;
        }
    }

    @Test
    public void testQueryInsertClient() throws Exception {
        this.ccfg = this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 2, 1024).setIndexedTypes(new Class[]{Integer.class, Integer.class});
        this.startGrid(0);
        this.client = true;
        this.startGrid(1);
        this.awaitPartitionMapExchange();
        IgniteEx checkNode = this.grid(0);
        IgniteEx updateNode = this.grid(1);
        IgniteCache cache = checkNode.cache("default");
        try (Transaction tx = updateNode.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
            tx.timeout(3000L);
            SqlFieldsQuery qry = new SqlFieldsQuery("INSERT INTO Integer (_key, _val) values (1,1),(2,2),(3,3)");
            IgniteCache cache0 = updateNode.cache("default");
            try (FieldsQueryCursor cur = cache0.query(qry);){
                CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)3L, ((List)cur.iterator().next()).get(0));
            }
            qry = new SqlFieldsQuery("INSERT INTO Integer (_key, _val) values (4,4),(5,5),(6,6)");
            cur = cache0.query(qry);
            var9_11 = null;
            try {
                CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)3L, ((List)cur.iterator().next()).get(0));
            }
            catch (Throwable throwable) {
                var9_11 = throwable;
                throw throwable;
            }
            finally {
                if (cur != null) {
                    if (var9_11 != null) {
                        try {
                            cur.close();
                        }
                        catch (Throwable throwable) {
                            var9_11.addSuppressed(throwable);
                        }
                    } else {
                        cur.close();
                    }
                }
            }
            tx.commit();
        }
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)1, (Object)cache.get((Object)1));
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)2, (Object)cache.get((Object)2));
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)3, (Object)cache.get((Object)3));
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)4, (Object)cache.get((Object)4));
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)5, (Object)cache.get((Object)5));
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)6, (Object)cache.get((Object)6));
    }

    @Test
    public void testQueryInsertClientImplicit() throws Exception {
        this.ccfg = this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 2, 1024).setIndexedTypes(new Class[]{Integer.class, Integer.class});
        this.startGrid(0);
        this.client = true;
        this.startGrid(1);
        this.awaitPartitionMapExchange();
        IgniteEx checkNode = this.grid(0);
        IgniteEx updateNode = this.grid(1);
        IgniteCache cache = checkNode.cache("default");
        SqlFieldsQuery qry = new SqlFieldsQuery("INSERT INTO Integer (_key, _val) values (1,1),(2,2),(3,3)").setTimeout(3000, TimeUnit.MILLISECONDS);
        IgniteCache cache0 = updateNode.cache("default");
        try (FieldsQueryCursor cur = cache0.query(qry);){
            CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)3L, ((List)cur.iterator().next()).get(0));
        }
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)1, (Object)cache.get((Object)1));
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)2, (Object)cache.get((Object)2));
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)3, (Object)cache.get((Object)3));
    }

    @Test
    public void testQueryInsertSubquery() throws Exception {
        this.ccfg = this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 2, 1024).setIndexedTypes(new Class[]{Integer.class, Integer.class, Integer.class, MvccTestSqlIndexValue.class});
        this.startGridsMultiThreaded(4);
        this.awaitPartitionMapExchange();
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        IgniteEx checkNode = this.grid(((Random)rnd).nextInt(4));
        IgniteEx updateNode = this.grid(((Random)rnd).nextInt(4));
        IgniteCache cache = checkNode.cache("default");
        cache.putAll(F.asMap((Object)1, (Object)new MvccTestSqlIndexValue(1), (Object)2, (Object)new MvccTestSqlIndexValue(2), (Object)3, (Object)new MvccTestSqlIndexValue(3)));
        IgniteCache cache0 = updateNode.cache("default");
        try (Transaction tx = updateNode.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
            tx.timeout(3000L);
            SqlFieldsQuery qry = new SqlFieldsQuery("INSERT INTO Integer (_key, _val) SELECT _key * 10, idxVal1 FROM MvccTestSqlIndexValue");
            try (FieldsQueryCursor cur = cache0.query(qry);){
                CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)3L, ((List)cur.iterator().next()).get(0));
            }
            tx.commit();
        }
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)1, (Object)cache0.get((Object)10));
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)2, (Object)cache0.get((Object)20));
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)3, (Object)cache0.get((Object)30));
    }

    @Test
    public void testQueryInsertSubqueryImplicit() throws Exception {
        this.ccfg = this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 2, 1024).setIndexedTypes(new Class[]{Integer.class, Integer.class, Integer.class, MvccTestSqlIndexValue.class});
        this.startGridsMultiThreaded(4);
        this.awaitPartitionMapExchange();
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        IgniteEx checkNode = this.grid(((Random)rnd).nextInt(4));
        IgniteEx updateNode = this.grid(((Random)rnd).nextInt(4));
        IgniteCache cache = checkNode.cache("default");
        cache.putAll(F.asMap((Object)1, (Object)new MvccTestSqlIndexValue(1), (Object)2, (Object)new MvccTestSqlIndexValue(2), (Object)3, (Object)new MvccTestSqlIndexValue(3)));
        SqlFieldsQuery qry = new SqlFieldsQuery("INSERT INTO Integer (_key, _val) SELECT _key * 10, idxVal1 FROM MvccTestSqlIndexValue").setTimeout(3000, TimeUnit.MILLISECONDS);
        IgniteCache cache0 = updateNode.cache("default");
        try (FieldsQueryCursor cur = cache0.query(qry);){
            CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)3L, ((List)cur.iterator().next()).get(0));
        }
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)1, (Object)cache0.get((Object)10));
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)2, (Object)cache0.get((Object)20));
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)3, (Object)cache0.get((Object)30));
    }

    @Test
    public void testQueryUpdateSubquery() throws Exception {
        this.ccfg = this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 2, 1024).setIndexedTypes(new Class[]{Integer.class, Integer.class, Integer.class, MvccTestSqlIndexValue.class});
        this.startGridsMultiThreaded(4);
        this.awaitPartitionMapExchange();
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        IgniteEx checkNode = this.grid(((Random)rnd).nextInt(4));
        IgniteEx updateNode = this.grid(((Random)rnd).nextInt(4));
        IgniteCache cache = checkNode.cache("default");
        cache.putAll(F.asMap((Object)1, (Object)new MvccTestSqlIndexValue(1), (Object)2, (Object)new MvccTestSqlIndexValue(2), (Object)3, (Object)new MvccTestSqlIndexValue(3)));
        try (Transaction tx = updateNode.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
            tx.timeout(3000L);
            SqlFieldsQuery qry = new SqlFieldsQuery("UPDATE MvccTestSqlIndexValue AS t SET (idxVal1) = (SELECT idxVal1*10 FROM MvccTestSqlIndexValue WHERE t._key = _key)");
            IgniteCache cache0 = updateNode.cache("default");
            try (FieldsQueryCursor cur = cache0.query(qry);){
                CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)3L, ((List)cur.iterator().next()).get(0));
            }
            tx.commit();
        }
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((int)10, (int)((MvccTestSqlIndexValue)cache.get((Object)1)).idxVal1);
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((int)20, (int)((MvccTestSqlIndexValue)cache.get((Object)2)).idxVal1);
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((int)30, (int)((MvccTestSqlIndexValue)cache.get((Object)3)).idxVal1);
    }

    @Test
    public void testQueryUpdateSubqueryImplicit() throws Exception {
        this.ccfg = this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 2, 1024).setIndexedTypes(new Class[]{Integer.class, Integer.class, Integer.class, MvccTestSqlIndexValue.class});
        this.startGridsMultiThreaded(4);
        this.awaitPartitionMapExchange();
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        IgniteEx checkNode = this.grid(((Random)rnd).nextInt(4));
        IgniteEx updateNode = this.grid(((Random)rnd).nextInt(4));
        IgniteCache cache = checkNode.cache("default");
        cache.putAll(F.asMap((Object)1, (Object)new MvccTestSqlIndexValue(1), (Object)2, (Object)new MvccTestSqlIndexValue(2), (Object)3, (Object)new MvccTestSqlIndexValue(3)));
        SqlFieldsQuery qry = new SqlFieldsQuery("UPDATE MvccTestSqlIndexValue AS t SET (idxVal1) = (SELECT idxVal1*10 FROM MvccTestSqlIndexValue WHERE t._key = _key)").setTimeout(3000, TimeUnit.MILLISECONDS);
        IgniteCache cache0 = updateNode.cache("default");
        try (FieldsQueryCursor cur = cache0.query(qry);){
            CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)3L, ((List)cur.iterator().next()).get(0));
        }
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((int)10, (int)((MvccTestSqlIndexValue)cache.get((Object)1)).idxVal1);
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((int)20, (int)((MvccTestSqlIndexValue)cache.get((Object)2)).idxVal1);
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((int)30, (int)((MvccTestSqlIndexValue)cache.get((Object)3)).idxVal1);
    }

    @Ignore(value="https://issues.apache.org/jira/browse/IGNITE-10764")
    @Test
    public void testQueryInsertMultithread() throws Exception {
        int THREAD_CNT = 8;
        int BATCH_SIZE = 1000;
        int ROUNDS = 10;
        this.ccfg = this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 2, 1024).setIndexedTypes(new Class[]{Integer.class, Integer.class});
        this.startGridsMultiThreaded(2);
        this.client = true;
        this.startGridsMultiThreaded(2, 2);
        final AtomicInteger seq = new AtomicInteger();
        this.multithreaded(new Runnable(){

            @Override
            public void run() {
                for (int r = 0; r < 10; ++r) {
                    int start;
                    StringBuilder bldr = new StringBuilder("INSERT INTO Integer (_key, _val) values ");
                    int end = start + 1000;
                    for (int i = start = seq.getAndAdd(1000); i < end; ++i) {
                        if (i != start) {
                            bldr.append(',');
                        }
                        bldr.append('(').append(i).append(',').append(i).append(')');
                    }
                    ThreadLocalRandom rnd = ThreadLocalRandom.current();
                    IgniteEx checkNode = CacheMvccSqlTxQueriesAbstractTest.this.grid(((Random)rnd).nextInt(4));
                    IgniteEx updateNode = CacheMvccSqlTxQueriesAbstractTest.this.grid(((Random)rnd).nextInt(4));
                    IgniteCache cache = checkNode.cache("default");
                    try (Transaction tx = updateNode.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                        tx.timeout(3000L);
                        SqlFieldsQuery qry = new SqlFieldsQuery(bldr.toString()).setPageSize(100);
                        IgniteCache cache0 = updateNode.cache("default");
                        try (FieldsQueryCursor cur = cache0.query(qry);){
                            Assert.assertEquals((Object)1000L, ((List)cur.iterator().next()).get(0));
                        }
                        tx.commit();
                    }
                    int end2 = start + 1000;
                    for (int i = start; i < end2; ++i) {
                        Assert.assertEquals((Object)i, (Object)cache.get((Object)i));
                    }
                }
            }
        }, 8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore(value="https://issues.apache.org/jira/browse/IGNITE-9470")
    @Test
    public void testQueryInsertUpdateMultithread() throws Exception {
        this.ccfg = this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 2, 1024).setIndexedTypes(new Class[]{Integer.class, Integer.class});
        this.startGridsMultiThreaded(2);
        final Phaser phaser = new Phaser(2);
        final AtomicReference ex = new AtomicReference();
        GridCompoundFuture fut = new GridCompoundFuture();
        fut.add(this.multithreadedAsync(new Runnable(){

            @Override
            public void run() {
                IgniteEx node = CacheMvccSqlTxQueriesAbstractTest.this.grid(0);
                try (Transaction tx = node.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                    tx.timeout(3000L);
                    IgniteCache cache0 = node.cache("default");
                    SqlFieldsQuery qry = new SqlFieldsQuery("INSERT INTO Integer (_key, _val) values (1,1),(2,2),(3,3)");
                    try (FieldsQueryCursor cur = cache0.query(qry);){
                        cur.getAll();
                    }
                    CacheMvccSqlTxQueriesAbstractTest.this.awaitPhase(phaser, 2);
                    qry = new SqlFieldsQuery("INSERT INTO Integer (_key, _val) values (4,4),(5,5),(6,6)");
                    cur = cache0.query(qry);
                    var7_10 = null;
                    try {
                        cur.getAll();
                    }
                    catch (Throwable throwable) {
                        var7_10 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (cur != null) {
                            if (var7_10 != null) {
                                try {
                                    cur.close();
                                }
                                catch (Throwable throwable) {
                                    var7_10.addSuppressed(throwable);
                                }
                            } else {
                                cur.close();
                            }
                        }
                    }
                    tx.commit();
                }
                catch (Exception e) {
                    CacheMvccSqlTxQueriesAbstractTest.this.onException(ex, e);
                }
            }
        }, 1));
        fut.add(this.multithreadedAsync(new Runnable(){

            @Override
            public void run() {
                IgniteEx node = CacheMvccSqlTxQueriesAbstractTest.this.grid(1);
                try {
                    phaser.arriveAndAwaitAdvance();
                    try (Transaction tx = node.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                        tx.timeout(3000L);
                        IgniteCache cache0 = node.cache("default");
                        cache0.invokeAllAsync(F.asSet((Object[])new Integer[]{1, 2, 3, 4, 5, 6}), (EntryProcessor)new EntryProcessor<Integer, Integer, Void>(){

                            public Void process(MutableEntry<Integer, Integer> entry, Object ... arguments) throws EntryProcessorException {
                                entry.setValue((Object)((Integer)entry.getValue() * 10));
                                return null;
                            }
                        }, new Object[0]);
                        phaser.arrive();
                        tx.commit();
                    }
                }
                catch (Exception e) {
                    CacheMvccSqlTxQueriesAbstractTest.this.onException(ex, e);
                }
            }
        }, 1));
        try {
            fut.markInitialized();
            fut.get(3000L);
        }
        catch (IgniteCheckedException e) {
            this.onException(ex, e);
        }
        finally {
            phaser.forceTermination();
        }
        Exception ex0 = (Exception)ex.get();
        if (ex0 != null) {
            throw ex0;
        }
        IgniteCache cache = this.grid(0).cache("default");
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)10, (Object)cache.get((Object)1));
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)20, (Object)cache.get((Object)2));
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)30, (Object)cache.get((Object)3));
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)40, (Object)cache.get((Object)4));
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)50, (Object)cache.get((Object)5));
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)60, (Object)cache.get((Object)6));
    }

    @Test
    public void testQueryInsertVersionConflict() throws Exception {
        this.ccfg = this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 2, 1024).setIndexedTypes(new Class[]{Integer.class, Integer.class});
        this.startGridsMultiThreaded(2);
        IgniteCache cache = this.grid(0).cache("default");
        SqlFieldsQuery qry = new SqlFieldsQuery("INSERT INTO Integer (_key, _val) values (1,1)");
        try (FieldsQueryCursor cur = cache.query(qry);){
            CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)1L, ((List)cur.iterator().next()).get(0));
        }
        final CyclicBarrier barrier = new CyclicBarrier(2);
        final AtomicReference ex = new AtomicReference();
        GridTestUtils.runMultiThreaded((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                IgniteEx node = CacheMvccSqlTxQueriesAbstractTest.this.grid(0);
                try (Transaction tx = node.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                    SqlFieldsQuery qry;
                    tx.timeout(3000L);
                    barrier.await(3000L, TimeUnit.MILLISECONDS);
                    IgniteCache cache0 = node.cache("default");
                    CyclicBarrier cyclicBarrier = barrier;
                    synchronized (cyclicBarrier) {
                        qry = new SqlFieldsQuery("SELECT * FROM Integer");
                        try (FieldsQueryCursor cur = cache0.query(qry);){
                            Assert.assertEquals((int)1, (int)cur.getAll().size());
                        }
                    }
                    barrier.await(3000L, TimeUnit.MILLISECONDS);
                    qry = new SqlFieldsQuery("UPDATE Integer SET _val = (_key * 10)");
                    try (FieldsQueryCursor cur = cache0.query(qry);){
                        Assert.assertEquals((Object)1L, ((List)cur.iterator().next()).get(0));
                    }
                    tx.commit();
                }
                catch (Exception e) {
                    CacheMvccSqlTxQueriesAbstractTest.this.onException(ex, e);
                }
            }
        }, (int)2, (String)"tx-thread");
        IgniteSQLException ex0 = (IgniteSQLException)X.cause((Throwable)((Throwable)ex.get()), IgniteSQLException.class);
        CacheMvccSqlTxQueriesAbstractTest.assertNotNull((String)"Exception has not been thrown.", (Object)ex0);
        CacheMvccSqlTxQueriesAbstractTest.assertTrue((boolean)ex0.getMessage().startsWith("Cannot serialize transaction due to write conflict"));
    }

    @Test
    public void testInsertAndFastDeleteWithoutVersionConflict() throws Exception {
        this.ccfg = this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 2, 1024).setIndexedTypes(new Class[]{Integer.class, Integer.class});
        this.startGridsMultiThreaded(2);
        IgniteCache cache0 = this.grid(0).cache("default");
        try (Transaction tx1 = this.grid(0).transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
            cache0.query(new SqlFieldsQuery("select * from Integer where _key = 1"));
            GridTestUtils.runAsync(() -> cache0.query(new SqlFieldsQuery("insert into Integer(_key, _val) values(?, ?)").setArgs(new Object[]{1, 1}))).get();
            cache0.query(new SqlFieldsQuery("delete from Integer where _key = ?").setArgs(new Object[]{1}));
            tx1.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            CacheMvccSqlTxQueriesAbstractTest.fail((String)"Exception is not expected here");
        }
    }

    @Test
    public void testInsertAndFastUpdateWithoutVersionConflict() throws Exception {
        this.ccfg = this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 2, 1024).setIndexedTypes(new Class[]{Integer.class, Integer.class});
        this.startGridsMultiThreaded(2);
        IgniteCache cache0 = this.grid(0).cache("default");
        try (Transaction tx1 = this.grid(0).transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
            cache0.query(new SqlFieldsQuery("select * from Integer where _key = 1"));
            GridTestUtils.runAsync(() -> cache0.query(new SqlFieldsQuery("insert into Integer(_key, _val) values(?, ?)").setArgs(new Object[]{1, 1}))).get();
            cache0.query(new SqlFieldsQuery("update Integer set _val = ? where _key = ?").setArgs(new Object[]{1, 1}));
            tx1.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            CacheMvccSqlTxQueriesAbstractTest.fail((String)"Exception is not expected here");
        }
    }

    @Ignore(value="https://issues.apache.org/jira/browse/IGNITE-9292")
    @Test
    public void testInsertFastUpdateConcurrent() throws Exception {
        this.ccfg = this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 2, 1024).setIndexedTypes(new Class[]{Integer.class, Integer.class});
        this.startGridsMultiThreaded(2);
        IgniteCache cache0 = this.grid(0).cache("default");
        try {
            int i = 0;
            while (i < 100) {
                int key = i++;
                CompletableFuture.allOf(CompletableFuture.runAsync(() -> cache0.query(new SqlFieldsQuery("insert into Integer(_key, _val) values(?, ?)").setArgs(new Object[]{key, key}))), CompletableFuture.runAsync(() -> cache0.query(new SqlFieldsQuery("update Integer set _val = ? where _key = ?").setArgs(new Object[]{key, key})))).get();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            CacheMvccSqlTxQueriesAbstractTest.fail((String)"Exception is not expected here");
        }
    }

    @Test
    public void testQueryInsertRollback() throws Exception {
        this.ccfg = this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 2, 1024).setIndexedTypes(new Class[]{Integer.class, Integer.class});
        this.startGridsMultiThreaded(4);
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        IgniteEx checkNode = this.grid(((Random)rnd).nextInt(4));
        IgniteEx updateNode = this.grid(((Random)rnd).nextInt(4));
        IgniteCache cache = checkNode.cache("default");
        try (Transaction tx = updateNode.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
            tx.timeout(3000L);
            SqlFieldsQuery qry = new SqlFieldsQuery("INSERT INTO Integer (_key, _val) values (1,1),(2,2),(3,3)");
            IgniteCache cache0 = updateNode.cache("default");
            try (FieldsQueryCursor cur = cache0.query(qry);){
                CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)3L, ((List)cur.iterator().next()).get(0));
            }
            qry = new SqlFieldsQuery("INSERT INTO Integer (_key, _val) values (4,4),(5,5),(6,6)");
            cur = cache0.query(qry);
            var10_13 = null;
            try {
                CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)3L, ((List)cur.iterator().next()).get(0));
            }
            catch (Throwable throwable) {
                var10_13 = throwable;
                throw throwable;
            }
            finally {
                if (cur != null) {
                    if (var10_13 != null) {
                        try {
                            cur.close();
                        }
                        catch (Throwable throwable) {
                            var10_13.addSuppressed(throwable);
                        }
                    } else {
                        cur.close();
                    }
                }
            }
            tx.rollback();
        }
        for (int i = 1; i <= 6; ++i) {
            CacheMvccSqlTxQueriesAbstractTest.assertTrue((boolean)cache.query(new SqlFieldsQuery("SELECT * FROM Integer WHERE _key = 1")).getAll().isEmpty());
        }
    }

    @Test
    public void testQueryInsertUpdateSameKeys() throws Exception {
        this.ccfg = this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 2, 1024).setIndexedTypes(new Class[]{Integer.class, Integer.class});
        this.startGridsMultiThreaded(4);
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        IgniteEx checkNode = this.grid(((Random)rnd).nextInt(4));
        IgniteEx updateNode = this.grid(((Random)rnd).nextInt(4));
        IgniteCache cache = checkNode.cache("default");
        try (Transaction tx = updateNode.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
            tx.timeout(3000L);
            SqlFieldsQuery qry = new SqlFieldsQuery("INSERT INTO Integer (_key, _val) values (1,1),(2,2),(3,3)");
            IgniteCache cache0 = updateNode.cache("default");
            try (FieldsQueryCursor cur = cache0.query(qry);){
                CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)3L, ((List)cur.iterator().next()).get(0));
            }
            qry = new SqlFieldsQuery("UPDATE Integer SET _val = (_key * 10)");
            cur = cache0.query(qry);
            var10_12 = null;
            try {
                cur.getAll();
            }
            catch (Throwable throwable) {
                var10_12 = throwable;
                throw throwable;
            }
            finally {
                if (cur != null) {
                    if (var10_12 != null) {
                        try {
                            cur.close();
                        }
                        catch (Throwable throwable) {
                            var10_12.addSuppressed(throwable);
                        }
                    } else {
                        cur.close();
                    }
                }
            }
            tx.commit();
        }
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)10, (Object)cache.get((Object)1));
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)20, (Object)cache.get((Object)2));
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)30, (Object)cache.get((Object)3));
    }

    @Test
    public void testQueryInsertUpdateSameKeysInSameOperation() throws Exception {
        this.ccfg = this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 2, 1024).setIndexedTypes(new Class[]{Integer.class, Integer.class});
        this.startGridsMultiThreaded(4);
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        IgniteEx updateNode = this.grid(((Random)rnd).nextInt(4));
        GridTestUtils.assertThrows(null, (Callable)new Callable<Object>((Ignite)updateNode){
            final /* synthetic */ Ignite val$updateNode;
            {
                this.val$updateNode = ignite;
            }

            @Override
            public Object call() throws Exception {
                try (Transaction tx = this.val$updateNode.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                    tx.timeout(3000L);
                    SqlFieldsQuery qry = new SqlFieldsQuery("INSERT INTO Integer (_key, _val) values (1,1),(1,2),(1,3)");
                    IgniteCache cache0 = this.val$updateNode.cache("default");
                    cache0.query(qry).getAll();
                    tx.commit();
                }
                return null;
            }
        }, CacheException.class, (String)"Duplicate key during INSERT [key=KeyCacheObjectImpl");
    }

    @Test
    public void testQueryPendingUpdates() throws Exception {
        this.ccfg = this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 2, 1024).setIndexedTypes(new Class[]{Integer.class, Integer.class});
        this.startGridsMultiThreaded(4);
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        IgniteEx checkNode = this.grid(((Random)rnd).nextInt(4));
        IgniteEx updateNode = this.grid(((Random)rnd).nextInt(4));
        final IgniteCache cache = checkNode.cache("default");
        try (Transaction tx = updateNode.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
            Object row2;
            tx.timeout(3000L);
            SqlFieldsQuery qry = new SqlFieldsQuery("INSERT INTO Integer (_key, _val) values (1,1),(2,2),(3,3)");
            IgniteCache cache0 = updateNode.cache("default");
            try (Object cur = cache0.query(qry);){
                CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)3L, ((List)cur.iterator().next()).get(0));
            }
            cur = cache0.query(qry.setSql("UPDATE Integer SET _val = (_key * 10)"));
            var10_12 = null;
            try {
                CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)3L, ((List)cur.iterator().next()).get(0));
            }
            catch (Throwable throwable) {
                var10_12 = throwable;
                throw throwable;
            }
            finally {
                if (cur != null) {
                    if (var10_12 != null) {
                        try {
                            cur.close();
                        }
                        catch (Throwable throwable) {
                            var10_12.addSuppressed(throwable);
                        }
                    } else {
                        cur.close();
                    }
                }
            }
            for (Object row2 : cache0.query(qry.setSql("SELECT _key, _val FROM Integer")).getAll()) {
                CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)((Integer)row2.get(0) * 10), row2.get(1));
            }
            cur = cache0.query(qry.setSql("UPDATE Integer SET _val = 15 where _key = 2"));
            row2 = null;
            try {
                CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)1L, ((List)cur.iterator().next()).get(0));
            }
            catch (Throwable throwable) {
                row2 = throwable;
                throw throwable;
            }
            finally {
                if (cur != null) {
                    if (row2 != null) {
                        try {
                            cur.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)row2).addSuppressed(throwable);
                        }
                    } else {
                        cur.close();
                    }
                }
            }
            for (Object row2 : cache0.query(qry.setSql("SELECT _key, _val FROM Integer")).getAll()) {
                if ((Integer)row2.get(0) == 2) {
                    CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)15, row2.get(1));
                    continue;
                }
                CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)((Integer)row2.get(0) * 10), row2.get(1));
            }
            GridTestUtils.runAsync((Runnable)new Runnable(){

                @Override
                public void run() {
                    SqlFieldsQuery qry = new SqlFieldsQuery("SELECT _key, _val FROM Integer");
                    Assert.assertTrue((boolean)cache.query(qry).getAll().isEmpty());
                }
            }).get(3000L);
            cache0.query(qry.setSql("DELETE FROM Integer")).getAll();
            CacheMvccSqlTxQueriesAbstractTest.assertTrue((boolean)cache0.query(qry.setSql("SELECT _key, _val FROM Integer")).getAll().isEmpty());
            CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)3L, ((List)cache0.query(qry.setSql("INSERT INTO Integer (_key, _val) values (1,1),(2,2),(3,3)")).getAll().iterator().next()).get(0));
            tx.commit();
        }
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)1, (Object)cache.get((Object)1));
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)2, (Object)cache.get((Object)2));
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)3, (Object)cache.get((Object)3));
    }

    @Test
    public void testSelectProducesTransaction() throws Exception {
        this.ccfg = this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 2, 1024).setIndexedTypes(new Class[]{Integer.class, MvccTestSqlIndexValue.class});
        this.startGridsMultiThreaded(4);
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        IgniteEx node = this.grid(((Random)rnd).nextInt(4));
        IgniteCache cache = node.cache("default");
        SqlFieldsQuery qry = new SqlFieldsQuery("INSERT INTO MvccTestSqlIndexValue (_key, idxVal1) values (1,1),(2,2),(3,3)");
        try (FieldsQueryCursor cur = cache.query(qry);){
            CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)3L, ((List)cur.iterator().next()).get(0));
        }
        SqlFieldsQueryEx qryEx = new SqlFieldsQueryEx("SELECT * FROM MvccTestSqlIndexValue", Boolean.valueOf(true));
        qryEx.setAutoCommit(false);
        try (FieldsQueryCursor cur = cache.query((SqlFieldsQuery)qryEx);){
            CacheMvccSqlTxQueriesAbstractTest.assertEquals((int)3, (int)cur.getAll().size());
        }
        var7_9 = null;
        try (GridNearTxLocal tx = ((IgniteEx)cache.unwrap(IgniteEx.class)).context().cache().context().tm().userTx();){
            CacheMvccSqlTxQueriesAbstractTest.assertNotNull((Object)tx);
        }
        catch (Throwable throwable) {
            var7_9 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testRepeatableRead() throws Exception {
        this.ccfg = this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 2, 1024).setIndexedTypes(new Class[]{Integer.class, MvccTestSqlIndexValue.class});
        this.startGridsMultiThreaded(4);
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        IgniteCache cache = this.grid(((Random)rnd).nextInt(4)).cache("default");
        try (FieldsQueryCursor cur = cache.query(new SqlFieldsQuery("INSERT INTO MvccTestSqlIndexValue (_key, idxVal1) values (1,1),(2,2),(3,3)"));){
            CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)3L, ((List)cur.iterator().next()).get(0));
        }
        IgniteEx node = this.grid(((Random)rnd).nextInt(4));
        IgniteCache cache0 = node.cache("default");
        SqlFieldsQuery qry = new SqlFieldsQuery("SELECT * FROM MvccTestSqlIndexValue");
        try (Transaction tx = node.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
            tx.timeout(3000L);
            try (FieldsQueryCursor cur = cache0.query(qry);){
                CacheMvccSqlTxQueriesAbstractTest.assertEquals((int)3, (int)cur.getAll().size());
            }
            GridTestUtils.runAsync((Runnable)new Runnable(){

                @Override
                public void run() {
                    IgniteCache cache = CacheMvccSqlTxQueriesAbstractTest.this.grid(ThreadLocalRandom.current().nextInt(4)).cache("default");
                    try (FieldsQueryCursor cur = cache.query(new SqlFieldsQuery("INSERT INTO MvccTestSqlIndexValue (_key, idxVal1) values (4,4),(5,5),(6,6)"));){
                        Assert.assertEquals((Object)3L, ((List)cur.iterator().next()).get(0));
                    }
                }
            }).get(3000L);
            cur = cache0.query(qry);
            var9_17 = null;
            try {
                CacheMvccSqlTxQueriesAbstractTest.assertEquals((int)3, (int)cur.getAll().size());
            }
            catch (Throwable throwable) {
                var9_17 = throwable;
                throw throwable;
            }
            finally {
                if (cur != null) {
                    if (var9_17 != null) {
                        try {
                            cur.close();
                        }
                        catch (Throwable throwable) {
                            var9_17.addSuppressed(throwable);
                        }
                    } else {
                        cur.close();
                    }
                }
            }
        }
        var7_11 = null;
        try (FieldsQueryCursor cur = cache0.query(qry);){
            CacheMvccSqlTxQueriesAbstractTest.assertEquals((int)6, (int)cur.getAll().size());
        }
        catch (Throwable throwable) {
            var7_11 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testFastInsertUpdateConcurrent() throws Exception {
        this.ccfg = this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 2, 1024).setIndexedTypes(new Class[]{Integer.class, Integer.class});
        Ignite ignite = this.startGridsMultiThreaded(4);
        IgniteCache cache = ignite.cache("default");
        int i = 0;
        while (i < 1000) {
            int key = i++;
            CompletableFuture.allOf(CompletableFuture.runAsync(() -> cache.query(new SqlFieldsQuery("insert into Integer(_key, _val) values(?, ?)").setArgs(new Object[]{key, key}))), CompletableFuture.runAsync(() -> cache.query(new SqlFieldsQuery("update Integer set _val = ? where _key = ?").setArgs(new Object[]{key, key})))).join();
        }
    }

    @Test
    public void testIterator() throws Exception {
        List res;
        this.ccfg = this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 2, 1024).setIndexedTypes(new Class[]{Integer.class, Integer.class});
        this.startGrid(this.getConfiguration("grid").setMvccVacuumFrequency(Integer.MAX_VALUE));
        IgniteEx client = this.startGrid(this.getConfiguration("client").setClientMode(true));
        IgniteCache cache = client.cache("default");
        cache.put((Object)1, (Object)1);
        cache.put((Object)2, (Object)2);
        cache.put((Object)3, (Object)3);
        cache.put((Object)4, (Object)4);
        try (Transaction tx = client.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
            tx.timeout(3000L);
            res = cache.query(new SqlFieldsQuery("UPDATE Integer SET _val = CASE _key WHEN 1 THEN 10 WHEN 2 THEN 20 ELSE 30 END")).getAll();
            CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)4L, ((List)res.get(0)).get(0));
            tx.rollback();
        }
        tx = client.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);
        var5_4 = null;
        try {
            tx.timeout(3000L);
            res = cache.query(new SqlFieldsQuery("UPDATE Integer SET _val = CASE _val WHEN 1 THEN 10 WHEN 2 THEN 20 ELSE 30 END")).getAll();
            CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)4L, ((List)res.get(0)).get(0));
            res = cache.query(new SqlFieldsQuery("UPDATE Integer SET _val = CASE _val WHEN 10 THEN 100 WHEN 20 THEN 200 ELSE 300 END")).getAll();
            CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)4L, ((List)res.get(0)).get(0));
            res = cache.query(new SqlFieldsQuery("DELETE FROM Integer WHERE _key = 4")).getAll();
            CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)1L, ((List)res.get(0)).get(0));
            tx.commit();
        }
        catch (Throwable throwable) {
            var5_4 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_4 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var5_4.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        IgniteCache cache0 = client.cache("default");
        Iterator it = cache0.iterator();
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        while (it.hasNext()) {
            Cache.Entry e = (Cache.Entry)it.next();
            CacheMvccSqlTxQueriesAbstractTest.assertNull((String)"duplicate key returned from iterator", (Object)map.putIfAbsent(e.getKey(), e.getValue()));
        }
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((int)3, (int)map.size());
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((int)100, (int)((Integer)map.get(1)));
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((int)200, (int)((Integer)map.get(2)));
        CacheMvccSqlTxQueriesAbstractTest.assertEquals((int)300, (int)((Integer)map.get(3)));
    }

    @Test
    public void testHints() throws Exception {
        List res;
        this.persistence = true;
        this.ccfg = this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 2, 1024).setIndexedTypes(new Class[]{Integer.class, Integer.class});
        IgniteEx node = this.startGrid(this.getConfiguration("grid").setMvccVacuumFrequency(100L));
        node.cluster().active(true);
        IgniteEx client = this.startGrid(this.getConfiguration("client").setClientMode(true));
        IgniteCache cache = client.cache("default");
        try (Transaction tx = client.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
            tx.timeout(3000L);
            res = cache.query(new SqlFieldsQuery("INSERT INTO Integer (_key, _val) VALUES (1, 1), (2, 2), (3, 3), (4, 4)")).getAll();
            CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)4L, ((List)res.get(0)).get(0));
            tx.commit();
        }
        tx = client.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);
        var6_5 = null;
        try {
            tx.timeout(3000L);
            res = cache.query(new SqlFieldsQuery("UPDATE Integer SET _val = CASE _key WHEN 1 THEN 10 WHEN 2 THEN 20 ELSE 30 END")).getAll();
            CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)4L, ((List)res.get(0)).get(0));
            tx.rollback();
        }
        catch (Throwable throwable) {
            var6_5 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var6_5 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var6_5.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = client.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);
        var6_5 = null;
        try {
            tx.timeout(3000L);
            res = cache.query(new SqlFieldsQuery("UPDATE Integer SET _val = CASE _val WHEN 1 THEN 10 WHEN 2 THEN 20 ELSE 30 END")).getAll();
            CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)4L, ((List)res.get(0)).get(0));
            res = cache.query(new SqlFieldsQuery("UPDATE Integer SET _val = CASE _val WHEN 10 THEN 100 WHEN 20 THEN 200 ELSE 300 END")).getAll();
            CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)4L, ((List)res.get(0)).get(0));
            res = cache.query(new SqlFieldsQuery("DELETE FROM Integer WHERE _key = 4")).getAll();
            CacheMvccSqlTxQueriesAbstractTest.assertEquals((Object)1L, ((List)res.get(0)).get(0));
            tx.commit();
        }
        catch (Throwable throwable) {
            var6_5 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var6_5 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var6_5.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        this.mvccProcessor((Ignite)node).runVacuum().get(3000L);
        this.checkAllVersionsHints(node.cache("default"));
    }

    private void checkAllVersionsHints(IgniteCache cache) throws IgniteCheckedException {
        IgniteCacheProxy cache0 = (IgniteCacheProxy)cache;
        GridCacheContext cctx = cache0.context();
        assert (cctx.mvccEnabled());
        for (Object e : cache) {
            IgniteBiTuple entry = (IgniteBiTuple)e;
            KeyCacheObject key = cctx.toCacheKeyObject(entry.getKey());
            GridCursor cur = cctx.offheap().mvccAllVersionsCursor(cctx, key, (Object)CacheDataRowAdapter.RowData.LINK_WITH_HEADER);
            while (cur.next()) {
                CacheDataRow row = (CacheDataRow)cur.get();
                CacheMvccSqlTxQueriesAbstractTest.assertTrue((row.mvccTxState() != 0 ? 1 : 0) != 0);
            }
        }
    }

    private <T extends Throwable> void onException(AtomicReference<T> ex, T e) {
        if (!ex.compareAndSet(null, e)) {
            ((Throwable)ex.get()).addSuppressed(e);
        }
    }

    private void awaitPhase(Phaser phaser, int phase) {
        int p;
        while ((p = phaser.arriveAndAwaitAdvance()) < phase && p >= 0) {
        }
    }

    static class MvccTestSqlIndexValue
    implements Serializable {
        @QuerySqlField(index=true)
        private int idxVal1;

        MvccTestSqlIndexValue(int idxVal1) {
            this.idxVal1 = idxVal1;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MvccTestSqlIndexValue value = (MvccTestSqlIndexValue)o;
            return this.idxVal1 == value.idxVal1;
        }

        public int hashCode() {
            return Objects.hash(this.idxVal1);
        }

        public String toString() {
            return S.toString(MvccTestSqlIndexValue.class, (Object)this);
        }
    }

    private static enum TimeoutMode {
        TX,
        STMT;

    }
}

