/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.mvcc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.UnaryOperator;
import junit.framework.Assert;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.TransactionConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.mvcc.CacheMvccAbstractTest;
import org.apache.ignite.transactions.Transaction;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CacheMvccSqlLockTimeoutTest
extends CacheMvccAbstractTest {
    private static final int TIMEOUT_MILLIS = 200;
    private UnaryOperator<IgniteConfiguration> cfgCustomizer = UnaryOperator.identity();

    protected CacheMode cacheMode() {
        throw new RuntimeException("Is not used in current test");
    }

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        return (IgniteConfiguration)this.cfgCustomizer.apply(super.getConfiguration(gridName));
    }

    @Test
    public void testLockTimeoutsForPartitionedCache() throws Exception {
        this.checkLockTimeouts(this.partitionedCacheConfig());
    }

    @Test
    public void testLockTimeoutsForReplicatedCache() throws Exception {
        this.checkLockTimeouts(this.replicatedCacheConfig());
    }

    @Test
    public void testLockTimeoutsAfterDefaultTxTimeoutForPartitionedCache() throws Exception {
        this.checkLockTimeoutsAfterDefaultTxTimeout(this.partitionedCacheConfig());
    }

    @Test
    public void testLockTimeoutsAfterDefaultTxTimeoutForReplicatedCache() throws Exception {
        this.checkLockTimeoutsAfterDefaultTxTimeout(this.replicatedCacheConfig());
    }

    @Test
    public void testConcurrentForPartitionedCache() throws Exception {
        this.checkTimeoutsConcurrent(this.partitionedCacheConfig());
    }

    @Test
    public void testConcurrentForReplicatedCache() throws Exception {
        this.checkTimeoutsConcurrent(this.replicatedCacheConfig());
    }

    private CacheConfiguration<?, ?> partitionedCacheConfig() {
        return this.baseCacheConfig().setCacheMode(CacheMode.PARTITIONED).setBackups(1);
    }

    private CacheConfiguration<?, ?> replicatedCacheConfig() {
        return this.baseCacheConfig().setCacheMode(CacheMode.REPLICATED);
    }

    private CacheConfiguration<?, ?> baseCacheConfig() {
        return new CacheConfiguration("test").setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL_SNAPSHOT).setSqlSchema("PUBLIC").setIndexedTypes(new Class[]{Integer.class, Integer.class});
    }

    private void checkLockTimeouts(CacheConfiguration<?, ?> ccfg) throws Exception {
        this.startGridsMultiThreaded(2);
        IgniteEx ignite = this.grid(0);
        ignite.createCache(ccfg);
        AtomicInteger keyCntr = new AtomicInteger();
        int nearKey = this.keyForNode(ignite.affinity("test"), keyCntr, ignite.localNode());
        int otherKey = this.keyForNode(ignite.affinity("test"), keyCntr, this.grid(1).localNode());
        TimeoutChecker timeoutChecker = new TimeoutChecker(ignite, "test");
        timeoutChecker.checkScenario(TimeoutMode.STMT, TxStartMode.EXPLICIT, nearKey);
        timeoutChecker.checkScenario(TimeoutMode.STMT, TxStartMode.EXPLICIT, otherKey);
        timeoutChecker.checkScenario(TimeoutMode.STMT, TxStartMode.IMPLICIT, nearKey);
        timeoutChecker.checkScenario(TimeoutMode.STMT, TxStartMode.IMPLICIT, otherKey);
        timeoutChecker.checkScenario(TimeoutMode.TX, TxStartMode.EXPLICIT, nearKey);
        timeoutChecker.checkScenario(TimeoutMode.TX, TxStartMode.EXPLICIT, otherKey);
    }

    private void checkLockTimeoutsAfterDefaultTxTimeout(CacheConfiguration<?, ?> ccfg) throws Exception {
        this.cfgCustomizer = cfg -> cfg.setTransactionConfiguration(new TransactionConfiguration().setDefaultTxTimeout(200L));
        this.startGridsMultiThreaded(2);
        IgniteEx ignite = this.grid(0);
        ignite.createCache(ccfg);
        AtomicInteger keyCntr = new AtomicInteger();
        int nearKey = this.keyForNode(ignite.affinity("test"), keyCntr, ignite.localNode());
        int otherKey = this.keyForNode(ignite.affinity("test"), keyCntr, this.grid(1).localNode());
        TimeoutChecker timeoutChecker = new TimeoutChecker(ignite, "test");
        timeoutChecker.checkScenario(TimeoutMode.TX_DEFAULT, TxStartMode.EXPLICIT, nearKey);
        timeoutChecker.checkScenario(TimeoutMode.TX_DEFAULT, TxStartMode.EXPLICIT, otherKey);
        timeoutChecker.checkScenario(TimeoutMode.TX_DEFAULT, TxStartMode.IMPLICIT, nearKey);
        timeoutChecker.checkScenario(TimeoutMode.TX_DEFAULT, TxStartMode.IMPLICIT, otherKey);
    }

    private static boolean msgContains(Throwable e, String str) {
        return e.getMessage() != null && e.getMessage().contains(str);
    }

    private void checkTimeoutsConcurrent(CacheConfiguration<?, ?> ccfg) throws Exception {
        int i;
        this.startGridsMultiThreaded(2);
        IgniteEx ignite = this.grid(0);
        IgniteCache cache = ignite.createCache(ccfg);
        AtomicInteger keyCntr = new AtomicInteger();
        ArrayList<Integer> keys = new ArrayList<Integer>();
        for (i = 0; i < 5; ++i) {
            keys.add(this.keyForNode(this.grid(0).affinity("test"), keyCntr, ignite.localNode()));
        }
        for (i = 0; i < 5; ++i) {
            keys.add(this.keyForNode(this.grid(1).affinity("test"), keyCntr, ignite.localNode()));
        }
        CompletableFuture.allOf(CompletableFuture.runAsync(() -> this.mergeInRandomOrder(ignite, cache, keys)), CompletableFuture.runAsync(() -> this.mergeInRandomOrder(ignite, cache, keys)), CompletableFuture.runAsync(() -> this.mergeInRandomOrder(ignite, cache, keys))).join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeInRandomOrder(IgniteEx ignite, IgniteCache<?, ?> cache, List<Integer> keys) {
        ArrayList<Integer> keys0 = new ArrayList<Integer>(keys);
        for (int i = 0; i < 100; ++i) {
            Collections.shuffle(keys0);
            try (Transaction tx = ignite.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                SqlFieldsQuery qry = new SqlFieldsQuery("merge into Integer(_key, _val) values(?, ?)").setTimeout(200, TimeUnit.MILLISECONDS);
                int op = 0;
                for (Integer key : keys0) {
                    cache.query(qry.setArgs(new Object[]{key, op++}));
                }
                tx.commit();
                continue;
            }
            catch (Exception e) {
                CacheMvccSqlLockTimeoutTest.assertTrue((CacheMvccSqlLockTimeoutTest.msgContains(e, "Failed to acquire lock within provided timeout for transaction") || CacheMvccSqlLockTimeoutTest.msgContains(e, "Cannot serialize transaction due to write conflict") ? 1 : 0) != 0);
                continue;
            }
            finally {
                ignite.context().cache().context().tm().resetContext();
            }
        }
    }

    private static enum TxStartMode {
        EXPLICIT,
        IMPLICIT;

    }

    private static enum TimeoutMode {
        TX,
        TX_DEFAULT,
        STMT;

    }

    private static class TimeoutChecker {
        final IgniteEx ignite;
        final String cacheName;

        TimeoutChecker(IgniteEx ignite, String cacheName) {
            this.ignite = ignite;
            this.cacheName = cacheName;
        }

        void checkScenario(TimeoutMode timeoutMode, TxStartMode txStartMode, int key) throws Exception {
            assert (key <= 999);
            try (Transaction tx = this.ignite.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ, 60000L, 1);){
                this.ignite.cache(this.cacheName).query(new SqlFieldsQuery("merge into Integer(_key, _val) values(?, 1)").setArgs(new Object[]{key}));
                tx.commit();
            }
            this.ensureTimeIsOut("insert into Integer(_key, _val) values(?, 42)", key, timeoutMode, txStartMode);
            this.ensureTimeIsOut("merge into Integer(_key, _val) values(?, 42)", key, timeoutMode, txStartMode);
            this.ensureTimeIsOut("update Integer set _val = 42 where _key = ?", key, timeoutMode, txStartMode);
            this.ensureTimeIsOut("update Integer set _val = 42 where _key = ? or _key > 999", key, timeoutMode, txStartMode);
            this.ensureTimeIsOut("delete from Integer where _key = ?", key, timeoutMode, txStartMode);
            this.ensureTimeIsOut("delete from Integer where _key = ? or _key > 999", key, timeoutMode, txStartMode);
            if (txStartMode != TxStartMode.IMPLICIT) {
                this.ensureTimeIsOut("select * from Integer where _key = ? for update", key, timeoutMode, txStartMode);
                this.ensureTimeIsOut("select * from Integer where _key = ? or _key > 999 for update", key, timeoutMode, txStartMode);
            }
        }

        void ensureTimeIsOut(String sql, int key, TimeoutMode timeoutMode, TxStartMode txStartMode) throws Exception {
            assert (txStartMode == TxStartMode.EXPLICIT || timeoutMode != TimeoutMode.TX);
            IgniteCache cache = this.ignite.cache(this.cacheName);
            int oldVal = (Integer)((List)cache.query(new SqlFieldsQuery("select _val from Integer where _key = ?").setArgs(new Object[]{key})).getAll().get(0)).get(0);
            try (Transaction tx1 = this.ignite.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ, 6000L, 1);){
                cache.query(new SqlFieldsQuery("update Integer set _val = 42 where _key = ?").setArgs(new Object[]{key}));
                try {
                    CompletableFuture.runAsync(() -> {
                        SqlFieldsQuery qry = new SqlFieldsQuery(sql).setArgs(new Object[]{key});
                        try (Transaction tx2 = txStartMode == TxStartMode.EXPLICIT ? this.startTx(timeoutMode) : null;){
                            if (timeoutMode == TimeoutMode.STMT) {
                                qry.setTimeout(200, TimeUnit.MILLISECONDS);
                            }
                            cache.query(qry).getAll();
                            if (tx2 != null) {
                                tx2.commit();
                            }
                        }
                        finally {
                            this.ignite.context().cache().context().tm().resetContext();
                        }
                    }).get();
                    Assert.fail((String)"Timeout exception should be thrown");
                }
                catch (ExecutionException e) {
                    Assert.assertTrue((CacheMvccSqlLockTimeoutTest.msgContains(e, "Failed to acquire lock within provided timeout for transaction") || CacheMvccSqlLockTimeoutTest.msgContains(e, "Failed to finish transaction because it has been rolled back") ? 1 : 0) != 0);
                }
                cache.query(new SqlFieldsQuery("update Integer set _val = 42 where _key = ?").setArgs(new Object[]{key}));
                tx1.rollback();
            }
            int newVal = (Integer)((List)cache.query(new SqlFieldsQuery("select _val from Integer where _key = ?").setArgs(new Object[]{key})).getAll().get(0)).get(0);
            Assert.assertEquals((int)oldVal, (int)newVal);
        }

        private Transaction startTx(TimeoutMode timeoutMode) {
            return timeoutMode == TimeoutMode.TX ? this.ignite.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ, 200L, 1) : this.ignite.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);
        }
    }
}

