/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.mvcc;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.cache.CacheException;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.cache.index.AbstractSchemaSelfTest;
import org.apache.ignite.internal.processors.cache.mvcc.CacheMvccAbstractTest;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.transactions.Transaction;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public abstract class CacheMvccSelectForUpdateQueryAbstractTest
extends CacheMvccAbstractTest {
    private static final int CACHE_SIZE = 50;

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.disableScheduledVacuum = this.getName().equals("testSelectForUpdateAfterAbortedTx");
        IgniteEx grid = this.startGrid(0);
        CacheConfiguration seg = new CacheConfiguration("segmented*");
        seg.setCacheMode(this.cacheMode());
        if (seg.getCacheMode() == CacheMode.PARTITIONED) {
            seg.setQueryParallelism(4);
        }
        grid.addCacheConfiguration(seg);
        try (Connection c = AbstractSchemaSelfTest.connect(grid);){
            AbstractSchemaSelfTest.execute(c, "create table person (id int primary key, firstName varchar, lastName varchar) with \"atomicity=transactional_snapshot,cache_name=Person\"");
            AbstractSchemaSelfTest.execute(c, "create table person_seg (id int primary key, firstName varchar, lastName varchar) with \"atomicity=transactional_snapshot,cache_name=PersonSeg,template=segmented\"");
            try (Transaction tx = this.grid(0).transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                for (int i = 1; i <= 50; ++i) {
                    AbstractSchemaSelfTest.execute(c, "insert into person(id, firstName, lastName) values(" + i + ",'" + i + "','" + i + "')");
                    AbstractSchemaSelfTest.execute(c, "insert into person_seg(id, firstName, lastName) values(" + i + ",'" + i + "','" + i + "')");
                }
                tx.commit();
            }
        }
        this.startGridsMultiThreaded(1, 2);
    }

    @Test
    public void testSelectForUpdateDistributed() throws Exception {
        this.doTestSelectForUpdateDistributed("Person", false);
    }

    @Test
    public void testSelectForUpdateLocal() throws Exception {
        this.doTestSelectForUpdateLocal("Person", false);
    }

    @Test
    public void testSelectForUpdateOutsideTxDistributed() throws Exception {
        this.doTestSelectForUpdateDistributed("Person", true);
    }

    @Test
    public void testSelectForUpdateOutsideTxLocal() throws Exception {
        this.doTestSelectForUpdateLocal("Person", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doTestSelectForUpdateLocal(String cacheName, boolean outsideTx) throws Exception {
        IgniteEx node = this.grid(0);
        IgniteCache cache = node.cache(cacheName);
        Transaction ignored = outsideTx ? null : node.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);
        try {
            SqlFieldsQuery qry = new SqlFieldsQuery("select id, * from " + CacheMvccSelectForUpdateQueryAbstractTest.tableName(cache) + " order by id for update").setLocal(true);
            FieldsQueryCursor query = cache.query(qry);
            List res = query.getAll();
            ArrayList<Integer> keys = new ArrayList<Integer>();
            for (List r : res) {
                keys.add((Integer)r.get(0));
            }
            this.checkLocks(cacheName, keys, !outsideTx);
        }
        finally {
            U.close((AutoCloseable)ignored, (IgniteLogger)this.log);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doTestSelectForUpdateDistributed(String cacheName, boolean outsideTx) throws Exception {
        this.awaitPartitionMapExchange();
        IgniteEx node = this.grid(0);
        IgniteCache cache = node.cache(cacheName);
        Transaction ignored = outsideTx ? null : node.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);
        try {
            SqlFieldsQuery qry = new SqlFieldsQuery("select id, * from " + CacheMvccSelectForUpdateQueryAbstractTest.tableName(cache) + " order by id for update").setPageSize(10);
            FieldsQueryCursor query = cache.query(qry);
            List res = query.getAll();
            ArrayList<Integer> keys = new ArrayList<Integer>();
            for (List r : res) {
                keys.add((Integer)r.get(0));
            }
            this.checkLocks(cacheName, keys, !outsideTx);
        }
        finally {
            U.close((AutoCloseable)ignored, (IgniteLogger)this.log);
        }
    }

    @Test
    public void testSelectForUpdateWithUnion() {
        this.assertQueryThrows("select id from person union select 1 for update", "SELECT UNION FOR UPDATE is not supported.");
    }

    @Test
    public void testSelectForUpdateWithJoin() {
        this.assertQueryThrows("select p1.id from person p1 join person p2 on p1.id = p2.id for update", "SELECT FOR UPDATE with joins is not supported.");
    }

    @Test
    public void testSelectForUpdateWithLimit() {
        this.assertQueryThrows("select id from person limit 0,5 for update", "LIMIT/OFFSET clauses are not supported for SELECT FOR UPDATE.");
    }

    @Test
    public void testSelectForUpdateWithGroupings() {
        this.assertQueryThrows("select count(*) from person for update", "SELECT FOR UPDATE with aggregates and/or GROUP BY is not supported.");
        this.assertQueryThrows("select lastName, count(*) from person group by lastName for update", "SELECT FOR UPDATE with aggregates and/or GROUP BY is not supported.");
    }

    @Test
    public void testSelectForUpdateAfterAbortedTx() throws Exception {
        List res;
        assert (this.disableScheduledVacuum);
        IgniteEx node = this.grid(0);
        IgniteCache cache = node.cache("Person");
        try (Transaction tx = node.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
            res = cache.query(new SqlFieldsQuery("update person set lastName=UPPER(lastName)")).getAll();
            CacheMvccSelectForUpdateQueryAbstractTest.assertEquals((Object)50L, ((List)res.get(0)).get(0));
            tx.rollback();
        }
        tx = node.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);
        var5_4 = null;
        try {
            res = cache.query(new SqlFieldsQuery("select id, * from person order by id for update")).getAll();
            CacheMvccSelectForUpdateQueryAbstractTest.assertEquals((int)50, (int)res.size());
            ArrayList<Integer> keys = new ArrayList<Integer>();
            for (List r : res) {
                keys.add((Integer)r.get(0));
            }
            this.checkLocks("Person", keys, true);
            tx.rollback();
            this.checkLocks("Person", keys, false);
        }
        catch (Throwable throwable) {
            var5_4 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_4 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var5_4.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    private void checkLocks(String cacheName, List<Integer> keys, boolean locked) throws Exception {
        final Ignite node = this.ignite(2);
        final IgniteCache cache = node.cache(cacheName);
        ArrayList<IgniteInternalFuture> calls = new ArrayList<IgniteInternalFuture>();
        for (final int key : keys) {
            calls.add(GridTestUtils.runAsync((Callable)new Callable<Integer>(){

                @Override
                public Integer call() {
                    try (Transaction ignored = node.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                        List res = cache.query(new SqlFieldsQuery("select * from " + CacheMvccSelectForUpdateQueryAbstractTest.tableName(cache) + " where id = " + key + " for update").setTimeout(1, TimeUnit.SECONDS)).getAll();
                        Integer n = (Integer)((List)res.get(0)).get(0);
                        return n;
                    }
                }
            }));
        }
        for (IgniteInternalFuture fut : calls) {
            if (!locked) {
                fut.get(3000L);
                continue;
            }
            try {
                fut.get();
            }
            catch (Exception e) {
                CacheException e0 = (CacheException)X.cause((Throwable)e, CacheException.class);
                assert (e0 != null);
                assert (e0.getMessage() != null && e0.getMessage().contains("Failed to acquire lock within provided timeout"));
            }
        }
    }

    private static String tableName(IgniteCache<?, ?> cache) {
        return ((QueryEntity)((CacheConfiguration)cache.getConfiguration(CacheConfiguration.class)).getQueryEntities().iterator().next()).getTableName();
    }

    private void assertQueryThrows(String qry, String exMsg) {
        this.assertQueryThrows(qry, exMsg, false);
        this.assertQueryThrows(qry, exMsg, true);
    }

    private void assertQueryThrows(String qry, String exMsg, boolean loc) {
        IgniteEx node = this.grid(0);
        GridTestUtils.assertThrows(null, (Callable)new Callable<Object>((Ignite)node, qry, loc){
            final /* synthetic */ Ignite val$node;
            final /* synthetic */ String val$qry;
            final /* synthetic */ boolean val$loc;
            {
                this.val$node = ignite;
                this.val$qry = string;
                this.val$loc = bl;
            }

            @Override
            public Object call() {
                return this.val$node.cache("Person").query(new SqlFieldsQuery(this.val$qry).setLocal(this.val$loc)).getAll();
            }
        }, IgniteSQLException.class, (String)exMsg);
    }
}

