/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.mvcc;

import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.mvcc.CacheMvccSqlTxQueriesAbstractTest;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.transactions.Transaction;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CacheMvccReplicatedSqlTxQueriesTest
extends CacheMvccSqlTxQueriesAbstractTest {
    protected CacheMode cacheMode() {
        return CacheMode.REPLICATED;
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.ccfgs = null;
        this.ccfg = null;
    }

    @Test
    public void testReplicatedJoinPartitionedClient() throws Exception {
        this.checkReplicatedJoinPartitioned(true);
    }

    @Test
    public void testReplicatedJoinPartitionedServer() throws Exception {
        this.checkReplicatedJoinPartitioned(false);
    }

    public void checkReplicatedJoinPartitioned(boolean client) throws Exception {
        List<List<?>> r;
        this.ccfgs = new CacheConfiguration[]{this.cacheConfiguration(CacheMode.REPLICATED, CacheWriteSynchronizationMode.FULL_SYNC, 0, 1024).setName("int").setIndexedTypes(new Class[]{Integer.class, Integer.class}), this.cacheConfiguration(CacheMode.PARTITIONED, CacheWriteSynchronizationMode.FULL_SYNC, 2, 1024).setIndexedTypes(new Class[]{Integer.class, CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue.class}), this.cacheConfiguration(CacheMode.REPLICATED, CacheWriteSynchronizationMode.FULL_SYNC, 0, 1024).setName("target").setIndexedTypes(new Class[]{Integer.class, Integer.class})};
        this.startGridsMultiThreaded(3);
        this.client = true;
        this.startGrid(3);
        IgniteEx node = client ? this.grid(3) : this.grid(0);
        try (Transaction tx = node.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
            tx.timeout(3000L);
            r = this.runSql((Ignite)node, "INSERT INTO \"int\".Integer(_key, _val) VALUES (1,1), (2,2), (3,3)");
            CacheMvccReplicatedSqlTxQueriesTest.assertEquals((Object)3L, r.get(0).get(0));
            tx.commit();
        }
        tx = node.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);
        var5_5 = null;
        try {
            tx.timeout(3000L);
            r = this.runSql((Ignite)node, "INSERT INTO \"default\".MvccTestSqlIndexValue(_key, idxVal1) VALUES (1,10), (2, 20), (3, 30)");
            CacheMvccReplicatedSqlTxQueriesTest.assertEquals((Object)3L, r.get(0).get(0));
            tx.commit();
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_5 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = node.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);
        var5_5 = null;
        try {
            tx.timeout(3000L);
            r = this.runSql((Ignite)node, "INSERT INTO \"target\".Integer(_key, _val) SELECT a._key, a.idxVal1*b._val FROM \"default\".MvccTestSqlIndexValue a JOIN \"int\".Integer b ON a._key = b._key");
            CacheMvccReplicatedSqlTxQueriesTest.assertEquals((Object)3L, r.get(0).get(0));
            tx.commit();
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_5 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        for (int n = 0; n < 3; ++n) {
            node = this.grid(n);
            r = this.runSqlLocal((Ignite)node, "SELECT _key, _val FROM \"target\".Integer ORDER BY _key");
            CacheMvccReplicatedSqlTxQueriesTest.assertEquals((long)3L, (long)r.size());
            CacheMvccReplicatedSqlTxQueriesTest.assertEquals((Object)1, r.get(0).get(0));
            CacheMvccReplicatedSqlTxQueriesTest.assertEquals((Object)2, r.get(1).get(0));
            CacheMvccReplicatedSqlTxQueriesTest.assertEquals((Object)3, r.get(2).get(0));
            CacheMvccReplicatedSqlTxQueriesTest.assertEquals((Object)10, r.get(0).get(1));
            CacheMvccReplicatedSqlTxQueriesTest.assertEquals((Object)40, r.get(1).get(1));
            CacheMvccReplicatedSqlTxQueriesTest.assertEquals((Object)90, r.get(2).get(1));
        }
    }

    @Ignore(value="https://issues.apache.org/jira/browse/IGNITE-10763")
    @Test
    public void testReplicatedAndPartitionedUpdateSingleTransaction() throws Exception {
        List<List<?>> r;
        this.ccfgs = new CacheConfiguration[]{this.cacheConfiguration(CacheMode.REPLICATED, CacheWriteSynchronizationMode.FULL_SYNC, 0, 1024).setName("rep").setIndexedTypes(new Class[]{Integer.class, Integer.class}), this.cacheConfiguration(CacheMode.PARTITIONED, CacheWriteSynchronizationMode.FULL_SYNC, 0, 1024).setIndexedTypes(new Class[]{Integer.class, CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue.class}).setName("part")};
        this.startGridsMultiThreaded(3);
        this.client = true;
        this.startGrid(3);
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        IgniteEx node = this.grid(((Random)rnd).nextInt(4));
        IgniteCache repCache = node.cache("rep");
        repCache.put((Object)1, (Object)1);
        repCache.put((Object)2, (Object)2);
        repCache.put((Object)3, (Object)3);
        IgniteCache partCache = node.cache("part");
        partCache.put((Object)1, (Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(1));
        partCache.put((Object)2, (Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(2));
        partCache.put((Object)3, (Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(3));
        try (Transaction tx = node.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
            tx.timeout(3000L);
            r = this.runSql((Ignite)node, "UPDATE \"rep\".Integer SET _val = _key * 10");
            CacheMvccReplicatedSqlTxQueriesTest.assertEquals((Object)3L, r.get(0).get(0));
            r = this.runSql((Ignite)node, "UPDATE  \"part\".MvccTestSqlIndexValue SET idxVal1 = _key * 10");
            CacheMvccReplicatedSqlTxQueriesTest.assertEquals((Object)3L, r.get(0).get(0));
            tx.commit();
        }
        r = this.runSql((Ignite)node, "SELECT COUNT(1) FROM \"rep\".Integer r JOIN \"part\".MvccTestSqlIndexValue p ON r._key = p._key WHERE r._val = p.idxVal1");
        CacheMvccReplicatedSqlTxQueriesTest.assertEquals((Object)3L, r.get(0).get(0));
        for (int n = 0; n < 3; ++n) {
            node = this.grid(n);
            r = this.runSqlLocal((Ignite)node, "SELECT _key, _val FROM \"rep\".Integer ORDER BY _key");
            CacheMvccReplicatedSqlTxQueriesTest.assertEquals((long)3L, (long)r.size());
            CacheMvccReplicatedSqlTxQueriesTest.assertEquals((Object)1, r.get(0).get(0));
            CacheMvccReplicatedSqlTxQueriesTest.assertEquals((Object)2, r.get(1).get(0));
            CacheMvccReplicatedSqlTxQueriesTest.assertEquals((Object)3, r.get(2).get(0));
            CacheMvccReplicatedSqlTxQueriesTest.assertEquals((Object)10, r.get(0).get(1));
            CacheMvccReplicatedSqlTxQueriesTest.assertEquals((Object)20, r.get(1).get(1));
            CacheMvccReplicatedSqlTxQueriesTest.assertEquals((Object)30, r.get(2).get(1));
        }
    }

    private List<List<?>> runSql(Ignite node, String sqlText) {
        GridQueryProcessor qryProc = ((IgniteEx)node).context().query();
        return qryProc.querySqlFields(new SqlFieldsQuery(sqlText), false).getAll();
    }

    private List<List<?>> runSqlLocal(Ignite node, String sqlText) {
        GridQueryProcessor qryProc = ((IgniteEx)node).context().query();
        return qryProc.querySqlFields(new SqlFieldsQuery(sqlText).setLocal(true), false).getAll();
    }
}

