/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.mvcc;

import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.Ignite;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.TestRecordingCommunicationSpi;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsSingleMessage;
import org.apache.ignite.internal.processors.cache.mvcc.CacheMvccSqlTxQueriesAbstractTest;
import org.apache.ignite.internal.processors.cache.mvcc.CacheMvccSqlTxQueriesWithReducerAbstractTest;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CacheMvccPartitionedSqlTxQueriesWithReducerTest
extends CacheMvccSqlTxQueriesWithReducerAbstractTest {
    protected CacheMode cacheMode() {
        return CacheMode.PARTITIONED;
    }

    @Test
    public void testQueryUpdateOnUnstableTopologyDoesNotCauseDeadlock() throws Exception {
        this.ccfg = this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 2, 1024).setIndexedTypes(new Class[]{Integer.class, CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue.class});
        this.testSpi = true;
        Ignite updateNode = this.startGrids(3);
        CountDownLatch latch = new CountDownLatch(1);
        TestRecordingCommunicationSpi spi = TestRecordingCommunicationSpi.spi((Ignite)this.grid(1));
        spi.blockMessages((IgniteBiPredicate & Serializable)(node, msg) -> {
            if (msg instanceof GridDhtPartitionsSingleMessage) {
                latch.countDown();
                return true;
            }
            return false;
        });
        CompletableFuture.runAsync(() -> this.stopGrid(2));
        CacheMvccPartitionedSqlTxQueriesWithReducerTest.assertTrue((boolean)latch.await(3000L, TimeUnit.MILLISECONDS));
        CompletableFuture<Void> queryFut = CompletableFuture.runAsync(() -> updateNode.cache("default").query(new SqlFieldsQuery("INSERT INTO MvccTestSqlIndexValue (_key, idxVal1) VALUES (1,1),(2,2),(3,3)")).getAll());
        Thread.sleep(300L);
        spi.stopBlock();
        queryFut.get(3000L, TimeUnit.MILLISECONDS);
    }
}

