/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.mvcc;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.cache.CacheException;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.processors.cache.mvcc.CacheMvccAbstractTest;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CacheMvccDmlSimpleTest
extends CacheMvccAbstractTest {
    private IgniteCache<?, ?> cache;

    protected CacheMode cacheMode() {
        return CacheMode.PARTITIONED;
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.cache = this.startGrid(0).getOrCreateCache(new CacheConfiguration("test").setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL_SNAPSHOT).setSqlSchema("PUBLIC").setIndexedTypes(new Class[]{Integer.class, Integer.class}));
    }

    @Test
    public void testInsert() throws Exception {
        int cnt = this.update("insert into Integer(_key, _val) values(1, 1),(2, 2)");
        CacheMvccDmlSimpleTest.assertEquals((int)2, (int)cnt);
        CacheMvccDmlSimpleTest.assertEquals(this.asSet(Arrays.asList(1, 1), Arrays.asList(2, 2)), this.query("select * from Integer"));
        try {
            this.update("insert into Integer(_key, _val) values(3, 3),(1, 1)");
        }
        catch (CacheException e) {
            CacheMvccDmlSimpleTest.assertTrue((boolean)(e.getCause() instanceof IgniteSQLException));
            CacheMvccDmlSimpleTest.assertEquals((int)4001, (int)((IgniteSQLException)e.getCause()).statusCode());
        }
        CacheMvccDmlSimpleTest.assertEquals(this.asSet(Arrays.asList(1, 1), Arrays.asList(2, 2)), this.query("select * from Integer"));
    }

    @Test
    public void testMerge() throws Exception {
        int cnt = this.update("merge into Integer(_key, _val) values(1, 1),(2, 2)");
        CacheMvccDmlSimpleTest.assertEquals((int)2, (int)cnt);
        CacheMvccDmlSimpleTest.assertEquals(this.asSet(Arrays.asList(1, 1), Arrays.asList(2, 2)), this.query("select * from Integer"));
        cnt = this.update("merge into Integer(_key, _val) values(3, 3),(1, 1)");
        CacheMvccDmlSimpleTest.assertEquals((int)2, (int)cnt);
        CacheMvccDmlSimpleTest.assertEquals(this.asSet(Arrays.asList(1, 1), Arrays.asList(2, 2), Arrays.asList(3, 3)), this.query("select * from Integer"));
    }

    @Test
    public void testUpdate() throws Exception {
        int cnt = this.update("update Integer set _val = 42 where _key = 42");
        CacheMvccDmlSimpleTest.assertEquals((int)0, (int)cnt);
        CacheMvccDmlSimpleTest.assertTrue((boolean)this.query("select * from Integer").isEmpty());
        this.update("insert into Integer(_key, _val) values(1, 1),(2, 2)");
        cnt = this.update("update Integer set _val = 42 where _key = 42");
        CacheMvccDmlSimpleTest.assertEquals((int)0, (int)cnt);
        CacheMvccDmlSimpleTest.assertEquals(this.asSet(Arrays.asList(1, 1), Arrays.asList(2, 2)), this.query("select * from Integer"));
        cnt = this.update("update Integer set _val = 42 where _key >= 42");
        CacheMvccDmlSimpleTest.assertEquals((int)0, (int)cnt);
        CacheMvccDmlSimpleTest.assertEquals(this.asSet(Arrays.asList(1, 1), Arrays.asList(2, 2)), this.query("select * from Integer"));
        cnt = this.update("update Integer set _val = 11 where _key = 1");
        CacheMvccDmlSimpleTest.assertEquals((int)1, (int)cnt);
        CacheMvccDmlSimpleTest.assertEquals(this.asSet(Arrays.asList(1, 11), Arrays.asList(2, 2)), this.query("select * from Integer"));
        cnt = this.update("update Integer set _val = 12 where _key <= 2");
        CacheMvccDmlSimpleTest.assertEquals(this.asSet(Arrays.asList(1, 12), Arrays.asList(2, 12)), this.query("select * from Integer"));
        CacheMvccDmlSimpleTest.assertEquals((int)2, (int)cnt);
    }

    @Test
    public void testDelete() throws Exception {
        int cnt = this.update("delete from Integer where _key = 42");
        CacheMvccDmlSimpleTest.assertEquals((int)0, (int)cnt);
        this.update("insert into Integer(_key, _val) values(1, 1),(2, 2)");
        cnt = this.update("delete from Integer where _key = 42");
        CacheMvccDmlSimpleTest.assertEquals((int)0, (int)cnt);
        CacheMvccDmlSimpleTest.assertEquals(this.asSet(Arrays.asList(1, 1), Arrays.asList(2, 2)), this.query("select * from Integer"));
        cnt = this.update("delete from Integer where _key >= 42");
        CacheMvccDmlSimpleTest.assertEquals((int)0, (int)cnt);
        CacheMvccDmlSimpleTest.assertEquals(this.asSet(Arrays.asList(1, 1), Arrays.asList(2, 2)), this.query("select * from Integer"));
        cnt = this.update("delete from Integer where _key = 1");
        CacheMvccDmlSimpleTest.assertEquals((int)1, (int)cnt);
        CacheMvccDmlSimpleTest.assertEquals(this.asSet(Arrays.asList(2, 2)), this.query("select * from Integer"));
        cnt = this.update("delete from Integer where _key <= 2");
        CacheMvccDmlSimpleTest.assertTrue((boolean)this.query("select * from Integer").isEmpty());
        CacheMvccDmlSimpleTest.assertEquals((int)1, (int)cnt);
    }

    private Set<List<?>> query(String q) {
        return new HashSet(this.cache.query(new SqlFieldsQuery(q)).getAll());
    }

    private int update(String q) {
        return Integer.parseInt(((List)this.cache.query(new SqlFieldsQuery(q)).getAll().get(0)).get(0).toString());
    }

    private Set<List<?>> asSet(List<?> ... ls) {
        return new HashSet(Arrays.asList(ls));
    }
}

