/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.mvcc;

import java.io.File;
import java.io.Serializable;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.mvcc.CacheMvccAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CacheMvccBulkLoadTest
extends CacheMvccAbstractTest {
    private IgniteCache<Object, Object> sqlNexus;
    private Statement stmt;

    protected CacheMode cacheMode() {
        return CacheMode.PARTITIONED;
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        IgniteEx ignite = this.startGrid(0);
        this.sqlNexus = ignite.getOrCreateCache(new CacheConfiguration("sqlNexus").setSqlSchema("PUBLIC"));
        this.sqlNexus.query(CacheMvccBulkLoadTest.q("create table person(  id int not null primary key,  name varchar not null) with \"atomicity=transactional_snapshot\""));
        this.stmt = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1").createStatement();
    }

    @Test
    public void testCopyStoresData() throws Exception {
        String csvFilePath = new File(((Object)((Object)this)).getClass().getResource("mvcc_person.csv").toURI()).getAbsolutePath();
        this.stmt.executeUpdate("copy from '" + csvFilePath + "' into person (id, name) format csv");
        List rows = this.sqlNexus.query(CacheMvccBulkLoadTest.q("select * from person")).getAll();
        List<List> exp = Arrays.asList(Arrays.asList(1, "John"), Arrays.asList(2, "Jack"));
        CacheMvccBulkLoadTest.assertEquals(exp, (Object)rows);
    }

    @Test
    public void testCopyDoesNotOverwrite() throws Exception {
        this.sqlNexus.query(CacheMvccBulkLoadTest.q("insert into person values(1, 'Old')"));
        String csvFilePath = new File(((Object)((Object)this)).getClass().getResource("mvcc_person.csv").toURI()).getAbsolutePath();
        this.stmt.executeUpdate("copy from '" + csvFilePath + "' into person (id, name) format csv");
        List rows = this.sqlNexus.query(CacheMvccBulkLoadTest.q("select * from person")).getAll();
        List<List> exp = Arrays.asList(Arrays.asList(1, "Old"), Arrays.asList(2, "Jack"));
        CacheMvccBulkLoadTest.assertEquals(exp, (Object)rows);
    }

    @Test
    public void testCopyLeavesPartialResultsInCaseOfFailure() throws Exception {
        String csvFilePath = new File(((Object)((Object)this)).getClass().getResource("mvcc_person_broken.csv").toURI()).getAbsolutePath();
        try {
            this.stmt.executeUpdate("copy from '" + csvFilePath + "' into person (id, name) format csv");
            CacheMvccBulkLoadTest.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        List rows = this.sqlNexus.query(CacheMvccBulkLoadTest.q("select * from person")).getAll();
        List<List<Serializable>> exp = Collections.singletonList(Arrays.asList(1, "John"));
        CacheMvccBulkLoadTest.assertEquals(exp, (Object)rows);
    }

    private static SqlFieldsQuery q(String sql) {
        return new SqlFieldsQuery(sql);
    }
}

