/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.mvcc;

import java.util.concurrent.Callable;
import javax.cache.CacheException;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheServerNotFoundException;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.TestRecordingCommunicationSpi;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtAffinityAssignmentResponse;
import org.apache.ignite.internal.processors.cache.mvcc.CacheMvccAbstractBasicCoordinatorFailoverTest;
import org.apache.ignite.internal.processors.cache.mvcc.CacheMvccAbstractTest;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public abstract class CacheMvccAbstractSqlCoordinatorFailoverTest
extends CacheMvccAbstractBasicCoordinatorFailoverTest {
    @Ignore(value="https://issues.apache.org/jira/browse/IGNITE-10750")
    @Test
    public void testAccountsTxSql_Server_Backups0_CoordinatorFails() throws Exception {
        this.accountsTxReadAll(2, 1, 0, 64, (IgniteInClosure)new CacheMvccAbstractTest.InitIndexing(new Class[]{Integer.class, CacheMvccAbstractTest.MvccTestAccount.class}), true, CacheMvccAbstractTest.ReadMode.SQL, CacheMvccAbstractTest.WriteMode.DML, 30000L, CacheMvccAbstractTest.RestartMode.RESTART_CRD);
    }

    @Ignore(value="https://issues.apache.org/jira/browse/IGNITE-10753")
    @Test
    public void testAccountsTxSql_SingleNode_CoordinatorFails_Persistence() throws Exception {
        this.persistence = true;
        this.accountsTxReadAll(1, 0, 0, 1, (IgniteInClosure)new CacheMvccAbstractTest.InitIndexing(new Class[]{Integer.class, CacheMvccAbstractTest.MvccTestAccount.class}), true, CacheMvccAbstractTest.ReadMode.SQL, CacheMvccAbstractTest.WriteMode.DML, 30000L, CacheMvccAbstractTest.RestartMode.RESTART_CRD);
    }

    @Test
    public void testPutAllGetAll_ClientServer_Backups0_RestartCoordinator_ScanDml() throws Exception {
        this.putAllGetAll(CacheMvccAbstractTest.RestartMode.RESTART_CRD, 2, 1, 0, 64, (IgniteInClosure)new CacheMvccAbstractTest.InitIndexing(new Class[]{Integer.class, Integer.class}), CacheMvccAbstractTest.ReadMode.SCAN, CacheMvccAbstractTest.WriteMode.DML);
    }

    @Ignore(value="https://issues.apache.org/jira/browse/IGNITE-10767")
    @Test
    public void testPutAllGetAll_SingleNode_RestartCoordinator_ScanDml_Persistence() throws Exception {
        this.persistence = true;
        this.putAllGetAll(CacheMvccAbstractTest.RestartMode.RESTART_CRD, 1, 0, 0, 1, (IgniteInClosure)new CacheMvccAbstractTest.InitIndexing(new Class[]{Integer.class, Integer.class}), CacheMvccAbstractTest.ReadMode.SCAN, CacheMvccAbstractTest.WriteMode.DML);
    }

    @Ignore(value="https://issues.apache.org/jira/browse/IGNITE-10753")
    @Test
    public void testPutAllGetAll_ClientServer_Backups0_RestartCoordinator_SqlDml() throws Exception {
        this.putAllGetAll(CacheMvccAbstractTest.RestartMode.RESTART_CRD, 2, 1, 0, 1024, (IgniteInClosure)new CacheMvccAbstractTest.InitIndexing(new Class[]{Integer.class, Integer.class}), CacheMvccAbstractTest.ReadMode.SQL, CacheMvccAbstractTest.WriteMode.DML);
    }

    @Test
    public void testPutAllGetAll_SingleNode_RestartCoordinator_SqlDml_Persistence() throws Exception {
        this.persistence = true;
        this.putAllGetAll(CacheMvccAbstractTest.RestartMode.RESTART_CRD, 1, 0, 0, 1, (IgniteInClosure)new CacheMvccAbstractTest.InitIndexing(new Class[]{Integer.class, Integer.class}), CacheMvccAbstractTest.ReadMode.SQL, CacheMvccAbstractTest.WriteMode.DML);
    }

    @Ignore(value="https://issues.apache.org/jira/browse/IGNITE-10752")
    @Test
    public void testUpdate_N_Objects_ClientServer_Backups0_Sql_Persistence() throws Exception {
        this.persistence = true;
        this.updateNObjectsTest(5, 2, 0, 0, 64, 30000L, (IgniteInClosure)new CacheMvccAbstractTest.InitIndexing(new Class[]{Integer.class, Integer.class}), CacheMvccAbstractTest.ReadMode.SQL, CacheMvccAbstractTest.WriteMode.DML, CacheMvccAbstractTest.RestartMode.RESTART_CRD);
    }

    @Ignore(value="https://issues.apache.org/jira/browse/IGNITE-10752")
    @Test
    public void testUpdate_N_Objects_SingleNode_Sql_Persistence() throws Exception {
        this.updateNObjectsTest(3, 1, 0, 0, 1, 30000L, (IgniteInClosure)new CacheMvccAbstractTest.InitIndexing(new Class[]{Integer.class, Integer.class}), CacheMvccAbstractTest.ReadMode.SQL, CacheMvccAbstractTest.WriteMode.DML, CacheMvccAbstractTest.RestartMode.RESTART_CRD);
    }

    @Test
    public void testCoordinatorFailureSimplePessimisticTxSql() throws Exception {
        this.coordinatorFailureSimple(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ, CacheMvccAbstractTest.ReadMode.SQL, CacheMvccAbstractTest.WriteMode.DML);
    }

    @Test
    public void testTxInProgressCoordinatorChangeSimple_Readonly() throws Exception {
        this.txInProgressCoordinatorChangeSimple(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ, (IgniteInClosure)new CacheMvccAbstractTest.InitIndexing(new Class[]{Integer.class, Integer.class}), CacheMvccAbstractTest.ReadMode.SQL, CacheMvccAbstractTest.WriteMode.DML);
    }

    @Test
    public void testReadInProgressCoordinatorFailsSimple_FromClient() throws Exception {
        this.readInProgressCoordinatorFailsSimple(true, (IgniteInClosure)new CacheMvccAbstractTest.InitIndexing(new Class[]{Integer.class, Integer.class}), CacheMvccAbstractTest.ReadMode.SQL, CacheMvccAbstractTest.WriteMode.DML);
    }

    @Test
    public void testCoordinatorChangeActiveQueryClientFails_Simple() throws Exception {
        this.checkCoordinatorChangeActiveQueryClientFails_Simple((IgniteInClosure)new CacheMvccAbstractTest.InitIndexing(new Class[]{Integer.class, Integer.class}), CacheMvccAbstractTest.ReadMode.SQL, CacheMvccAbstractTest.WriteMode.DML);
    }

    @Test
    public void testCoordinatorChangeActiveQueryClientFails_SimpleScan() throws Exception {
        this.checkCoordinatorChangeActiveQueryClientFails_Simple((IgniteInClosure)new CacheMvccAbstractTest.InitIndexing(new Class[]{Integer.class, Integer.class}), CacheMvccAbstractTest.ReadMode.SCAN, CacheMvccAbstractTest.WriteMode.DML);
    }

    @Test
    public void testStartLastServerFails() throws Exception {
        this.testSpi = true;
        this.startGrids(3);
        CacheConfiguration cfg = this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 0, 1024).setIndexedTypes(new Class[]{Integer.class, Integer.class});
        cfg.setNodeFilter((IgnitePredicate)new TestNodeFilter(this.getTestIgniteInstanceName(1)));
        Ignite srv1 = this.ignite(1);
        srv1.createCache(cfg);
        this.client = true;
        IgniteEx c = this.startGrid(3);
        this.client = false;
        TestRecordingCommunicationSpi.spi((Ignite)srv1).blockMessages(GridDhtAffinityAssignmentResponse.class, c.name());
        IgniteInternalFuture fut = GridTestUtils.runAsync((Callable)new Callable<Void>((Ignite)c){
            final /* synthetic */ Ignite val$c;
            {
                this.val$c = ignite;
            }

            @Override
            public Void call() throws Exception {
                this.val$c.cache("default");
                return null;
            }
        }, (String)"start-cache");
        U.sleep((long)1000L);
        CacheMvccAbstractSqlCoordinatorFailoverTest.assertFalse((boolean)fut.isDone());
        this.stopGrid(1);
        fut.get();
        final IgniteCache clientCache = c.cache("default");
        int i = 0;
        while (i < 10) {
            final int k = i++;
            GridTestUtils.assertThrows((IgniteLogger)this.log, (Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    clientCache.get((Object)k);
                    return null;
                }
            }, CacheServerNotFoundException.class, null);
            GridTestUtils.assertThrows((IgniteLogger)this.log, (Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    clientCache.put((Object)k, (Object)k);
                    return null;
                }
            }, CacheServerNotFoundException.class, null);
            GridTestUtils.assertThrows((IgniteLogger)this.log, (Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    clientCache.remove((Object)k);
                    return null;
                }
            }, CacheServerNotFoundException.class, null);
            GridTestUtils.assertThrows((IgniteLogger)this.log, (Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    clientCache.query(new SqlFieldsQuery("SELECT * FROM INTEGER")).getAll();
                    return null;
                }
            }, CacheException.class, (String)"Failed to find data nodes for cache");
            GridTestUtils.assertThrows((IgniteLogger)this.log, (Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    clientCache.query(new SqlFieldsQuery("SELECT * FROM INTEGER ORDER BY _val")).getAll();
                    return null;
                }
            }, CacheException.class, (String)"Failed to find data nodes for cache");
            GridTestUtils.assertThrows((IgniteLogger)this.log, (Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    clientCache.query(new SqlFieldsQuery("DELETE FROM Integer WHERE 1 = 1")).getAll();
                    return null;
                }
            }, CacheException.class, (String)"Failed to find data nodes for cache");
            GridTestUtils.assertThrows((IgniteLogger)this.log, (Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    clientCache.query(new SqlFieldsQuery("INSERT INTO Integer (_key, _val) VALUES (1, 2)")).getAll();
                    return null;
                }
            }, CacheException.class, (String)"Failed to get primary node");
            GridTestUtils.assertThrows((IgniteLogger)this.log, (Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    clientCache.query(new SqlFieldsQuery("UPDATE Integer SET _val=42 WHERE _key IN (SELECT DISTINCT _val FROM INTEGER)")).getAll();
                    return null;
                }
            }, CacheException.class, (String)"Failed to find data nodes for cache");
        }
        this.startGrid(1);
        this.awaitPartitionMapExchange();
        for (i = 0; i < 100; ++i) {
            CacheMvccAbstractSqlCoordinatorFailoverTest.assertNull((Object)clientCache.get((Object)i));
            clientCache.put((Object)i, (Object)i);
            CacheMvccAbstractSqlCoordinatorFailoverTest.assertEquals((Object)i, (Object)clientCache.get((Object)i));
        }
    }

    private static class TestNodeFilter
    implements IgnitePredicate<ClusterNode> {
        private final String includeName;

        public TestNodeFilter(String includeName) {
            this.includeName = includeName;
        }

        public boolean apply(ClusterNode node) {
            return this.includeName.equals(node.attribute("org.apache.ignite.ignite.name"));
        }
    }
}

