/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.local;

import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.cache.Cache;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.IgniteCacheAbstractQuerySelfTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class IgniteCacheLocalQuerySelfTest
extends IgniteCacheAbstractQuerySelfTest {
    @Override
    protected int gridCount() {
        return 1;
    }

    @Override
    protected CacheMode cacheMode() {
        return CacheMode.LOCAL;
    }

    @Test
    public void testQueryLocal() throws Exception {
        for (int i = 0; i < 2; ++i) {
            IgniteCache<Integer, String> cache = this.jcache(Integer.class, String.class);
            cache.put((Object)1, (Object)"value1");
            cache.put((Object)2, (Object)"value2");
            cache.put((Object)3, (Object)"value3");
            cache.put((Object)4, (Object)"value4");
            cache.put((Object)5, (Object)"value5");
            QueryCursor qry = cache.query((Query)new SqlQuery(String.class, "_val='value1'").setLocal(true));
            Iterator iter = qry.iterator();
            Cache.Entry entry = (Cache.Entry)iter.next();
            assert (!iter.hasNext());
            assert (entry != null);
            assert ((Integer)entry.getKey() == 1);
            assert ("value1".equals(entry.getValue()));
            qry = cache.query((Query)new SqlQuery(String.class, "_val like 'value%'").setLocal(true));
            iter = qry.iterator();
            assert (iter.next() != null);
            assert (iter.next() != null);
            assert (iter.next() != null);
            assert (iter.next() != null);
            assert (iter.next() != null);
            assert (!iter.hasNext());
            List res = cache.query(new SqlFieldsQuery("explain select _key from String where _val > 'value1'").setLocal(true)).getAll();
            IgniteCacheLocalQuerySelfTest.assertTrue((String)("__ explain: \n" + res), (boolean)((String)((List)res.get(0)).get(0)).toLowerCase().contains("_val_idx"));
            cache.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Test
    public void testLocalSqlQueryFromClient() throws Exception {
        try {
            IgniteEx g = this.startGrid("client");
            IgniteCache<Integer, Integer> c = this.jcache((Ignite)g, Integer.class, Integer.class);
            for (int i = 0; i < 10; ++i) {
                c.put((Object)i, (Object)i);
            }
            SqlQuery qry = new SqlQuery(Integer.class, "_key >= 5 order by _key");
            qry.setLocal(true);
            try (QueryCursor qryCursor = c.query((Query)qry);){
                IgniteCacheLocalQuerySelfTest.assertNotNull((Object)qryCursor);
                List res = qryCursor.getAll();
                IgniteCacheLocalQuerySelfTest.assertNotNull((Object)res);
                IgniteCacheLocalQuerySelfTest.assertEquals((int)5, (int)res.size());
            }
        }
        finally {
            this.stopGrid("client");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Test
    public void testLocalSqlFieldsQueryFromClient() throws Exception {
        try {
            IgniteEx g = this.startGrid("client");
            IgniteCache<UUID, IgniteCacheAbstractQuerySelfTest.Person> c = this.jcache((Ignite)g, UUID.class, IgniteCacheAbstractQuerySelfTest.Person.class);
            IgniteCacheAbstractQuerySelfTest.Person p = new IgniteCacheAbstractQuerySelfTest.Person("Jon", 1500);
            c.put((Object)p.id(), (Object)p);
            SqlFieldsQuery qry = new SqlFieldsQuery("select * from Person");
            qry.setLocal(true);
            try (FieldsQueryCursor qryCursor = c.query(qry);){
                IgniteCacheLocalQuerySelfTest.assertNotNull((Object)qryCursor);
                List res = qryCursor.getAll();
                IgniteCacheLocalQuerySelfTest.assertNotNull((Object)res);
                IgniteCacheLocalQuerySelfTest.assertEquals((int)1, (int)res.size());
            }
        }
        finally {
            this.stopGrid("client");
        }
    }
}

