/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.local;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.QueryCancelledException;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class IgniteCacheLocalQueryCancelOrTimeoutSelfTest
extends GridCommonAbstractTest {
    private static final int CACHE_SIZE = 10000;
    private static final String QUERY = "select a._val, b._val from String a, String b";

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        CacheConfiguration ccfg = new CacheConfiguration("default");
        ccfg.setIndexedTypes(new Class[]{Integer.class, String.class});
        ccfg.setCacheMode(CacheMode.LOCAL);
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfg});
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGrid(0);
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        for (Ignite g : G.allGrids()) {
            g.cache("default").removeAll();
        }
    }

    private void loadCache(IgniteCache<Integer, String> cache) {
        int p = 1;
        for (int i = 1; i <= 10000; ++i) {
            char[] tmp = new char[256];
            Arrays.fill(tmp, ' ');
            cache.put((Object)i, (Object)new String(tmp));
            if (!((float)i / 10000.0f >= (float)p / 10.0f)) continue;
            this.log().info("Loaded " + i + " of " + 10000);
            ++p;
        }
    }

    @Test
    public void testQueryCancel() {
        this.testQuery(false, 1, TimeUnit.SECONDS);
    }

    @Test
    public void testQueryCancelZeroTimeout() {
        this.testQuery(false, 1, TimeUnit.MILLISECONDS);
    }

    @Test
    public void testQueryTimeout() {
        this.testQuery(true, 1, TimeUnit.SECONDS);
    }

    private void testQuery(boolean timeout, int timeoutUnits, TimeUnit timeUnit) {
        FieldsQueryCursor cursor;
        IgniteEx ignite = this.grid(0);
        IgniteCache cache = ignite.cache("default");
        this.loadCache((IgniteCache<Integer, String>)cache);
        SqlFieldsQuery qry = new SqlFieldsQuery(QUERY);
        if (timeout) {
            qry.setTimeout(timeoutUnits, timeUnit);
            cursor = cache.query(qry);
        } else {
            cursor = cache.query(qry);
            ignite.scheduler().runLocal(new Runnable((QueryCursor)cursor){
                final /* synthetic */ QueryCursor val$cursor;
                {
                    this.val$cursor = queryCursor;
                }

                @Override
                public void run() {
                    this.val$cursor.close();
                }
            }, (long)timeoutUnits, timeUnit);
        }
        try (FieldsQueryCursor ignored = cursor;){
            cursor.iterator();
            IgniteCacheLocalQueryCancelOrTimeoutSelfTest.fail((String)"Expecting timeout");
        }
        catch (Exception e) {
            IgniteCacheLocalQueryCancelOrTimeoutSelfTest.assertTrue((String)"Must throw correct exception", (boolean)(e.getCause() instanceof QueryCancelledException));
        }
    }
}

