/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.index;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import java.util.List;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.Ignition;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.apache.ignite.transactions.Transaction;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class MvccEmptyTransactionSelfTest
extends GridCommonAbstractTest {
    protected void afterTest() throws Exception {
        this.stopAllGrids();
    }

    @Test
    public void testEmptyTransaction() throws Exception {
        Ignition.start((IgniteConfiguration)MvccEmptyTransactionSelfTest.config("srv", false));
        Ignite cli = Ignition.start((IgniteConfiguration)MvccEmptyTransactionSelfTest.config("cli", true));
        try (Connection conn = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1:10801");
             Statement stmt = conn.createStatement();){
            stmt.execute("CREATE TABLE person (id BIGINT PRIMARY KEY, name VARCHAR) WITH \"atomicity=TRANSACTIONAL_SNAPSHOT, cache_name=PERSON_CACHE\"");
        }
        IgniteCache cache = cli.cache("PERSON_CACHE");
        try (Transaction tx = cli.transactions().txStart();){
            cache.query(new SqlFieldsQuery("UPDATE person SET name=?").setArgs(new Object[]{"Petr"})).getAll();
            cache.query(new SqlFieldsQuery("UPDATE person SET name=?").setArgs(new Object[]{"Petr"})).getAll();
            cache.query(new SqlFieldsQuery("INSERT INTO person VALUES (?, ?)").setArgs(new Object[]{1, "Ivan"})).getAll();
            cache.query(new SqlFieldsQuery("UPDATE person SET name=?").setArgs(new Object[]{"Sergey"})).getAll();
            cache.query(new SqlFieldsQuery("UPDATE person SET name=? WHERE name=?").setArgs(new Object[]{"Vasiliy", "Ivan"})).getAll();
            cache.query(new SqlFieldsQuery("UPDATE person SET name=?").setArgs(new Object[]{"Vsevolod"})).getAll();
            tx.commit();
        }
        List res = cache.query(new SqlFieldsQuery("SELECT name FROM person")).getAll();
        assert (res.size() == 1);
        assert (((List)res.get(0)).size() == 1);
        MvccEmptyTransactionSelfTest.assertEquals((String)"Vsevolod", (String)((String)((List)res.get(0)).get(0)));
    }

    private static IgniteConfiguration config(String name, boolean client) {
        IgniteConfiguration cfg = new IgniteConfiguration();
        cfg.setIgniteInstanceName(name);
        cfg.setClientMode(client);
        return cfg;
    }
}

