/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.index;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.index.AbstractSchemaSelfTest;
import org.jetbrains.annotations.NotNull;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class IgniteDecimalSelfTest
extends AbstractSchemaSelfTest {
    private static final int PRECISION = 9;
    private static final int SCALE = 8;
    private static final String DEC_TAB_NAME = "DECIMAL_TABLE";
    private static final String VALUE = "VALUE";
    private static final String SALARY_TAB_NAME = "SALARY";
    private static final MathContext MATH_CTX = new MathContext(9);
    private static final BigDecimal VAL_1 = BigDecimal.valueOf(123456789L);
    private static final BigDecimal VAL_2 = BigDecimal.valueOf(1.23456789);
    private static final BigDecimal VAL_3 = BigDecimal.valueOf(0.12345678);

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        IgniteEx grid = this.startGrid(0);
        this.execute((Ignite)grid, "CREATE TABLE DECIMAL_TABLE(id LONG PRIMARY KEY, VALUE DECIMAL(9, 8))");
        String insertQry = "INSERT INTO DECIMAL_TABLE VALUES (?, ?)";
        this.execute((Ignite)grid, insertQry, 1, VAL_1);
        this.execute((Ignite)grid, insertQry, 2, VAL_2);
        this.execute((Ignite)grid, insertQry, 3, VAL_3);
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        CacheConfiguration<Integer, Salary> ccfg = this.cacheCfg(SALARY_TAB_NAME, "salary_cache");
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfg});
        return cfg;
    }

    @NotNull
    private CacheConfiguration<Integer, Salary> cacheCfg(String tabName, String cacheName) {
        CacheConfiguration ccfg = new CacheConfiguration(cacheName);
        QueryEntity queryEntity = new QueryEntity(Integer.class.getName(), Salary.class.getName());
        queryEntity.setTableName(tabName);
        queryEntity.addQueryField("id", Integer.class.getName(), null);
        queryEntity.addQueryField("amount", BigDecimal.class.getName(), null);
        HashMap<String, Integer> precision = new HashMap<String, Integer>();
        HashMap<String, Integer> scale = new HashMap<String, Integer>();
        precision.put("amount", 9);
        scale.put("amount", 8);
        queryEntity.setFieldsPrecision(precision);
        queryEntity.setFieldsScale(scale);
        ccfg.setQueryEntities(Collections.singletonList(queryEntity));
        return ccfg;
    }

    @Test
    public void testConfiguredFromDdl() throws Exception {
        this.checkPrecisionAndScale(DEC_TAB_NAME, VALUE, 9, 8);
    }

    @Test
    public void testConfiguredFromQueryEntity() throws Exception {
        this.checkPrecisionAndScale(SALARY_TAB_NAME, "amount", 9, 8);
    }

    @Test
    public void testConfiguredFromQueryEntityInDynamicallyCreatedCache() throws Exception {
        IgniteEx grid = this.grid(0);
        String tabName = "SALARY2";
        CacheConfiguration<Integer, Salary> ccfg = this.cacheCfg(tabName, "SalaryCache-2");
        IgniteCache cache = grid.createCache(ccfg);
        this.checkPrecisionAndScale(tabName, "amount", 9, 8);
    }

    @Test
    public void testConfiguredFromAnnotations() throws Exception {
        IgniteEx grid = this.grid(0);
        CacheConfiguration ccfg = new CacheConfiguration("SalaryCache-3");
        ccfg.setIndexedTypes(new Class[]{Integer.class, SalaryWithAnnotations.class});
        grid.createCache(ccfg);
        this.checkPrecisionAndScale(SalaryWithAnnotations.class.getSimpleName().toUpperCase(), "amount", 9, 8);
    }

    @Test
    public void testSelectDecimal() throws Exception {
        IgniteEx grid = this.grid(0);
        List<List<?>> rows = this.execute((Ignite)grid, "SELECT id, value FROM DECIMAL_TABLE order by id");
        IgniteDecimalSelfTest.assertEquals((int)rows.size(), (int)3);
        IgniteDecimalSelfTest.assertEquals(Arrays.asList(1L, VAL_1), rows.get(0));
        IgniteDecimalSelfTest.assertEquals(Arrays.asList(2L, VAL_2), rows.get(1));
        IgniteDecimalSelfTest.assertEquals(Arrays.asList(3L, VAL_3), rows.get(2));
    }

    private void checkPrecisionAndScale(String tabName, String colName, Integer precision, Integer scale) {
        QueryEntity queryEntity = this.findTableInfo(tabName);
        IgniteDecimalSelfTest.assertNotNull((Object)queryEntity);
        Map fieldsPrecision = queryEntity.getFieldsPrecision();
        IgniteDecimalSelfTest.assertNotNull((Object)precision);
        IgniteDecimalSelfTest.assertEquals(fieldsPrecision.get(colName), (Object)precision);
        Map fieldsScale = queryEntity.getFieldsScale();
        IgniteDecimalSelfTest.assertEquals(fieldsScale.get(colName), (Object)scale);
        IgniteDecimalSelfTest.assertNotNull((Object)scale);
    }

    private QueryEntity findTableInfo(String tabName) {
        IgniteEx ignite = this.grid(0);
        Collection cacheNames = ignite.cacheNames();
        for (String cacheName : cacheNames) {
            CacheConfiguration ccfg = (CacheConfiguration)ignite.cache(cacheName).getConfiguration(CacheConfiguration.class);
            Collection entities = ccfg.getQueryEntities();
            for (QueryEntity entity : entities) {
                if (!entity.getTableName().equalsIgnoreCase(tabName)) continue;
                return entity;
            }
        }
        return null;
    }

    private List<List<?>> execute(Ignite node, String sql, Object ... args) {
        SqlFieldsQuery qry = new SqlFieldsQuery(sql).setArgs(args).setSchema("PUBLIC");
        return IgniteDecimalSelfTest.queryProcessor(node).querySqlFields(qry, true).getAll();
    }

    private static class SalaryWithAnnotations {
        @QuerySqlField(index=true, precision=9, scale=8)
        private BigDecimal amount;

        private SalaryWithAnnotations() {
        }

        public BigDecimal getAmount() {
            return this.amount;
        }

        public void setAmount(BigDecimal amount) {
            this.amount = amount;
        }
    }

    private static class Salary {
        private BigDecimal amount;

        private Salary() {
        }

        public BigDecimal getAmount() {
            return this.amount;
        }

        public void setAmount(BigDecimal amount) {
            this.amount = amount;
        }
    }
}

