/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.index;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.cache.Cache;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.query.h2.H2RowCache;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2KeyValueRowOnheap;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.jsr166.ConcurrentLinkedHashMap;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class H2RowCacheSelfTest
extends GridCommonAbstractTest {
    private static final int ENTRIES = 1000;
    private static final Random RND = new Random(System.currentTimeMillis());

    protected void beforeTest() throws Exception {
        this.startGrid();
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        super.afterTest();
    }

    private CacheConfiguration cacheConfiguration(String name, boolean enableOnheapCache) {
        return new CacheConfiguration().setName(name).setSqlOnheapCacheEnabled(enableOnheapCache).setGroupName("group").setQueryEntities(Collections.singleton(new QueryEntity(Integer.class, Value.class)));
    }

    @Test
    public void testDestroyCacheCreation() {
        String cacheName0 = "cache0";
        String cacheName1 = "cache1";
        this.grid().getOrCreateCache(this.cacheConfiguration("cache0", false));
        int grpId = this.grid().cachex("cache0").context().groupId();
        H2RowCacheSelfTest.assertNull((Object)this.rowCache(this.grid(), grpId));
        this.grid().getOrCreateCache(this.cacheConfiguration("cache1", true));
        H2RowCacheSelfTest.assertEquals((int)grpId, (int)this.grid().cachex("cache1").context().groupId());
        H2RowCacheSelfTest.assertNotNull((Object)this.rowCache(this.grid(), grpId));
    }

    @Test
    public void testDestroyCacheSingleCacheInGroup() throws IgniteCheckedException {
        this.checkDestroyCache();
    }

    @Test
    public void testDestroyCacheWithOtherCacheInGroup() throws IgniteCheckedException {
        this.grid().getOrCreateCache(this.cacheConfiguration("cacheWithoutOnheapCache", false));
        this.checkDestroyCache();
    }

    @Test
    public void testDeleteEntryCacheSingleCacheInGroup() throws Exception {
        this.checkDeleteEntry();
    }

    @Test
    public void testDeleteEntryWithOtherCacheInGroup() throws Exception {
        this.grid().getOrCreateCache(this.cacheConfiguration("cacheWithoutOnheapCache", false));
        this.checkDeleteEntry();
    }

    @Test
    public void testUpdateEntryCacheSingleCacheInGroup() throws Exception {
        this.checkDeleteEntry();
    }

    @Test
    public void testUpdateEntryWithOtherCacheInGroup() throws Exception {
        this.grid().getOrCreateCache(this.cacheConfiguration("cacheWithoutOnheapCache", false));
        this.checkUpdateEntry();
    }

    @Test
    public void testFixedSize() throws Exception {
        int i;
        int maxSize = 100;
        String cacheName = "cacheWithLimitedSize";
        CacheConfiguration ccfg = this.cacheConfiguration(cacheName, true).setSqlOnheapCacheMaxSize(maxSize);
        IgniteCache cache = this.grid().getOrCreateCache(ccfg);
        int grpId = this.grid().cachex(cacheName).context().groupId();
        for (int i2 = 0; i2 < maxSize / 2; ++i2) {
            cache.put((Object)i2, (Object)new Value(1));
        }
        H2RowCache rowCache = this.rowCache(this.grid(), grpId);
        H2RowCacheSelfTest.assertEquals((int)0, (int)rowCache.size());
        cache.query(new SqlFieldsQuery("SELECT * FROM Value")).getAll();
        H2RowCacheSelfTest.assertEquals((int)(maxSize / 2), (int)rowCache.size());
        cache.query(new SqlFieldsQuery("SELECT * FROM Value")).getAll();
        H2RowCacheSelfTest.assertEquals((int)(maxSize / 2), (int)rowCache.size());
        for (i = maxSize / 2; i < maxSize; ++i) {
            cache.put((Object)i, (Object)new Value(1));
        }
        H2RowCacheSelfTest.assertEquals((int)(maxSize / 2), (int)rowCache.size());
        cache.query(new SqlFieldsQuery("SELECT * FROM Value")).getAll();
        H2RowCacheSelfTest.assertEquals((int)maxSize, (int)rowCache.size());
        for (i = maxSize; i < maxSize * 2; ++i) {
            cache.put((Object)i, (Object)new Value(1));
        }
        H2RowCacheSelfTest.assertEquals((int)maxSize, (int)rowCache.size());
        cache.query(new SqlFieldsQuery("SELECT * FROM Value")).getAll();
        H2RowCacheSelfTest.assertEquals((int)maxSize, (int)rowCache.size());
        cache.query(new SqlFieldsQuery("DELETE FROM Value")).getAll();
        H2RowCacheSelfTest.assertEquals((int)0, (int)rowCache.size());
        cache.query(new SqlFieldsQuery("SELECT * FROM Value")).getAll();
        H2RowCacheSelfTest.assertEquals((int)0, (int)rowCache.size());
    }

    private void checkDestroyCache() throws IgniteCheckedException {
        int i;
        int i2;
        String cacheName0 = "cache0";
        String cacheName1 = "cache1";
        this.grid().getOrCreateCache(this.cacheConfiguration("cache0", true));
        this.grid().getOrCreateCache(this.cacheConfiguration("cache1", true));
        int grpId = this.grid().cachex("cache0").context().groupId();
        H2RowCacheSelfTest.assertEquals((int)grpId, (int)this.grid().cachex("cache1").context().groupId());
        try (IgniteDataStreamer streamer = this.grid().dataStreamer("cache0");){
            for (i2 = 0; i2 < 500; ++i2) {
                streamer.addData((Object)i2, (Object)new Value(i2));
            }
        }
        streamer = this.grid().dataStreamer("cache1");
        var5_5 = null;
        try {
            for (i2 = 500; i2 < 1000; ++i2) {
                streamer.addData((Object)i2, (Object)new Value(i2));
            }
        }
        catch (Throwable i3) {
            var5_5 = i3;
            throw i3;
        }
        finally {
            if (streamer != null) {
                if (var5_5 != null) {
                    try {
                        streamer.close();
                    }
                    catch (Throwable i3) {
                        var5_5.addSuppressed(i3);
                    }
                } else {
                    streamer.close();
                }
            }
        }
        H2RowCache rowCache = this.rowCache(this.grid(), grpId);
        H2RowCacheSelfTest.assertNotNull((Object)rowCache);
        HashSet<Long> linksOfCache0 = new HashSet<Long>(500);
        HashSet<Long> linksOfCache1 = new HashSet<Long>(500);
        for (i = 0; i < 500; ++i) {
            linksOfCache0.add(this.getLinkForKey("cache0", this.rowCache(this.grid(), grpId), i));
        }
        for (i = 500; i < 1000; ++i) {
            linksOfCache1.add(this.getLinkForKey("cache1", this.rowCache(this.grid(), grpId), i));
        }
        this.grid().destroyCache("cache0");
        H2RowCacheSelfTest.assertNotNull((Object)this.rowCache(this.grid(), grpId));
        Iterator iterator = linksOfCache0.iterator();
        while (iterator.hasNext()) {
            long link = (Long)iterator.next();
            H2RowCacheSelfTest.assertNull((Object)this.rowCache(this.grid(), grpId).get(link));
        }
        this.grid().destroyCache("cache1");
        H2RowCacheSelfTest.assertNull((Object)this.rowCache(this.grid(), grpId));
    }

    private void checkDeleteEntry() throws Exception {
        String cacheName = "cache";
        this.grid().getOrCreateCache(this.cacheConfiguration("cache", true));
        int grpId = this.grid().cachex("cache").context().groupId();
        H2RowCacheSelfTest.assertEquals((int)grpId, (int)this.grid().cachex("cache").context().groupId());
        this.fillCache("cache");
        H2RowCache rowCache = this.rowCache(this.grid(), grpId);
        this.fillRowCache("cache");
        H2RowCacheSelfTest.assertNotNull((Object)rowCache);
        int key = RND.nextInt(1000);
        this.grid().cache("cache").query((Query)new SqlQuery(Value.class, "_key = " + key)).getAll();
        int rowCacheSize = rowCache.size();
        long rowLink = this.getLinkForKey("cache", rowCache, key);
        H2RowCacheSelfTest.assertNotNull((Object)rowCache.get(rowLink));
        this.grid().cache("cache").remove((Object)key);
        H2RowCacheSelfTest.assertNull((Object)rowCache.get(rowLink));
        int rowCacheSizeAfterUpdate = rowCache.size();
        H2RowCacheSelfTest.assertEquals((int)(rowCacheSize - 1), (int)rowCacheSizeAfterUpdate);
    }

    private void checkUpdateEntry() throws Exception {
        String cacheName = "cache";
        this.grid().getOrCreateCache(this.cacheConfiguration("cache", true));
        int grpId = this.grid().cachex("cache").context().groupId();
        H2RowCacheSelfTest.assertEquals((int)grpId, (int)this.grid().cachex("cache").context().groupId());
        this.fillCache("cache");
        H2RowCache rowCache = this.rowCache(this.grid(), grpId);
        this.fillRowCache("cache");
        H2RowCacheSelfTest.assertNotNull((Object)rowCache);
        int key = RND.nextInt(1000);
        long rowLink = this.getLinkForKey("cache", rowCache, key);
        int rowCacheSize = rowCache.size();
        H2RowCacheSelfTest.assertNotNull((Object)rowCache.get(rowLink));
        this.grid().cache("cache").put((Object)key, (Object)new Value(key + 1));
        H2RowCacheSelfTest.assertNull((Object)rowCache.get(rowLink));
        int rowCacheSizeAfterUpdate = rowCache.size();
        H2RowCacheSelfTest.assertEquals((int)(rowCacheSize - 1), (int)rowCacheSizeAfterUpdate);
        List res = this.grid().cache("cache").query((Query)new SqlQuery(Value.class, "_key = " + key)).getAll();
        H2RowCacheSelfTest.assertEquals((int)1, (int)res.size());
        H2RowCacheSelfTest.assertEquals((int)(key + 1), (int)((int)((Value)((Cache.Entry)res.get(0)).getValue()).lVal));
    }

    private long getLinkForKey(String cacheName, H2RowCache rowCache, int key) {
        this.grid().cache(cacheName).query((Query)new SqlQuery(Value.class, "_key = " + key)).getAll().size();
        ConcurrentLinkedHashMap rowsMap = (ConcurrentLinkedHashMap)GridTestUtils.getFieldValue((Object)rowCache, (String[])new String[]{"rows"});
        for (Map.Entry e : rowsMap.entrySet()) {
            GridH2KeyValueRowOnheap val = (GridH2KeyValueRowOnheap)e.getValue();
            if ((Integer)val.key().value(null, false) != key) continue;
            return (Long)e.getKey();
        }
        H2RowCacheSelfTest.fail((String)("Row cache doesn't contain key [key=" + key + ']'));
        return -1L;
    }

    private H2RowCache rowCache(IgniteEx ig, int grpId) {
        return (H2RowCache)ig.context().query().getIndexing().rowCacheCleaner(grpId);
    }

    private void fillCache(String name) {
        try (IgniteDataStreamer streamer = this.grid().dataStreamer(name);){
            for (int i = 0; i < 1000; ++i) {
                streamer.addData((Object)i, (Object)new Value(i));
            }
        }
    }

    private void fillRowCache(String name) {
        for (int i = 0; i < 1000; ++i) {
            this.grid().cache(name).query((Query)new SqlQuery(Value.class, "_key = " + i)).getAll().size();
        }
    }

    private static class Value {
        @QuerySqlField
        private long lVal;
        @QuerySqlField
        private String strVal;

        Value(int k) {
            this.lVal = k;
            this.strVal = "val_" + k;
        }
    }
}

