/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.index;

import java.util.Collections;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataPageEvictionMode;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.query.h2.H2RowCache;
import org.apache.ignite.internal.processors.query.h2.H2RowCacheRegistry;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class H2RowCachePageEvictionTest
extends GridCommonAbstractTest {
    private static final int ENTRIES = 10000;
    private static final int SIZE = 0xC00000;
    private static final int TEST_TIME = 180000;
    private static final String DATA_REGION_NAME = "default";
    private static final String CACHE_NAME = "cache";
    private static final ThreadLocalRandom RND = ThreadLocalRandom.current();
    private static boolean persistenceEnabled;

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        super.afterTest();
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"db", (boolean)true);
        U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"wal", (boolean)true);
    }

    protected long getTestTimeout() {
        return 780000L;
    }

    private CacheConfiguration cacheConfiguration(String name, boolean sqlOnheapCacheEnabled) {
        return new CacheConfiguration().setName(name).setSqlOnheapCacheEnabled(sqlOnheapCacheEnabled).setDataRegionName(DATA_REGION_NAME).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 2)).setQueryEntities(Collections.singleton(new QueryEntity(Integer.class, Value.class)));
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName).setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(persistenceEnabled).setMaxSize(0xC00000L).setInitialSize(0xC00000L).setPageEvictionMode(persistenceEnabled ? DataPageEvictionMode.DISABLED : DataPageEvictionMode.RANDOM_LRU).setName(DATA_REGION_NAME)));
        return cfg;
    }

    private void checkRowCacheOnPageEviction() {
        this.grid().getOrCreateCache(this.cacheConfiguration(CACHE_NAME, true));
        int grpId = this.grid().cachex(CACHE_NAME).context().groupId();
        H2RowCachePageEvictionTest.assertEquals((int)grpId, (int)this.grid().cachex(CACHE_NAME).context().groupId());
        try (IgniteDataStreamer stream = this.grid().dataStreamer(CACHE_NAME);){
            for (int i = 0; i < 10000; ++i) {
                stream.addData((Object)i, (Object)new Value(i));
            }
        }
        H2RowCache rowCache = this.rowCache(this.grid()).forGroup(grpId);
        this.fillRowCache(CACHE_NAME);
        H2RowCachePageEvictionTest.assertNotNull((Object)rowCache);
        int rowCacheSizeBeforeEvict = rowCache.size();
        try (IgniteDataStreamer stream = this.grid().dataStreamer(CACHE_NAME);){
            for (int i = 10000; i < 20000; ++i) {
                stream.addData((Object)i, (Object)new Value(i));
            }
        }
        H2RowCachePageEvictionTest.assertTrue((String)("rowCache size before evictions: " + rowCacheSizeBeforeEvict + ", after evictions: " + rowCache.size()), (rowCacheSizeBeforeEvict > rowCache.size() ? 1 : 0) != 0);
    }

    @Test
    public void testEvictPagesWithDiskStorageSingleCacheInGroup() throws Exception {
        persistenceEnabled = true;
        this.startGrid();
        this.grid().active(true);
        this.checkRowCacheOnPageEviction();
    }

    @Test
    public void testEvictPagesWithDiskStorageWithOtherCacheInGroup() throws Exception {
        persistenceEnabled = true;
        this.startGrid();
        this.grid().active(true);
        this.grid().getOrCreateCache(this.cacheConfiguration("cacheWithoutOnHeapCache", false));
        this.checkRowCacheOnPageEviction();
    }

    @Test
    public void testEvictPagesWithoutDiskStorageSingleCacheInGroup() throws Exception {
        persistenceEnabled = false;
        this.startGrid();
        this.checkRowCacheOnPageEviction();
    }

    @Test
    public void testEvictPagesWithoutDiskStorageWithOtherCacheInGroup() throws Exception {
        persistenceEnabled = false;
        this.startGrid();
        this.grid().getOrCreateCache(this.cacheConfiguration("cacheWithoutOnHeapCache", false));
        this.checkRowCacheOnPageEviction();
    }

    private H2RowCacheRegistry rowCache(IgniteEx ig) {
        IgniteH2Indexing indexing = (IgniteH2Indexing)ig.context().query().getIndexing();
        return (H2RowCacheRegistry)GridTestUtils.getFieldValue((Object)indexing, (String[])new String[]{"rowCache"});
    }

    private void fillRowCache(String name) {
        for (int i = 0; i < 10000; ++i) {
            this.grid().cache(name).query((Query)new SqlQuery(Value.class, "_key = " + i)).getAll();
        }
    }

    private static class Value {
        @QuerySqlField
        private long lVal;
        @QuerySqlField
        private byte[] bytes = new byte[1024];

        Value(int k) {
            this.lVal = k;
            RND.nextBytes(this.bytes);
        }
    }
}

