/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.index;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.Ignition;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.index.AbstractSchemaSelfTest;
import org.apache.ignite.internal.processors.cache.index.DynamicIndexAbstractSelfTest;
import org.apache.ignite.internal.processors.query.GridQueryProperty;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.QueryTypeDescriptorImpl;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.processors.query.h2.H2TableDescriptor;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.schema.SchemaOperationException;
import org.apache.ignite.internal.util.GridStringBuilder;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.testframework.GridTestUtils;
import org.h2.jdbc.JdbcSQLException;
import org.h2.value.DataType;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class H2DynamicTableSelfTest
extends AbstractSchemaSelfTest {
    private static final int CLIENT = 2;
    private static final String INDEXED_CACHE_NAME = "cache_idx";
    private static final String INDEXED_CACHE_NAME_2 = "cache_idx_2";
    public static final String DATA_REGION_NAME = "my_data_region";
    public static final String DATA_REGION_NAME_BAD = "my_data_region_bad";
    private static final String CACHE_NAME_BACKUPS = "cache_backups";
    private static final int DFLT_BACKUPS = 2;

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        for (IgniteConfiguration cfg : this.configurations()) {
            Ignition.start((IgniteConfiguration)cfg);
        }
        this.client().addCacheConfiguration(this.cacheConfiguration());
        this.client().addCacheConfiguration(this.cacheConfiguration().setName("cache_async").setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_ASYNC));
        this.client().addCacheConfiguration(this.cacheConfiguration().setName(CACHE_NAME_BACKUPS).setBackups(2));
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.client().getOrCreateCache(this.cacheConfigurationForIndexing());
        this.client().getOrCreateCache(this.cacheConfigurationForIndexingInPublicSchema());
    }

    protected void afterTest() throws Exception {
        this.execute("DROP TABLE IF EXISTS PUBLIC.\"Person\"");
        this.execute("DROP TABLE IF EXISTS PUBLIC.\"City\"");
        this.execute("DROP TABLE IF EXISTS PUBLIC.\"NameTest\"");
        this.execute("DROP TABLE IF EXISTS PUBLIC.\"BackupTest\"");
        super.afterTest();
    }

    @Test
    public void testCreateTable() throws Exception {
        this.doTestCreateTable("cache", null, null, null, new String[0]);
    }

    @Test
    public void testCreateTableWithCacheGroup() throws Exception {
        this.doTestCreateTable("cache", "MyGroup", null, null, new String[0]);
    }

    @Test
    public void testCreateTableWithCacheGroupAndLegacyParamName() throws Exception {
        this.doTestCreateTable("cache", "MyGroup", null, null, true, new String[0]);
    }

    @Test
    public void testCreateTableWithWriteSyncMode() throws Exception {
        this.doTestCreateTable("cache_async", null, null, CacheWriteSynchronizationMode.FULL_ASYNC, new String[0]);
    }

    @Test
    public void testCreateTableReplicated() throws Exception {
        this.doTestCreateTable("REPLICATED", null, CacheMode.REPLICATED, CacheWriteSynchronizationMode.FULL_SYNC, new String[0]);
    }

    @Test
    public void testCreateTablePartitioned() throws Exception {
        this.doTestCreateTable("PARTITIONED", null, CacheMode.PARTITIONED, CacheWriteSynchronizationMode.FULL_SYNC, new String[0]);
    }

    @Test
    public void testCreateTableReplicatedCaseInsensitive() throws Exception {
        this.doTestCreateTable("replicated", null, CacheMode.REPLICATED, CacheWriteSynchronizationMode.FULL_SYNC, new String[0]);
    }

    @Test
    public void testCreateTablePartitionedCaseInsensitive() throws Exception {
        this.doTestCreateTable("partitioned", null, CacheMode.PARTITIONED, CacheWriteSynchronizationMode.FULL_SYNC, new String[0]);
    }

    @Test
    public void testCreateTableNoTemplate() throws Exception {
        this.doTestCreateTable(null, null, CacheMode.PARTITIONED, CacheWriteSynchronizationMode.FULL_SYNC, new String[0]);
    }

    @Test
    public void testTableNameCaseSensitivity() {
        this.doTestTableNameCaseSensitivity("Person", false);
        this.doTestTableNameCaseSensitivity("Person", true);
    }

    @Test
    public void testFullSyncWriteMode() throws Exception {
        this.doTestCreateTable(null, null, null, CacheWriteSynchronizationMode.FULL_SYNC, "write_synchronization_mode=full_sync");
    }

    @Test
    public void testPrimarySyncWriteMode() throws Exception {
        this.doTestCreateTable(null, null, null, CacheWriteSynchronizationMode.PRIMARY_SYNC, "write_synchronization_mode=primary_sync");
    }

    @Test
    public void testFullAsyncWriteMode() throws Exception {
        this.doTestCreateTable(null, null, null, CacheWriteSynchronizationMode.FULL_ASYNC, "write_synchronization_mode=full_async");
    }

    @Test
    public void testCustomCacheName() {
        this.doTestCustomNames("cname", null, null);
    }

    @Test
    public void testCustomKeyTypeName() {
        this.doTestCustomNames(null, "keytype", null);
    }

    @Test
    public void testCustomValueTypeName() {
        this.doTestCustomNames(null, null, "valtype");
    }

    @Test
    public void testCustomCacheAndKeyTypeName() {
        this.doTestCustomNames("cname", "keytype", null);
    }

    @Test
    public void testCustomCacheAndValueTypeName() {
        this.doTestCustomNames("cname", null, "valtype");
    }

    @Test
    public void testCustomKeyAndValueTypeName() {
        this.doTestCustomNames(null, "keytype", "valtype");
    }

    @Test
    public void testCustomCacheAndKeyAndValueTypeName() {
        this.doTestCustomNames("cname", "keytype", "valtype");
    }

    @Test
    public void testDuplicateCustomCacheName() throws Exception {
        this.client().getOrCreateCache("new");
        try {
            GridTestUtils.assertThrows(null, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    H2DynamicTableSelfTest.this.doTestCustomNames("new", null, null);
                    return null;
                }
            }, IgniteSQLException.class, (String)"Table already exists: NameTest");
        }
        finally {
            this.client().destroyCache("new");
        }
    }

    @Test
    public void testPlainKey() throws Exception {
        this.doTestCreateTable(null, null, null, CacheWriteSynchronizationMode.FULL_SYNC, new String[0]);
    }

    private void doTestCustomNames(String cacheName, String keyTypeName, String valTypeName) {
        String res;
        GridStringBuilder b = new GridStringBuilder("CREATE TABLE \"NameTest\" (id int primary key, x varchar) WITH wrap_key,wrap_value");
        assert (!(F.isEmpty((String)cacheName) && F.isEmpty((String)keyTypeName) && F.isEmpty((String)valTypeName)));
        if (!F.isEmpty((String)cacheName)) {
            b.a(",\"cache_name=").a(cacheName).a('\"');
        }
        if (!F.isEmpty((String)keyTypeName)) {
            b.a(",\"key_type=").a(keyTypeName).a('\"');
        }
        if (!F.isEmpty((String)valTypeName)) {
            b.a(",\"value_type=").a(valTypeName).a('\"');
        }
        if ((res = b.toString()).endsWith(",")) {
            res = res.substring(0, res.length() - 1);
        }
        this.execute((Ignite)this.client(), res);
        String resCacheName = (String)U.firstNotNull((Object[])new String[]{cacheName, H2DynamicTableSelfTest.cacheName("NameTest")});
        IgniteInternalCache cache = this.client().cachex(resCacheName);
        H2DynamicTableSelfTest.assertNotNull((Object)cache);
        CacheConfiguration ccfg = cache.configuration();
        H2DynamicTableSelfTest.assertEquals((int)1, (int)ccfg.getQueryEntities().size());
        QueryEntity e = (QueryEntity)ccfg.getQueryEntities().iterator().next();
        if (!F.isEmpty((String)keyTypeName)) {
            H2DynamicTableSelfTest.assertEquals((String)keyTypeName, (String)e.getKeyType());
        } else {
            H2DynamicTableSelfTest.assertTrue((boolean)e.getKeyType().startsWith("SQL_PUBLIC"));
        }
        if (!F.isEmpty((String)valTypeName)) {
            H2DynamicTableSelfTest.assertEquals((String)valTypeName, (String)e.getValueType());
        } else {
            H2DynamicTableSelfTest.assertTrue((boolean)e.getValueType().startsWith("SQL_PUBLIC"));
        }
        this.execute((Ignite)this.client(), "INSERT INTO \"NameTest\" (id, x) values (1, 'a')");
        List<List<?>> qres = this.execute((Ignite)this.client(), "SELECT id, x from \"NameTest\"");
        this.assertEqualsCollections(Collections.singletonList(Arrays.asList(1, "a")), qres);
        BinaryObject key = this.client().binary().builder(e.getKeyType()).setField("ID", (Object)1).build();
        BinaryObject val = (BinaryObject)this.client().cache(resCacheName).withKeepBinary().get((Object)key);
        BinaryObject exVal = this.client().binary().builder(e.getValueType()).setField("X", (Object)"a").build();
        H2DynamicTableSelfTest.assertEquals((Object)exVal, (Object)val);
    }

    private void doTestTableNameCaseSensitivity(String tblName, boolean sensitive) {
        String tblNameSql = sensitive ? '\"' + tblName + '\"' : tblName;
        this.assertTableNameIsValid(tblNameSql, tblNameSql);
        if (sensitive) {
            this.assertTableNameIsNotValid(tblNameSql, tblName.toUpperCase());
            this.assertTableNameIsNotValid(tblNameSql, tblName.toLowerCase());
        } else {
            this.assertTableNameIsValid(tblNameSql, '\"' + tblName.toUpperCase() + '\"');
            this.assertTableNameIsValid(tblNameSql, tblName.toUpperCase());
            this.assertTableNameIsValid(tblNameSql, tblName.toLowerCase());
        }
    }

    private void assertTableNameIsValid(String tblNameToCreate, String checkedTblName) {
        this.info("Checking table name variant for validity: " + checkedTblName);
        this.execute("create table if not exists " + tblNameToCreate + " (id int primary key, name varchar)");
        this.execute("MERGE INTO " + checkedTblName + " (id, name) values (1, 'A')");
        this.execute("SELECT * FROM " + checkedTblName);
        this.execute("DROP TABLE " + checkedTblName);
    }

    private void assertTableNameIsNotValid(String tblNameToCreate, String checkedTblName) {
        this.info("Checking table name variant for invalidity: " + checkedTblName);
        this.execute("create table if not exists " + tblNameToCreate + " (id int primary key, name varchar)");
        this.assertCommandThrowsTableNotFound(checkedTblName.toUpperCase(), "MERGE INTO " + checkedTblName + " (id, name) values (1, 'A')");
        this.assertCommandThrowsTableNotFound(checkedTblName.toUpperCase(), "SELECT * FROM " + checkedTblName);
        this.assertDdlCommandThrowsTableNotFound(checkedTblName.toUpperCase(), "DROP TABLE " + checkedTblName);
    }

    private void assertCommandThrowsTableNotFound(String checkedTblName, final String cmd) {
        final Throwable e = GridTestUtils.assertThrowsWithCause((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                H2DynamicTableSelfTest.this.execute(cmd);
                return null;
            }
        }, JdbcSQLException.class);
        GridTestUtils.assertThrows(null, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                throw (Exception)e.getCause();
            }
        }, JdbcSQLException.class, (String)("Table \"" + checkedTblName + "\" not found"));
    }

    private void assertDdlCommandThrowsTableNotFound(String checkedTblName, final String cmd) {
        GridTestUtils.assertThrows(null, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                H2DynamicTableSelfTest.this.execute(cmd);
                return null;
            }
        }, IgniteSQLException.class, (String)("Table doesn't exist: " + checkedTblName));
    }

    private void doTestCreateTable(String tplCacheName, String cacheGrp, CacheMode cacheMode, CacheWriteSynchronizationMode writeSyncMode, String ... additionalParams) throws SQLException {
        this.doTestCreateTable(tplCacheName, cacheGrp, cacheMode, writeSyncMode, false, additionalParams);
    }

    @Test
    public void testBackups() throws Exception {
        String cacheName = "BackupTestCache";
        this.execute("CREATE TABLE \"BackupTest\" (id BIGINT PRIMARY KEY, name VARCHAR) WITH \"template=cache_backups, cache_name=" + cacheName + "\"");
        CacheConfiguration ccfg = (CacheConfiguration)this.grid(0).cache(cacheName).getConfiguration(CacheConfiguration.class);
        H2DynamicTableSelfTest.assertEquals((int)2, (int)ccfg.getBackups());
        this.execute("DROP TABLE PUBLIC.\"BackupTest\"");
        this.execute("CREATE TABLE \"BackupTest\" (id BIGINT PRIMARY KEY, name VARCHAR) WITH \"template=cache_backups, cache_name=" + cacheName + ", backups=1\"");
        ccfg = (CacheConfiguration)this.grid(0).cache(cacheName).getConfiguration(CacheConfiguration.class);
        H2DynamicTableSelfTest.assertEquals((int)1, (int)ccfg.getBackups());
    }

    private void doTestCreateTable(String tplCacheName, String cacheGrp, CacheMode cacheMode, CacheWriteSynchronizationMode writeSyncMode, boolean useLegacyCacheGrpParamName, String ... additionalParams) throws SQLException {
        String cacheGrpParamName = useLegacyCacheGrpParamName ? "cacheGroup" : "cache_group";
        String sql = "CREATE TABLE \"Person\" (\"id\" int, \"city\" varchar, \"name\" varchar, \"surname\" varchar, \"age\" int, PRIMARY KEY (\"id\", \"city\")) WITH " + (F.isEmpty((String)tplCacheName) ? "" : "\"template=" + tplCacheName + "\",") + "\"backups=10,atomicity=atomic\"" + (F.isEmpty((String)cacheGrp) ? "" : ",\"" + cacheGrpParamName + '=' + cacheGrp + '\"');
        for (String p : additionalParams) {
            sql = sql + ",\"" + p + "\"";
        }
        this.execute(sql);
        String cacheName = H2DynamicTableSelfTest.cacheName("Person");
        for (int i = 0; i < 4; ++i) {
            IgniteEx node = this.grid(i);
            H2DynamicTableSelfTest.assertNotNull((Object)node.cache(cacheName));
            DynamicCacheDescriptor cacheDesc = node.context().cache().cacheDescriptor(cacheName);
            H2DynamicTableSelfTest.assertNotNull((Object)cacheDesc);
            if (cacheMode == CacheMode.REPLICATED) {
                H2DynamicTableSelfTest.assertEquals((int)Integer.MAX_VALUE, (int)cacheDesc.cacheConfiguration().getBackups());
            } else {
                H2DynamicTableSelfTest.assertEquals((int)10, (int)cacheDesc.cacheConfiguration().getBackups());
            }
            H2DynamicTableSelfTest.assertEquals((Object)CacheAtomicityMode.ATOMIC, (Object)cacheDesc.cacheConfiguration().getAtomicityMode());
            H2DynamicTableSelfTest.assertTrue((boolean)cacheDesc.sql());
            H2DynamicTableSelfTest.assertEquals((String)cacheGrp, (String)cacheDesc.groupDescriptor().groupName());
            if (cacheMode != null) {
                H2DynamicTableSelfTest.assertEquals((Object)cacheMode, (Object)cacheDesc.cacheConfiguration().getCacheMode());
            }
            if (writeSyncMode != null) {
                H2DynamicTableSelfTest.assertEquals((Object)writeSyncMode, (Object)cacheDesc.cacheConfiguration().getWriteSynchronizationMode());
            }
            ArrayList<String> colNames = new ArrayList<String>(5);
            ArrayList colTypes = new ArrayList(5);
            ArrayList<String> pkColNames = new ArrayList<String>(2);
            try (Connection c = H2DynamicTableSelfTest.connect(node);){
                int j;
                try (ResultSet rs = c.getMetaData().getColumns(null, "PUBLIC", "Person", null);){
                    for (j = 0; j < 5; ++j) {
                        H2DynamicTableSelfTest.assertTrue((boolean)rs.next());
                        colNames.add(rs.getString("COLUMN_NAME"));
                        try {
                            colTypes.add(Class.forName(DataType.getTypeClassName((int)DataType.convertSQLTypeToValueType((int)rs.getInt("DATA_TYPE")))));
                            continue;
                        }
                        catch (ClassNotFoundException e) {
                            throw new AssertionError((Object)e);
                        }
                    }
                    H2DynamicTableSelfTest.assertFalse((boolean)rs.next());
                }
                rs = c.getMetaData().getPrimaryKeys(null, "PUBLIC", "Person");
                var19_22 = null;
                try {
                    for (j = 0; j < 2; ++j) {
                        H2DynamicTableSelfTest.assertTrue((boolean)rs.next());
                        pkColNames.add(rs.getString("COLUMN_NAME"));
                    }
                    H2DynamicTableSelfTest.assertFalse((boolean)rs.next());
                }
                catch (Throwable throwable) {
                    var19_22 = throwable;
                    throw throwable;
                }
                finally {
                    if (rs != null) {
                        if (var19_22 != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable) {
                                var19_22.addSuppressed(throwable);
                            }
                        } else {
                            rs.close();
                        }
                    }
                }
            }
            this.assertEqualsCollections(F.asList((Object[])new String[]{"id", "city", "name", "surname", "age"}), colNames);
            this.assertEqualsCollections(F.asList((Object[])new Class[]{Integer.class, String.class, String.class, String.class, Integer.class}), colTypes);
            this.assertEqualsCollections(F.asList((Object[])new String[]{"id", "city"}), pkColNames);
        }
    }

    @Test
    public void testNegativeBackups() {
        this.assertCreateTableWithParamsThrows("bAckUPs = -5  ", "\"BACKUPS\" cannot be negative: -5");
    }

    @Test
    public void testEmptyBackups() {
        this.assertCreateTableWithParamsThrows(" bAckUPs =  ", "Parameter value cannot be empty: BACKUPS");
    }

    @Test
    public void testEmptyAtomicity() {
        this.assertCreateTableWithParamsThrows("AtomicitY=  ", "Parameter value cannot be empty: ATOMICITY");
    }

    @Test
    public void testInvalidAtomicity() {
        this.assertCreateTableWithParamsThrows("atomicity=InvalidValue", "Invalid value of \"ATOMICITY\" parameter (should be either TRANSACTIONAL or ATOMIC): InvalidValue");
    }

    @Test
    public void testEmptyCacheGroup() {
        this.assertCreateTableWithParamsThrows("cache_group=", "Parameter value cannot be empty: CACHE_GROUP");
    }

    @Test
    public void testEmptyWriteSyncMode() {
        this.assertCreateTableWithParamsThrows("write_synchronization_mode=", "Parameter value cannot be empty: WRITE_SYNCHRONIZATION_MODE");
    }

    @Test
    public void testInvalidWriteSyncMode() {
        this.assertCreateTableWithParamsThrows("write_synchronization_mode=invalid", "Invalid value of \"WRITE_SYNCHRONIZATION_MODE\" parameter (should be FULL_SYNC, FULL_ASYNC, or PRIMARY_SYNC): invalid");
    }

    @Test
    public void testCreateTableIfNotExists() throws Exception {
        this.execute("CREATE TABLE \"Person\" (\"id\" int, \"city\" varchar, \"name\" varchar, \"surname\" varchar, \"age\" int, PRIMARY KEY (\"id\", \"city\")) WITH \"template=cache\"");
        this.execute("CREATE TABLE IF NOT EXISTS \"Person\" (\"id\" int, \"city\" varchar, \"name\" varchar, \"surname\" varchar, \"age\" int, PRIMARY KEY (\"id\", \"city\")) WITH \"template=cache\"");
    }

    @Test
    public void testCreateExistingTable() throws Exception {
        this.execute("CREATE TABLE \"Person\" (\"id\" int, \"city\" varchar, \"name\" varchar, \"surname\" varchar, \"age\" int, PRIMARY KEY (\"id\", \"city\")) WITH \"template=cache\"");
        GridTestUtils.assertThrows(null, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                H2DynamicTableSelfTest.this.execute("CREATE TABLE \"Person\" (\"id\" int, \"city\" varchar, \"name\" varchar, \"surname\" varchar, \"age\" int, PRIMARY KEY (\"id\", \"city\")) WITH \"template=cache\"");
                return null;
            }
        }, IgniteSQLException.class, (String)"Table already exists: Person");
    }

    @Test
    public void testCreateTableWithWrongColumnNameAsKey() throws Exception {
        GridTestUtils.assertThrows(null, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                H2DynamicTableSelfTest.this.execute("CREATE TABLE \"Person\" (\"id\" int, \"city\" varchar, \"name\" varchar, \"surname\" varchar, \"age\" int, PRIMARY KEY (\"id\", \"c_ity\")) WITH \"template=cache\"");
                return null;
            }
        }, IgniteSQLException.class, (String)"PRIMARY KEY column is not defined: c_ity");
    }

    @Test
    public void testDropTable() throws Exception {
        this.execute("CREATE TABLE IF NOT EXISTS \"Person\" (\"id\" int, \"city\" varchar, \"name\" varchar, \"surname\" varchar, \"age\" int, PRIMARY KEY (\"id\", \"city\")) WITH \"template=cache\"");
        this.execute("DROP TABLE \"Person\"");
        for (int i = 0; i < 4; ++i) {
            IgniteEx node = this.grid(i);
            H2DynamicTableSelfTest.assertNull((Object)node.cache("Person"));
            QueryTypeDescriptorImpl desc = H2DynamicTableSelfTest.type(node, "Person", "Person");
            H2DynamicTableSelfTest.assertNull((Object)desc);
        }
    }

    @Test
    public void testCacheSelfDrop() throws Exception {
        this.execute("CREATE TABLE IF NOT EXISTS \"Person\" (\"id\" int, \"city\" varchar, \"name\" varchar, \"surname\" varchar, \"age\" int, PRIMARY KEY (\"id\", \"city\")) WITH \"template=cache\"");
        GridTestUtils.assertThrows(null, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                H2DynamicTableSelfTest.this.client().cache(QueryUtils.createTableCacheName((String)"PUBLIC", (String)"Person")).query(new SqlFieldsQuery("DROP TABLE \"Person\"")).getAll();
                return null;
            }
        }, IgniteSQLException.class, (String)"DROP TABLE cannot be called from the same cache that holds the table being dropped");
        this.execute("DROP TABLE \"Person\"");
    }

    @Test
    public void testDropMissingTableIfExists() throws Exception {
        this.execute("DROP TABLE IF EXISTS \"City\"");
    }

    @Test
    public void testDropMissingTable() throws Exception {
        GridTestUtils.assertThrows(null, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                H2DynamicTableSelfTest.this.execute("DROP TABLE \"City\"");
                return null;
            }
        }, IgniteSQLException.class, (String)"Table doesn't exist: City");
    }

    @Test
    public void testDropNonDynamicTable() throws Exception {
        GridTestUtils.assertThrows(null, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                H2DynamicTableSelfTest.this.execute("DROP TABLE PUBLIC.\"Integer\"");
                return null;
            }
        }, IgniteSQLException.class, (String)"Only cache created with CREATE TABLE may be removed with DROP TABLE [cacheName=cache_idx_2]");
    }

    @Test
    public void testDestroyDynamicSqlCache() throws Exception {
        this.execute("CREATE TABLE \"Person\" (\"id\" int, \"city\" varchar, \"name\" varchar, \"surname\" varchar, \"age\" int, PRIMARY KEY (\"id\", \"city\")) WITH \"template=cache\"");
        this.client().destroyCache(H2DynamicTableSelfTest.cacheName("Person"));
    }

    @Test
    public void testSqlFlagCompatibilityCheck() throws Exception {
        this.execute("CREATE TABLE \"Person\" (\"id\" int, \"city\" varchar, \"name\" varchar, \"surname\" varchar, \"age\" int, PRIMARY KEY (\"id\", \"city\")) WITH \"template=cache\"");
        GridTestUtils.assertThrows(null, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                String cacheName = H2DynamicTableSelfTest.cacheName("Person");
                Ignition.start((IgniteConfiguration)H2DynamicTableSelfTest.this.clientConfiguration(5).setCacheConfiguration(new CacheConfiguration[]{new CacheConfiguration(cacheName)}));
                return null;
            }
        }, IgniteException.class, (String)"Cache configuration mismatch (local cache was created via Ignite API, while remote cache was created via CREATE TABLE): SQL_PUBLIC_Person");
    }

    @Test
    public void testIndexNameConflictCheckDiscovery() throws Exception {
        this.execute((Ignite)this.grid(0), "CREATE TABLE \"Person\" (id int primary key, name varchar)");
        this.execute((Ignite)this.grid(0), "CREATE INDEX \"idx\" ON \"Person\" (\"name\")");
        GridTestUtils.assertThrows(null, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                QueryEntity e = new QueryEntity();
                e.setTableName("City");
                e.setKeyFields(Collections.singleton("name"));
                e.setFields(new LinkedHashMap<String, String>(Collections.singletonMap("name", String.class.getName())));
                e.setIndexes(Collections.singleton(new QueryIndex("name").setName("idx")));
                e.setKeyType("CityKey");
                e.setValueType("City");
                AbstractSchemaSelfTest.queryProcessor(H2DynamicTableSelfTest.this.client()).dynamicTableCreate("PUBLIC", e, CacheMode.PARTITIONED.name(), null, null, null, null, CacheAtomicityMode.ATOMIC, null, Integer.valueOf(10), false, false);
                return null;
            }
        }, SchemaOperationException.class, (String)"Index already exists: idx");
    }

    @Test
    public void testTableNameConflictCheckSql() throws Exception {
        this.execute((Ignite)this.grid(0), "CREATE TABLE \"Person\" (id int primary key, name varchar)");
        GridTestUtils.assertThrows(null, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                H2DynamicTableSelfTest.this.execute((Ignite)H2DynamicTableSelfTest.this.client(), "CREATE TABLE \"Person\" (id int primary key, name varchar)");
                return null;
            }
        }, IgniteSQLException.class, (String)"Table already exists: Person");
    }

    @Test
    public void testAffinityKey() throws Exception {
        this.execute("CREATE TABLE \"City\" (\"name\" varchar primary key, \"code\" int) WITH wrap_key,wrap_value,\"affinity_key='name'\"");
        this.assertAffinityCacheConfiguration("City", "name");
        this.execute("INSERT INTO \"City\" (\"name\", \"code\") values ('A', 1), ('B', 2), ('C', 3)");
        List<String> cityNames = Arrays.asList("A", "B", "C");
        List<Integer> cityCodes = Arrays.asList(1, 2, 3);
        this.execute("CREATE TABLE \"Person2\" (\"id\" int, \"city\" varchar, \"name\" varchar, \"surname\" varchar, \"age\" int, PRIMARY KEY (\"id\", \"city\")) WITH wrap_key,wrap_value,\"template=cache,affinity_key='city'\"");
        this.assertAffinityCacheConfiguration("Person2", "city");
        Random r = new Random();
        HashMap<Integer, Integer> personId2cityCode = new HashMap<Integer, Integer>();
        for (int i = 0; i < 100; ++i) {
            int cityIdx = r.nextInt(3);
            String cityName = cityNames.get(cityIdx);
            int cityCode = cityCodes.get(cityIdx);
            personId2cityCode.put(i, cityCode);
            H2DynamicTableSelfTest.queryProcessor(this.client()).querySqlFields(new SqlFieldsQuery("insert into \"Person2\"(\"id\", \"city\") values (?, ?)").setArgs(new Object[]{i, cityName}), true).getAll();
        }
        List res = H2DynamicTableSelfTest.queryProcessor(this.client()).querySqlFields(new SqlFieldsQuery("select \"id\", c.\"code\" from \"Person2\" p left join \"City\" c on p.\"city\" = c.\"name\" where c.\"name\" is not null"), true).getAll();
        H2DynamicTableSelfTest.assertEquals((int)100, (int)res.size());
        for (int i = 0; i < 100; ++i) {
            H2DynamicTableSelfTest.assertNotNull(((List)res.get(i)).get(0));
            H2DynamicTableSelfTest.assertNotNull(((List)res.get(i)).get(1));
            int id = (Integer)((List)res.get(i)).get(0);
            int code = (Integer)((List)res.get(i)).get(1);
            H2DynamicTableSelfTest.assertEquals((int)((Integer)personId2cityCode.get(id)), (int)code);
        }
    }

    @Test
    public void testDataRegion() throws Exception {
        GridTestUtils.assertThrows((IgniteLogger)this.log, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                H2DynamicTableSelfTest.this.execute("CREATE TABLE TEST_DATA_REGION (name varchar primary key, code int) WITH \"data_region=\"");
                return null;
            }
        }, IgniteSQLException.class, (String)"Parameter value cannot be empty: DATA_REGION");
        this.execute("CREATE TABLE TEST_DATA_REGION (name varchar primary key, code int) WITH \"data_region=my_data_region\"");
        CacheConfiguration ccfg = (CacheConfiguration)this.client().cache("SQL_PUBLIC_TEST_DATA_REGION").getConfiguration(CacheConfiguration.class);
        H2DynamicTableSelfTest.assertEquals((String)DATA_REGION_NAME, (String)ccfg.getDataRegionName());
    }

    @Test
    public void testAffinityKeyCaseSensitivity() {
        this.execute("CREATE TABLE \"A\" (\"name\" varchar primary key, \"code\" int) WITH wrap_key,wrap_value,\"affinity_key='name'\"");
        this.assertAffinityCacheConfiguration("A", "name");
        this.execute("CREATE TABLE \"B\" (name varchar primary key, \"code\" int) WITH wrap_key,wrap_value,\"affinity_key=name\"");
        this.assertAffinityCacheConfiguration("B", "NAME");
        this.execute("CREATE TABLE \"C\" (name varchar primary key, \"code\" int) WITH wrap_key,wrap_value,\"affinity_key=NamE\"");
        this.assertAffinityCacheConfiguration("C", "NAME");
        this.execute("CREATE TABLE \"D\" (\"name\" varchar primary key, \"code\" int) WITH wrap_key,wrap_value,\"affinity_key=NAME\"");
        this.assertAffinityCacheConfiguration("D", "name");
        GridTestUtils.assertThrows(null, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                H2DynamicTableSelfTest.this.execute("CREATE TABLE \"E\" (name varchar primary key, \"code\" int) WITH wrap_key,wrap_value,\"affinity_key='Name'\"");
                return null;
            }
        }, IgniteSQLException.class, (String)"Affinity key column with given name not found: Name");
        GridTestUtils.assertThrows(null, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                H2DynamicTableSelfTest.this.execute("CREATE TABLE \"E\" (\"name\" varchar, \"Name\" int, val int, primary key(\"name\", \"Name\")) WITH \"affinity_key=name\"");
                return null;
            }
        }, IgniteSQLException.class, (String)"Ambiguous affinity column name, use single quotes for case sensitivity: name");
        this.execute("CREATE TABLE \"E\" (\"name\" varchar, \"Name\" int, val int, primary key(\"name\", \"Name\")) WITH wrap_key,wrap_value,\"affinityKey='Name'\"");
        this.assertAffinityCacheConfiguration("E", "Name");
        this.execute("drop table a");
        this.execute("drop table b");
        this.execute("drop table c");
        this.execute("drop table d");
        this.execute("drop table e");
    }

    @Test
    public void testAffinityKeyNotKeyColumn() {
        GridTestUtils.assertThrows(null, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                H2DynamicTableSelfTest.this.execute("CREATE TABLE \"E\" (name varchar primary key, \"code\" int) WITH \"affinity_key=code\"");
                return null;
            }
        }, IgniteSQLException.class, (String)"Affinity key column must be one of key columns: code");
    }

    @Test
    public void testAffinityKeyNotFound() {
        GridTestUtils.assertThrows(null, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                H2DynamicTableSelfTest.this.execute("CREATE TABLE \"E\" (name varchar primary key, \"code\" int) WITH \"affinity_key=missing\"");
                return null;
            }
        }, IgniteSQLException.class, (String)"Affinity key column with given name not found: missing");
    }

    @Test
    public void testTableAndIndexRecreate() {
        this.execute("drop table if exists \"PUBLIC\".t");
        this.execute("create table \"PUBLIC\".t (a int primary key, b varchar(30))");
        this.fillRecreatedTable();
        this.execute("create index on \"PUBLIC\".t (b desc)");
        this.execute("drop table \"PUBLIC\".t");
        H2DynamicTableSelfTest.assertNull((Object)this.client().cache(H2DynamicTableSelfTest.cacheName("t")));
        this.execute("create table \"PUBLIC\".t (a int primary key, b varchar(30))");
        this.fillRecreatedTable();
        this.execute("create index on \"PUBLIC\".t (b desc)");
        this.execute("drop table \"PUBLIC\".t");
        H2DynamicTableSelfTest.assertNull((Object)this.client().cache("t"));
        this.execute("create table \"PUBLIC\".t (a int primary key, b varchar(30))");
        this.fillRecreatedTable();
        this.execute("create index namedIdx on \"PUBLIC\".t (b desc)");
        this.execute("drop table \"PUBLIC\".t");
        H2DynamicTableSelfTest.assertNull((Object)this.client().cache("t"));
        this.execute("create table \"PUBLIC\".t (a int primary key, b varchar(30))");
        this.fillRecreatedTable();
        this.execute("create index namedIdx on \"PUBLIC\".t (b desc)");
        this.execute("drop table \"PUBLIC\".t");
    }

    @Test
    public void testQueryLocalWithRecreate() throws Exception {
        this.execute("CREATE TABLE A(id int primary key, name varchar, surname varchar) WITH \"cache_name=cache,template=replicated\"");
        IgniteInternalCache cache = this.grid(0).cachex("cache");
        H2DynamicTableSelfTest.assertNotNull((Object)cache);
        this.executeLocal(cache.context(), "INSERT INTO A(id, name, surname) values (1, 'X', 'Y')");
        this.assertEqualsCollections(Collections.singletonList(Arrays.asList(1, "X", "Y")), this.executeLocal(cache.context(), "SELECT id, name, surname FROM A"));
        this.execute("DROP TABLE A");
        this.execute("CREATE TABLE A(id int primary key, name varchar, surname varchar) WITH \"cache_name=cache\"");
        cache = this.grid(0).cachex("cache");
        H2DynamicTableSelfTest.assertNotNull((Object)cache);
        try {
            this.executeLocal(cache.context(), "INSERT INTO A(id, name, surname) values (1, 'X', 'Y')");
        }
        finally {
            this.execute("DROP TABLE A");
        }
    }

    @Test
    public void testWrappedAndUnwrappedKeyTablesInteroperability() {
        this.execute("create table a (id int primary key, x varchar)");
        this.assertDdlCommandThrows("create table a (id int primary key, x varchar) with wrap_key", "Table already exists: A");
        this.assertDdlCommandThrows("create table a (id int primary key, x varchar) with wrap_value", "Table already exists: A");
        this.assertDdlCommandThrows("create table a (id int primary key, x varchar) with wrap_key,wrap_value", "Table already exists: A");
        this.execute("drop table a");
        this.execute("create table a (id int primary key, x varchar) with wrap_key");
        this.assertDdlCommandThrows("create table a (id int primary key, x varchar)", "Table already exists: A");
        this.assertDdlCommandThrows("create table a (id int primary key, x varchar) with wrap_value", "Table already exists: A");
        this.assertDdlCommandThrows("create table a (id int primary key, x varchar) with wrap_key,wrap_value", "Table already exists: A");
        this.execute("drop table a");
        this.execute("create table a (id int primary key, x varchar) with wrap_value");
        this.assertDdlCommandThrows("create table a (id int primary key, x varchar)", "Table already exists: A");
        this.assertDdlCommandThrows("create table a (id int primary key, x varchar) with wrap_key", "Table already exists: A");
        this.assertDdlCommandThrows("create table a (id int primary key, x varchar) with wrap_key,wrap_value", "Table already exists: A");
        this.execute("drop table a");
        this.execute("create table a (id int primary key, x varchar) with wrap_key,wrap_value");
        this.assertDdlCommandThrows("create table a (id int primary key, x varchar)", "Table already exists: A");
        this.assertDdlCommandThrows("create table a (id int primary key, x varchar) with wrap_value", "Table already exists: A");
        this.assertDdlCommandThrows("create table a (id int primary key, x varchar) with wrap_key", "Table already exists: A");
        this.execute("drop table a");
    }

    @Test
    public void testDynamicTablesInteroperability() {
        this.execute("create table a (id int primary key, x varchar) with \"wrap_value=false\"");
        this.execute("create table b (id long primary key, y varchar) with \"wrap_value=false\"");
        this.execute("create table c (id int primary key, z long) with \"wrap_value=false\"");
        this.execute("create table d (id int primary key, w varchar) with \"wrap_value=false\"");
        this.execute("drop table a");
        this.execute("drop table b");
        this.execute("drop table c");
        this.execute("drop table d");
    }

    @Test
    public void testWrappingAlwaysOnWithComplexObjects() {
        this.assertDdlCommandThrows("create table a (id int, x varchar, c long, primary key(id, c)) with \"wrap_key=false\"", "WRAP_KEY cannot be false when composite primary key exists.");
        this.assertDdlCommandThrows("create table a (id int, x varchar, c long, primary key(id)) with \"wrap_value=false\"", "WRAP_VALUE cannot be false when multiple non-primary key columns exist.");
    }

    @Test
    public void testNoWrap() throws SQLException {
        this.doTestKeyValueWrap(false, false, false);
    }

    @Test
    public void testKeyWrap() throws SQLException {
        this.doTestKeyValueWrap(true, false, false);
    }

    @Test
    public void testValueWrap() throws SQLException {
        this.doTestKeyValueWrap(false, true, false);
    }

    @Test
    public void testKeyAndValueWrap() throws SQLException {
        this.doTestKeyValueWrap(true, true, false);
    }

    @Test
    public void testUuidNoWrap() throws SQLException {
        this.doTestKeyValueWrap(false, false, true);
    }

    @Test
    public void testUuidKeyWrap() throws SQLException {
        this.doTestKeyValueWrap(true, false, true);
    }

    @Test
    public void testUuidValueWrap() throws SQLException {
        this.doTestKeyValueWrap(false, true, true);
    }

    @Test
    public void testUuidKeyAndValueWrap() throws SQLException {
        this.doTestKeyValueWrap(true, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTestKeyValueWrap(boolean wrapKey, boolean wrapVal, boolean testUuid) throws SQLException {
        try {
            String sql = testUuid ? String.format("CREATE TABLE T (\"id\" UUID primary key, \"x\" UUID) WITH \"wrap_key=%b,wrap_value=%b\"", wrapKey, wrapVal) : String.format("CREATE TABLE T (\"id\" int primary key, \"x\" varchar) WITH \"wrap_key=%b,wrap_value=%b\"", wrapKey, wrapVal);
            UUID guid = UUID.randomUUID();
            if (wrapKey) {
                sql = sql + ",\"key_type=" + (testUuid ? "tkey_guid" : "tkey") + "\"";
            }
            if (wrapVal) {
                sql = sql + ",\"value_type=" + (testUuid ? "tval_guid" : "tval") + "\"";
            }
            this.execute(sql);
            if (testUuid) {
                this.execute("INSERT INTO T(\"id\", \"x\") values('" + guid.toString() + "', '" + guid.toString() + "')");
            } else {
                this.execute("INSERT INTO T(\"id\", \"x\") values(1, 'a')");
            }
            LinkedHashMap<String, String> resCols = new LinkedHashMap<String, String>();
            ArrayList<Object> resData = new ArrayList<Object>();
            try (Connection conn = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1");){
                try (ResultSet colsRs = conn.getMetaData().getColumns(null, "PUBLIC", "T", ".*");){
                    while (colsRs.next()) {
                        resCols.put(colsRs.getString("COLUMN_NAME"), DataType.getTypeClassName((int)DataType.convertSQLTypeToValueType((int)colsRs.getShort("DATA_TYPE"))));
                    }
                }
                var11_13 = null;
                try (PreparedStatement ps = conn.prepareStatement("SELECT * FROM T");
                     ResultSet dataRs = ps.executeQuery();){
                    H2DynamicTableSelfTest.assertTrue((boolean)dataRs.next());
                    for (int i = 0; i < dataRs.getMetaData().getColumnCount(); ++i) {
                        resData.add(dataRs.getObject(i + 1));
                    }
                }
                catch (Throwable throwable) {
                    var11_13 = throwable;
                    throw throwable;
                }
            }
            LinkedHashMap<String, String> expCols = new LinkedHashMap<String, String>();
            if (testUuid) {
                expCols.put("id", Object.class.getName());
                expCols.put("x", Object.class.getName());
            } else {
                expCols.put("id", Integer.class.getName());
                expCols.put("x", String.class.getName());
            }
            H2DynamicTableSelfTest.assertEquals(expCols, resCols);
            this.assertEqualsCollections(testUuid ? Arrays.asList(guid, guid) : Arrays.asList(1, "a"), resData);
            Object key = this.createKeyForWrapTest(testUuid ? guid : Integer.valueOf(1), wrapKey);
            Object val = this.client().cache(H2DynamicTableSelfTest.cacheName("T")).withKeepBinary().get(key);
            H2DynamicTableSelfTest.assertNotNull((Object)val);
            H2DynamicTableSelfTest.assertEquals((Object)this.createValueForWrapTest(testUuid ? guid : "a", wrapVal), (Object)val);
        }
        finally {
            this.execute("DROP TABLE IF EXISTS T");
        }
    }

    private Object createKeyForWrapTest(Object key, boolean wrap) {
        if (!wrap) {
            return key;
        }
        return this.client().binary().builder(key instanceof UUID ? "tkey_guid" : "tkey").setField("id", key).build();
    }

    private Object createValueForWrapTest(Object val, boolean wrap) {
        if (!wrap) {
            return val;
        }
        return this.client().binary().builder(val instanceof UUID ? "tval_guid" : "tval").setField("x", val).build();
    }

    private void fillRecreatedTable() {
        for (int j = 1; j < 10; ++j) {
            String s = Integer.toString(j);
            this.execute("insert into \"PUBLIC\".t (a,b) values (" + s + ", '" + s + "')");
        }
    }

    private void assertAffinityCacheConfiguration(String cacheName, String affKeyFieldName) {
        String actualCacheName = H2DynamicTableSelfTest.cacheName(cacheName);
        Collection types = this.client().context().query().types(actualCacheName);
        H2DynamicTableSelfTest.assertEquals((int)1, (int)types.size());
        GridQueryTypeDescriptor type = (GridQueryTypeDescriptor)types.iterator().next();
        H2DynamicTableSelfTest.assertTrue((boolean)type.name().startsWith(actualCacheName));
        H2DynamicTableSelfTest.assertEquals((String)cacheName, (String)type.tableName());
        H2DynamicTableSelfTest.assertEquals((String)affKeyFieldName, (String)type.affinityKey());
        GridH2Table tbl = ((IgniteH2Indexing)H2DynamicTableSelfTest.queryProcessor(this.client()).getIndexing()).dataTable("PUBLIC", cacheName);
        H2DynamicTableSelfTest.assertNotNull((Object)tbl);
        H2DynamicTableSelfTest.assertNotNull((Object)tbl.getAffinityKeyColumn());
        H2DynamicTableSelfTest.assertEquals((String)affKeyFieldName, (String)tbl.getAffinityKeyColumn().columnName);
    }

    private void createTableWithParams(String params) {
        this.execute("CREATE TABLE \"Person\" (\"id\" int, \"city\" varchar, \"name\" varchar, \"surname\" varchar, \"age\" int, PRIMARY KEY (\"id\", \"city\")) WITH \"template=cache," + params + '\"');
    }

    private void assertCreateTableWithParamsThrows(final String params, String expErrMsg) {
        GridTestUtils.assertThrows(null, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                H2DynamicTableSelfTest.this.createTableWithParams(params);
                return null;
            }
        }, IgniteSQLException.class, (String)expErrMsg);
    }

    private void assertDdlCommandThrows(final String cmd, String expErrMsg) {
        GridTestUtils.assertThrows(null, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                H2DynamicTableSelfTest.this.execute(cmd);
                return null;
            }
        }, IgniteSQLException.class, (String)expErrMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetTablesForCache() throws Exception {
        try {
            this.execute("create table t1(id int primary key, name varchar)");
            this.execute("create table t2(id int primary key, name varchar)");
            IgniteH2Indexing h2Idx = (IgniteH2Indexing)this.grid(0).context().query().getIndexing();
            String cacheName = H2DynamicTableSelfTest.cacheName("T1");
            Collection col = (Collection)GridTestUtils.invoke((Object)h2Idx, (String)"tables", (Object[])new Object[]{cacheName});
            H2DynamicTableSelfTest.assertNotNull((Object)col);
            H2TableDescriptor[] tables = col.toArray(new H2TableDescriptor[col.size()]);
            H2DynamicTableSelfTest.assertEquals((int)1, (int)tables.length);
            H2DynamicTableSelfTest.assertEquals((String)tables[0].table().getName(), (String)"T1");
        }
        finally {
            this.execute("drop table t1 if exists");
            this.execute("drop table t2 if exists");
        }
    }

    private void execute(String sql) {
        this.execute((Ignite)this.client(), sql);
    }

    private void assertProperty(QueryTypeDescriptorImpl desc, String name, Class<?> type, boolean isKey) {
        GridQueryProperty p = desc.property(name);
        H2DynamicTableSelfTest.assertNotNull((String)name, (Object)p);
        H2DynamicTableSelfTest.assertEquals(type, (Object)p.type());
        H2DynamicTableSelfTest.assertEquals((boolean)isKey, (boolean)p.key());
    }

    private List<IgniteConfiguration> configurations() throws Exception {
        return Arrays.asList(this.serverConfiguration(0), this.serverConfiguration(1), this.clientConfiguration(2), this.serverConfiguration(3));
    }

    private IgniteConfiguration serverConfiguration(int idx) throws Exception {
        return this.commonConfiguration(idx);
    }

    private IgniteConfiguration clientConfiguration(int idx) throws Exception {
        return this.commonConfiguration(idx).setClientMode(true);
    }

    @Override
    protected IgniteConfiguration commonConfiguration(int idx) throws Exception {
        IgniteConfiguration cfg = super.commonConfiguration(idx);
        DataRegionConfiguration dataRegionCfg = new DataRegionConfiguration().setName(DATA_REGION_NAME);
        cfg.setDataStorageConfiguration(new DataStorageConfiguration().setDataRegionConfigurations(new DataRegionConfiguration[]{dataRegionCfg}));
        return this.optimize(cfg);
    }

    private List<List<?>> executeLocal(GridCacheContext cctx, String sql) {
        return H2DynamicTableSelfTest.queryProcessor(cctx.grid()).querySqlFields(new SqlFieldsQuery(sql).setLocal(true), true).getAll();
    }

    private IgniteEx client() {
        return this.grid(2);
    }

    private CacheConfiguration cacheConfiguration() {
        CacheConfiguration ccfg = new CacheConfiguration("cache");
        ccfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        ccfg.setSqlEscapeAll(true);
        ccfg.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        ccfg.setCacheMode(CacheMode.PARTITIONED);
        return ccfg;
    }

    private CacheConfiguration cacheConfigurationForIndexing() {
        CacheConfiguration ccfg = this.cacheConfiguration();
        ccfg.setName(INDEXED_CACHE_NAME);
        ccfg.setQueryEntities(Collections.singletonList(new QueryEntity().setKeyType(Integer.class.getName()).setValueType(Integer.class.getName())));
        return ccfg;
    }

    private CacheConfiguration cacheConfigurationForIndexingInPublicSchema() {
        return this.cacheConfigurationForIndexing().setName(INDEXED_CACHE_NAME_2).setSqlSchema("PUBLIC").setNodeFilter(F.not((IgnitePredicate[])new IgnitePredicate[]{new DynamicIndexAbstractSelfTest.NodeFilter()}));
    }

    private static String cacheName(String tblName) {
        return QueryUtils.createTableCacheName((String)"PUBLIC", (String)tblName);
    }
}

