/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.index;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import junit.framework.Assert;
import org.apache.ignite.Ignition;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.index.DynamicIndexAbstractSelfTest;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public abstract class H2DynamicIndexingComplexAbstractTest
extends DynamicIndexAbstractSelfTest {
    private final CacheMode cacheMode;
    private final CacheAtomicityMode atomicityMode;
    private final int nodeIdx;
    private final int backups;
    private static final List<String> COMPANIES = Arrays.asList("ASF", "GNU", "BSD");
    private static final List<String> CITIES = Arrays.asList("St. Petersburg", "Boston", "Berkeley", "London");
    protected static final int SRV_IDX = 0;
    protected static final int CLIENT_IDX = 1;

    H2DynamicIndexingComplexAbstractTest(CacheMode cacheMode, CacheAtomicityMode atomicityMode, int backups, int nodeIdx) {
        this.cacheMode = cacheMode;
        this.atomicityMode = atomicityMode;
        this.backups = backups;
        this.nodeIdx = nodeIdx;
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        Ignition.start((IgniteConfiguration)this.serverConfiguration(0));
        Ignition.start((IgniteConfiguration)this.clientConfiguration(1));
        Ignition.start((IgniteConfiguration)this.serverConfiguration(2));
        Ignition.start((IgniteConfiguration)this.serverConfiguration(3));
    }

    @Test
    public void testOperations() {
        this.executeSql("CREATE TABLE person (id int, name varchar, age int, company varchar, city varchar, primary key (id, name, city)) WITH \"template=" + this.cacheMode.name() + ",atomicity=" + this.atomicityMode.name() + ",backups=" + this.backups + ",affinity_key=city\"", new Object[0]);
        this.executeSql("CREATE INDEX idx on person (city asc, name asc)", new Object[0]);
        this.executeSql("CREATE TABLE city (name varchar, population int, primary key (name)) WITH \"template=" + this.cacheMode.name() + ",atomicity=" + this.atomicityMode.name() + ",backups=" + this.backups + ",affinity_key=name\"", new Object[0]);
        this.executeSql("INSERT INTO city (name, population) values(?, ?), (?, ?), (?, ?)", "St. Petersburg", 6000000, "Boston", 2000000, "London", 8000000);
        long PERSON_COUNT = 100L;
        int i = 0;
        while ((long)i < 100L) {
            this.executeSql("INSERT INTO person (id, name, age, company, city) values (?, ?, ?, ?, ?)", i, "Person " + i, 20 + i % 10, COMPANIES.get(i % COMPANIES.size()), CITIES.get(i % CITIES.size()));
            ++i;
        }
        this.assertAllPersons(new IgniteInClosure<List<?>>(){

            public void apply(List<?> person) {
                H2DynamicIndexingComplexAbstractTest.this.assertInitPerson(person);
            }
        });
        long r = (Long)this.executeSqlSingle("SELECT COUNT(*) from Person", new Object[0]);
        H2DynamicIndexingComplexAbstractTest.assertEquals((long)100L, (long)r);
        r = (Long)this.executeSqlSingle("SELECT COUNT(*) from Person p inner join City c on p.city = c.name", new Object[0]);
        H2DynamicIndexingComplexAbstractTest.assertEquals((long)75L, (long)r);
        this.executeSqlSingle("UPDATE Person SET company = 'GNU', age = CASE WHEN MOD(id, 2) <> 0 THEN age + 5 ELSE age + 1 END WHERE company = 'ASF'", new Object[0]);
        this.assertAllPersons(new IgniteInClosure<List<?>>(){

            public void apply(List<?> person) {
                int id = (Integer)person.get(0);
                if (id % COMPANIES.size() == 0) {
                    int initAge = 20 + id % 10;
                    int expAge = initAge % 2 != 0 ? initAge + 5 : initAge + 1;
                    H2DynamicIndexingComplexAbstractTest.this.assertPerson(id, "Person " + id, expAge, "GNU", (String)CITIES.get(id % CITIES.size()), person);
                } else {
                    H2DynamicIndexingComplexAbstractTest.this.assertInitPerson(person);
                }
            }
        });
        this.executeSql("DROP INDEX idx", new Object[0]);
        this.assertAllPersons(new IgniteInClosure<List<?>>(){

            public void apply(List<?> person) {
                int id = (Integer)person.get(0);
                if (id % COMPANIES.size() == 0) {
                    int initAge = 20 + id % 10;
                    int expAge = initAge % 2 != 0 ? initAge + 5 : initAge + 1;
                    H2DynamicIndexingComplexAbstractTest.this.assertPerson(id, "Person " + id, expAge, "GNU", (String)CITIES.get(id % CITIES.size()), person);
                } else {
                    H2DynamicIndexingComplexAbstractTest.this.assertInitPerson(person);
                }
            }
        });
        this.executeSql("DELETE FROM person WHERE ASCII(company) = ASCII(city)", new Object[0]);
        this.assertAllPersons(new IgniteInClosure<List<?>>(){

            public void apply(List<?> person) {
                String city = H2DynamicIndexingComplexAbstractTest.city(person);
                String company = H2DynamicIndexingComplexAbstractTest.company(person);
                Assert.assertFalse((city.charAt(0) == company.charAt(0) ? 1 : 0) != 0);
            }
        });
        H2DynamicIndexingComplexAbstractTest.assertNotNull((Object)this.node().cache("SQL_PUBLIC_PERSON"));
        this.executeSql("DROP TABLE person", new Object[0]);
        H2DynamicIndexingComplexAbstractTest.assertNull((Object)this.node().cache("SQL_PUBLIC_PERSON"));
        GridTestUtils.assertThrows(null, (Callable)new IgniteCallable<Object>(){

            public Object call() throws Exception {
                return H2DynamicIndexingComplexAbstractTest.this.executeSql("SELECT * from Person", new Object[0]);
            }
        }, IgniteSQLException.class, (String)"Table \"PERSON\" not found");
    }

    private void assertAllPersons(IgniteInClosure<List<?>> clo) {
        List<List<?>> res = this.executeSql("SELECT * from Person", new Object[0]);
        for (List<?> p : res) {
            clo.apply(p);
        }
    }

    private static int id(List<?> person) {
        return (Integer)person.get(0);
    }

    private static String name(List<?> person) {
        return (String)person.get(1);
    }

    private static int age(List<?> person) {
        return (Integer)person.get(2);
    }

    private static String company(List<?> person) {
        return (String)person.get(3);
    }

    private static String city(List<?> person) {
        return (String)person.get(4);
    }

    private void assertInitPerson(List<?> person) {
        H2DynamicIndexingComplexAbstractTest.assertEquals((int)5, (int)person.size());
        int id = H2DynamicIndexingComplexAbstractTest.id(person);
        String name = "Person " + id;
        int age = 20 + id % 10;
        String company = COMPANIES.get(id % COMPANIES.size());
        String city = CITIES.get(id % CITIES.size());
        this.assertPerson(id, name, age, company, city, person);
    }

    private void assertPerson(int id, String name, int age, String company, String city, List<?> person) {
        H2DynamicIndexingComplexAbstractTest.assertEquals((String)name, (String)H2DynamicIndexingComplexAbstractTest.name(person));
        H2DynamicIndexingComplexAbstractTest.assertEquals((int)age, (int)H2DynamicIndexingComplexAbstractTest.age(person));
        H2DynamicIndexingComplexAbstractTest.assertEquals((String)company, (String)H2DynamicIndexingComplexAbstractTest.company(person));
        H2DynamicIndexingComplexAbstractTest.assertEquals((String)city, (String)H2DynamicIndexingComplexAbstractTest.city(person));
        String cacheName = "SQL_PUBLIC_PERSON";
        Collection descs = this.node().context().query().types(cacheName);
        H2DynamicIndexingComplexAbstractTest.assertEquals((int)1, (int)descs.size());
        GridQueryTypeDescriptor desc = (GridQueryTypeDescriptor)descs.iterator().next();
        String keyType = desc.keyTypeName();
        String valType = desc.valueTypeName();
        BinaryObject k = this.node().binary().builder(keyType).setField("id", (Object)id).setField("name", (Object)name).setField("city", (Object)city).build();
        Object v = this.node().cache(cacheName).withKeepBinary().get((Object)k);
        H2DynamicIndexingComplexAbstractTest.assertNotNull((Object)v);
        BinaryObject expVal = this.node().binary().builder(valType).setField("age", (Object)age).setField("company", (Object)company).build();
        H2DynamicIndexingComplexAbstractTest.assertEquals((Object)expVal, (Object)v);
    }

    private List<List<?>> executeSql(IgniteEx node, String stmt, Object ... args) {
        return node.context().query().querySqlFields(new SqlFieldsQuery(stmt).setArgs(args), true).getAll();
    }

    private List<List<?>> executeSql(String stmt, Object ... args) {
        return this.executeSql(this.node(), stmt, args);
    }

    private Object executeSqlSingle(String stmt, Object ... args) {
        List<List<?>> res = this.executeSql(stmt, args);
        H2DynamicIndexingComplexAbstractTest.assertEquals((int)1, (int)res.size());
        List<?> row = res.get(0);
        H2DynamicIndexingComplexAbstractTest.assertEquals((int)1, (int)row.size());
        return row.get(0);
    }

    protected IgniteEx node() {
        return this.grid(this.nodeIdx);
    }
}

