/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.index;

import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.util.lang.GridAbsPredicate;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class H2ConnectionLeaksSelfTest
extends GridCommonAbstractTest {
    private static final String CACHE_NAME = "cache";
    private static final int NODE_CNT = 2;
    private static final int KEY_CNT = 100;
    private static final int THREAD_CNT = 100;

    protected void beforeTestsStarted() throws Exception {
        Ignite node = this.startGrids(2);
        IgniteCache cache = node.cache(CACHE_NAME);
        for (int i = 0; i < 100; ++i) {
            cache.put((Object)i, (Object)String.valueOf(i));
        }
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        CacheConfiguration ccfg = new CacheConfiguration().setName(CACHE_NAME).setIndexedTypes(new Class[]{Long.class, String.class});
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfg});
        if (this.getTestIgniteInstanceIndex(igniteInstanceName) != 0) {
            cfg.setClientMode(true);
        }
        return cfg;
    }

    @Test
    public void testConnectionLeaks() throws Exception {
        final IgniteCache cache = this.grid(1).cache(CACHE_NAME);
        final CountDownLatch latch = new CountDownLatch(100);
        for (int i = 0; i < 100; ++i) {
            new Thread(){

                @Override
                public void run() {
                    SqlFieldsQuery qry = new SqlFieldsQuery("select * from String").setLocal(false);
                    cache.query(qry).getAll();
                    latch.countDown();
                }
            }.start();
        }
        latch.await();
        this.checkConnectionLeaks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectionLeaksOnSqlException() throws Exception {
        final CountDownLatch latch = new CountDownLatch(100);
        final CountDownLatch latch2 = new CountDownLatch(1);
        for (int i = 0; i < 100; ++i) {
            new Thread(){

                @Override
                public void run() {
                    try {
                        IgniteH2Indexing idx = (IgniteH2Indexing)H2ConnectionLeaksSelfTest.this.grid(1).context().query().getIndexing();
                        idx.executeStatement(H2ConnectionLeaksSelfTest.CACHE_NAME, "select *");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    latch.countDown();
                    try {
                        latch2.await();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }.start();
        }
        try {
            latch.await();
            this.checkConnectionLeaks();
        }
        finally {
            latch2.countDown();
        }
    }

    private void checkConnectionLeaks() throws Exception {
        boolean notLeak = GridTestUtils.waitForCondition((GridAbsPredicate)new GridAbsPredicate(){

            public boolean apply() {
                for (int i = 0; i < 2; ++i) {
                    Map conns = H2ConnectionLeaksSelfTest.this.perThreadConnections(i);
                    for (Thread t : conns.keySet()) {
                        if (t.isAlive()) continue;
                        return false;
                    }
                }
                return true;
            }
        }, (long)5000L);
        if (!notLeak) {
            for (int i = 0; i < 2; ++i) {
                Map<Thread, ?> conns = this.perThreadConnections(i);
                for (Thread t : conns.keySet()) {
                    this.log.error("+++ Connection is not closed for thread: " + t.getName());
                }
            }
            H2ConnectionLeaksSelfTest.fail((String)"H2 JDBC connections leak detected. See the log above.");
        }
    }

    private Map<Thread, ?> perThreadConnections(int nodeIdx) {
        return ((IgniteH2Indexing)this.grid(nodeIdx).context().query().getIndexing()).perThreadConnections();
    }
}

