/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.index;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.index.AbstractSchemaSelfTest;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.QueryField;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.h2.value.DataType;

public abstract class DynamicColumnsAbstractTest
extends GridCommonAbstractTest {
    static final String CREATE_SQL = "CREATE TABLE IF NOT EXISTS Person (id int primary key, name varchar)";
    static final String CREATE_SQL_4_COLS = "CREATE TABLE IF NOT EXISTS Person (id int primary key, name varchar, age int, city varchar)";
    static final String DROP_SQL = "DROP TABLE Person";

    static int checkTableState(IgniteEx node, String schemaName, String tblName, QueryField ... cols) throws SQLException {
        ArrayList<QueryField> flds = new ArrayList<QueryField>();
        try (Connection c = AbstractSchemaSelfTest.connect(node);
             ResultSet rs = c.getMetaData().getColumns(null, schemaName, tblName, "%");){
            while (rs.next()) {
                String name = rs.getString("COLUMN_NAME");
                short type = rs.getShort("DATA_TYPE");
                String typeClsName = DataType.getTypeClassName((int)DataType.convertSQLTypeToValueType((int)type));
                short nullable = rs.getShort("NULLABLE");
                flds.add(new QueryField(name, typeClsName, nullable == 1));
            }
        }
        Iterator it = flds.iterator();
        for (int i = flds.size() - cols.length; i > 0 && it.hasNext(); --i) {
            it.next();
        }
        for (QueryField exp : cols) {
            DynamicColumnsAbstractTest.assertTrue((String)("New column not found in metadata: " + exp.name()), (boolean)it.hasNext());
            QueryField act = (QueryField)it.next();
            DynamicColumnsAbstractTest.assertEquals((String)exp.name(), (String)act.name());
            DynamicColumnsAbstractTest.assertEquals((String)exp.typeName(), (String)act.typeName());
            DynamicColumnsAbstractTest.assertEquals((boolean)exp.isNullable(), (boolean)act.isNullable());
        }
        return flds.size() - cols.length;
    }

    static QueryField getColumnMeta(IgniteEx node, String schemaName, String tblName, String colName) throws SQLException {
        try (Connection c = AbstractSchemaSelfTest.connect(node);
             ResultSet rs = c.getMetaData().getColumns(null, schemaName, tblName, colName);){
            if (rs.next()) {
                String name = rs.getString("COLUMN_NAME");
                short type = rs.getShort("DATA_TYPE");
                String typeClsName = DataType.getTypeClassName((int)DataType.convertSQLTypeToValueType((int)type));
                short nullable = rs.getShort("NULLABLE");
                QueryField queryField = new QueryField(name, typeClsName, nullable == 1);
                return queryField;
            }
        }
        return null;
    }

    protected static QueryField c(String name, String typeName) {
        return new QueryField(name, typeName, true);
    }

    protected IgniteConfiguration clientConfiguration(int idx) throws Exception {
        QueryEntity e = new QueryEntity(Integer.class.getName(), "Person");
        LinkedHashMap<String, String> flds = new LinkedHashMap<String, String>();
        flds.put("name", String.class.getName());
        e.setFields(flds);
        return this.commonConfiguration(idx).setClientMode(true).setCacheConfiguration(new CacheConfiguration[]{new CacheConfiguration("idx").setQueryEntities(Collections.singletonList(e))});
    }

    protected IgniteConfiguration commonConfiguration(int idx) throws Exception {
        IgniteConfiguration cfg = this.getConfiguration(this.getTestIgniteInstanceName(idx));
        DataStorageConfiguration memCfg = new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setMaxSize(0x8000000L));
        cfg.setDataStorageConfiguration(memCfg);
        return this.optimize(cfg);
    }

    IgniteConfiguration serverConfiguration(int idx) throws Exception {
        return this.commonConfiguration(idx);
    }

    protected List<List<?>> run(Ignite node, String sql) {
        return ((IgniteEx)node).context().query().querySqlFields(new SqlFieldsQuery(sql).setSchema("PUBLIC"), true).getAll();
    }

    protected List<List<?>> run(IgniteCache<?, ?> cache, String sql, Object ... args) {
        SqlFieldsQuery qry = new SqlFieldsQuery(sql).setSchema("PUBLIC").setArgs(args).setDistributedJoins(true);
        return cache.query(qry).getAll();
    }

    protected void assertThrows(final Ignite node, final String sql, String msg) {
        GridTestUtils.assertThrows((IgniteLogger)this.log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                DynamicColumnsAbstractTest.this.run(node, sql);
                return null;
            }
        }, IgniteSQLException.class, (String)msg);
    }

    protected void assertThrowsAnyCause(final Ignite node, final String sql, Class<? extends Throwable> cls, String msg) {
        GridTestUtils.assertThrowsAnyCause((IgniteLogger)this.log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                DynamicColumnsAbstractTest.this.run(node, sql);
                return null;
            }
        }, cls, (String)msg);
    }
}

