/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.index;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.cache.Cache;
import junit.framework.Assert;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.Ignition;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteClientReconnectAbstractTest;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.managers.discovery.CustomEventListener;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.index.DynamicColumnsAbstractTest;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.QueryField;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.schema.SchemaOperationException;
import org.apache.ignite.internal.processors.query.schema.message.SchemaFinishDiscoveryMessage;
import org.apache.ignite.internal.util.GridConcurrentHashSet;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T3;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public abstract class DynamicColumnsAbstractConcurrentSelfTest
extends DynamicColumnsAbstractTest {
    private static final long TEST_DUR = 10000L;
    private static final int LARGE_CACHE_SIZE = 100000;
    private static final String TBL_NAME = "PERSON";
    private static final String CACHE_NAME = QueryUtils.createTableCacheName((String)"PUBLIC", (String)"PERSON");
    private static final String ATTR_FILTERED = "FILTERED";
    private final String createSql;
    private final String createSql4Cols;
    private static final ConcurrentHashMap<UUID, T3<CountDownLatch, AtomicBoolean, CountDownLatch>> BLOCKS = new ConcurrentHashMap();
    private final CacheMode cacheMode;
    private final CacheAtomicityMode atomicityMode;

    DynamicColumnsAbstractConcurrentSelfTest(CacheMode cacheMode, CacheAtomicityMode atomicityMode) {
        this.cacheMode = cacheMode;
        this.atomicityMode = atomicityMode;
        String template = " WITH \"template=TPL\"";
        this.createSql = "CREATE TABLE IF NOT EXISTS Person (id int primary key, name varchar) WITH \"template=TPL\"";
        this.createSql4Cols = "CREATE TABLE IF NOT EXISTS Person (id int primary key, name varchar, age int, city varchar) WITH \"template=TPL\"";
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        GridQueryProcessor.idxCls = BlockingIndexing.class;
    }

    protected void afterTest() throws Exception {
        GridQueryProcessor.idxCls = null;
        for (T3<CountDownLatch, AtomicBoolean, CountDownLatch> block : BLOCKS.values()) {
            ((CountDownLatch)block.get1()).countDown();
        }
        BLOCKS.clear();
        this.stopAllGrids();
        super.afterTest();
    }

    protected long getTestTimeout() {
        return 300000L;
    }

    @Override
    protected IgniteConfiguration commonConfiguration(int idx) throws Exception {
        IgniteClientReconnectAbstractTest.TestTcpDiscoverySpi spi = new IgniteClientReconnectAbstractTest.TestTcpDiscoverySpi();
        spi.setIpFinder(LOCAL_IP_FINDER);
        return super.commonConfiguration(idx).setDiscoverySpi((DiscoverySpi)spi);
    }

    @Test
    public void testAddColumnCoordinatorChange() throws Exception {
        this.checkCoordinatorChange(true);
    }

    @Test
    public void testDropColumnCoordinatorChange() throws Exception {
        this.checkCoordinatorChange(false);
    }

    public void checkCoordinatorChange(boolean addOrRemove) throws Exception {
        CountDownLatch finishLatch = new CountDownLatch(2);
        IgniteEx srv1 = DynamicColumnsAbstractConcurrentSelfTest.ignitionStart(this.serverConfiguration(1), null);
        IgniteEx srv2 = DynamicColumnsAbstractConcurrentSelfTest.ignitionStart(this.serverConfiguration(2), null);
        IgniteEx srv3 = DynamicColumnsAbstractConcurrentSelfTest.ignitionStart(this.serverConfiguration(3, true), finishLatch);
        UUID srv1Id = srv1.cluster().localNode().id();
        UUID srv2Id = srv2.cluster().localNode().id();
        IgniteEx cli = DynamicColumnsAbstractConcurrentSelfTest.ignitionStart(this.clientConfiguration(4), finishLatch);
        this.createSqlCache((Ignite)cli);
        this.run((Ignite)cli, addOrRemove ? this.createSql : this.createSql4Cols);
        CountDownLatch idxLatch = DynamicColumnsAbstractConcurrentSelfTest.blockIndexing(srv1Id);
        IgniteInternalFuture<?> colFut1 = addOrRemove ? DynamicColumnsAbstractConcurrentSelfTest.addCols((Ignite)cli, "PUBLIC", DynamicColumnsAbstractConcurrentSelfTest.c("age", Integer.class.getName())) : DynamicColumnsAbstractConcurrentSelfTest.dropCols((Ignite)cli, "PUBLIC", "AGE");
        U.await((CountDownLatch)idxLatch);
        Ignition.stop((String)srv1.name(), (boolean)true);
        DynamicColumnsAbstractConcurrentSelfTest.unblockIndexing(srv1Id);
        colFut1.get();
        DynamicColumnsAbstractConcurrentSelfTest.checkTableState(srv2, "PUBLIC", TBL_NAME, addOrRemove ? DynamicColumnsAbstractConcurrentSelfTest.c("age", Integer.class.getName()) : DynamicColumnsAbstractConcurrentSelfTest.c("CITY", String.class.getName()));
        idxLatch = DynamicColumnsAbstractConcurrentSelfTest.blockIndexing(srv2Id);
        IgniteInternalFuture<?> colFut2 = addOrRemove ? DynamicColumnsAbstractConcurrentSelfTest.addCols((Ignite)cli, "PUBLIC", DynamicColumnsAbstractConcurrentSelfTest.c("city", String.class.getName())) : DynamicColumnsAbstractConcurrentSelfTest.dropCols((Ignite)cli, "PUBLIC", "CITY");
        idxLatch.countDown();
        Ignition.stop((String)srv2.name(), (boolean)true);
        U.await((CountDownLatch)idxLatch);
        colFut2.get();
        srv3.cache(QueryUtils.createTableCacheName((String)"PUBLIC", (String)TBL_NAME));
        DynamicColumnsAbstractConcurrentSelfTest.checkTableState(srv3, "PUBLIC", TBL_NAME, addOrRemove ? DynamicColumnsAbstractConcurrentSelfTest.c("city", String.class.getName()) : DynamicColumnsAbstractConcurrentSelfTest.c("NAME", String.class.getName()));
    }

    @Test
    public void testOperationChaining() throws Exception {
        CountDownLatch finishLatch = new CountDownLatch(14);
        IgniteEx srv1 = DynamicColumnsAbstractConcurrentSelfTest.ignitionStart(this.serverConfiguration(1), finishLatch);
        DynamicColumnsAbstractConcurrentSelfTest.ignitionStart(this.serverConfiguration(2), finishLatch);
        DynamicColumnsAbstractConcurrentSelfTest.ignitionStart(this.serverConfiguration(3, true), finishLatch);
        DynamicColumnsAbstractConcurrentSelfTest.ignitionStart(this.clientConfiguration(4), finishLatch);
        this.createSqlCache((Ignite)srv1);
        this.run((Ignite)srv1, this.createSql);
        CountDownLatch idxLatch = DynamicColumnsAbstractConcurrentSelfTest.blockIndexing((Ignite)srv1);
        QueryField c0 = DynamicColumnsAbstractConcurrentSelfTest.c("ID", Integer.class.getName());
        QueryField c1 = DynamicColumnsAbstractConcurrentSelfTest.c("NAME", String.class.getName());
        QueryField c2 = DynamicColumnsAbstractConcurrentSelfTest.c("age", Integer.class.getName());
        QueryField c3 = DynamicColumnsAbstractConcurrentSelfTest.c("city", String.class.getName());
        IgniteInternalFuture<?> colFut1 = DynamicColumnsAbstractConcurrentSelfTest.addCols((Ignite)srv1, "PUBLIC", c2);
        IgniteInternalFuture<?> colFut2 = DynamicColumnsAbstractConcurrentSelfTest.dropCols((Ignite)srv1, "PUBLIC", c1.name());
        IgniteInternalFuture<?> colFut3 = DynamicColumnsAbstractConcurrentSelfTest.addCols((Ignite)srv1, "PUBLIC", c3);
        U.await((CountDownLatch)idxLatch);
        DynamicColumnsAbstractConcurrentSelfTest.ignitionStart(this.serverConfiguration(5), finishLatch);
        DynamicColumnsAbstractConcurrentSelfTest.ignitionStart(this.serverConfiguration(6, true), finishLatch);
        DynamicColumnsAbstractConcurrentSelfTest.ignitionStart(this.clientConfiguration(7), finishLatch);
        assert (!colFut1.isDone());
        assert (!colFut2.isDone());
        assert (!colFut3.isDone());
        DynamicColumnsAbstractConcurrentSelfTest.unblockIndexing((Ignite)srv1);
        colFut1.get();
        colFut2.get();
        colFut3.get();
        U.await((CountDownLatch)finishLatch);
        DynamicColumnsAbstractConcurrentSelfTest.checkTableState(srv1, "PUBLIC", TBL_NAME, c0, c2, c3);
    }

    @Test
    public void testNodeJoinOnPendingAddOperation() throws Exception {
        this.checkNodeJoinOnPendingOperation(true);
    }

    @Test
    public void testNodeJoinOnPendingDropOperation() throws Exception {
        this.checkNodeJoinOnPendingOperation(false);
    }

    private void checkNodeJoinOnPendingOperation(boolean addOrRemove) throws Exception {
        CountDownLatch finishLatch = new CountDownLatch(3);
        IgniteEx srv1 = DynamicColumnsAbstractConcurrentSelfTest.ignitionStart(this.serverConfiguration(1), finishLatch);
        this.createSqlCache((Ignite)srv1);
        this.run((Ignite)srv1, addOrRemove ? this.createSql : this.createSql4Cols);
        CountDownLatch idxLatch = DynamicColumnsAbstractConcurrentSelfTest.blockIndexing((Ignite)srv1);
        QueryField c = DynamicColumnsAbstractConcurrentSelfTest.c("AGE", Integer.class.getName());
        IgniteInternalFuture<?> idxFut = addOrRemove ? DynamicColumnsAbstractConcurrentSelfTest.addCols((Ignite)srv1, "PUBLIC", c) : DynamicColumnsAbstractConcurrentSelfTest.dropCols((Ignite)srv1, "PUBLIC", "CITY");
        U.await((CountDownLatch)idxLatch);
        DynamicColumnsAbstractConcurrentSelfTest.ignitionStart(this.serverConfiguration(2), finishLatch);
        DynamicColumnsAbstractConcurrentSelfTest.ignitionStart(this.serverConfiguration(3, true), finishLatch);
        DynamicColumnsAbstractConcurrentSelfTest.assertFalse((boolean)idxFut.isDone());
        DynamicColumnsAbstractConcurrentSelfTest.unblockIndexing((Ignite)srv1);
        idxFut.get();
        U.await((CountDownLatch)finishLatch);
        DynamicColumnsAbstractConcurrentSelfTest.checkTableState(srv1, "PUBLIC", TBL_NAME, c);
    }

    @Test
    public void testConcurrentPutRemove() throws Exception {
        CountDownLatch finishLatch = new CountDownLatch(4);
        IgniteEx srv1 = DynamicColumnsAbstractConcurrentSelfTest.ignitionStart(this.serverConfiguration(1), finishLatch);
        DynamicColumnsAbstractConcurrentSelfTest.ignitionStart(this.serverConfiguration(2), finishLatch);
        DynamicColumnsAbstractConcurrentSelfTest.ignitionStart(this.serverConfiguration(3), finishLatch);
        DynamicColumnsAbstractConcurrentSelfTest.ignitionStart(this.serverConfiguration(4), finishLatch);
        this.awaitPartitionMapExchange();
        this.createSqlCache((Ignite)srv1);
        this.run((Ignite)srv1, this.createSql4Cols);
        final AtomicBoolean stopped = new AtomicBoolean();
        IgniteInternalFuture updateFut = this.multithreadedAsync(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                while (!stopped.get()) {
                    IgniteEx node = DynamicColumnsAbstractConcurrentSelfTest.this.grid(ThreadLocalRandom.current().nextInt(1, 5));
                    int key = ThreadLocalRandom.current().nextInt(0, 100000);
                    int val = ThreadLocalRandom.current().nextInt();
                    IgniteCache cache = node.cache(CACHE_NAME);
                    if (ThreadLocalRandom.current().nextBoolean()) {
                        cache.put(DynamicColumnsAbstractConcurrentSelfTest.this.key(key), (Object)DynamicColumnsAbstractConcurrentSelfTest.this.val((Ignite)node, val));
                        continue;
                    }
                    cache.remove(DynamicColumnsAbstractConcurrentSelfTest.this.key(key));
                }
                return null;
            }
        }, 4);
        Thread.sleep(500L);
        DynamicColumnsAbstractConcurrentSelfTest.addCols((Ignite)srv1, "PUBLIC", DynamicColumnsAbstractConcurrentSelfTest.c("v", Integer.class.getName())).get();
        DynamicColumnsAbstractConcurrentSelfTest.dropCols((Ignite)srv1, "PUBLIC", "CITY").get();
        stopped.set(true);
        updateFut.get();
        finishLatch.await();
        DynamicColumnsAbstractConcurrentSelfTest.checkTableState(srv1, "PUBLIC", TBL_NAME, DynamicColumnsAbstractConcurrentSelfTest.c("AGE", Integer.class.getName()), DynamicColumnsAbstractConcurrentSelfTest.c("v", Integer.class.getName()));
        this.run((Ignite)srv1, "update person set \"v\" = case when mod(id, 2) <> 0 then substring(name, 7, length(name) - 6) else null end");
        HashSet<Integer> expKeys = new HashSet<Integer>();
        IgniteCache cache = srv1.cache(CACHE_NAME).withKeepBinary();
        for (int i = 0; i < 100000; ++i) {
            Object key = this.key(i);
            BinaryObject val = (BinaryObject)cache.get(key);
            if (val == null) continue;
            int id = (Integer)key;
            DynamicColumnsAbstractConcurrentSelfTest.assertEquals((int)i, (int)id);
            if (id % 2 == 0) continue;
            expKeys.add(i);
        }
        String valTypeName = ((GridQueryTypeDescriptor)srv1.context().query().types(CACHE_NAME).iterator().next()).valueTypeName();
        for (Ignite node : Ignition.allGrids()) {
            IgniteCache nodeCache = node.cache(CACHE_NAME).withKeepBinary();
            SqlQuery qry = new SqlQuery(valTypeName, "from PERSON where mod(id, 2) <> 0");
            List res = nodeCache.query((Query)qry).getAll();
            DynamicColumnsAbstractConcurrentSelfTest.assertEquals((String)("Cache size mismatch [exp=" + expKeys.size() + ", actual=" + res.size() + ']'), (int)expKeys.size(), (int)res.size());
            for (Cache.Entry entry : res) {
                int key = (Integer)entry.getKey();
                int v = (Integer)((BinaryObject)entry.getValue()).field("v");
                String name = (String)((BinaryObject)entry.getValue()).field("NAME");
                DynamicColumnsAbstractConcurrentSelfTest.assertTrue((String)("Expected key is not in result set: " + key), (boolean)expKeys.contains(key));
                DynamicColumnsAbstractConcurrentSelfTest.assertEquals((int)Integer.parseInt(name.substring(6)), (int)v);
            }
        }
    }

    private BinaryObject val(Ignite node, int val) {
        String valTypeName = ((GridQueryTypeDescriptor)((IgniteEx)node).context().query().types(CACHE_NAME).iterator().next()).valueTypeName();
        return node.binary().builder(valTypeName).setField("name", (Object)("person" + val)).build();
    }

    private Object key(int id) {
        return id;
    }

    @Test
    public void testAddConcurrentRebalance() throws Exception {
        this.checkConcurrentRebalance(true);
    }

    @Test
    public void testDropConcurrentRebalance() throws Exception {
        this.checkConcurrentRebalance(false);
    }

    public void checkConcurrentRebalance(boolean addOrRemove) throws Exception {
        IgniteEx srv1 = DynamicColumnsAbstractConcurrentSelfTest.ignitionStart(this.serverConfiguration(1));
        IgniteEx srv2 = DynamicColumnsAbstractConcurrentSelfTest.ignitionStart(this.serverConfiguration(2));
        this.createSqlCache((Ignite)srv1);
        this.run((Ignite)srv1, this.createSql);
        this.awaitPartitionMapExchange();
        this.put((Ignite)srv1, 0, 100000);
        CountDownLatch idxLatch1 = DynamicColumnsAbstractConcurrentSelfTest.blockIndexing((Ignite)srv1);
        CountDownLatch idxLatch2 = DynamicColumnsAbstractConcurrentSelfTest.blockIndexing((Ignite)srv2);
        QueryField c = DynamicColumnsAbstractConcurrentSelfTest.c("salary", Double.class.getName());
        IgniteInternalFuture<?> idxFut = addOrRemove ? DynamicColumnsAbstractConcurrentSelfTest.addCols((Ignite)srv1, "PUBLIC", c) : DynamicColumnsAbstractConcurrentSelfTest.dropCols((Ignite)srv1, "PUBLIC", "NAME");
        U.await((CountDownLatch)idxLatch1);
        U.await((CountDownLatch)idxLatch2);
        DynamicColumnsAbstractConcurrentSelfTest.ignitionStart(this.serverConfiguration(3));
        DynamicColumnsAbstractConcurrentSelfTest.unblockIndexing((Ignite)srv1);
        DynamicColumnsAbstractConcurrentSelfTest.unblockIndexing((Ignite)srv2);
        DynamicColumnsAbstractConcurrentSelfTest.ignitionStart(this.serverConfiguration(4));
        this.awaitPartitionMapExchange();
        idxFut.get();
        DynamicColumnsAbstractConcurrentSelfTest.checkTableState(srv1, "PUBLIC", TBL_NAME, addOrRemove ? c : DynamicColumnsAbstractConcurrentSelfTest.c("ID", Integer.class.getName()));
    }

    private void put(Ignite node, int startIdx, int endIdx) {
        for (int i = startIdx; i < endIdx; ++i) {
            node.cache(CACHE_NAME).put(this.key(i), (Object)this.val(node, i));
        }
    }

    @Test
    public void testAddConcurrentCacheDestroy() throws Exception {
        this.checkConcurrentCacheDestroy(true);
    }

    @Test
    public void testDropConcurrentCacheDestroy() throws Exception {
        this.checkConcurrentCacheDestroy(false);
    }

    private void checkConcurrentCacheDestroy(boolean addOrRemove) throws Exception {
        IgniteEx srv1 = DynamicColumnsAbstractConcurrentSelfTest.ignitionStart(this.serverConfiguration(1));
        DynamicColumnsAbstractConcurrentSelfTest.ignitionStart(this.serverConfiguration(2));
        DynamicColumnsAbstractConcurrentSelfTest.ignitionStart(this.serverConfiguration(3, true));
        IgniteEx cli = DynamicColumnsAbstractConcurrentSelfTest.ignitionStart(this.clientConfiguration(4));
        this.waitForDiscovery(new Ignite[]{srv1, this.grid(2), this.grid(3), cli});
        this.createSqlCache((Ignite)cli);
        this.run((Ignite)cli, this.createSql);
        this.put((Ignite)cli, 0, 100000);
        CountDownLatch idxLatch = DynamicColumnsAbstractConcurrentSelfTest.blockIndexing((Ignite)srv1);
        QueryField c = DynamicColumnsAbstractConcurrentSelfTest.c("city", String.class.getName());
        IgniteInternalFuture<?> idxFut = addOrRemove ? DynamicColumnsAbstractConcurrentSelfTest.addCols((Ignite)srv1, "PUBLIC", c) : DynamicColumnsAbstractConcurrentSelfTest.dropCols((Ignite)srv1, "PUBLIC", "NAME");
        idxLatch.await();
        this.run((Ignite)cli, "DROP TABLE Person");
        DynamicColumnsAbstractConcurrentSelfTest.unblockIndexing((Ignite)srv1);
        try {
            idxFut.get();
            DynamicColumnsAbstractConcurrentSelfTest.fail((String)"Exception has not been thrown.");
        }
        catch (SchemaOperationException schemaOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryConsistencyMultithreaded() throws Exception {
        DynamicColumnsAbstractConcurrentSelfTest.ignitionStart(this.serverConfiguration(1));
        DynamicColumnsAbstractConcurrentSelfTest.ignitionStart(this.serverConfiguration(2));
        DynamicColumnsAbstractConcurrentSelfTest.ignitionStart(this.serverConfiguration(3, true));
        IgniteEx cli = DynamicColumnsAbstractConcurrentSelfTest.ignitionStart(this.clientConfiguration(4));
        this.createSqlCache((Ignite)cli);
        this.run((Ignite)cli, this.createSql);
        this.put((Ignite)cli, 0, 5000);
        final AtomicBoolean stopped = new AtomicBoolean();
        final AtomicInteger dynColCnt = new AtomicInteger();
        final GridConcurrentHashSet fields = new GridConcurrentHashSet();
        IgniteInternalFuture fut = this.multithreadedAsync(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                while (!stopped.get()) {
                    IgniteInternalFuture fut;
                    IgniteEx node = DynamicColumnsAbstractConcurrentSelfTest.this.grid(ThreadLocalRandom.current().nextInt(1, 5));
                    int fieldNum = ThreadLocalRandom.current().nextInt(0, dynColCnt.get() + 1);
                    boolean removed = fields.remove((Object)fieldNum);
                    if (removed) {
                        fut = DynamicColumnsAbstractConcurrentSelfTest.dropCols((Ignite)node, "PUBLIC", new String[]{"newCol" + fieldNum});
                    } else {
                        fieldNum = dynColCnt.getAndIncrement();
                        fut = DynamicColumnsAbstractConcurrentSelfTest.addCols((Ignite)node, "PUBLIC", new QueryField[]{DynamicColumnsAbstractTest.c("newCol" + fieldNum, Integer.class.getName())});
                    }
                    try {
                        fut.get();
                        if (removed) continue;
                        fields.add((Object)fieldNum);
                    }
                    catch (SchemaOperationException schemaOperationException) {
                    }
                    catch (Exception e) {
                        Assert.fail((String)("Unexpected exception: " + e));
                    }
                }
                return null;
            }
        }, 1);
        IgniteInternalFuture qryFut = this.multithreadedAsync(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                while (!stopped.get()) {
                    IgniteEx node = DynamicColumnsAbstractConcurrentSelfTest.this.grid(ThreadLocalRandom.current().nextInt(1, 5));
                    IgniteCache cache = node.cache(CACHE_NAME).withKeepBinary();
                    String valTypeName = ((GridQueryTypeDescriptor)node.context().query().types(CACHE_NAME).iterator().next()).valueTypeName();
                    List res = cache.query((Query)new SqlQuery(valTypeName, "from PERSON")).getAll();
                    Assert.assertEquals((int)5000, (int)res.size());
                }
                return null;
            }
        }, 8);
        Thread.sleep(10000L);
        stopped.set(true);
        fut.get();
        qryFut.get();
    }

    @Test
    public void testClientReconnect() throws Exception {
        this.checkClientReconnect(false, true);
    }

    @Test
    public void testClientReconnectWithCacheRestart() throws Exception {
        this.checkClientReconnect(true, true);
    }

    @Test
    public void testClientReconnectWithNonDynamicCache() throws Exception {
        this.checkClientReconnect(false, false);
    }

    @Test
    public void testClientReconnectWithNonDynamicCacheRestart() throws Exception {
        this.checkClientReconnect(true, false);
    }

    private void checkClientReconnect(boolean restartCache, boolean dynamicCache) throws Exception {
        final IgniteEx srv = DynamicColumnsAbstractConcurrentSelfTest.ignitionStart(this.serverConfiguration(1));
        DynamicColumnsAbstractConcurrentSelfTest.ignitionStart(this.serverConfiguration(2));
        DynamicColumnsAbstractConcurrentSelfTest.ignitionStart(this.serverConfiguration(3, true));
        IgniteEx cli = DynamicColumnsAbstractConcurrentSelfTest.ignitionStart(this.clientConfiguration(4));
        if (dynamicCache) {
            this.createSqlCache((Ignite)cli);
            this.run((Ignite)cli, this.createSql);
        }
        final String schemaName = dynamicCache ? "PUBLIC" : "idx";
        final QueryField[] cols = new QueryField[]{DynamicColumnsAbstractConcurrentSelfTest.c("age", Integer.class.getName()), DynamicColumnsAbstractConcurrentSelfTest.c("city", String.class.getName())};
        this.reconnectClientNode((Ignite)srv, (Ignite)cli, restartCache, dynamicCache, new RunnableX(){

            @Override
            public void run() throws Exception {
                DynamicColumnsAbstractConcurrentSelfTest.addCols((Ignite)srv, schemaName, cols).get();
                DynamicColumnsAbstractConcurrentSelfTest.dropCols((Ignite)srv, schemaName, new String[]{"NAME"}).get();
            }
        });
        DynamicColumnsAbstractConcurrentSelfTest.checkTableState(srv, schemaName, TBL_NAME, cols);
    }

    private void reconnectClientNode(final Ignite srvNode, Ignite cliNode, final boolean restart, final boolean dynamicCache, final RunnableX clo) throws Exception {
        IgniteClientReconnectAbstractTest.reconnectClientNode((IgniteLogger)this.log, (Ignite)cliNode, (Ignite)srvNode, (Runnable)new Runnable(){

            @Override
            public void run() {
                if (restart) {
                    if (dynamicCache) {
                        DynamicColumnsAbstractConcurrentSelfTest.this.run(srvNode, "DROP TABLE Person");
                        DynamicColumnsAbstractConcurrentSelfTest.this.run(srvNode, DynamicColumnsAbstractConcurrentSelfTest.this.createSql);
                    } else {
                        CacheConfiguration ccfg;
                        srvNode.destroyCache("idx");
                        try {
                            ccfg = DynamicColumnsAbstractConcurrentSelfTest.this.clientConfiguration(0).getCacheConfiguration()[0];
                        }
                        catch (Exception e) {
                            throw new AssertionError((Object)e);
                        }
                        srvNode.createCache(ccfg);
                    }
                }
                try {
                    clo.run();
                }
                catch (Exception e) {
                    throw new IgniteException("Test reconnect runnable failed.", (Throwable)e);
                }
            }
        });
        if (restart) {
            cliNode.cache(CACHE_NAME);
        }
    }

    @Test
    public void testConcurrentOperationsAndNodeStartStopMultithreaded() throws Exception {
        DynamicColumnsAbstractConcurrentSelfTest.ignitionStart(this.serverConfiguration(1));
        DynamicColumnsAbstractConcurrentSelfTest.ignitionStart(this.serverConfiguration(2));
        DynamicColumnsAbstractConcurrentSelfTest.ignitionStart(this.serverConfiguration(3, true));
        IgniteEx cli = DynamicColumnsAbstractConcurrentSelfTest.ignitionStart(this.clientConfiguration(4));
        this.createSqlCache((Ignite)cli);
        this.run((Ignite)cli, this.createSql);
        final AtomicBoolean stopped = new AtomicBoolean();
        final AtomicInteger nodeIdx = new AtomicInteger(4);
        final AtomicInteger dynColCnt = new AtomicInteger();
        IgniteInternalFuture startStopFut = this.multithreadedAsync(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                boolean exists = false;
                int lastIdx = 0;
                while (!stopped.get()) {
                    if (exists) {
                        DynamicColumnsAbstractConcurrentSelfTest.this.stopGrid(lastIdx);
                        exists = false;
                    } else {
                        IgniteConfiguration cfg;
                        lastIdx = nodeIdx.incrementAndGet();
                        switch (ThreadLocalRandom.current().nextInt(0, 3)) {
                            case 1: {
                                cfg = DynamicColumnsAbstractConcurrentSelfTest.this.serverConfiguration(lastIdx, false);
                                break;
                            }
                            case 2: {
                                cfg = DynamicColumnsAbstractConcurrentSelfTest.this.serverConfiguration(lastIdx, true);
                                break;
                            }
                            default: {
                                cfg = DynamicColumnsAbstractConcurrentSelfTest.this.clientConfiguration(lastIdx);
                            }
                        }
                        DynamicColumnsAbstractConcurrentSelfTest.ignitionStart(cfg);
                        exists = true;
                    }
                    Thread.sleep(ThreadLocalRandom.current().nextLong(500L, 1500L));
                }
                return null;
            }
        }, 1);
        final GridConcurrentHashSet fields = new GridConcurrentHashSet();
        IgniteInternalFuture idxFut = this.multithreadedAsync(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                while (!stopped.get()) {
                    IgniteInternalFuture fut;
                    IgniteEx node = DynamicColumnsAbstractConcurrentSelfTest.this.grid(ThreadLocalRandom.current().nextInt(1, 5));
                    int fieldNum = ThreadLocalRandom.current().nextInt(0, dynColCnt.get() + 1);
                    boolean removed = fields.remove((Object)fieldNum);
                    if (removed) {
                        fut = DynamicColumnsAbstractConcurrentSelfTest.dropCols((Ignite)node, "PUBLIC", new String[]{"newCol" + fieldNum});
                    } else {
                        fieldNum = dynColCnt.getAndIncrement();
                        fut = DynamicColumnsAbstractConcurrentSelfTest.addCols((Ignite)node, "PUBLIC", new QueryField[]{DynamicColumnsAbstractTest.c("newCol" + fieldNum, Integer.class.getName())});
                    }
                    try {
                        fut.get();
                        if (removed) continue;
                        fields.add((Object)fieldNum);
                    }
                    catch (SchemaOperationException schemaOperationException) {
                    }
                    catch (Exception e) {
                        Assert.fail((String)("Unexpected exception: " + e));
                    }
                }
                return null;
            }
        }, 1);
        Thread.sleep(10000L);
        stopped.set(true);
        startStopFut.get();
        idxFut.get();
        this.createSqlCache((Ignite)cli);
        QueryField[] expCols = new QueryField[fields.size()];
        int idxColsCnt = Math.min(300, expCols.length);
        Integer[] args = new Integer[idxColsCnt];
        String updQry = "UPDATE PERSON SET ";
        String idxQry = "CREATE INDEX idx ON PERSON(";
        Object[] sorted = (Integer[])fields.toArray((Object[])new Integer[fields.size()]);
        Arrays.sort(sorted);
        for (int i = 0; i < expCols.length; ++i) {
            int fieldNum = (Integer)sorted[i];
            expCols[i] = DynamicColumnsAbstractConcurrentSelfTest.c("newCol" + fieldNum, Integer.class.getName());
            if (i >= idxColsCnt) continue;
            if (i > 0) {
                updQry = updQry + ", ";
                idxQry = idxQry + ", ";
            }
            updQry = updQry + "\"newCol" + fieldNum + "\" = id + ?";
            idxQry = idxQry + "\"newCol" + fieldNum + '\"';
            args[i] = i;
        }
        idxQry = idxQry + ')';
        DynamicColumnsAbstractConcurrentSelfTest.checkTableState(cli, "PUBLIC", TBL_NAME, expCols);
        this.put((Ignite)cli, 0, 500);
        this.run(cli.cache(CACHE_NAME), updQry, args);
        this.run((Ignite)cli, idxQry);
        this.run((Ignite)cli, "DROP INDEX idx");
    }

    private static CountDownLatch blockIndexing(Ignite node) {
        UUID nodeId = ((IgniteEx)node).localNode().id();
        return DynamicColumnsAbstractConcurrentSelfTest.blockIndexing(nodeId);
    }

    private static CountDownLatch blockIndexing(UUID nodeId) {
        DynamicColumnsAbstractConcurrentSelfTest.assertFalse((boolean)BLOCKS.contains(nodeId));
        CountDownLatch idxLatch = new CountDownLatch(1);
        BLOCKS.put(nodeId, (T3<CountDownLatch, AtomicBoolean, CountDownLatch>)new T3((Object)new CountDownLatch(1), (Object)new AtomicBoolean(), (Object)idxLatch));
        return idxLatch;
    }

    private static void unblockIndexing(Ignite node) {
        UUID nodeId = ((IgniteEx)node).localNode().id();
        DynamicColumnsAbstractConcurrentSelfTest.unblockIndexing(nodeId);
    }

    private static void unblockIndexing(UUID nodeId) {
        T3<CountDownLatch, AtomicBoolean, CountDownLatch> blocker = BLOCKS.remove(nodeId);
        DynamicColumnsAbstractConcurrentSelfTest.assertNotNull(blocker);
        ((CountDownLatch)blocker.get1()).countDown();
    }

    private static void awaitIndexing(UUID nodeId) {
        T3<CountDownLatch, AtomicBoolean, CountDownLatch> blocker = BLOCKS.get(nodeId);
        if (blocker != null) {
            DynamicColumnsAbstractConcurrentSelfTest.assertTrue((boolean)((AtomicBoolean)blocker.get2()).compareAndSet(false, true));
            ((CountDownLatch)blocker.get3()).countDown();
            while (true) {
                try {
                    ((CountDownLatch)blocker.get1()).await();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    private static IgniteInternalFuture<?> addCols(Ignite node, String schemaName, QueryField ... flds) {
        String cacheName = F.eq((Object)schemaName, (Object)"PUBLIC") ? CACHE_NAME : "idx";
        return ((IgniteEx)node).context().query().dynamicColumnAdd(cacheName, schemaName, TBL_NAME, Arrays.asList(flds), false, false);
    }

    private static IgniteInternalFuture<?> dropCols(Ignite node, String schemaName, String ... flds) {
        String cacheName = F.eq((Object)schemaName, (Object)"PUBLIC") ? CACHE_NAME : "idx";
        return ((IgniteEx)node).context().query().dynamicColumnRemove(cacheName, schemaName, TBL_NAME, Arrays.asList(flds), false, false);
    }

    private IgniteCache<?, ?> createSqlCache(Ignite node) throws IgniteCheckedException {
        node.addCacheConfiguration(new CacheConfiguration("TPL").setCacheMode(this.cacheMode).setAtomicityMode(this.atomicityMode).setNodeFilter((IgnitePredicate)new NodeFilter()));
        return node.getOrCreateCache(new CacheConfiguration("idx").setIndexedTypes(new Class[]{Integer.class, Integer.class}));
    }

    private static IgniteEx ignitionStart(IgniteConfiguration cfg) {
        return DynamicColumnsAbstractConcurrentSelfTest.ignitionStart(cfg, null);
    }

    private static IgniteEx ignitionStart(IgniteConfiguration cfg, final CountDownLatch latch) {
        GridQueryProcessor.idxCls = BlockingIndexing.class;
        IgniteEx node = (IgniteEx)Ignition.start((IgniteConfiguration)cfg);
        if (latch != null) {
            node.context().discovery().setCustomEventListener(SchemaFinishDiscoveryMessage.class, (CustomEventListener)new CustomEventListener<SchemaFinishDiscoveryMessage>(){

                public void onCustomEvent(AffinityTopologyVersion topVer, ClusterNode snd, SchemaFinishDiscoveryMessage msg) {
                    latch.countDown();
                }
            });
        }
        return node;
    }

    private IgniteConfiguration serverConfiguration(int nodeIdx, boolean filtered) throws Exception {
        IgniteConfiguration cfg = this.serverConfiguration(nodeIdx);
        if (filtered) {
            cfg.setUserAttributes(Collections.singletonMap(ATTR_FILTERED, true));
        }
        return cfg;
    }

    protected static class NodeFilter
    implements IgnitePredicate<ClusterNode>,
    Serializable {
        private static final long serialVersionUID = 0L;

        protected NodeFilter() {
        }

        public boolean apply(ClusterNode node) {
            return node.attribute(DynamicColumnsAbstractConcurrentSelfTest.ATTR_FILTERED) == null;
        }
    }

    static interface RunnableX {
        public void run() throws Exception;
    }

    private static class BlockingIndexing
    extends IgniteH2Indexing {
        private BlockingIndexing() {
        }

        public void dynamicAddColumn(String schemaName, String tblName, List<QueryField> cols, boolean ifTblExists, boolean ifColNotExists) throws IgniteCheckedException {
            DynamicColumnsAbstractConcurrentSelfTest.awaitIndexing(this.ctx.localNodeId());
            super.dynamicAddColumn(schemaName, tblName, cols, ifTblExists, ifColNotExists);
        }

        public void dynamicDropColumn(String schemaName, String tblName, List<String> cols, boolean ifTblExists, boolean ifColExists) throws IgniteCheckedException {
            DynamicColumnsAbstractConcurrentSelfTest.awaitIndexing(this.ctx.localNodeId());
            super.dynamicDropColumn(schemaName, tblName, cols, ifTblExists, ifColExists);
        }
    }
}

