/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.index;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStoreManager;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class BasicIndexTest
extends GridCommonAbstractTest {
    private Collection<QueryIndex> indexes = Collections.emptyList();
    private Integer inlineSize;
    private boolean isPersistenceEnabled;
    private int gridCount = 1;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        BasicIndexTest.assertNotNull((Object)this.inlineSize);
        for (QueryIndex index : this.indexes) {
            index.setInlineSize(this.inlineSize.intValue());
        }
        IgniteConfiguration igniteCfg = super.getConfiguration(igniteInstanceName);
        igniteCfg.setConsistentId((Serializable)((Object)igniteInstanceName));
        LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
        fields.put("keyStr", String.class.getName());
        fields.put("keyLong", Long.class.getName());
        fields.put("keyPojo", Pojo.class.getName());
        fields.put("valStr", String.class.getName());
        fields.put("valLong", Long.class.getName());
        fields.put("valPojo", Pojo.class.getName());
        CacheConfiguration ccfg = new CacheConfiguration("default").setQueryEntities(Collections.singleton(new QueryEntity().setKeyType(Key.class.getName()).setValueType(Val.class.getName()).setFields(fields).setIndexes(this.indexes))).setSqlIndexMaxInlineSize(this.inlineSize.intValue());
        igniteCfg.setCacheConfiguration(new CacheConfiguration[]{ccfg});
        if (this.isPersistenceEnabled) {
            igniteCfg.setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true)));
        }
        return igniteCfg;
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
        super.afterTest();
    }

    protected int gridCount() {
        return this.gridCount;
    }

    @Test
    public void testNoIndexesNoPersistence() throws Exception {
        int[] inlineSizes;
        for (int i : inlineSizes = new int[]{0, 10, 20, 50, 100}) {
            this.log().info("Checking inlineSize=" + i);
            this.inlineSize = i;
            this.startGridsMultiThreaded(this.gridCount());
            this.populateCache();
            this.checkAll();
            this.stopAllGrids();
        }
    }

    @Test
    public void testAllIndexesNoPersistence() throws Exception {
        int[] inlineSizes;
        this.indexes = Arrays.asList(new QueryIndex("keyStr"), new QueryIndex("keyLong"), new QueryIndex("keyPojo"), new QueryIndex("valStr"), new QueryIndex("valLong"), new QueryIndex("valPojo"));
        for (int i : inlineSizes = new int[]{0, 10, 20, 50, 100}) {
            this.log().info("Checking inlineSize=" + i);
            this.inlineSize = i;
            this.startGridsMultiThreaded(this.gridCount());
            this.populateCache();
            this.checkAll();
            this.stopAllGrids();
        }
    }

    @Test
    public void testDynamicIndexesNoPersistence() throws Exception {
        int[] inlineSizes;
        for (int i : inlineSizes = new int[]{0, 10, 20, 50, 100}) {
            this.log().info("Checking inlineSize=" + i);
            this.inlineSize = i;
            this.startGridsMultiThreaded(this.gridCount());
            this.populateCache();
            this.createDynamicIndexes("keyStr", "keyLong", "keyPojo", "valStr", "valLong", "valPojo");
            this.checkAll();
            this.stopAllGrids();
        }
    }

    @Test
    public void testNoIndexesWithPersistence() throws Exception {
        int[] inlineSizes;
        this.isPersistenceEnabled = true;
        for (int i : inlineSizes = new int[]{0, 10, 20, 50, 100}) {
            this.log().info("Checking inlineSize=" + i);
            this.inlineSize = i;
            this.startGridsMultiThreaded(this.gridCount());
            this.populateCache();
            this.checkAll();
            this.stopAllGrids();
            this.startGridsMultiThreaded(this.gridCount());
            this.checkAll();
            this.stopAllGrids();
            this.cleanPersistenceDir();
        }
    }

    @Test
    public void testAllIndexesWithPersistence() throws Exception {
        int[] inlineSizes;
        this.indexes = Arrays.asList(new QueryIndex("keyStr"), new QueryIndex("keyLong"), new QueryIndex("keyPojo"), new QueryIndex("valStr"), new QueryIndex("valLong"), new QueryIndex("valPojo"));
        this.isPersistenceEnabled = true;
        for (int i : inlineSizes = new int[]{0, 10, 20, 50, 100}) {
            this.log().info("Checking inlineSize=" + i);
            this.inlineSize = i;
            this.startGridsMultiThreaded(this.gridCount());
            this.populateCache();
            this.checkAll();
            this.stopAllGrids();
            this.startGridsMultiThreaded(this.gridCount());
            this.checkAll();
            this.stopAllGrids();
            this.cleanPersistenceDir();
        }
    }

    @Test
    public void testDynamicIndexesWithPersistence() throws Exception {
        int[] inlineSizes;
        this.isPersistenceEnabled = true;
        for (int i : inlineSizes = new int[]{0, 10, 20, 50, 100}) {
            this.log().info("Checking inlineSize=" + i);
            this.inlineSize = i;
            this.startGridsMultiThreaded(this.gridCount());
            this.populateCache();
            this.createDynamicIndexes("keyStr", "keyLong", "keyPojo", "valStr", "valLong", "valPojo");
            this.checkAll();
            this.stopAllGrids();
            this.startGridsMultiThreaded(this.gridCount());
            this.checkAll();
            this.stopAllGrids();
            this.cleanPersistenceDir();
        }
    }

    @Test
    public void testDynamicIndexesDropWithPersistence() throws Exception {
        int[] inlineSizes;
        this.isPersistenceEnabled = true;
        for (int i : inlineSizes = new int[]{0, 10, 20, 50, 100}) {
            this.log().info("Checking inlineSize=" + i);
            this.inlineSize = i;
            this.startGridsMultiThreaded(this.gridCount());
            this.populateCache();
            String[] cols = new String[]{"keyStr", "keyLong", "keyPojo", "valStr", "valLong", "valPojo"};
            this.createDynamicIndexes(cols);
            this.checkAll();
            this.dropDynamicIndexes(cols);
            this.checkAll();
            this.stopAllGrids();
            this.startGridsMultiThreaded(this.gridCount());
            this.checkAll();
            this.stopAllGrids();
            this.cleanPersistenceDir();
        }
    }

    @Test
    public void testNoIndexesWithPersistenceIndexRebuild() throws Exception {
        int[] inlineSizes;
        this.isPersistenceEnabled = true;
        for (int i : inlineSizes = new int[]{0, 10, 20, 50, 100}) {
            this.log().info("Checking inlineSize=" + i);
            this.inlineSize = i;
            this.startGridsMultiThreaded(this.gridCount());
            this.populateCache();
            this.checkAll();
            List<Path> idxPaths = this.getIndexBinPaths();
            this.grid(0).cluster().active(false);
            this.stopAllGrids();
            idxPaths.forEach(idxPath -> BasicIndexTest.assertTrue((boolean)U.delete((Path)idxPath)));
            this.startGridsMultiThreaded(this.gridCount());
            this.grid(0).cache("default").indexReadyFuture().get();
            this.checkAll();
            this.stopAllGrids();
            this.cleanPersistenceDir();
        }
    }

    @Test
    public void testAllIndexesWithPersistenceIndexRebuild() throws Exception {
        int[] inlineSizes;
        this.indexes = Arrays.asList(new QueryIndex("keyStr"), new QueryIndex("keyLong"), new QueryIndex("keyPojo"), new QueryIndex("valStr"), new QueryIndex("valLong"), new QueryIndex("valPojo"));
        this.isPersistenceEnabled = true;
        for (int i : inlineSizes = new int[]{0, 10, 20, 50, 100}) {
            this.log().info("Checking inlineSize=" + i);
            this.inlineSize = i;
            this.startGridsMultiThreaded(this.gridCount());
            this.populateCache();
            this.checkAll();
            List<Path> idxPaths = this.getIndexBinPaths();
            this.grid(0).cluster().active(false);
            this.stopAllGrids();
            idxPaths.forEach(idxPath -> BasicIndexTest.assertTrue((boolean)U.delete((Path)idxPath)));
            this.startGridsMultiThreaded(this.gridCount());
            this.grid(0).cache("default").indexReadyFuture().get();
            this.checkAll();
            this.stopAllGrids();
            this.cleanPersistenceDir();
        }
    }

    @Test
    public void testDynamicIndexesWithPersistenceIndexRebuild() throws Exception {
        int[] inlineSizes;
        this.isPersistenceEnabled = true;
        for (int i : inlineSizes = new int[]{0, 10, 20, 50, 100}) {
            this.log().info("Checking inlineSize=" + i);
            this.inlineSize = i;
            this.startGridsMultiThreaded(this.gridCount());
            this.populateCache();
            this.createDynamicIndexes("keyStr", "keyLong", "keyPojo", "valStr", "valLong", "valPojo");
            this.checkAll();
            List<Path> idxPaths = this.getIndexBinPaths();
            this.grid(0).cluster().active(false);
            this.stopAllGrids();
            idxPaths.forEach(idxPath -> BasicIndexTest.assertTrue((boolean)U.delete((Path)idxPath)));
            this.startGridsMultiThreaded(this.gridCount());
            this.grid(0).cache("default").indexReadyFuture().get();
            this.checkAll();
            this.stopAllGrids();
            this.cleanPersistenceDir();
        }
    }

    private void checkAll() {
        IgniteCache cache = this.grid(0).cache("default");
        this.checkRemovePut((IgniteCache<Key, Val>)cache);
        this.checkSelectAll((IgniteCache<Key, Val>)cache);
        this.checkSelectStringEqual((IgniteCache<Key, Val>)cache);
        this.checkSelectLongEqual((IgniteCache<Key, Val>)cache);
        this.checkSelectStringRange((IgniteCache<Key, Val>)cache);
        this.checkSelectLongRange((IgniteCache<Key, Val>)cache);
    }

    private void populateCache() {
        int i;
        IgniteCache cache = this.grid(0).cache("default");
        for (i = 0; i < 100; i += 2) {
            cache.put((Object)BasicIndexTest.key(i), (Object)BasicIndexTest.val(i));
        }
        for (i = 99; i > 0; i -= 2) {
            cache.put((Object)BasicIndexTest.key(i), (Object)BasicIndexTest.val(i));
        }
        for (i = 99; i > 0; i -= 2) {
            BasicIndexTest.assertEquals((Object)BasicIndexTest.val(i), (Object)cache.get((Object)BasicIndexTest.key(i)));
        }
    }

    private void checkRemovePut(IgniteCache<Key, Val> cache) {
        int INT = 24;
        BasicIndexTest.assertEquals((Object)BasicIndexTest.val(24L), (Object)cache.get((Object)BasicIndexTest.key(24L)));
        cache.remove((Object)BasicIndexTest.key(24L));
        BasicIndexTest.assertNull((Object)cache.get((Object)BasicIndexTest.key(24L)));
        cache.put((Object)BasicIndexTest.key(24L), (Object)BasicIndexTest.val(24L));
        BasicIndexTest.assertEquals((Object)BasicIndexTest.val(24L), (Object)cache.get((Object)BasicIndexTest.key(24L)));
    }

    private void checkSelectAll(IgniteCache<Key, Val> cache) {
        List data = cache.query(new SqlFieldsQuery("select _key, _val from Val")).getAll();
        BasicIndexTest.assertEquals((int)100, (int)data.size());
        for (List row : data) {
            Key key = (Key)row.get(0);
            Val val = (Val)row.get(1);
            long i = key.keyLong;
            BasicIndexTest.assertEquals((Object)BasicIndexTest.key(i), (Object)key);
            BasicIndexTest.assertEquals((Object)BasicIndexTest.val(i), (Object)val);
        }
    }

    private void checkSelectStringEqual(IgniteCache<Key, Val> cache) {
        String STR = "foo011";
        long LONG = 11L;
        List data = cache.query(new SqlFieldsQuery("select _key, _val from Val where keyStr = ?").setArgs(new Object[]{"foo011"})).getAll();
        BasicIndexTest.assertEquals((int)1, (int)data.size());
        List row = (List)data.get(0);
        BasicIndexTest.assertEquals((Object)BasicIndexTest.key(11L), row.get(0));
        BasicIndexTest.assertEquals((Object)BasicIndexTest.val(11L), row.get(1));
    }

    private void checkSelectLongEqual(IgniteCache<Key, Val> cache) {
        long LONG = 42L;
        List data = cache.query(new SqlFieldsQuery("select _key, _val from Val where valLong = ?").setArgs(new Object[]{42L})).getAll();
        BasicIndexTest.assertEquals((int)1, (int)data.size());
        List row = (List)data.get(0);
        BasicIndexTest.assertEquals((Object)BasicIndexTest.key(42L), row.get(0));
        BasicIndexTest.assertEquals((Object)BasicIndexTest.val(42L), row.get(1));
    }

    private void checkSelectStringRange(IgniteCache<Key, Val> cache) {
        String PREFIX = "foo06";
        List data = cache.query(new SqlFieldsQuery("select _key, _val from Val where keyStr like ?").setArgs(new Object[]{"foo06%"})).getAll();
        BasicIndexTest.assertEquals((int)10, (int)data.size());
        for (List row : data) {
            Key key = (Key)row.get(0);
            Val val = (Val)row.get(1);
            long i = key.keyLong;
            BasicIndexTest.assertEquals((Object)BasicIndexTest.key(i), (Object)key);
            BasicIndexTest.assertEquals((Object)BasicIndexTest.val(i), (Object)val);
            BasicIndexTest.assertTrue((boolean)key.keyStr.startsWith("foo06"));
        }
    }

    private void checkSelectLongRange(IgniteCache<Key, Val> cache) {
        long RANGE_START = 70L;
        long RANGE_END = 80L;
        List data = cache.query(new SqlFieldsQuery("select _key, _val from Val where valLong >= ? and valLong < ?").setArgs(new Object[]{70L, 80L})).getAll();
        BasicIndexTest.assertEquals((int)10, (int)data.size());
        for (List row : data) {
            Key key = (Key)row.get(0);
            Val val = (Val)row.get(1);
            long i = key.keyLong;
            BasicIndexTest.assertEquals((Object)BasicIndexTest.key(i), (Object)key);
            BasicIndexTest.assertEquals((Object)BasicIndexTest.val(i), (Object)val);
            BasicIndexTest.assertTrue((i >= 70L && i < 80L ? 1 : 0) != 0);
        }
    }

    private List<Path> getIndexBinPaths() {
        return G.allGrids().stream().map(grid -> (IgniteEx)grid).map(grid -> {
            IgniteInternalCache cachex = grid.cachex("default");
            BasicIndexTest.assertNotNull((Object)cachex);
            FilePageStoreManager pageStoreMgr = (FilePageStoreManager)cachex.context().shared().pageStore();
            BasicIndexTest.assertNotNull((Object)pageStoreMgr);
            File cacheWorkDir = pageStoreMgr.cacheWorkDir(cachex.configuration());
            return cacheWorkDir.toPath().resolve("index.bin");
        }).collect(Collectors.toList());
    }

    private void createDynamicIndexes(String ... cols) {
        IgniteCache cache = this.grid(0).cache("default");
        for (String col : cols) {
            String indexName = col + "_idx";
            String schemaName = "default";
            cache.query(new SqlFieldsQuery(String.format("create index %s on \"%s\".Val(%s) INLINE_SIZE %s;", indexName, schemaName, col, this.inlineSize))).getAll();
        }
        cache.indexReadyFuture().get();
    }

    private void dropDynamicIndexes(String ... cols) {
        IgniteCache cache = this.grid(0).cache("default");
        for (String col : cols) {
            String indexName = col + "_idx";
            cache.query(new SqlFieldsQuery(String.format("drop index %s;", indexName))).getAll();
        }
        cache.indexReadyFuture().get();
    }

    private static Key key(long i) {
        return new Key(String.format("foo%03d", i), i, new Pojo(i));
    }

    private static Val val(long i) {
        return new Val(String.format("bar%03d", i), i, new Pojo(i));
    }

    private static class Pojo {
        private long pojoLong;

        private Pojo(long pojoLong) {
            this.pojoLong = pojoLong;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Pojo pojo = (Pojo)o;
            return this.pojoLong == pojo.pojoLong;
        }

        public int hashCode() {
            return Objects.hash(this.pojoLong);
        }

        public String toString() {
            return S.toString(Pojo.class, (Object)this);
        }
    }

    private static class Val {
        private String valStr;
        private long valLong;
        private Pojo valPojo;

        private Val(String str, long aLong, Pojo pojo) {
            this.valStr = str;
            this.valLong = aLong;
            this.valPojo = pojo;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Val val = (Val)o;
            return this.valLong == val.valLong && Objects.equals(this.valStr, val.valStr) && Objects.equals(this.valPojo, val.valPojo);
        }

        public int hashCode() {
            return Objects.hash(this.valStr, this.valLong, this.valPojo);
        }

        public String toString() {
            return S.toString(Val.class, (Object)this);
        }
    }

    private static class Key {
        private String keyStr;
        private long keyLong;
        private Pojo keyPojo;

        private Key(String str, long aLong, Pojo pojo) {
            this.keyStr = str;
            this.keyLong = aLong;
            this.keyPojo = pojo;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return this.keyLong == key.keyLong && Objects.equals(this.keyStr, key.keyStr) && Objects.equals(this.keyPojo, key.keyPojo);
        }

        public int hashCode() {
            return Objects.hash(this.keyStr, this.keyLong, this.keyPojo);
        }

        public String toString() {
            return S.toString(Key.class, (Object)this);
        }
    }
}

