/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.replicated;

import java.util.List;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class IgniteCacheReplicatedFieldsQueryJoinNoPrimaryPartitionsSelfTest
extends GridCommonAbstractTest {
    public static final String NODE_CLI = "client";
    public static final String CACHE_PARTITIONED = "partitioned";
    public static final String CACHE_REPLICATED = "replicated";
    public static final int REP_CNT = 3;
    public static final int PART_CNT = 100;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setClientMode(F.eq((Object)NODE_CLI, (Object)igniteInstanceName));
        CacheConfiguration ccfg1 = new CacheConfiguration(CACHE_PARTITIONED);
        ccfg1.setCacheMode(CacheMode.PARTITIONED);
        ccfg1.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        ccfg1.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        ccfg1.setIndexedTypes(new Class[]{Integer.class, PartValue.class});
        ccfg1.setSqlSchema("PUBLIC");
        CacheConfiguration ccfg2 = new CacheConfiguration(CACHE_REPLICATED);
        ccfg2.setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 3));
        ccfg2.setCacheMode(CacheMode.REPLICATED);
        ccfg2.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        ccfg2.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        ccfg2.setIndexedTypes(new Class[]{Integer.class, RepValue.class});
        ccfg2.setSqlSchema("PUBLIC");
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfg1, ccfg2});
        return cfg;
    }

    protected void beforeTest() throws Exception {
        int i;
        this.startGridsMultiThreaded(3);
        IgniteEx cli = this.startGrid(NODE_CLI);
        for (i = 0; i < 3; ++i) {
            cli.cache(CACHE_REPLICATED).put((Object)i, (Object)new RepValue(i));
        }
        for (i = 0; i < 100; ++i) {
            cli.cache(CACHE_PARTITIONED).put((Object)i, (Object)new PartValue(i, (i + 1) % 3));
        }
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
    }

    @Test
    public void testJoinNonCollocated() throws Exception {
        SqlFieldsQuery qry = new SqlFieldsQuery("SELECT COUNT(*) FROM PartValue p, RepValue r WHERE p.repId=r.id");
        long cnt = (Long)((List)this.grid(NODE_CLI).cache(CACHE_PARTITIONED).query(qry).getAll().get(0)).get(0);
        IgniteCacheReplicatedFieldsQueryJoinNoPrimaryPartitionsSelfTest.assertEquals((long)100L, (long)cnt);
    }

    public static class RepValue {
        @QuerySqlField
        private int id;

        public RepValue(int id) {
            this.id = id;
        }
    }

    public static class PartValue {
        @QuerySqlField
        private int id;
        @QuerySqlField
        private int repId;

        public PartValue(int id, int repId) {
            this.id = id;
            this.repId = repId;
        }
    }
}

