/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.cache.CacheException;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.QueryCancelledException;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.GridProcessor;
import org.apache.ignite.internal.processors.cache.distributed.near.IgniteCacheQueryAbstractDistributedJoinSelfTest;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class IgniteCacheQueryStopOnCancelOrTimeoutDistributedJoinSelfTest
extends IgniteCacheQueryAbstractDistributedJoinSelfTest {
    @Test
    public void testCancel1() throws Exception {
        this.testQueryCancel((Ignite)this.grid(0), "pe", "select co._key, count(*) cnt\nfrom \"pe\".Person pe, \"pr\".Product pr, \"co\".Company co, \"pu\".Purchase pu\nwhere pe._key = pu.personId and pu.productId = pr._key and pr.companyId = co._key \ngroup by co._key order by cnt desc, co._key", 1, TimeUnit.MILLISECONDS, false);
    }

    @Test
    public void testCancel2() throws Exception {
        this.testQueryCancel((Ignite)this.grid(0), "pe", "select co._key, count(*) cnt\nfrom \"pe\".Person pe, \"pr\".Product pr, \"co\".Company co, \"pu\".Purchase pu\nwhere pe._key = pu.personId and pu.productId = pr._key and pr.companyId = co._key \ngroup by co._key order by cnt desc, co._key", 50, TimeUnit.MILLISECONDS, false);
    }

    @Test
    public void testCancel3() throws Exception {
        this.testQueryCancel((Ignite)this.grid(0), "pe", "select co._key, count(*) cnt\nfrom \"pe\".Person pe, \"pr\".Product pr, \"co\".Company co, \"pu\".Purchase pu\nwhere pe._key = pu.personId and pu.productId = pr._key and pr.companyId = co._key \ngroup by co._key order by cnt desc, co._key", 100, TimeUnit.MILLISECONDS, false);
    }

    @Test
    public void testCancel4() throws Exception {
        this.testQueryCancel((Ignite)this.grid(0), "pe", "select co._key, count(*) cnt\nfrom \"pe\".Person pe, \"pr\".Product pr, \"co\".Company co, \"pu\".Purchase pu\nwhere pe._key = pu.personId and pu.productId = pr._key and pr.companyId = co._key \ngroup by co._key order by cnt desc, co._key", 500, TimeUnit.MILLISECONDS, false);
    }

    @Test
    public void testTimeout1() throws Exception {
        this.testQueryCancel((Ignite)this.grid(0), "pe", "select co._key, count(*) cnt\nfrom \"pe\".Person pe, \"pr\".Product pr, \"co\".Company co, \"pu\".Purchase pu\nwhere pe._key = pu.personId and pu.productId = pr._key and pr.companyId = co._key \ngroup by co._key order by cnt desc, co._key", 1, TimeUnit.MILLISECONDS, true);
    }

    @Test
    public void testTimeout2() throws Exception {
        this.testQueryCancel((Ignite)this.grid(0), "pe", "select co._key, count(*) cnt\nfrom \"pe\".Person pe, \"pr\".Product pr, \"co\".Company co, \"pu\".Purchase pu\nwhere pe._key = pu.personId and pu.productId = pr._key and pr.companyId = co._key \ngroup by co._key order by cnt desc, co._key", 50, TimeUnit.MILLISECONDS, true);
    }

    @Test
    public void testTimeout3() throws Exception {
        this.testQueryCancel((Ignite)this.grid(0), "pe", "select co._key, count(*) cnt\nfrom \"pe\".Person pe, \"pr\".Product pr, \"co\".Company co, \"pu\".Purchase pu\nwhere pe._key = pu.personId and pu.productId = pr._key and pr.companyId = co._key \ngroup by co._key order by cnt desc, co._key", 100, TimeUnit.MILLISECONDS, true);
    }

    @Test
    public void testTimeout4() throws Exception {
        this.testQueryCancel((Ignite)this.grid(0), "pe", "select co._key, count(*) cnt\nfrom \"pe\".Person pe, \"pr\".Product pr, \"co\".Company co, \"pu\".Purchase pu\nwhere pe._key = pu.personId and pu.productId = pr._key and pr.companyId = co._key \ngroup by co._key order by cnt desc, co._key", 500, TimeUnit.MILLISECONDS, true);
    }

    private void testQueryCancel(Ignite ignite, String cacheName, String sql, int timeoutUnits, TimeUnit timeUnit, boolean timeout) throws Exception {
        FieldsQueryCursor cursor;
        SqlFieldsQuery qry = new SqlFieldsQuery(sql).setDistributedJoins(true);
        IgniteCache cache = ignite.cache(cacheName);
        if (timeout) {
            qry.setTimeout(timeoutUnits, timeUnit);
            cursor = cache.query(qry);
        } else {
            cursor = cache.query(qry);
            ignite.scheduler().runLocal(new Runnable((QueryCursor)cursor){
                final /* synthetic */ QueryCursor val$cursor;
                {
                    this.val$cursor = queryCursor;
                }

                @Override
                public void run() {
                    this.val$cursor.close();
                }
            }, (long)timeoutUnits, timeUnit);
        }
        try (FieldsQueryCursor ignored = cursor;){
            cursor.iterator();
        }
        catch (CacheException ex) {
            this.log().error("Got expected exception", (Throwable)ex);
            IgniteCacheQueryStopOnCancelOrTimeoutDistributedJoinSelfTest.assertTrue((String)"Must throw correct exception", (boolean)(ex.getCause() instanceof QueryCancelledException));
        }
        Thread.sleep(TimeUnit.MILLISECONDS.convert(timeoutUnits, timeUnit) + 3000L);
        this.checkCleanState();
    }

    private void checkCleanState() throws IgniteCheckedException {
        for (int i = 0; i < 2; ++i) {
            IgniteEx grid = this.grid(i);
            ConcurrentMap map = (ConcurrentMap)U.field((Object)((IgniteH2Indexing)U.field((Object)((GridProcessor)U.field((Object)grid.context(), (String)"qryProc")), (String)"idx")).mapQueryExecutor(), (String)"qryRess");
            String msg = "Map executor state is not cleared";
            for (Object result : map.values()) {
                Map m = (Map)U.field(result, (String)"res");
                IgniteCacheQueryStopOnCancelOrTimeoutDistributedJoinSelfTest.assertEquals((String)msg, (int)0, (int)m.size());
            }
        }
    }
}

