/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.cache.CacheException;
import junit.framework.Assert;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class IgniteCacheQueryNodeFailTest
extends GridCommonAbstractTest {
    private boolean client;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setClientMode(this.client);
        CacheConfiguration ccfg = new CacheConfiguration("default");
        ccfg.setBackups(0);
        ccfg.setIndexedTypes(new Class[]{Integer.class, Integer.class});
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfg});
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGrid(0);
        this.client = true;
        this.startGrid(1);
        this.client = false;
    }

    @Test
    public void testNodeFailedSimpleQuery() throws Exception {
        this.checkNodeFailed("select _key from Integer");
    }

    @Test
    public void testNodeFailedReduceQuery() throws Exception {
        this.checkNodeFailed("select avg(_key) from Integer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkNodeFailed(final String qry) throws Exception {
        IgniteEx failSrv = this.startGrid(2);
        this.awaitPartitionMapExchange();
        IgniteCacheQueryNodeFailTest.assertFalse((boolean)failSrv.configuration().isClientMode());
        IgniteEx client = this.grid(1);
        final IgniteCache cache = client.cache("default");
        for (int i = 0; i < 100000; ++i) {
            cache.put((Object)i, (Object)i);
        }
        final AtomicBoolean stop = new AtomicBoolean();
        IgniteInternalFuture fut = GridTestUtils.runMultiThreadedAsync((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                SqlFieldsQuery fieldsQry = new SqlFieldsQuery(qry);
                while (!stop.get()) {
                    try {
                        cache.query(fieldsQry).getAll();
                    }
                    catch (CacheException e) {
                        Throwable cause = e.getCause();
                        Assert.assertFalse((String)("Unexpected cause: " + cause), (boolean)(cause instanceof NullPointerException));
                    }
                }
                return null;
            }
        }, (int)20, (String)"qry-thread");
        try {
            failSrv.close();
            U.sleep((long)100L);
        }
        finally {
            stop.set(true);
        }
        fut.get();
    }
}

