/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import java.util.Arrays;
import javax.cache.CacheException;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class IgniteCacheDistributedQueryCancelSelfTest
extends GridCommonAbstractTest {
    private static final int GRIDS_COUNT = 3;
    public static final int CACHE_SIZE = 10000;
    public static final int VAL_SIZE = 16;
    private static final String QUERY = "select a._val, b._val from String a, String b";

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.startGridsMultiThreaded(3);
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        CacheConfiguration ccfg = new CacheConfiguration("default");
        ccfg.setIndexedTypes(new Class[]{Integer.class, String.class});
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfg});
        if ("client".equals(igniteInstanceName)) {
            cfg.setClientMode(true);
        }
        return cfg;
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        this.stopAllGrids();
    }

    @Test
    public void testQueryCancelsOnGridShutdown() throws Exception {
        try (IgniteEx client = this.startGrid("client");){
            IgniteCache cache = client.cache("default");
            IgniteCacheDistributedQueryCancelSelfTest.assertEquals((int)0, (int)cache.localSize(new CachePeekMode[0]));
            int p = 1;
            for (int i = 1; i <= 10000; ++i) {
                char[] tmp = new char[16];
                Arrays.fill(tmp, ' ');
                cache.put((Object)i, (Object)new String(tmp));
                if (!((float)i / 10000.0f >= (float)p / 10.0f)) continue;
                this.log().info("Loaded " + i + " of " + 10000);
                ++p;
            }
            SqlFieldsQuery qry = new SqlFieldsQuery(QUERY);
            IgniteInternalFuture fut = this.multithreadedAsync(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(1500L);
                    }
                    catch (InterruptedException e) {
                        throw new IgniteException((Throwable)e);
                    }
                    for (Ignite g : G.allGrids()) {
                        if (g.configuration().isClientMode().booleanValue()) continue;
                        IgniteCacheDistributedQueryCancelSelfTest.this.stopGrid(g.name(), true);
                    }
                }
            }, 1);
            try {
                FieldsQueryCursor cursor = cache.query(qry);
                cursor.iterator();
            }
            catch (CacheException cacheException) {
                // empty catch block
            }
            fut.get();
        }
    }

    @Test
    public void testQueryResponseFailCode() throws Exception {
        try (IgniteEx client = this.startGrid("client");){
            CacheConfiguration cfg = new CacheConfiguration("default");
            cfg.setSqlFunctionClasses(new Class[]{Functions.class});
            cfg.setIndexedTypes(new Class[]{Integer.class, Integer.class});
            cfg.setName("test");
            IgniteCache cache = client.getOrCreateCache(cfg);
            cache.put((Object)1, (Object)1);
            FieldsQueryCursor qry = cache.query(new SqlFieldsQuery("select fail() from Integer"));
            try {
                qry.getAll();
                IgniteCacheDistributedQueryCancelSelfTest.fail();
            }
            catch (Exception e) {
                IgniteCacheDistributedQueryCancelSelfTest.assertTrue((boolean)(e instanceof CacheException));
            }
        }
    }

    public static class Functions {
        @QuerySqlFunction
        public static int fail() {
            throw new IllegalArgumentException();
        }
    }
}

