/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import java.util.Arrays;
import java.util.List;
import javax.cache.Cache;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.affinity.Affinity;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.internal.processors.cache.distributed.near.IgniteCacheDistributedPartitionQueryAbstractSelfTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class IgniteCacheDistributedPartitionQuerySelfTest
extends IgniteCacheDistributedPartitionQueryAbstractSelfTest {
    @Test
    public void testRegionQuery() {
        this.doTestRegionQuery((Ignite)this.grid(0));
    }

    @Test
    public void testRegionQueryClient() throws Exception {
        this.doTestRegionQuery((Ignite)this.grid("client"));
    }

    @Test
    public void testPartitionsQuery() {
        this.doTestPartitionsQuery((Ignite)this.grid(0));
    }

    @Test
    public void testPartitionsQueryClient() throws Exception {
        this.doTestPartitionsQuery((Ignite)this.grid("client"));
    }

    @Test
    public void testJoinQuery() {
        this.doTestJoinQuery((Ignite)this.grid(0), new int[0]);
    }

    @Test
    public void testJoinQueryClient() throws Exception {
        this.doTestJoinQuery((Ignite)this.grid("client"), new int[0]);
    }

    @Test
    public void testLocalQuery() {
        Affinity affinity = this.grid(0).affinity("cl");
        int[] parts = affinity.primaryPartitions(this.grid(0).localNode());
        Arrays.sort(parts);
        IgniteCache cl = this.grid(0).cache("cl");
        SqlQuery qry1 = new SqlQuery(IgniteCacheDistributedPartitionQueryAbstractSelfTest.Client.class, "1=1");
        qry1.setLocal(true);
        qry1.setPartitions(new int[]{parts[0]});
        List clients = cl.query((Query)qry1).getAll();
        for (Cache.Entry client : clients) {
            IgniteCacheDistributedPartitionQuerySelfTest.assertEquals((String)"Incorrect partition", (int)parts[0], (int)affinity.partition(client.getKey()));
        }
        SqlFieldsQuery qry2 = new SqlFieldsQuery("select cl._KEY, cl._VAL from \"cl\".Client cl");
        qry2.setLocal(true);
        qry2.setPartitions(new int[]{parts[0]});
        List rows = cl.query(qry2).getAll();
        for (List row : rows) {
            IgniteCacheDistributedPartitionQuerySelfTest.assertEquals((String)"Incorrect partition", (int)parts[0], (int)affinity.partition(row.get(0)));
        }
    }
}

