/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import org.apache.ignite.Ignite;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.cache.distributed.near.IgniteCacheDistributedPartitionQueryAbstractSelfTest;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class IgniteCacheDistributedPartitionQueryNodeRestartsSelfTest
extends IgniteCacheDistributedPartitionQueryAbstractSelfTest {
    @Override
    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        System.setProperty("IGNITE_SQL_RETRY_TIMEOUT", Long.toString(1000000L));
    }

    protected void afterTestsStopped() throws Exception {
        System.setProperty("IGNITE_SQL_RETRY_TIMEOUT", Long.toString(30000L));
        super.afterTestsStopped();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJoinQueryUnstableTopology() throws Exception {
        final AtomicBoolean stop = new AtomicBoolean();
        final AtomicIntegerArray states = new AtomicIntegerArray(10);
        IgniteEx client = this.grid("client");
        AtomicInteger cnt = new AtomicInteger();
        IgniteInternalFuture fut = this.multithreadedAsync(new Runnable((Ignite)client, cnt){
            final /* synthetic */ Ignite val$client;
            final /* synthetic */ AtomicInteger val$cnt;
            {
                this.val$client = ignite;
                this.val$cnt = atomicInteger;
            }

            @Override
            public void run() {
                while (!stop.get()) {
                    IgniteCacheDistributedPartitionQueryNodeRestartsSelfTest.this.doTestJoinQuery(this.val$client, IgniteCacheDistributedPartitionQueryNodeRestartsSelfTest.this.rnd.nextInt(IgniteCacheDistributedPartitionQueryAbstractSelfTest.PARTS_PER_REGION.length) + 1);
                    int cur = this.val$cnt.incrementAndGet();
                    if (cur % 100 != 0) continue;
                    IgniteCacheDistributedPartitionQueryNodeRestartsSelfTest.this.log().info("Queries count: " + cur);
                }
            }
        }, 4);
        final AtomicIntegerArray restartStats = new AtomicIntegerArray(10);
        IgniteInternalFuture fut2 = this.multithreadedAsync(new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                while (!stop.get()) {
                    int grid = IgniteCacheDistributedPartitionQueryNodeRestartsSelfTest.this.rnd.nextInt(10);
                    String name = IgniteCacheDistributedPartitionQueryNodeRestartsSelfTest.this.getTestIgniteInstanceName(grid);
                    Integer regionId = IgniteCacheDistributedPartitionQueryNodeRestartsSelfTest.this.regionForGrid(name);
                    if (regionId != 3 && regionId != 4 || !states.compareAndSet(grid, 0, 1)) continue;
                    restartStats.incrementAndGet(grid);
                    try {
                        IgniteCacheDistributedPartitionQueryNodeRestartsSelfTest.this.stopGrid(grid);
                        Thread.sleep(IgniteCacheDistributedPartitionQueryNodeRestartsSelfTest.this.rnd.nextInt(1000));
                        IgniteCacheDistributedPartitionQueryNodeRestartsSelfTest.this.startGrid(grid);
                        Thread.sleep(IgniteCacheDistributedPartitionQueryNodeRestartsSelfTest.this.rnd.nextInt(1000));
                    }
                    finally {
                        states.set(grid, 0);
                    }
                }
                return null;
            }
        }, 2);
        U.sleep((long)60000L);
        stop.set(true);
        try {
            fut.get();
            fut2.get();
        }
        finally {
            this.log().info("Queries count: " + cnt.get());
            for (int i = 0; i < 10; ++i) {
                this.log().info("Grid [name = " + this.getTestIgniteInstanceName(i) + ", idx=" + i + " ] restarts count: " + restartStats.get(i));
            }
        }
    }
}

