/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.authentication;

import java.util.List;
import java.util.concurrent.Callable;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.processors.authentication.AuthorizationContext;
import org.apache.ignite.internal.processors.authentication.IgniteAccessControlException;
import org.apache.ignite.internal.processors.authentication.UserManagementException;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SqlUserCommandSelfTest
extends GridCommonAbstractTest {
    private static final int NODES_COUNT = 3;
    private static final int CLI_NODE = 2;
    private AuthorizationContext actxDflt;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        if (this.getTestIgniteInstanceIndex(igniteInstanceName) == 2) {
            cfg.setClientMode(true);
        }
        cfg.setAuthenticationEnabled(true);
        cfg.setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true).setMaxSize(0x10000000L)));
        return cfg;
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"db", (boolean)true);
        this.startGrids(3);
        this.grid(0).cluster().active(true);
        this.actxDflt = this.grid(0).context().authentication().authenticate("ignite", "ignite");
        SqlUserCommandSelfTest.assertNotNull((Object)this.actxDflt);
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        super.afterTest();
    }

    @Test
    public void testCreateUpdateDropUser() throws Exception {
        AuthorizationContext.context((AuthorizationContext)this.actxDflt);
        for (int i = 0; i < 3; ++i) {
            this.userSql(i, "CREATE USER test WITH PASSWORD 'test'");
            AuthorizationContext actx = this.grid(i).context().authentication().authenticate("TEST", "test");
            SqlUserCommandSelfTest.assertNotNull((Object)actx);
            SqlUserCommandSelfTest.assertEquals((String)"TEST", (String)actx.userName());
            this.userSql(i, "ALTER USER test WITH PASSWORD 'newpasswd'");
            actx = this.grid(i).context().authentication().authenticate("TEST", "newpasswd");
            SqlUserCommandSelfTest.assertNotNull((Object)actx);
            SqlUserCommandSelfTest.assertEquals((String)"TEST", (String)actx.userName());
            this.userSql(i, "DROP USER test");
        }
    }

    @Test
    public void testCreateWithAlreadyExistUser() throws Exception {
        AuthorizationContext.context((AuthorizationContext)this.actxDflt);
        this.userSql(0, "CREATE USER test WITH PASSWORD 'test'");
        int i = 0;
        while (i < 3) {
            final int idx = i++;
            GridTestUtils.assertThrowsAnyCause((IgniteLogger)this.log, (Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    SqlUserCommandSelfTest.this.userSql(idx, "CREATE USER test WITH PASSWORD 'test'");
                    return null;
                }
            }, UserManagementException.class, (String)"User already exists [login=TEST]");
        }
    }

    @Test
    public void testAlterDropNotExistUser() throws Exception {
        AuthorizationContext.context((AuthorizationContext)this.actxDflt);
        int i = 0;
        while (i < 3) {
            final int idx = i++;
            GridTestUtils.assertThrowsAnyCause((IgniteLogger)this.log, (Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    SqlUserCommandSelfTest.this.userSql(idx, "ALTER USER test WITH PASSWORD 'test'");
                    return null;
                }
            }, UserManagementException.class, (String)"User doesn't exist [userName=TEST]");
            GridTestUtils.assertThrowsAnyCause((IgniteLogger)this.log, (Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    SqlUserCommandSelfTest.this.userSql(idx, "DROP USER test");
                    return null;
                }
            }, UserManagementException.class, (String)"User doesn't exist [userName=TEST]");
        }
    }

    @Test
    public void testNotAuthenticateOperation() throws Exception {
        int i = 0;
        while (i < 3) {
            final int idx = i++;
            GridTestUtils.assertThrowsAnyCause((IgniteLogger)this.log, (Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    SqlUserCommandSelfTest.this.userSql(idx, "CREATE USER test WITH PASSWORD 'test'");
                    return null;
                }
            }, IgniteAccessControlException.class, (String)"Operation not allowed: authorized context is empty");
            GridTestUtils.assertThrowsAnyCause((IgniteLogger)this.log, (Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    SqlUserCommandSelfTest.this.userSql(idx, "ALTER USER test WITH PASSWORD 'test'");
                    return null;
                }
            }, IgniteAccessControlException.class, (String)"Operation not allowed: authorized context is empty");
            GridTestUtils.assertThrowsAnyCause((IgniteLogger)this.log, (Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    SqlUserCommandSelfTest.this.userSql(idx, "DROP USER test");
                    return null;
                }
            }, IgniteAccessControlException.class, (String)"Operation not allowed: authorized context is empty");
        }
    }

    @Test
    public void testNotAuthorizedOperation() throws Exception {
        AuthorizationContext.context((AuthorizationContext)this.actxDflt);
        this.userSql(0, "CREATE USER user0 WITH PASSWORD 'user0'");
        AuthorizationContext actx = this.grid(0).context().authentication().authenticate("USER0", "user0");
        AuthorizationContext.context((AuthorizationContext)actx);
        int i = 0;
        while (i < 3) {
            final int idx = i++;
            GridTestUtils.assertThrowsAnyCause((IgniteLogger)this.log, (Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    SqlUserCommandSelfTest.this.userSql(idx, "CREATE USER test WITH PASSWORD 'test'");
                    return null;
                }
            }, IgniteAccessControlException.class, (String)"User management operations are not allowed for user");
            GridTestUtils.assertThrowsAnyCause((IgniteLogger)this.log, (Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    SqlUserCommandSelfTest.this.userSql(idx, "ALTER USER test WITH PASSWORD 'test'");
                    return null;
                }
            }, IgniteAccessControlException.class, (String)"User management operations are not allowed for user");
            GridTestUtils.assertThrowsAnyCause((IgniteLogger)this.log, (Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    SqlUserCommandSelfTest.this.userSql(idx, "DROP USER test");
                    return null;
                }
            }, IgniteAccessControlException.class, (String)"User management operations are not allowed for user");
        }
    }

    @Test
    public void testDropDefaultUser() throws Exception {
        AuthorizationContext.context((AuthorizationContext)this.actxDflt);
        int i = 0;
        while (i < 3) {
            final int idx = i++;
            GridTestUtils.assertThrowsAnyCause((IgniteLogger)this.log, (Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    SqlUserCommandSelfTest.this.userSql(idx, "DROP USER \"ignite\"");
                    return null;
                }
            }, IgniteAccessControlException.class, (String)"Default user cannot be removed");
        }
    }

    @Test
    public void testQuotedUsername() throws Exception {
        AuthorizationContext.context((AuthorizationContext)this.actxDflt);
        this.userSql(0, "CREATE USER \"test\" with password 'test'");
        this.userSql(0, "CREATE USER \" test\" with password 'test'");
        this.userSql(0, "CREATE USER \" test \" with password 'test'");
        this.userSql(0, "CREATE USER \"test \" with password 'test'");
        this.userSql(0, "CREATE USER \"111\" with password 'test'");
    }

    private void userSql(int nodeIdx, String sql) {
        List res = this.grid(nodeIdx).context().query().querySqlFields(new SqlFieldsQuery(sql), false).getAll();
        SqlUserCommandSelfTest.assertEquals((int)1, (int)res.size());
        SqlUserCommandSelfTest.assertEquals((int)1, (int)((List)res.get(0)).size());
        SqlUserCommandSelfTest.assertEquals((Object)0L, ((List)res.get(0)).get(0));
    }
}

