/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Serializable;
import java.sql.PreparedStatement;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlQueryParser;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SqlFieldsQuerySelfTest
extends GridCommonAbstractTest {
    private static final String INSERT = "insert into Person(_key, name) values (5, 'x')";

    protected void afterTest() throws Exception {
        this.stopAllGrids();
    }

    @Test
    public void testSqlFieldsQuery() throws Exception {
        this.startGrids(2);
        this.createAndFillCache();
        this.executeQuery();
    }

    @Test
    public void testSqlFieldsQueryWithTopologyChanges() throws Exception {
        this.startGrid(0);
        this.createAndFillCache();
        this.startGrid(1);
        this.executeQuery();
    }

    @Test
    public void testQueryCaching() throws Exception {
        PreparedStatement stmt0;
        int i;
        this.startGrid(0);
        PreparedStatement stmt = null;
        for (i = 0; i < 2; ++i) {
            this.createAndFillCache();
            stmt0 = this.grid(0).context().query().prepareNativeStatement("person", INSERT);
            SqlFieldsQuerySelfTest.assertTrue((stmt != stmt0 ? 1 : 0) != 0);
            stmt = stmt0;
            new GridSqlQueryParser(false).parse(GridSqlQueryParser.prepared((PreparedStatement)stmt));
            this.destroyCache();
        }
        stmt = null;
        this.createAndFillCache();
        for (i = 0; i < 2; ++i) {
            stmt0 = this.grid(0).context().query().prepareNativeStatement("person", INSERT);
            SqlFieldsQuerySelfTest.assertTrue((stmt == null || stmt == stmt0 ? 1 : 0) != 0);
            stmt = stmt0;
            new GridSqlQueryParser(false).parse(GridSqlQueryParser.prepared((PreparedStatement)stmt));
        }
        this.destroyCache();
    }

    private void executeQuery() {
        IgniteCache cache = this.grid(1).cache("person");
        SqlFieldsQuery qry = new SqlFieldsQuery("select name as \"Full Name\", age from person where age > 10");
        FieldsQueryCursor qryCursor = cache.query(qry);
        SqlFieldsQuerySelfTest.assertEquals((int)2, (int)qryCursor.getAll().size());
        SqlFieldsQuerySelfTest.assertEquals((int)2, (int)qryCursor.getColumnsCount());
        SqlFieldsQuerySelfTest.assertEquals((String)"Full Name", (String)qryCursor.getFieldName(0));
        SqlFieldsQuerySelfTest.assertEquals((String)"AGE", (String)qryCursor.getFieldName(1));
    }

    private IgniteCache<Integer, Person> createAndFillCache() {
        CacheConfiguration cacheConf = new CacheConfiguration("default");
        cacheConf.setCacheMode(CacheMode.PARTITIONED);
        cacheConf.setBackups(0);
        cacheConf.setIndexedTypes(new Class[]{Integer.class, Person.class});
        cacheConf.setName("person");
        IgniteCache cache = this.grid(0).createCache(cacheConf);
        cache.put((Object)1, (Object)new Person("sun", 100));
        cache.put((Object)2, (Object)new Person("moon", 50));
        return cache;
    }

    private void destroyCache() {
        this.grid(0).destroyCache("person");
    }

    public static class Person
    implements Serializable {
        @QuerySqlField
        private String name;
        @QuerySqlField
        private int age;

        public Person(String name, int age) {
            this.name = name;
            this.age = age;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getAge() {
            return this.age;
        }

        public void setAge(int age) {
            this.age = age;
        }
    }
}

