/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.File;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class QueryJoinWithDifferentNodeFiltersTest
extends GridCommonAbstractTest {
    private static final String CACHE_NAME = "cache";
    private static final String CACHE_NAME_2 = "cache2";
    private static final int NODE_COUNT = 4;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setCacheConfiguration(new CacheConfiguration[]{new CacheConfiguration(CACHE_NAME).setBackups(1).setCacheMode(CacheMode.REPLICATED).setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC).setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setIndexedTypes(new Class[]{Integer.class, Organization.class}), new CacheConfiguration(CACHE_NAME_2).setNodeFilter((IgnitePredicate)new TestFilter()).setBackups(1).setCacheMode(CacheMode.PARTITIONED).setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC).setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setIndexedTypes(new Class[]{Integer.class, Person.class})});
        if (this.getTestIgniteInstanceName(0).equals(igniteInstanceName) || this.getTestIgniteInstanceName(1).equals(igniteInstanceName)) {
            cfg.setUserAttributes(F.asMap((Object)"DATA", (Object)"true"));
        }
        if ("client".equals(igniteInstanceName)) {
            cfg.setClientMode(true);
        }
        return cfg;
    }

    protected void beforeTest() throws Exception {
        U.delete((File)U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"snapshot", (boolean)false));
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        U.delete((File)U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"snapshot", (boolean)false));
    }

    @Test
    public void testSize() throws Exception {
        this.startGrids(4);
        IgniteEx client = this.startGrid("client");
        client.cluster().active(true);
        IgniteCache cache = client.cache(CACHE_NAME);
        IgniteCache cache2 = client.cache(CACHE_NAME_2);
        int size = 100;
        for (int i = 0; i < size; ++i) {
            cache.put((Object)i, (Object)new Organization(i, "Org-" + i));
            cache2.put((Object)i, (Object)new Person(i, i, "Person-" + i));
        }
        this.info(cache2.query(new SqlFieldsQuery("select * from \"cache\".Organization r, \"cache2\".Person p where p.orgId=r.orgId")).getAll().toString());
    }

    private static class TestFilter
    implements IgnitePredicate<ClusterNode> {
        private TestFilter() {
        }

        public boolean apply(ClusterNode clusterNode) {
            return clusterNode.attribute("DATA") != null;
        }
    }

    private static class Person {
        @QuerySqlField(index=true)
        private int personId;
        @QuerySqlField(index=true)
        private int orgId;
        private String name;

        public Person(int personId, int orgId, String name) {
            this.personId = personId;
            this.orgId = orgId;
            this.name = name;
        }
    }

    private static class Organization {
        @QuerySqlField(index=true)
        private int orgId;
        private String orgName;

        public Organization(int orgId, String orgName) {
            this.orgId = orgId;
            this.orgName = orgName;
        }
    }
}

