/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.concurrent.Callable;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class QueryEntityCaseMismatchTest
extends GridCommonAbstractTest {
    protected void afterTest() throws Exception {
        this.stopAllGrids();
    }

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        cfg.setLocalHost("127.0.0.1");
        cfg.setPeerClassLoadingEnabled(true);
        TcpDiscoveryVmIpFinder ipFinder = new TcpDiscoveryVmIpFinder(true);
        ipFinder.setAddresses(Collections.singletonList("127.0.0.1:47500..47509"));
        TcpDiscoverySpi discoSpi = new TcpDiscoverySpi();
        discoSpi.setIpFinder((TcpDiscoveryIpFinder)ipFinder);
        cfg.setDiscoverySpi((DiscoverySpi)discoSpi);
        CacheConfiguration ccfg = new CacheConfiguration("default");
        cfg.setMarshaller((Marshaller)new BinaryMarshaller());
        QueryEntity queryEntity = new QueryEntity("KeyType", Integer.class.getName());
        LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
        fields.put("a", "TypeA");
        fields.put("b", "TypeB");
        queryEntity.setFields(fields);
        HashSet<String> keyFields = new HashSet<String>();
        keyFields.add("a");
        keyFields.add("B");
        queryEntity.setKeyFields(keyFields);
        ccfg.setQueryEntities((Collection)F.asList((Object)queryEntity));
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfg});
        return cfg;
    }

    @Test
    public void testCacheInitializationFailure() throws Exception {
        GridTestUtils.assertThrows((IgniteLogger)this.log, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                QueryEntityCaseMismatchTest.this.startGrid(1);
                return null;
            }
        }, IgniteCheckedException.class, null);
    }
}

