/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.processors.cache.distributed.IgniteCachePartitionLossPolicySelfTest;

public class IndexingCachePartitionLossPolicySelfTest
extends IgniteCachePartitionLossPolicySelfTest {
    protected CacheConfiguration<Integer, Integer> cacheConfiguration() {
        CacheConfiguration ccfg = super.cacheConfiguration();
        ccfg.setIndexedTypes(new Class[]{Integer.class, Integer.class});
        return ccfg;
    }

    protected void checkQueryPasses(Ignite node, boolean loc, int ... parts) {
        IndexingCachePartitionLossPolicySelfTest.executeQuery(node, loc, parts);
    }

    protected void checkQueryFails(Ignite node, boolean loc, int ... parts) {
        block3: {
            if (loc) {
                return;
            }
            try {
                IndexingCachePartitionLossPolicySelfTest.executeQuery(node, loc, parts);
                IndexingCachePartitionLossPolicySelfTest.fail((String)"Exception is not thrown.");
            }
            catch (Exception e) {
                boolean exp;
                boolean bl = exp = e.getMessage() != null && e.getMessage().contains("Failed to execute query because cache partition has been lost");
                if (exp) break block3;
                throw e;
            }
        }
    }

    private static void executeQuery(Ignite node, boolean loc, int ... parts) {
        IgniteCache cache = node.cache("default");
        SqlFieldsQuery qry = new SqlFieldsQuery("SELECT * FROM Integer");
        if (parts != null && parts.length != 0) {
            qry.setPartitions(parts);
        }
        if (loc) {
            qry.setLocal(true);
        }
        cache.query(qry).getAll();
    }
}

